/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.utils;

import gde.config.Settings;
import gde.histo.recordings.TrailRecordSet;
import gde.log.Logger;
import gde.messages.Messages;
import gde.utils.GraphicsUtils;
import gde.utils.LocalizedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class HistoTimeLine {
    private static final String $CLASS_NAME = HistoTimeLine.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int X_TOLERANCE = 20;
    private final Settings settings = Settings.getInstance();
    private TrailRecordSet trailRecordSet;
    private Rectangle curveAreaBounds;
    private int width;
    private TimeScale relativeTimeScale;
    private Density density;
    private ScalePositions scalePositions;
    private ScaleTimeStamps scaleTimeStamps;

    public synchronized void initialize(TrailRecordSet newTrailRecordSet, Rectangle newCurveAreaBounds) {
        this.trailRecordSet = newTrailRecordSet;
        this.curveAreaBounds = newCurveAreaBounds;
        this.width = newCurveAreaBounds.width;
        this.relativeTimeScale = this.defineRelativeScale();
        this.density = this.defineDensity();
        this.scalePositions = ScalePositions.createScalePositions(this.density, this.width, this.relativeTimeScale);
        this.scaleTimeStamps = null;
    }

    public String toString() {
        return String.format("width=%d  leftmostTimeStamp = %,d  rightmostTimeStamp = %,d  density=%s scalePositionsSize=%d scaleTimeStamps_ms=%d", this.width, this.relativeTimeScale.getLeftMostTimeStamp_ms(), this.relativeTimeScale.getRightMostTimeStamp_ms(), this.density.toString(), this.scaleTimeStamps.size(), this.scaleTimeStamps.getScaleTimeStampsSum_ms());
    }

    public void drawTimeLine(GC gc) {
        String timeLineDescription;
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setForeground(Settings.getInstance().getTimeLineColor());
        int x0 = this.curveAreaBounds.x;
        int y0 = this.curveAreaBounds.y + this.curveAreaBounds.height;
        gc.drawLine(x0 - 1, y0, x0 + this.width + 1, y0);
        log.fine(() -> String.format("time line - x0=%d y0=%d - width=%d", x0, y0, this.width));
        LocalizedDateTime.DateTimePattern timeFormat = this.getScaleFormat(this.trailRecordSet.getTopTimeStamp_ms() - this.trailRecordSet.getLowestTimeStamp_ms());
        if (timeFormat == LocalizedDateTime.DateTimePattern.MMdd) {
            timeLineDescription = Messages.getString("GDE_MSGT0745");
        } else if (timeFormat == LocalizedDateTime.DateTimePattern.MMdd_HH) {
            timeLineDescription = Messages.getString("GDE_MSGT0744");
        } else if (timeFormat == LocalizedDateTime.DateTimePattern.yyyyMM) {
            timeLineDescription = Messages.getString("GDE_MSGT0743");
        } else if (timeFormat == LocalizedDateTime.DateTimePattern.yyyyMMdd) {
            timeLineDescription = Messages.getString("GDE_MSGT0742");
        } else if (timeFormat == LocalizedDateTime.DateTimePattern.yyyyMMdd_HHmm) {
            timeLineDescription = Messages.getString("GDE_MSGT0741");
        } else {
            throw new UnsupportedOperationException();
        }
        long sampleTimeStamp_ms = this.trailRecordSet.getTimeStepSize() == 0 ? 11L : this.trailRecordSet.getTopTimeStamp_ms();
        Point pt = gc.textExtent(LocalizedDateTime.getFormatedTime(timeFormat, sampleTimeStamp_ms));
        GraphicsUtils.drawTimeLineText(timeLineDescription, x0 + this.width / 2, y0 + pt.y * 5 / 2 + 2, gc, 256);
        this.drawTickMarks(gc, x0, y0, pt, timeFormat);
    }

    private LocalizedDateTime.DateTimePattern getScaleFormat(long totalDisplayTime_ms) {
        log.finer(() -> "totalDisplayTime_ms = " + totalDisplayTime_ms);
        long totalTime_month = TimeUnit.DAYS.convert(totalDisplayTime_ms, TimeUnit.MILLISECONDS) / 30L;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.relativeTimeScale.getLeftMostTimeStamp_ms());
        LocalizedDateTime.DateTimePattern timeFormat = totalTime_month < 12L && Calendar.getInstance().get(1) == cal.get(1) ? (this.density == Density.EXTREME ? LocalizedDateTime.DateTimePattern.MMdd : (this.density == Density.HIGH ? LocalizedDateTime.DateTimePattern.MMdd_HH : (this.density == Density.MEDIUM ? LocalizedDateTime.DateTimePattern.yyyyMMdd : LocalizedDateTime.DateTimePattern.yyyyMMdd_HHmm))) : (this.density == Density.EXTREME ? LocalizedDateTime.DateTimePattern.yyyyMM : (this.density == Density.HIGH ? LocalizedDateTime.DateTimePattern.yyyyMM : (this.density == Density.MEDIUM ? LocalizedDateTime.DateTimePattern.yyyyMMdd : LocalizedDateTime.DateTimePattern.yyyyMMdd_HHmm)));
        log.finer(() -> "timeLineText = " + Messages.getString("GDE_MSGT0267"));
        return timeFormat;
    }

    public ScalePositions getScalePositions() {
        return this.scalePositions;
    }

    private TimeScale defineRelativeScale() {
        long maxVerifiedTimeStamp = -1L;
        TimeScale applicableDistances = new TimeScale();
        long lastTimeStamp = 0L;
        for (int i = 0; i < this.trailRecordSet.getTimeStepSize(); ++i) {
            long currentTimeStamp = (long)this.trailRecordSet.getTime_ms(i);
            if (lastTimeStamp != 0L) {
                double currentDistance = lastTimeStamp - currentTimeStamp;
                applicableDistances.put(currentTimeStamp, currentDistance);
            } else {
                maxVerifiedTimeStamp = currentTimeStamp;
            }
            lastTimeStamp = currentTimeStamp;
        }
        log.finer(() -> "applicableDistancesSum=" + applicableDistances.runningSum + " number of distances=" + applicableDistances.size());
        TimeScale result = new TimeScale(this.settings.isXAxisReversed());
        result.put(maxVerifiedTimeStamp, 0.0);
        boolean isNaturalTimescale = false;
        TimeScale normalizedDistances = new TimeScale();
        for (Map.Entry<Long, Double> entry : applicableDistances.entrySet()) {
            double normalizedDistance = this.settings.isXAxisLogarithmicDistance() ? (entry.getValue() != 0.0 ? Math.log(entry.getValue() / applicableDistances.runningSum) : 0.0) : entry.getValue() / applicableDistances.runningSum;
            normalizedDistances.put(entry.getKey(), normalizedDistance);
        }
        log.log(Level.FINER, "normalizedDistancesSum=", normalizedDistances.runningSum);
        double logBaseDivisor = Math.log(1.0 + Math.pow(10.0, this.settings.getXAxisSpreadOrdinal() - 3));
        double scaleConstant = normalizedDistances.runningSum / logBaseDivisor + (1.0 - normalizedDistances.runningMin / logBaseDivisor) * (double)normalizedDistances.size();
        for (Map.Entry<Long, Double> entry2 : normalizedDistances.entrySet()) {
            double relativeDistance = (1.0 + (entry2.getValue() - normalizedDistances.runningMin) / logBaseDivisor) / scaleConstant;
            result.putRunningSum(entry2.getKey(), relativeDistance);
        }
        log.log(Level.FINER, "relativeTimeScaleSum=", result.runningSum);
        return result;
    }

    private Density defineDensity() {
        Density result;
        ArrayList<Double> relativeDistances = new ArrayList<Double>();
        Map.Entry<Long, Double> lastEntry = null;
        for (Map.Entry<Long, Double> entry : this.relativeTimeScale.entrySet()) {
            if (lastEntry != null) {
                double relativeDistance = Math.abs((Double)lastEntry.getValue() - entry.getValue());
                double absoluteDistance = relativeDistance * (double)this.width;
                if (absoluteDistance > 0.5) {
                    relativeDistances.add(Math.abs(lastEntry.getValue() - entry.getValue()));
                } else {
                    log.finer(() -> String.format("subpixel distance discarded at %d    absoluteDistance = %f", entry.getKey(), absoluteDistance));
                }
            }
            lastEntry = entry;
        }
        if (relativeDistances.size() < 3) {
            result = Density.LOW;
        } else {
            Collections.sort(relativeDistances);
            double distanceQuantile = (Double)relativeDistances.get(relativeDistances.size() * (2 + 2 * (this.settings.getBoxplotScaleOrdinal() + 1)) / 10);
            int absoluteDistance = (int)((double)this.width * distanceQuantile + 0.5);
            result = absoluteDistance > Density.LOW.boxWidth ? Density.LOW : (absoluteDistance > Density.MEDIUM.boxWidth ? Density.MEDIUM : (absoluteDistance > Density.HIGH.boxWidth ? Density.HIGH : Density.EXTREME));
            log.fine(() -> String.format("absoluteDistance=%d  boxType=%s   relativeDistancesMin=%f relativeDistancesMax=%f", absoluteDistance, this.density.toString(), relativeDistances.get(0), relativeDistances.get(relativeDistances.size() - 1)));
        }
        log.log(Level.FINER, "", this);
        return result;
    }

    private void drawTickMarks(GC gc, int x0, int y0, Point pt, LocalizedDateTime.DateTimePattern timeFormat) {
        int tickLength = pt.y / 2 + 1;
        int gap = pt.y / 3;
        int labelGap = 4 + pt.x;
        int lastXPosLabel = -2147483647;
        String lastText = " ";
        for (Map.Entry<Long, Integer> entry : this.getScalePositions().entrySet()) {
            int xPos = x0 + entry.getValue();
            String text = LocalizedDateTime.getFormatedTime(timeFormat, entry.getKey());
            if (!lastText.equals(text) && Math.abs(lastXPosLabel - xPos) > labelGap) {
                gc.drawLine(xPos, y0 + 1, xPos, y0 + tickLength);
                GraphicsUtils.drawTextCentered(text, xPos, y0 + tickLength + gap + pt.y / 2, gc, 256);
                lastText = text;
                lastXPosLabel = xPos;
                continue;
            }
            gc.drawLine(xPos, y0 + 1, xPos, y0 + tickLength / 2);
        }
    }

    public int getXPosTimestamp(long timestamp_ms) {
        log.finest(() -> "scalePositionsSize=" + this.scalePositions.size() + "  timestamp_ms=  " + timestamp_ms);
        return this.scalePositions.get(timestamp_ms);
    }

    public Long getSnappedTimestamp(int xPos) {
        if (this.scaleTimeStamps == null) {
            this.scaleTimeStamps = new ScaleTimeStamps(this.scalePositions);
        }
        return this.scaleTimeStamps.getSnappedTimeStamp_ms(xPos);
    }

    public long getAdjacentTimestamp(int xPos) {
        if (this.scaleTimeStamps == null) {
            this.scaleTimeStamps = new ScaleTimeStamps(this.scalePositions);
        }
        return this.scaleTimeStamps.getAdjacentTimeStamp_ms(xPos);
    }

    public Density getDensity() {
        return this.density;
    }

    public Rectangle getCurveAreaBounds() {
        return this.curveAreaBounds;
    }

    private static final class TimeScale {
        private final TreeMap<Long, Double> timeScale;
        private final BiFunction<Long, Double, Double> putter;
        double runningSum = 0.0;
        double runningMin = Double.MAX_VALUE;

        public TimeScale() {
            this(true);
        }

        public TimeScale(boolean isXAxisReversed) {
            if (isXAxisReversed) {
                this.timeScale = new TreeMap(Collections.reverseOrder());
                this.putter = (scaleTimeStamp_ms, position) -> this.timeScale.put((Long)scaleTimeStamp_ms, (Double)position);
            } else {
                this.timeScale = new TreeMap();
                this.putter = (scaleTimeStamp_ms, position) -> this.timeScale.put((Long)scaleTimeStamp_ms, 1.0 - position);
            }
        }

        public long getLeftMostTimeStamp_ms() {
            return this.timeScale.firstKey();
        }

        public long getRightMostTimeStamp_ms() {
            return this.timeScale.lastKey();
        }

        public Double put(long scaleTimeStamp_ms, double distance) {
            this.runningSum += distance;
            this.runningMin = Math.min(this.runningMin, distance);
            return this.putter.apply(scaleTimeStamp_ms, distance);
        }

        public Double putRunningSum(long scaleTimeStamp_ms, double distance) {
            this.runningSum += distance;
            return this.putter.apply(scaleTimeStamp_ms, this.runningSum);
        }

        public Set<Map.Entry<Long, Double>> entrySet() {
            return this.timeScale.entrySet();
        }

        public int size() {
            return this.timeScale.size();
        }

        public String toString() {
            return "TimeScale [timeScaleSize=" + this.timeScale.size() + ", runningSum=" + this.runningSum + ", runningMin=" + this.runningMin + "]";
        }
    }

    static enum Density {
        EXTREME(4),
        HIGH(8),
        MEDIUM(10),
        LOW(16);

        private final Settings settings = Settings.getInstance();
        public final int boxWidthAmplitude = 2;
        private final int boxWidth;
        public static final Density[] VALUES;

        private Density(int boxWidth) {
            this.boxWidth = boxWidth;
        }

        public static Density fromOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        public static String toString(Density density) {
            return density.name();
        }

        public int getScaledBoxWidth() {
            return (int)((double)this.boxWidth * (1.0 + (double)(this.settings.getBoxplotScaleOrdinal() - 1) / 3.0));
        }

        static {
            VALUES = Density.values();
        }
    }

    public static final class ScalePositions {
        private final TreeMap<Long, Integer> scalePositions;

        public static ScalePositions createScalePositions(Density density, int width, TimeScale relativeTimeScale) {
            int rightMargin;
            int remainingWidthPerItem;
            int leftMargin = Settings.getInstance().isXAxisLogarithmicDistance() || density == Density.LOW || relativeTimeScale.size() <= 2 ? ((remainingWidthPerItem = (width - density.boxWidth) / relativeTimeScale.size()) > 2 * Density.LOW.boxWidth ? (rightMargin = width / (relativeTimeScale.size() + 1)) : (rightMargin = density.getScaledBoxWidth() / 2)) : (rightMargin = density.getScaledBoxWidth() / 2);
            int netWidth = width - leftMargin - rightMargin;
            log.finer(() -> String.format("width = %4d|leftMargin = %4d|rightMargin = %4d|netWidth = %4d", width, leftMargin, rightMargin, netWidth));
            TreeMap<Long, Integer> newScalePositions = new TreeMap<Long, Integer>(Collections.reverseOrder());
            for (Map.Entry<Long, Double> entry : relativeTimeScale.entrySet()) {
                newScalePositions.put(entry.getKey(), leftMargin + (int)(entry.getValue() * (double)netWidth));
                log.finest(() -> "timeStamp = " + String.valueOf(entry.getKey()) + " position = " + String.valueOf(newScalePositions.get(entry.getKey())));
            }
            return new ScalePositions(newScalePositions);
        }

        private ScalePositions(TreeMap<Long, Integer> scalePositions) {
            this.scalePositions = scalePositions;
        }

        public int get(long scaleTimeStamp_ms) {
            return this.scalePositions.get(scaleTimeStamp_ms);
        }

        public Set<Map.Entry<Long, Integer>> entrySet() {
            return this.scalePositions.entrySet();
        }

        public int size() {
            return this.scalePositions.size();
        }
    }

    private static final class ScaleTimeStamps {
        private final TreeMap<Integer, List<Long>> scaleTimeStamps_ms;

        public ScaleTimeStamps(ScalePositions scalePositions) {
            this.scaleTimeStamps_ms = this.defineScaleTimeStamps_ms(scalePositions);
        }

        private TreeMap<Integer, List<Long>> defineScaleTimeStamps_ms(ScalePositions scalePositions) {
            TreeMap<Integer, List<Long>> scaleTimeStamps = new TreeMap<Integer, List<Long>>();
            if (Settings.getInstance().isXAxisReversed()) {
                Map.Entry<Integer, List<Long>> previous = null;
                for (Map.Entry<Long, Integer> entry : scalePositions.entrySet()) {
                    if (previous == null || entry.getValue() != previous.getKey()) {
                        scaleTimeStamps.put(entry.getValue(), new ArrayList());
                        previous = scaleTimeStamps.lastEntry();
                    }
                    ((List)previous.getValue()).add(entry.getKey());
                }
            } else {
                Map.Entry<Integer, List<Long>> previous = null;
                for (Map.Entry<Long, Integer> entry : scalePositions.entrySet()) {
                    if (previous == null || entry.getValue() != previous.getKey()) {
                        scaleTimeStamps.put(entry.getValue(), new ArrayList());
                        previous = scaleTimeStamps.firstEntry();
                    }
                    ((List)previous.getValue()).add(0, entry.getKey());
                }
            }
            return scaleTimeStamps;
        }

        public Long getSnappedTimeStamp_ms(int xPos) {
            Long timeStamp_ms = null;
            Map.Entry<Integer, List<Long>> lowerEntry = this.scaleTimeStamps_ms.lowerEntry(xPos);
            if (lowerEntry == null) {
                Map.Entry<Integer, List<Long>> ceilingEntry = this.scaleTimeStamps_ms.ceilingEntry(xPos);
                if (ceilingEntry == null) {
                    throw new UnsupportedOperationException("an empty scale is not allowed");
                }
                timeStamp_ms = ceilingEntry.getValue().get(0);
            } else if (xPos == lowerEntry.getKey()) {
                timeStamp_ms = lowerEntry.getValue().get(0);
            } else {
                Map.Entry<Integer, List<Long>> ceilingEntry = this.scaleTimeStamps_ms.ceilingEntry(xPos);
                if (ceilingEntry != null && (xPos <= lowerEntry.getKey() + 20 || xPos >= ceilingEntry.getKey() - 20)) {
                    timeStamp_ms = xPos <= (ceilingEntry.getKey() + lowerEntry.getKey()) / 2 ? lowerEntry.getValue().get(lowerEntry.getValue().size() - 1) : ceilingEntry.getValue().get(0);
                }
            }
            return timeStamp_ms;
        }

        public long getAdjacentTimeStamp_ms(int xPos) {
            long timeStamp_ms;
            Map.Entry<Integer, List<Long>> lowerEntry = this.scaleTimeStamps_ms.lowerEntry(xPos);
            if (lowerEntry == null) {
                Map.Entry<Integer, List<Long>> ceilingEntry = this.scaleTimeStamps_ms.ceilingEntry(xPos);
                if (ceilingEntry == null) {
                    throw new UnsupportedOperationException(" an empty scale is not allowed");
                }
                timeStamp_ms = ceilingEntry.getValue().get(0);
            } else {
                Map.Entry<Integer, List<Long>> ceilingEntry;
                timeStamp_ms = xPos == lowerEntry.getKey() ? lowerEntry.getValue().get(0) : ((ceilingEntry = this.scaleTimeStamps_ms.ceilingEntry(xPos)) == null ? lowerEntry.getValue().get(lowerEntry.getValue().size() - 1).longValue() : (xPos <= (ceilingEntry.getKey() + lowerEntry.getKey()) / 2 ? lowerEntry.getValue().get(lowerEntry.getValue().size() - 1) : ceilingEntry.getValue().get(0)).longValue());
            }
            return timeStamp_ms;
        }

        public int getScaleTimeStampsSum_ms() {
            return this.scaleTimeStamps_ms.entrySet().parallelStream().mapToInt(c -> ((List)c.getValue()).size()).sum();
        }

        public int size() {
            return this.scaleTimeStamps_ms.size();
        }
    }
}

