/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class FormLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int spacing = 0;

    int computeHeight(Control control, FormData data2, boolean flushCache) {
        FormAttachment top2 = data2.getTopAttachment(control, this.spacing, flushCache);
        FormAttachment bottom2 = data2.getBottomAttachment(control, this.spacing, flushCache);
        FormAttachment height = bottom2.minus(top2);
        if (height.numerator == 0) {
            if (bottom2.numerator == 0) {
                return bottom2.offset;
            }
            if (bottom2.numerator == bottom2.denominator) {
                return -top2.offset;
            }
            if (bottom2.offset <= 0) {
                return -top2.offset * top2.denominator / bottom2.numerator;
            }
            int divider = bottom2.denominator - bottom2.numerator;
            return bottom2.denominator * bottom2.offset / divider;
        }
        return height.solveY(data2.getHeight(control, flushCache));
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = this.layout(composite, false, 0, 0, wHint, hHint, flushCache);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object data2 = control.getLayoutData();
        if (data2 != null) {
            ((FormData)data2).flushCache();
        }
        return true;
    }

    String getName() {
        String string2 = this.getClass().getName();
        int index = string2.lastIndexOf(46);
        if (index == -1) {
            return string2;
        }
        return string2.substring(index + 1, string2.length());
    }

    int computeWidth(Control control, FormData data2, boolean flushCache) {
        FormAttachment left2 = data2.getLeftAttachment(control, this.spacing, flushCache);
        FormAttachment right2 = data2.getRightAttachment(control, this.spacing, flushCache);
        FormAttachment width = right2.minus(left2);
        if (width.numerator == 0) {
            if (right2.numerator == 0) {
                return right2.offset;
            }
            if (right2.numerator == right2.denominator) {
                return -left2.offset;
            }
            if (right2.offset <= 0) {
                return -left2.offset * left2.denominator / left2.numerator;
            }
            int divider = right2.denominator - right2.numerator;
            return right2.denominator * right2.offset / divider;
        }
        return width.solveY(data2.getWidth(control, flushCache));
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        int x2 = rect.x + this.marginLeft + this.marginWidth;
        int y2 = rect.y + this.marginTop + this.marginHeight;
        int width = Math.max(0, rect.width - this.marginLeft - 2 * this.marginWidth - this.marginRight);
        int height = Math.max(0, rect.height - this.marginTop - 2 * this.marginHeight - this.marginBottom);
        this.layout(composite, true, x2, y2, width, height, flushCache);
    }

    Point layout(Composite composite, boolean move2, int x2, int y2, int width, int height, boolean flushCache) {
        FormData data2;
        Control child;
        Control[] children = composite.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            Control child2 = children[i2];
            FormData data3 = (FormData)child2.getLayoutData();
            if (data3 == null) {
                data3 = new FormData();
                child2.setLayoutData(data3);
            }
            if (flushCache) {
                data3.flushCache();
            }
            data3.cacheBottom = null;
            data3.cacheTop = null;
            data3.cacheRight = null;
            data3.cacheLeft = null;
            ++i2;
        }
        boolean[] flush = null;
        Rectangle[] bounds = null;
        int w2 = 0;
        int h2 = 0;
        int i3 = 0;
        while (i3 < children.length) {
            child = children[i3];
            data2 = (FormData)child.getLayoutData();
            if (width != -1) {
                data2.needed = false;
                FormAttachment left2 = data2.getLeftAttachment(child, this.spacing, flushCache);
                FormAttachment right2 = data2.getRightAttachment(child, this.spacing, flushCache);
                int x1 = left2.solveX(width);
                int x22 = right2.solveX(width);
                if (data2.height == -1 && !data2.needed) {
                    int trim = 0;
                    if (child instanceof Scrollable) {
                        Rectangle rect = ((Scrollable)child).computeTrim(0, 0, 0, 0);
                        trim = rect.width;
                    } else {
                        trim = child.getBorderWidth() * 2;
                    }
                    data2.cacheHeight = -1;
                    data2.cacheWidth = -1;
                    int currentWidth = Math.max(0, x22 - x1 - trim);
                    data2.computeSize(child, currentWidth, data2.height, flushCache);
                    if (flush == null) {
                        flush = new boolean[children.length];
                    }
                    flush[i3] = true;
                }
                w2 = Math.max(x22, w2);
                if (move2) {
                    if (bounds == null) {
                        bounds = new Rectangle[children.length];
                    }
                    bounds[i3] = new Rectangle(0, 0, 0, 0);
                    bounds[i3].x = x2 + x1;
                    bounds[i3].width = x22 - x1;
                }
            } else {
                w2 = Math.max(this.computeWidth(child, data2, flushCache), w2);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < children.length) {
            child = children[i3];
            data2 = (FormData)child.getLayoutData();
            if (height != -1) {
                int y1 = data2.getTopAttachment(child, this.spacing, flushCache).solveX(height);
                int y22 = data2.getBottomAttachment(child, this.spacing, flushCache).solveX(height);
                h2 = Math.max(y22, h2);
                if (move2) {
                    bounds[i3].y = y2 + y1;
                    bounds[i3].height = y22 - y1;
                }
            } else {
                h2 = Math.max(this.computeHeight(child, data2, flushCache), h2);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < children.length) {
            child = children[i3];
            data2 = (FormData)child.getLayoutData();
            if (flush != null && flush[i3] != false) {
                data2.cacheHeight = -1;
                data2.cacheWidth = -1;
            }
            data2.cacheBottom = null;
            data2.cacheTop = null;
            data2.cacheRight = null;
            data2.cacheLeft = null;
            ++i3;
        }
        if (move2) {
            i3 = 0;
            while (i3 < children.length) {
                children[i3].setBounds((Rectangle)bounds[i3]);
                ++i3;
            }
        }
        return new Point(w2 += this.marginLeft + this.marginWidth * 2 + this.marginRight, h2 += this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    public String toString() {
        String string2 = String.valueOf(this.getName()) + " {";
        if (this.marginWidth != 0) {
            string2 = String.valueOf(string2) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string2 = String.valueOf(string2) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string2 = String.valueOf(string2) + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string2 = String.valueOf(string2) + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string2 = String.valueOf(string2) + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string2 = String.valueOf(string2) + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.spacing != 0) {
            string2 = String.valueOf(string2) + "spacing=" + this.spacing + " ";
        }
        string2 = string2.trim();
        string2 = String.valueOf(string2) + "}";
        return string2;
    }
}

