/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocWriter;
import com.itextpdf.text.pdf.ByteBuffer;

public class StringUtils {
    private static final byte[] r = DocWriter.getISOBytes("\\r");
    private static final byte[] n = DocWriter.getISOBytes("\\n");
    private static final byte[] t = DocWriter.getISOBytes("\\t");
    private static final byte[] b = DocWriter.getISOBytes("\\b");
    private static final byte[] f = DocWriter.getISOBytes("\\f");

    private StringUtils() {
    }

    public static byte[] escapeString(byte[] bytes) {
        ByteBuffer content = new ByteBuffer();
        StringUtils.escapeString(bytes, content);
        return content.toByteArray();
    }

    public static void escapeString(byte[] bytes, ByteBuffer content) {
        content.append_i(40);
        block8: for (int k2 = 0; k2 < bytes.length; ++k2) {
            byte c2 = bytes[k2];
            switch (c2) {
                case 13: {
                    content.append(r);
                    continue block8;
                }
                case 10: {
                    content.append(n);
                    continue block8;
                }
                case 9: {
                    content.append(t);
                    continue block8;
                }
                case 8: {
                    content.append(b);
                    continue block8;
                }
                case 12: {
                    content.append(f);
                    continue block8;
                }
                case 40: 
                case 41: 
                case 92: {
                    content.append_i(92).append_i(c2);
                    continue block8;
                }
                default: {
                    content.append_i(c2);
                }
            }
        }
        content.append_i(41);
    }

    public static byte[] convertCharsToBytes(char[] chars) {
        byte[] result2 = new byte[chars.length * 2];
        for (int i2 = 0; i2 < chars.length; ++i2) {
            result2[2 * i2] = (byte)(chars[i2] / 256);
            result2[2 * i2 + 1] = (byte)(chars[i2] % 256);
        }
        return result2;
    }
}

