/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public final class AltitudeBlock
extends DataBlock {
    private short altitudeInTenthOfMeter;

    public AltitudeBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("Altitude A");
        this.measurementUnits.add("m");
        this.measurementFactors.add(0.1);
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof AltitudeBlock) {
            AltitudeBlock alt = (AltitudeBlock)block;
            return alt.altitudeInTenthOfMeter == this.altitudeInTenthOfMeter;
        }
        return false;
    }

    public short getAltitudeInTenthOfMeter() {
        return this.altitudeInTenthOfMeter;
    }

    private void decode(byte[] rawData) {
        this.altitudeInTenthOfMeter = Shorts.fromBytes(rawData[6], rawData[7]);
        this.measurementValues.add(Integer.valueOf(this.getAltitudeInTenthOfMeter()));
    }
}

