/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math3.util.MathUtils;

public class Array2DRowRealMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = -1067294169172445528L;
    private double[][] data;

    public Array2DRowRealMatrix() {
    }

    public Array2DRowRealMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        super(rowDimension, columnDimension);
        this.data = new double[rowDimension][columnDimension];
    }

    public Array2DRowRealMatrix(double[][] d2) throws DimensionMismatchException, NoDataException, NullArgumentException {
        this.copyIn(d2);
    }

    public Array2DRowRealMatrix(double[][] d2, boolean copyArray) throws DimensionMismatchException, NoDataException, NullArgumentException {
        if (copyArray) {
            this.copyIn(d2);
        } else {
            if (d2 == null) {
                throw new NullArgumentException();
            }
            int nRows = d2.length;
            if (nRows == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int nCols = d2[0].length;
            if (nCols == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            for (int r2 = 1; r2 < nRows; ++r2) {
                if (d2[r2].length == nCols) continue;
                throw new DimensionMismatchException(d2[r2].length, nCols);
            }
            this.data = d2;
        }
    }

    public Array2DRowRealMatrix(double[] v2) {
        int nRows = v2.length;
        this.data = new double[nRows][1];
        for (int row2 = 0; row2 < nRows; ++row2) {
            this.data[row2][0] = v2[row2];
        }
    }

    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        return new Array2DRowRealMatrix(rowDimension, columnDimension);
    }

    public RealMatrix copy() {
        return new Array2DRowRealMatrix(this.copyOut(), false);
    }

    public Array2DRowRealMatrix add(Array2DRowRealMatrix m2) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row2 = 0; row2 < rowCount; ++row2) {
            double[] dataRow = this.data[row2];
            double[] mRow = m2.data[row2];
            double[] outDataRow = outData[row2];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col] + mRow[col];
            }
        }
        return new Array2DRowRealMatrix(outData, false);
    }

    public Array2DRowRealMatrix subtract(Array2DRowRealMatrix m2) throws MatrixDimensionMismatchException {
        MatrixUtils.checkSubtractionCompatible(this, m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row2 = 0; row2 < rowCount; ++row2) {
            double[] dataRow = this.data[row2];
            double[] mRow = m2.data[row2];
            double[] outDataRow = outData[row2];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col] - mRow[col];
            }
        }
        return new Array2DRowRealMatrix(outData, false);
    }

    public Array2DRowRealMatrix multiply(Array2DRowRealMatrix m2) throws DimensionMismatchException {
        MatrixUtils.checkMultiplicationCompatible(this, m2);
        int nRows = this.getRowDimension();
        int nCols = m2.getColumnDimension();
        int nSum = this.getColumnDimension();
        double[][] outData = new double[nRows][nCols];
        double[] mCol = new double[nSum];
        double[][] mData = m2.data;
        for (int col = 0; col < nCols; ++col) {
            for (int mRow = 0; mRow < nSum; ++mRow) {
                mCol[mRow] = mData[mRow][col];
            }
            for (int row2 = 0; row2 < nRows; ++row2) {
                double[] dataRow = this.data[row2];
                double sum = 0.0;
                for (int i2 = 0; i2 < nSum; ++i2) {
                    sum += dataRow[i2] * mCol[i2];
                }
                outData[row2][col] = sum;
            }
        }
        return new Array2DRowRealMatrix(outData, false);
    }

    public double[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataRef() {
        return this.data;
    }

    public void setSubMatrix(double[][] subMatrix, int row2, int column2) throws NoDataException, OutOfRangeException, DimensionMismatchException, NullArgumentException {
        if (this.data == null) {
            if (row2 > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row2);
            }
            if (column2 > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column2);
            }
            MathUtils.checkNotNull(subMatrix);
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            this.data = new double[subMatrix.length][nCols];
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (subMatrix[i2].length != nCols) {
                    throw new DimensionMismatchException(subMatrix[i2].length, nCols);
                }
                System.arraycopy(subMatrix[i2], 0, this.data[i2 + row2], column2, nCols);
            }
        } else {
            super.setSubMatrix(subMatrix, row2, column2);
        }
    }

    public double getEntry(int row2, int column2) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, row2, column2);
        return this.data[row2][column2];
    }

    public void setEntry(int row2, int column2, double value) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, row2, column2);
        this.data[row2][column2] = value;
    }

    public void addToEntry(int row2, int column2, double increment) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, row2, column2);
        double[] dArray = this.data[row2];
        int n2 = column2;
        dArray[n2] = dArray[n2] + increment;
    }

    public void multiplyEntry(int row2, int column2, double factor) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, row2, column2);
        double[] dArray = this.data[row2];
        int n2 = column2;
        dArray[n2] = dArray[n2] * factor;
    }

    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    public double[] operate(double[] v2) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v2.length != nCols) {
            throw new DimensionMismatchException(v2.length, nCols);
        }
        double[] out = new double[nRows];
        for (int row2 = 0; row2 < nRows; ++row2) {
            double[] dataRow = this.data[row2];
            double sum = 0.0;
            for (int i2 = 0; i2 < nCols; ++i2) {
                sum += dataRow[i2] * v2[i2];
            }
            out[row2] = sum;
        }
        return out;
    }

    public double[] preMultiply(double[] v2) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v2.length != nRows) {
            throw new DimensionMismatchException(v2.length, nRows);
        }
        double[] out = new double[nCols];
        for (int col = 0; col < nCols; ++col) {
            double sum = 0.0;
            for (int i2 = 0; i2 < nRows; ++i2) {
                sum += this.data[i2][col] * v2[i2];
            }
            out[col] = sum;
        }
        return out;
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i2 = 0; i2 < rows; ++i2) {
            double[] rowI = this.data[i2];
            for (int j2 = 0; j2 < columns; ++j2) {
                rowI[j2] = visitor2.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor2.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i2 = 0; i2 < rows; ++i2) {
            double[] rowI = this.data[i2];
            for (int j2 = 0; j2 < columns; ++j2) {
                visitor2.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor2.end();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor2, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            double[] rowI = this.data[i2];
            for (int j2 = startColumn; j2 <= endColumn; ++j2) {
                rowI[j2] = visitor2.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor2.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor2, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            double[] rowI = this.data[i2];
            for (int j2 = startColumn; j2 <= endColumn; ++j2) {
                visitor2.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor2.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j2 = 0; j2 < columns; ++j2) {
            for (int i2 = 0; i2 < rows; ++i2) {
                double[] rowI = this.data[i2];
                rowI[j2] = visitor2.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor2.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j2 = 0; j2 < columns; ++j2) {
            for (int i2 = 0; i2 < rows; ++i2) {
                visitor2.visit(i2, j2, this.data[i2][j2]);
            }
        }
        return visitor2.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor2, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j2 = startColumn; j2 <= endColumn; ++j2) {
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                double[] rowI = this.data[i2];
                rowI[j2] = visitor2.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor2.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor2, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j2 = startColumn; j2 <= endColumn; ++j2) {
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                visitor2.visit(i2, j2, this.data[i2][j2]);
            }
        }
        return visitor2.end();
    }

    private double[][] copyOut() {
        int nRows = this.getRowDimension();
        double[][] out = new double[nRows][this.getColumnDimension()];
        for (int i2 = 0; i2 < nRows; ++i2) {
            System.arraycopy(this.data[i2], 0, out[i2], 0, this.data[i2].length);
        }
        return out;
    }

    private void copyIn(double[][] in) throws DimensionMismatchException, NoDataException, NullArgumentException {
        this.setSubMatrix(in, 0, 0);
    }
}

