/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class CharValue
extends IntegerValueConstant<Character> {
    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module) {
        Intrinsics.checkNotNullParameter(module, "module");
        SimpleType simpleType2 = module.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "module.builtIns.charType");
        return simpleType2;
    }

    @Override
    @NotNull
    public String toString() {
        String string2 = "\\u%04X ('%s')";
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(this, *args)");
        return string3;
    }

    private final String getPrintablePart(char c2) {
        String string2;
        switch (c2) {
            case '\b': {
                string2 = "\\b";
                break;
            }
            case '\t': {
                string2 = "\\t";
                break;
            }
            case '\n': {
                string2 = "\\n";
                break;
            }
            case '\f': {
                string2 = "\\f";
                break;
            }
            case '\r': {
                string2 = "\\r";
                break;
            }
            default: {
                string2 = this.isPrintableUnicode(c2) ? String.valueOf(c2) : "?";
            }
        }
        return string2;
    }

    private final boolean isPrintableUnicode(char c2) {
        byte t2 = (byte)Character.getType(c2);
        return t2 != 0 && t2 != 13 && t2 != 14 && t2 != 15 && t2 != 16 && t2 != 18 && t2 != 19;
    }

    public CharValue(char value) {
        super(Character.valueOf(value));
    }
}

