/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder;

import de.treichels.hott.decoder.HoTTTransmitter;
import de.treichels.hott.decoder.a.b.a;
import de.treichels.hott.decoder.a.b.b;
import de.treichels.hott.decoder.a.b.z;
import de.treichels.hott.model.BaseModel;
import de.treichels.hott.model.enums.ModelType;
import de.treichels.hott.voice.VoiceFile;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.jvm.internal.Intrinsics;

public final class HoTTDecoderKt {
    public static final BaseModel decodeFile(File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return b.a(file);
    }

    public static final BaseModel decodeMemory(HoTTTransmitter hoTTTransmitter, int n2) {
        Intrinsics.checkNotNullParameter(hoTTTransmitter, "port");
        return b.a(hoTTTransmitter, n2);
    }

    public static final BaseModel decodeStream(ModelType modelType, String string2, InputStream inputStream2) {
        Intrinsics.checkNotNullParameter((Object)modelType, "type");
        Intrinsics.checkNotNullParameter(string2, "name");
        Intrinsics.checkNotNullParameter(inputStream2, "data");
        return a.a.a(modelType, string2, inputStream2);
    }

    public static final VoiceFile decodeVDF(byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "bytes");
        return z.a(byArray);
    }

    public static final VoiceFile decodeVDF(File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        byte[] byArray = Files.readAllBytes(file.toPath());
        Intrinsics.checkNotNullExpressionValue(byArray, "Files.readAllBytes(file.toPath())");
        return HoTTDecoderKt.decodeVDF(byArray);
    }

    public static final File encodeFile(BaseModel baseModel, File file) {
        Intrinsics.checkNotNullParameter(baseModel, "model");
        Intrinsics.checkNotNullParameter(file, "dir");
        return a.a.a(baseModel, file);
    }

    public static final Path encodeVDF(VoiceFile voiceFile, File file) {
        Intrinsics.checkNotNullParameter(voiceFile, "voiceFile");
        Intrinsics.checkNotNullParameter(file, "file");
        Path path2 = Files.write(file.toPath(), z.a.a(voiceFile), new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "Files.write(file.toPath(\u2026der.encodeVDF(voiceFile))");
        return path2;
    }

    public static final int getMaxDataSize(VoiceFile voiceFile) {
        Intrinsics.checkNotNullParameter(voiceFile, "voiceFile");
        return z.a(voiceFile);
    }

    public static final int getMaxInfoSize(VoiceFile voiceFile) {
        Intrinsics.checkNotNullParameter(voiceFile, "voiceFile");
        return z.b(voiceFile);
    }

    public static final int getMaxVoiceCount(VoiceFile voiceFile) {
        Intrinsics.checkNotNullParameter(voiceFile, "voiceFile");
        return z.c(voiceFile);
    }

    public static final void verityVDF(VoiceFile voiceFile) {
        Intrinsics.checkNotNullParameter(voiceFile, "voiceFile");
        z.a.a(voiceFile);
    }
}

