/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.config.Settings;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DesktopPropertyType;
import gde.device.DesktopPropertyTypes;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.graupner.Ultramat;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.custom.CTabItem;

public class UltraDuoPlus40
extends Ultramat {
    static final Logger logger = Logger.getLogger(UltraDuoPlus40.class.getName());

    public UltraDuoPlus40(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGT2204"), Messages.getString((String)"GDE_MSGT2205"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2208"), Messages.getString((String)"GDE_MSGT2209")};
        this.CHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2211"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2214"), Messages.getString((String)"GDE_MSGT2215"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2217"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2219"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2221"), Messages.getString((String)"GDE_MSGT2222")};
        this.DISCHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2211"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2223"), Messages.getString((String)"GDE_MSGT2224"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2222")};
        this.DELAY_MODE = new String[]{Messages.getString((String)"GDE_MSGT2225"), Messages.getString((String)"GDE_MSGT2226"), Messages.getString((String)"GDE_MSGT2227"), Messages.getString((String)"GDE_MSGT2228")};
        this.CURRENT_MODE = new String[]{Messages.getString((String)"GDE_MSGT2229"), Messages.getString((String)"GDE_MSGT2230"), Messages.getString((String)"GDE_MSGT2231"), Messages.getString((String)"GDE_MSGT2232"), Messages.getString((String)"GDE_MSGT2233"), Messages.getString((String)"GDE_MSGT2234"), Messages.getString((String)"GDE_MSGT2235"), Messages.getString((String)"GDE_MSGT2236"), Messages.getString((String)"GDE_MSGT2237")};
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public UltraDuoPlus40(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGT2204"), Messages.getString((String)"GDE_MSGT2205"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2208"), Messages.getString((String)"GDE_MSGT2209")};
        this.CHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2211"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2214"), Messages.getString((String)"GDE_MSGT2215"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2217"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2219"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2221"), Messages.getString((String)"GDE_MSGT2222")};
        this.DISCHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2211"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2223"), Messages.getString((String)"GDE_MSGT2224"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2222")};
        this.DELAY_MODE = new String[]{Messages.getString((String)"GDE_MSGT2225"), Messages.getString((String)"GDE_MSGT2226"), Messages.getString((String)"GDE_MSGT2227"), Messages.getString((String)"GDE_MSGT2228")};
        this.CURRENT_MODE = new String[]{Messages.getString((String)"GDE_MSGT2229"), Messages.getString((String)"GDE_MSGT2230"), Messages.getString((String)"GDE_MSGT2231"), Messages.getString((String)"GDE_MSGT2232"), Messages.getString((String)"GDE_MSGT2233"), Messages.getString((String)"GDE_MSGT2234"), Messages.getString((String)"GDE_MSGT2235"), Messages.getString((String)"GDE_MSGT2236"), Messages.getString((String)"GDE_MSGT2237")};
        this.configureSerialPortMenu(1, "", "");
    }

    @Override
    public int getLovDataByteSize() {
        return 148;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int channel2Offset1 = 97;
        int channel2Offset2 = 105;
        int[] points = new int[this.getNumberOfMeasurements(recordSet.getChannelConfigNumber())];
        int offset = 4;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        int outputChannel = recordSet.getChannelConfigNumber();
        if (dataBuffer[offset] == 12) {
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                if (outputChannel == 1) {
                    System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
                } else if (outputChannel == 2) {
                    System.arraycopy(dataBuffer, channel2Offset1 + offset + i * lovDataSize, convertBuffer, 5, 8);
                    convertBuffer[14] = 48;
                    convertBuffer[13] = 48;
                    System.arraycopy(dataBuffer, channel2Offset2 + offset + i * lovDataSize, convertBuffer, 15, 41);
                }
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
            }
            recordSet.setTimeStep_ms(this.getAverageTimeStep_ms() != null ? this.getAverageTimeStep_ms() : 1000.0);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        try {
            points[0] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[15]), Character.valueOf((char)dataBuffer[16]), Character.valueOf((char)dataBuffer[17]), Character.valueOf((char)dataBuffer[18])), 16);
            points[1] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[19]), Character.valueOf((char)dataBuffer[20]), Character.valueOf((char)dataBuffer[21]), Character.valueOf((char)dataBuffer[22])), 16);
            points[2] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[23]), Character.valueOf((char)dataBuffer[24]), Character.valueOf((char)dataBuffer[25]), Character.valueOf((char)dataBuffer[26])), 16);
            points[3] = Double.valueOf((double)(points[0] * points[1]) / 1000.0).intValue();
            points[4] = Double.valueOf((double)(points[0] * points[2]) / 1000.0).intValue();
            points[5] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[27]), Character.valueOf((char)dataBuffer[28]), Character.valueOf((char)dataBuffer[29]), Character.valueOf((char)dataBuffer[30])), 16);
            String sign = String.format("%c%c", Character.valueOf((char)dataBuffer[31]), Character.valueOf((char)dataBuffer[32]));
            if (sign != null && sign.length() > 0 && Integer.parseInt(sign) == 0) {
                points[5] = -1 * points[5];
            }
            points[6] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[5]), Character.valueOf((char)dataBuffer[6]), Character.valueOf((char)dataBuffer[7]), Character.valueOf((char)dataBuffer[8])), 16);
            points[7] = 0;
            int i = 0;
            int j = 0;
            while (i < points.length - 8) {
                points[i + 8] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[35 + j]), Character.valueOf((char)dataBuffer[36 + j]), Character.valueOf((char)dataBuffer[37 + j]), Character.valueOf((char)dataBuffer[38 + j])), 16);
                if (points[i + 8] > 0) {
                    maxVotage = points[i + 8] > maxVotage ? points[i + 8] : maxVotage;
                    minVotage = points[i + 8] < minVotage ? points[i + 8] : minVotage;
                }
                ++i;
                j += 4;
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            logger.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
            points[4] = Double.valueOf((double)points[0] / 1000.0 * (double)points[2]).intValue();
            points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
            points[7] = 0;
            int j = 0;
            int k = 0;
            while (j < points.length - 8) {
                points[j + 8] = ((convertBuffer[k + 20] & 0xFF) << 24) + ((convertBuffer[k + 21] & 0xFF) << 16) + ((convertBuffer[k + 22] & 0xFF) << 8) + ((convertBuffer[k + 23] & 0xFF) << 0);
                if (points[j + 8] > 0) {
                    maxVotage = points[j + 8] > maxVotage ? points[j + 8] : maxVotage;
                    minVotage = points[j + 8] < minVotage ? points[j + 8] : minVotage;
                }
                ++j;
                k += 4;
            }
            points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public int getDesktopTargetReferenceOrdinal(DesktopPropertyTypes desktopPropertyType) {
        DesktopPropertyType property = this.getDesktopProperty(desktopPropertyType);
        return property != null ? property.getTargetReferenceOrdinal() : -1;
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{0, this.channels.getActiveChannelNumber() == 3 ? 6 : 2};
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        int displayableCounter = 0;
        recordSet.setAllDisplayable();
        int numCells = recordSet.getChannelConfigNumber() == 1 ? 14 : 4;
        for (i = recordSet.size() - numCells - 1; i < recordSet.size(); ++i) {
            record.setDisplayable((record = recordSet.get(i)).getOrdinal() <= 5 || record.hasReasonableData());
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, record.getName() + " setDisplayable=" + (record.getOrdinal() <= 5 || record.hasReasonableData()));
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
        }
        if (logger.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                logger.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    @Override
    public Ultramat.GraupnerDeviceType getDeviceTypeIdentifier() {
        return Ultramat.GraupnerDeviceType.UltraDuoPlus40;
    }

    @Override
    public boolean isProcessing(int outletNum, byte[] dataBuffer) {
        if (outletNum == 1) {
            String operationModeOut1 = String.format("%c%c", Character.valueOf((char)dataBuffer[9]), Character.valueOf((char)dataBuffer[10]));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "operationModeOut1 = " + (operationModeOut1 != null && operationModeOut1.length() > 0 ? this.USAGE_MODE[Integer.parseInt(operationModeOut1, 16)] : operationModeOut1));
            }
            if (this.settings.isReduceChargeDischarge()) {
                return operationModeOut1 != null && operationModeOut1.length() == 2 && (operationModeOut1.equals("01") || operationModeOut1.equals("02") || this.settings.isContinuousRecordSet() && operationModeOut1.equals("03"));
            }
            return operationModeOut1 != null && operationModeOut1.length() == 2 && !operationModeOut1.equals("00") && !operationModeOut1.equals("06");
        }
        if (outletNum == 2) {
            String operationModeOut2 = String.format("%c%c", Character.valueOf((char)dataBuffer[95]), Character.valueOf((char)dataBuffer[96]));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "operationModeOut2 = " + (operationModeOut2 != null && operationModeOut2.length() > 0 ? this.USAGE_MODE[Integer.parseInt(operationModeOut2, 16)] : operationModeOut2));
            }
            if (this.settings.isReduceChargeDischarge()) {
                return operationModeOut2 != null && operationModeOut2.length() == 2 && (operationModeOut2.equals("01") || operationModeOut2.equals("02") || this.settings.isContinuousRecordSet() && operationModeOut2.equals("03"));
            }
            return operationModeOut2 != null && operationModeOut2.length() == 2 && !operationModeOut2.equals("00") && !operationModeOut2.equals("06");
        }
        return false;
    }

    @Override
    public int getProcessingMode(byte[] dataBuffer) {
        String operationMode = String.format("%c%c", Character.valueOf((char)dataBuffer[9]), Character.valueOf((char)dataBuffer[10]));
        return operationMode != null && operationMode.length() > 0 ? Integer.parseInt(operationMode, 16) : 0;
    }

    @Override
    public String getProcessingType(byte[] dataBuffer) {
        String type = "";
        String operationMode = String.format("%c%c", Character.valueOf((char)dataBuffer[9]), Character.valueOf((char)dataBuffer[10]));
        int opMode = operationMode != null && operationMode.length() > 0 ? Integer.parseInt(operationMode, 16) : 0;
        String operationType = String.format("%c%c", Character.valueOf((char)dataBuffer[11]), Character.valueOf((char)dataBuffer[12]));
        switch (opMode) {
            case 1: {
                type = operationType != null && operationType.length() > 0 ? this.CHARGE_MODE[Integer.parseInt(operationType, 16)] : "";
                break;
            }
            case 2: {
                type = operationType != null && operationType.length() > 0 ? this.DISCHARGE_MODE[Integer.parseInt(operationType, 16)] : "";
                break;
            }
            case 3: {
                type = operationType != null && operationType.length() > 0 ? this.DELAY_MODE[Integer.parseInt(operationType, 16)] : "";
                break;
            }
            case 5: {
                type = operationType != null && operationType.length() > 0 ? this.CURRENT_MODE[Integer.parseInt(operationType, 16)] : "";
                break;
            }
            case 6: {
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGE2218") + String.format("%02d", Integer.parseInt(operationType, 16)), 3);
            }
        }
        return type;
    }

    @Override
    public int getCycleNumber(int outletNum, byte[] dataBuffer) {
        String cycleNumber = String.format("%c%c", Character.valueOf((char)dataBuffer[13]), Character.valueOf((char)dataBuffer[14]));
        if (outletNum == 2) {
            cycleNumber = "0";
        }
        return Integer.parseInt(cycleNumber, 16);
    }

    @Override
    public void setTemperatureUnit(int channelNumber, RecordSet recordSet, byte[] dataBuffer) {
        String unit = String.format("%c%c", Character.valueOf((char)dataBuffer[33]), Character.valueOf((char)dataBuffer[34]));
        if (Integer.parseInt(unit) == 0) {
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 5, "\u00b0C");
        } else if (Integer.parseInt(unit) == 1) {
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 5, "\u00b0F");
        }
    }

    public CTabItem getUtilityDeviceTabItem() {
        return this.application.getUtilGraphicsWindow(Messages.getString((String)"GDE_MSGT2340"));
    }
}

