/*
 * Decompiled with CFR 0.152.
 */
package gde.device.conrad;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.conrad.GathererThread;
import gde.device.conrad.VC800Dialog;
import gde.device.conrad.VC800SerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class VC800
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(VC800.class.getName());
    public static final String INPUT_TYPE = "input_type";
    public static final String INPUT_SYMBOL = "input_symbol";
    public static final String INPUT_UNIT = "input_unit";
    final DataExplorer application;
    final VC800SerialPort serialPort;
    final VC800Dialog dialog;

    public VC800(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.conrad.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new VC800SerialPort(this, this.application);
        this.dialog = new VC800Dialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public VC800(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.conrad.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new VC800SerialPort(this, this.application);
        this.dialog = new VC800Dialog(this.application.getShell(), this);
        this.configureSerialPortMenu(1, "", "");
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGW0022"));
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGW0022"));
        return "";
    }

    public int getLovDataByteSize() {
        return 20;
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int lovDataSize = this.getLovDataByteSize();
        int deviceDataBufferSize = 8;
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        int[] points = new int[this.getNumberOfMeasurements(1)];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
            recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        if (log.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder();
            for (byte b : dataBuffer) {
                sb.append(String.format("%02x", b)).append(" ");
            }
            log.log(Level.FINER, sb.toString());
        }
        points[0] = 1000 * this.getDigit((dataBuffer[1] & 7) << 4 | dataBuffer[2] & 0xF);
        points[0] = points[0] + 100 * this.getDigit((dataBuffer[3] & 7) << 4 | dataBuffer[4] & 0xF);
        points[0] = points[0] + 10 * this.getDigit((dataBuffer[5] & 7) << 4 | dataBuffer[6] & 0xF);
        points[0] = points[0] + 1 * this.getDigit((dataBuffer[7] & 7) << 4 | dataBuffer[8] & 0xF);
        log.log(Level.FINEST, "digits = " + points[0]);
        points[0] = (dataBuffer[3] & 8) > 0 ? points[0] * 1 : ((dataBuffer[5] & 8) > 0 ? points[0] * 10 : ((dataBuffer[7] & 8) > 0 ? points[0] * 100 : points[0] * 1000));
        if ((dataBuffer[1] & 8) > 0) {
            points[0] = points[0] * -1;
        }
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 0;
        if (!recordSet.isTimeStepConstant()) {
            timeStampBufferSize = 4 * recordDataSize;
            byte[] timeStampBuffer = new byte[timeStampBufferSize];
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (int i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            dataTableRow[1] = recordSet.get(0).getDecimalFormat().format((double)recordSet.get(0).realGet(rowIndex).intValue() / 1000.0);
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public int getDigit(int select) {
        int digit = 0;
        switch (select) {
            case 125: {
                digit = 0;
                break;
            }
            case 5: {
                digit = 1;
                break;
            }
            case 91: {
                digit = 2;
                break;
            }
            case 31: {
                digit = 3;
                break;
            }
            case 39: {
                digit = 4;
                break;
            }
            case 62: {
                digit = 5;
                break;
            }
            case 126: {
                digit = 6;
                break;
            }
            case 21: {
                digit = 7;
                break;
            }
            case 127: {
                digit = 8;
                break;
            }
            case 63: {
                digit = 9;
            }
        }
        return digit;
    }

    public boolean isBatteryLevelLow(byte[] buffer) {
        return (buffer[12] & 1) != 1;
    }

    public HashMap<String, String> getMeasurementInfo(byte[] buffer, HashMap<String, String> measurementInfo) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "  buffer : " + StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
        }
        Object unit = "";
        if ((buffer[9] & 2) > 0) {
            unit = "k";
        } else if ((buffer[9] & 4) > 0) {
            unit = "n";
        } else if ((buffer[9] & 8) > 0) {
            unit = "\u00b5";
        } else if ((buffer[10] & 2) > 0) {
            unit = "M";
        } else if ((buffer[10] & 8) > 0) {
            unit = "m";
        } else if ((buffer[10] & 4) > 0) {
            unit = "%";
        }
        unit = (buffer[11] & 4) > 0 ? (String)unit + "\u03a9" : ((buffer[11] & 8) > 0 ? (String)unit + "F" : ((buffer[12] & 2) > 0 ? (String)unit + "Hz" : ((buffer[12] & 4) > 0 ? (String)unit + "V" : ((buffer[12] & 8) > 0 ? (String)unit + "A" : (String)unit + "\u00b0C"))));
        measurementInfo.put(INPUT_UNIT, (String)unit);
        String typeSymbol = Messages.getString((String)"GDE_MSGT1500");
        if (((String)unit).endsWith("V")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1501");
        } else if (((String)unit).endsWith("A")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1503");
        } else if (((String)unit).endsWith("\u03a9")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1504");
        } else if (((String)unit).endsWith("F")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1505");
        } else if (((String)unit).endsWith("Hz")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1506");
        } else if (((String)unit).endsWith("\u00b0C")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1507");
        }
        try {
            measurementInfo.put(INPUT_TYPE, typeSymbol.split(" ")[0]);
            measurementInfo.put(INPUT_SYMBOL, typeSymbol.split(" ")[1]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return measurementInfo;
    }

    public String getMode(byte[] buffer) {
        Object mode = Messages.getString((String)"GDE_MSGT1510");
        if ((buffer[0] & 2) > 0) {
            mode = Messages.getString((String)"GDE_MSGT1511");
        }
        if ((buffer[12] & 0xC) > 0 && (buffer[0] & 4) > 0) {
            mode = (String)mode + Messages.getString((String)"GDE_MSGT1512");
        } else if ((buffer[12] & 0xC) > 0 && (buffer[0] & 8) > 0) {
            mode = (String)mode + Messages.getString((String)"GDE_MSGT1513");
        } else if ((buffer[9] & 1) > 0) {
            mode = (String)mode + Messages.getString((String)"GDE_MSGT1514");
        } else if ((buffer[11] & 4) > 0) {
            mode = (String)mode + Messages.getString((String)"GDE_MSGT1515");
        } else if ((buffer[11] & 8) > 0) {
            mode = (String)mode + Messages.getString((String)"GDE_MSGT1516");
        } else if ((buffer[12] & 2) > 0) {
            mode = (String)mode + Messages.getString((String)"GDE_MSGT1517");
        } else if ((buffer[13] & 1) > 0) {
            mode = (String)mode + Messages.getString((String)"GDE_MSGT1518");
        }
        return mode;
    }

    public double translateValue(Record record, double value) {
        double newValue = value;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double newValue = value;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        recordSet.setAllVisibleAndDisplayable();
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        log.log(Level.FINE, "no update required for " + recordSet.getName());
    }

    public VC800Dialog getDialog() {
        return this.dialog;
    }

    public VC800SerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR};
    }

    public void open_closeCommPort() {
        block12: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block12;
                        this.getDialog().dataGatherThread = new GathererThread(this.application, this, this.serialPort, activChannel.getNumber(), this.getDialog());
                        try {
                            if (this.serialPort.isConnected()) {
                                this.getDialog().dataGatherThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                        if (this.getDialog().boundsComposite != null && !this.getDialog().isDisposed()) {
                            this.getDialog().boundsComposite.redraw();
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                } else {
                    if (this.getDialog().dataGatherThread != null) {
                        this.getDialog().dataGatherThread.stopDataGatheringThread(false);
                    }
                    if (this.getDialog().boundsComposite != null && !this.getDialog().isDisposed()) {
                        this.getDialog().boundsComposite.redraw();
                    }
                    this.serialPort.close();
                }
            }
        }
    }
}

