/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.device;

import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MaxMinObserver {
    private static final String $CLASS_NAME = MaxMinObserver.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    protected final int[] points;
    protected final int[] minPoints;
    protected final int[] maxPoints;
    List<Integer> thisMaxIndices = new ArrayList<Integer>();
    List<Integer> lastMaxIndices = new ArrayList<Integer>();
    List<Integer> thisMinIndices = new ArrayList<Integer>();
    List<Integer> lastMinIndices = new ArrayList<Integer>();
    private boolean isLastAutonomousExtremum;
    private boolean isThisChanged;

    public MaxMinObserver(int[] points, int[] newMaxPoints, int[] newMinPoints) {
        this.points = points;
        this.maxPoints = new int[newMaxPoints.length];
        this.minPoints = new int[newMinPoints.length];
        this.setMaxMinPoints(newMaxPoints, newMinPoints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("max ").append(Arrays.toString(this.maxPoints)).append("\n");
        sb.append("min ").append(Arrays.toString(this.minPoints)).append("\n");
        sb.append("maxIndices ").append(Arrays.toString(this.lastMaxIndices.toArray())).append("\n");
        sb.append("minIndices ").append(Arrays.toString(this.lastMinIndices.toArray())).append("\n");
        sb.append(String.format("isThisChanged=%b isLastAutonomousExtremum=%b", this.isThisChanged, this.isLastAutonomousExtremum));
        return sb.toString();
    }

    public boolean update(long timeStep_ms, int[] lastPoints) {
        boolean isLastChanged = this.isThisChanged;
        this.isThisChanged = false;
        this.isLastAutonomousExtremum = false;
        if (isLastChanged) {
            this.lastMaxIndices = this.thisMaxIndices;
            this.lastMinIndices = this.thisMinIndices;
            this.thisMaxIndices = new ArrayList<Integer>();
            this.thisMinIndices = new ArrayList<Integer>();
        }
        for (int i = 0; i < this.points.length; ++i) {
            int point = this.points[i];
            if (point > this.maxPoints[i]) {
                this.thisMaxIndices.add(i);
                this.maxPoints[i] = point;
                this.isThisChanged = true;
                continue;
            }
            if (point >= this.minPoints[i]) continue;
            this.thisMinIndices.add(i);
            this.minPoints[i] = point;
            this.isThisChanged = true;
        }
        log.finer(() -> String.format("timeStep_ms=%,12d newMinMax=%b %s", timeStep_ms, this.isThisChanged, Arrays.toString(this.points)));
        if (isLastChanged && this.isThisChanged) {
            this.setLastAutonomousExtremum(timeStep_ms, lastPoints);
        }
        return this.isThisChanged;
    }

    private void setLastAutonomousExtremum(long timeStep_ms, int[] lastPoints) {
        int i;
        int j;
        ArrayList<Integer> autonomousIndices = new ArrayList<Integer>();
        for (j = 0; j < this.lastMaxIndices.size(); ++j) {
            i = this.lastMaxIndices.get(j);
            if (this.points[i] >= lastPoints[i]) continue;
            autonomousIndices.add(i);
        }
        if (!autonomousIndices.isEmpty()) {
            this.isLastAutonomousExtremum = true;
            log.finer(() -> String.format("%,12d  autonomous last max found %s from %s", timeStep_ms, Arrays.toString(autonomousIndices.toArray()), Arrays.toString(this.lastMaxIndices.toArray())));
        }
        autonomousIndices = new ArrayList();
        for (j = 0; j < this.lastMinIndices.size(); ++j) {
            i = this.lastMinIndices.get(j);
            if (this.points[i] <= lastPoints[i]) continue;
            autonomousIndices.add(i);
        }
        if (!autonomousIndices.isEmpty()) {
            this.isLastAutonomousExtremum = true;
            log.finer(() -> String.format("%,12d  autonomous last min found %s from %s", timeStep_ms, Arrays.toString(autonomousIndices.toArray()), Arrays.toString(this.lastMinIndices.toArray())));
        }
    }

    public void setMaxMinPoints(int[] newMaxPoints, int[] newMinPoints) {
        int value;
        int i;
        if (this.maxPoints.length != newMaxPoints.length || this.minPoints.length != newMinPoints.length) {
            throw new UnsupportedOperationException();
        }
        for (i = 0; i < newMaxPoints.length; ++i) {
            value = newMaxPoints[i];
            this.maxPoints[i] = value == Integer.MIN_VALUE ? value : value - 1;
        }
        for (i = 0; i < newMinPoints.length; ++i) {
            value = newMinPoints[i];
            this.minPoints[i] = value == Integer.MAX_VALUE ? value : value + 1;
        }
    }

    public void resetMaxMinPoints() {
        Arrays.fill(this.maxPoints, Integer.MIN_VALUE);
        Arrays.fill(this.minPoints, Integer.MAX_VALUE);
    }

    public boolean isLastAutonomousExtremum() {
        return this.isLastAutonomousExtremum;
    }
}

