/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.win32;

import java.util.Arrays;

public class TCHAR {
    public char[] chars;
    public static final int sizeof = 2;

    public TCHAR(int codePage, int length) {
        this.chars = new char[length];
    }

    public TCHAR(int codePage, char ch, boolean terminate) {
        char[] cArray;
        if (terminate) {
            char[] cArray2 = new char[2];
            cArray = cArray2;
            cArray2[0] = ch;
        } else {
            char[] cArray3 = new char[1];
            cArray = cArray3;
            cArray3[0] = ch;
        }
        this(codePage, cArray, false);
    }

    public TCHAR(int codePage, char[] chars, boolean terminate) {
        int charCount = chars.length;
        if (terminate && (charCount == 0 || charCount > 0 && chars[charCount - 1] != '\u0000')) {
            char[] newChars = new char[charCount + 1];
            System.arraycopy(chars, 0, newChars, 0, charCount);
            chars = newChars;
        }
        this.chars = chars;
    }

    public TCHAR(int codePage, String string2, boolean terminate) {
        this(codePage, TCHAR.getChars(string2, terminate), false);
    }

    static char[] getChars(String string2, boolean terminate) {
        int length = string2.length();
        char[] chars = new char[length + (terminate ? 1 : 0)];
        string2.getChars(0, length, chars, 0);
        return chars;
    }

    public void clear() {
        Arrays.fill(this.chars, '\u0000');
    }

    public int length() {
        return this.chars.length;
    }

    public int strlen() {
        int i2 = 0;
        while (i2 < this.chars.length) {
            if (this.chars[i2] == '\u0000') {
                return i2;
            }
            ++i2;
        }
        return this.chars.length;
    }

    public int tcharAt(int index) {
        return this.chars[index];
    }

    public String toString() {
        return this.toString(0, this.length());
    }

    public String toString(int start, int length) {
        return new String(this.chars, start, length);
    }
}

