/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.graupner.Polaron;
import gde.device.graupner.PolaronGathererThread;
import gde.device.graupner.PolaronSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import java.util.Locale;
import javax.xml.bind.JAXBException;

public class PolaronSports
extends Polaron {
    public PolaronSports(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        this.CHARGE_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3110"), Messages.getString((String)"GDE_MSGT3111"), Messages.getString((String)"GDE_MSGT3112"), Messages.getString((String)"GDE_MSGT3113"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3119"), Messages.getString((String)"GDE_MSGT3116"), Messages.getString((String)"GDE_MSGT3121"), Messages.getString((String)"GDE_MSGT3117"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3119"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3122")};
        this.DISCHARGE_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3110"), Messages.getString((String)"GDE_MSGT3111"), Messages.getString((String)"GDE_MSGT3112"), Messages.getString((String)"GDE_MSGT3113"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3124"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3122")};
    }

    public PolaronSports(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.CHARGE_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3110"), Messages.getString((String)"GDE_MSGT3111"), Messages.getString((String)"GDE_MSGT3112"), Messages.getString((String)"GDE_MSGT3113"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3119"), Messages.getString((String)"GDE_MSGT3116"), Messages.getString((String)"GDE_MSGT3121"), Messages.getString((String)"GDE_MSGT3117"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3119"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3122")};
        this.DISCHARGE_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3110"), Messages.getString((String)"GDE_MSGT3111"), Messages.getString((String)"GDE_MSGT3112"), Messages.getString((String)"GDE_MSGT3113"), Messages.getString((String)"GDE_MSGT3124"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3122")};
    }

    @Override
    public Polaron.GraupnerDeviceType getDeviceTypeIdentifier() {
        return Polaron.GraupnerDeviceType.PolaronSports;
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{1, this.channels.getActiveChannelNumber() == 3 ? 7 : 3};
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        if (deviceDataBufferSize == dataBuffer.length && this.isLinkedMode(dataBuffer)) {
            try {
                points[0] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[9]), Character.valueOf((char)dataBuffer[10]), Character.valueOf((char)dataBuffer[11]), Character.valueOf((char)dataBuffer[12])), 16);
                points[2] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[25]), Character.valueOf((char)dataBuffer[26]), Character.valueOf((char)dataBuffer[27]), Character.valueOf((char)dataBuffer[28])), 16);
                points[3] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[93]), Character.valueOf((char)dataBuffer[94]), Character.valueOf((char)dataBuffer[95]), Character.valueOf((char)dataBuffer[96])), 16);
                points[1] = points[2] + points[3];
                points[5] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[29]), Character.valueOf((char)dataBuffer[30]), Character.valueOf((char)dataBuffer[31]), Character.valueOf((char)dataBuffer[32])), 16);
                points[6] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[97]), Character.valueOf((char)dataBuffer[98]), Character.valueOf((char)dataBuffer[99]), Character.valueOf((char)dataBuffer[100])), 16);
                points[4] = points[5] + points[6];
                points[8] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[33]), Character.valueOf((char)dataBuffer[34]), Character.valueOf((char)dataBuffer[35]), Character.valueOf((char)dataBuffer[36])), 16);
                points[9] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[101]), Character.valueOf((char)dataBuffer[102]), Character.valueOf((char)dataBuffer[103]), Character.valueOf((char)dataBuffer[104])), 16);
                points[7] = points[8] + points[9];
                points[11] = Double.valueOf((double)(points[2] * points[5]) / 1000.0).intValue();
                points[12] = Double.valueOf((double)(points[3] * points[6]) / 1000.0).intValue();
                points[10] = points[11] + points[12];
                points[14] = Double.valueOf((double)(points[2] * points[8]) / 1000.0).intValue();
                points[15] = Double.valueOf((double)(points[3] * points[9]) / 1000.0).intValue();
                points[13] = points[14] + points[15];
                points[16] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[37]), Character.valueOf((char)dataBuffer[38]), Character.valueOf((char)dataBuffer[39]), Character.valueOf((char)dataBuffer[40])), 16);
                String sign = String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[41]), Character.valueOf((char)dataBuffer[42]), Character.valueOf((char)dataBuffer[43]), Character.valueOf((char)dataBuffer[44]));
                if (sign != null && sign.length() > 0 && Integer.parseInt(sign) == 0) {
                    points[16] = -1 * points[16];
                }
                points[17] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[105]), Character.valueOf((char)dataBuffer[106]), Character.valueOf((char)dataBuffer[107]), Character.valueOf((char)dataBuffer[108])), 16);
                sign = String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[109]), Character.valueOf((char)dataBuffer[110]), Character.valueOf((char)dataBuffer[111]), Character.valueOf((char)dataBuffer[112]));
                if (sign != null && sign.length() > 0 && Integer.parseInt(sign) == 0) {
                    points[17] = -1 * points[17];
                }
                points[18] = 0;
                int i = 0;
                int j = 0;
                while (i < 7) {
                    points[i + 19] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[49 + j]), Character.valueOf((char)dataBuffer[50 + j]), Character.valueOf((char)dataBuffer[51 + j]), Character.valueOf((char)dataBuffer[52 + j])), 16);
                    if (points[i + 19] > 0) {
                        maxVotage = points[i + 19] > maxVotage ? points[i + 19] : maxVotage;
                        minVotage = points[i + 19] < minVotage ? points[i + 19] : minVotage;
                    }
                    ++i;
                    j += 4;
                }
                i = 0;
                j = 0;
                while (i < 7) {
                    points[i + 26] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[117 + j]), Character.valueOf((char)dataBuffer[118 + j]), Character.valueOf((char)dataBuffer[119 + j]), Character.valueOf((char)dataBuffer[120 + j])), 16);
                    if (points[i + 26] > 0) {
                        maxVotage = points[i + 26] > maxVotage ? points[i + 26] : maxVotage;
                        minVotage = points[i + 26] < minVotage ? points[i + 26] : minVotage;
                    }
                    ++i;
                    j += 4;
                }
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
            points[18] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        } else {
            try {
                points[0] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[9]), Character.valueOf((char)dataBuffer[10]), Character.valueOf((char)dataBuffer[11]), Character.valueOf((char)dataBuffer[12])), 16);
                points[1] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[25]), Character.valueOf((char)dataBuffer[26]), Character.valueOf((char)dataBuffer[27]), Character.valueOf((char)dataBuffer[28])), 16);
                points[2] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[29]), Character.valueOf((char)dataBuffer[30]), Character.valueOf((char)dataBuffer[31]), Character.valueOf((char)dataBuffer[32])), 16);
                points[3] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[33]), Character.valueOf((char)dataBuffer[34]), Character.valueOf((char)dataBuffer[35]), Character.valueOf((char)dataBuffer[36])), 16);
                points[4] = Double.valueOf((double)(points[1] * points[2]) / 1000.0).intValue();
                points[5] = Double.valueOf((double)(points[1] * points[3]) / 1000.0).intValue();
                points[6] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[37]), Character.valueOf((char)dataBuffer[38]), Character.valueOf((char)dataBuffer[39]), Character.valueOf((char)dataBuffer[40])), 16);
                String sign = String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[41]), Character.valueOf((char)dataBuffer[42]), Character.valueOf((char)dataBuffer[43]), Character.valueOf((char)dataBuffer[44]));
                if (sign != null && sign.length() > 0 && Integer.parseInt(sign) == 0) {
                    points[6] = -1 * points[6];
                }
                points[7] = 0;
                int i = 0;
                int j = 0;
                while (i < 7) {
                    points[i + 8] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[49 + j]), Character.valueOf((char)dataBuffer[50 + j]), Character.valueOf((char)dataBuffer[51 + j]), Character.valueOf((char)dataBuffer[52 + j])), 16);
                    if (points[i + 8] > 0) {
                        maxVotage = points[i + 8] > maxVotage ? points[i + 8] : maxVotage;
                        minVotage = points[i + 8] < minVotage ? points[i + 8] : minVotage;
                    }
                    ++i;
                    j += 4;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
            points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        if (recordSet.getChannelConfigNumber() == 3) {
            for (int i = 0; i < recordDataSize; ++i) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                Polaron.log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[2] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[3] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[1] = points[2] + points[3];
                points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
                points[4] = points[5] + points[6];
                points[8] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + ((convertBuffer[23] & 0xFF) << 0);
                points[9] = ((convertBuffer[24] & 0xFF) << 24) + ((convertBuffer[25] & 0xFF) << 16) + ((convertBuffer[26] & 0xFF) << 8) + ((convertBuffer[27] & 0xFF) << 0);
                points[7] = points[8] + points[9];
                points[10] = Double.valueOf((double)points[1] / 1000.0 * (double)points[4]).intValue();
                points[11] = Double.valueOf((double)points[2] / 1000.0 * (double)points[5]).intValue();
                points[12] = Double.valueOf((double)points[3] / 1000.0 * (double)points[6]).intValue();
                points[13] = Double.valueOf((double)points[1] / 1000.0 * (double)points[7]).intValue();
                points[14] = Double.valueOf((double)points[1] / 1000.0 * (double)points[8]).intValue();
                points[15] = Double.valueOf((double)points[1] / 1000.0 * (double)points[9]).intValue();
                points[16] = ((convertBuffer[28] & 0xFF) << 24) + ((convertBuffer[29] & 0xFF) << 16) + ((convertBuffer[30] & 0xFF) << 8) + ((convertBuffer[31] & 0xFF) << 0);
                points[17] = ((convertBuffer[32] & 0xFF) << 24) + ((convertBuffer[33] & 0xFF) << 16) + ((convertBuffer[34] & 0xFF) << 8) + ((convertBuffer[35] & 0xFF) << 0);
                points[18] = 0;
                int j = 0;
                int k = 0;
                while (j < 14) {
                    points[j + 19] = ((convertBuffer[k + 36] & 0xFF) << 24) + ((convertBuffer[k + 37] & 0xFF) << 16) + ((convertBuffer[k + 38] & 0xFF) << 8) + ((convertBuffer[k + 39] & 0xFF) << 0);
                    if (points[j + 19] > 0) {
                        maxVotage = points[j + 19] > maxVotage ? points[j + 19] : maxVotage;
                        minVotage = points[j + 19] < minVotage ? points[j + 19] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[18] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        } else {
            for (int i = 0; i < recordDataSize; ++i) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                Polaron.log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[3] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                points[5] = Double.valueOf((double)points[1] / 1000.0 * (double)points[3]).intValue();
                points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
                points[7] = 0;
                int j = 0;
                int k = 0;
                while (j < 7) {
                    points[j + 8] = ((convertBuffer[k + 20] & 0xFF) << 24) + ((convertBuffer[k + 21] & 0xFF) << 16) + ((convertBuffer[k + 22] & 0xFF) << 8) + ((convertBuffer[k + 23] & 0xFF) << 0);
                    if (points[j + 8] > 0) {
                        maxVotage = points[j + 8] > maxVotage ? points[j + 8] : maxVotage;
                        minVotage = points[j + 8] < minVotage ? points[j + 8] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public boolean isProcessing(int outletNum, byte[] dataBuffer) {
        if (outletNum == 1) {
            int processingModeOut1 = this.getProcessingMode(dataBuffer);
            int n = processingModeOut1 = processingModeOut1 > 9 ? 0 : processingModeOut1;
            if (Polaron.log.isLoggable(java.util.logging.Level.FINE)) {
                Polaron.log.log(java.util.logging.Level.FINE, "processingModeOut1 = " + this.PROCESSING_MODE[processingModeOut1]);
            }
            return processingModeOut1 != 0 && processingModeOut1 != 6;
        }
        if (outletNum == 2) {
            int processingModeOut2;
            String tmpProcessing = String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[81]), Character.valueOf((char)dataBuffer[82]), Character.valueOf((char)dataBuffer[83]), Character.valueOf((char)dataBuffer[84]));
            int n = processingModeOut2 = tmpProcessing != null && tmpProcessing.length() > 0 ? Integer.parseInt(tmpProcessing, 16) : 0;
            if (Polaron.log.isLoggable(java.util.logging.Level.FINE)) {
                Polaron.log.log(java.util.logging.Level.FINE, "processingModeOut2 = " + this.PROCESSING_MODE[processingModeOut2]);
            }
            return processingModeOut2 != 0 && processingModeOut2 != 6;
        }
        return false;
    }

    @Override
    public int getProcessingMode(byte[] dataBuffer) {
        String processingMode = String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[13]), Character.valueOf((char)dataBuffer[14]), Character.valueOf((char)dataBuffer[15]), Character.valueOf((char)dataBuffer[16]));
        return processingMode != null && processingMode.length() > 0 ? Integer.parseInt(processingMode, 16) : 0;
    }

    @Override
    public String getProcessingType(byte[] dataBuffer) {
        String type = "";
        int processingMode = this.getProcessingMode(dataBuffer);
        String processingType = String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[17]), Character.valueOf((char)dataBuffer[18]), Character.valueOf((char)dataBuffer[19]), Character.valueOf((char)dataBuffer[20]));
        switch (processingMode) {
            case 1: {
                type = processingType != null && processingType.length() > 0 ? this.CHARGE_TYPE[Integer.parseInt(processingType, 16)] : "";
                break;
            }
            case 2: {
                type = processingType != null && processingType.length() > 0 ? this.DISCHARGE_TYPE[Integer.parseInt(processingType, 16)] : "";
                break;
            }
            case 6: {
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGE3118") + String.format("%02d", Integer.parseInt(processingType, 16)), 3);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "processingMode=" + processingMode + " processingType=" + type);
        }
        return type;
    }

    @Override
    public boolean isLinkedMode(byte[] dataBuffer) {
        int operationMode1 = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[13]), Character.valueOf((char)dataBuffer[14]), Character.valueOf((char)dataBuffer[15]), Character.valueOf((char)dataBuffer[16])), 16);
        int operationMode2 = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[81]), Character.valueOf((char)dataBuffer[82]), Character.valueOf((char)dataBuffer[83]), Character.valueOf((char)dataBuffer[84])), 16);
        int operationType1 = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[17]), Character.valueOf((char)dataBuffer[18]), Character.valueOf((char)dataBuffer[19]), Character.valueOf((char)dataBuffer[20])), 16);
        int operationType2 = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[85]), Character.valueOf((char)dataBuffer[86]), Character.valueOf((char)dataBuffer[87]), Character.valueOf((char)dataBuffer[88])), 16);
        return operationMode1 == operationMode2 && operationType1 == operationType2 && operationMode1 == 1 && operationType1 == 6 || operationMode1 == 2 && operationType1 == 4;
    }

    @Override
    public int getProductCode(byte[] dataBuffer) {
        return Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[5]), Character.valueOf((char)dataBuffer[6]), Character.valueOf((char)dataBuffer[7]), Character.valueOf((char)dataBuffer[8])), 16);
    }

    @Override
    public String getFirmwareVersion(byte[] dataBuffer) {
        return String.format(Locale.ENGLISH, "%.3f", (double)Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[1]), Character.valueOf((char)dataBuffer[2]), Character.valueOf((char)dataBuffer[3]), Character.valueOf((char)dataBuffer[4])), 16) / 1000.0);
    }

    @Override
    public void setTemperatureUnit(int channelNumber, RecordSet recordSet, byte[] dataBuffer) {
        int unit = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[45]), Character.valueOf((char)dataBuffer[46]), Character.valueOf((char)dataBuffer[47]), Character.valueOf((char)dataBuffer[48])), 16);
        if (unit == 0) {
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 6, "\u00b0C");
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 6, "\u00b0C");
        } else if (unit == 1) {
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 6, "\u00b0F");
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 6, "\u00b0F");
        }
    }

    @Override
    public int getCycleNumber(int outletNum, byte[] dataBuffer) {
        String cycleNumber = String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[21]), Character.valueOf((char)dataBuffer[22]), Character.valueOf((char)dataBuffer[23]), Character.valueOf((char)dataBuffer[24]));
        if (outletNum == 2) {
            try {
                cycleNumber = String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[89]), Character.valueOf((char)dataBuffer[90]), Character.valueOf((char)dataBuffer[91]), Character.valueOf((char)dataBuffer[92]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Integer.parseInt(cycleNumber, 16);
    }

    @Override
    public void open_closeCommPort() {
        block22: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        this.serialPort.open();
                        this.serialPort.write(PolaronSerialPort.RESET);
                        try {
                            int answer;
                            byte[] dataBuffer = this.serialPort.getData(true);
                            this.firmware = this.getFirmwareVersion(dataBuffer);
                            if (!this.getDeviceTypeIdentifier().name().equals(((Object)((Object)this)).getClass().getSimpleName()) && this.getDeviceTypeIdentifier().ordinal() != this.getProductCode(dataBuffer) && (answer = this.application.openYesNoMessageDialog(Messages.getString((String)"GDE_MSGW3102", (Object[])new String[]{Polaron.GraupnerDeviceType.values()[this.getProductCode(dataBuffer)].toString()}))) == 64) {
                                this.application.getDeviceSelectionDialog().setupDevice(Polaron.GraupnerDeviceType.values()[this.getProductCode(dataBuffer)].toString());
                                this.serialPort.close();
                                return;
                            }
                        }
                        catch (SerialPortException e) {
                            if (this.serialPort.isConnected()) {
                                this.serialPort.write(PolaronSerialPort.RESET);
                            }
                            throw e;
                        }
                        catch (TimeOutException e) {
                            if (this.serialPort.isConnected()) {
                                this.serialPort.write(PolaronSerialPort.RESET);
                            }
                            throw new SerialPortException(e.getMessage());
                        }
                        catch (Exception e) {
                            if (this.serialPort.isConnected()) {
                                this.serialPort.write(PolaronSerialPort.RESET);
                            }
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                            throw e;
                        }
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block22;
                        this.dataGatherThread = new PolaronGathererThread();
                        try {
                            if (this.serialPort.isConnected()) {
                                this.dataGatherThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.serialPort.close();
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.serialPort.close();
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.serialPort.close();
                    }
                } else {
                    if (this.dataGatherThread != null) {
                        try {
                            this.dataGatherThread.stopDataGatheringThread(false, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.serialPort.close();
                }
            }
        }
    }
}

