/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.transitions;

import gde.data.Record;
import gde.device.TransitionClassTypes;
import gde.device.TransitionType;
import gde.log.Logger;
import gde.utils.StringHelper;

public final class Transition {
    static final String $CLASS_NAME = Transition.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    final int referenceSize;
    final int thresholdSize;
    final int recoverySize;
    private final Record transitionRecord;
    private final TransitionType transitionType;
    final int startIndex;
    final int referenceStartIndex;
    final int referenceEndIndex;
    final int thresholdStartIndex;
    final int thresholdEndIndex;
    final int recoveryStartIndex;
    final int recoveryEndIndex;

    public Transition(int startIndex, int referenceSize, int thresholdStartIndex, int thresholdSize, Record transitionRecord, TransitionType transitionType) {
        this.startIndex = startIndex;
        this.referenceStartIndex = thresholdStartIndex - referenceSize;
        this.referenceSize = referenceSize;
        this.referenceEndIndex = thresholdStartIndex - 1;
        this.thresholdStartIndex = thresholdStartIndex;
        this.thresholdSize = thresholdSize;
        this.transitionRecord = transitionRecord;
        this.transitionType = transitionType;
        this.thresholdEndIndex = thresholdStartIndex + thresholdSize - 1;
        this.recoveryStartIndex = -1;
        this.recoverySize = 0;
        this.recoveryEndIndex = -1;
    }

    public Transition(int startIndex, int referenceSize, int thresholdStartIndex, int thresholdSize, int recoveryStartIndex, int recoverySize, Record transitionRecord, TransitionType transitionType) {
        this.startIndex = startIndex;
        this.referenceStartIndex = thresholdStartIndex - referenceSize;
        this.referenceSize = referenceSize;
        this.referenceEndIndex = thresholdStartIndex - 1;
        this.thresholdStartIndex = thresholdStartIndex;
        this.thresholdSize = thresholdSize;
        this.transitionRecord = transitionRecord;
        this.transitionType = transitionType;
        this.thresholdEndIndex = recoveryStartIndex - 1;
        this.recoveryStartIndex = recoveryStartIndex;
        this.recoverySize = recoverySize;
        this.recoveryEndIndex = recoveryStartIndex + recoverySize - 1;
    }

    public double getTimeStamp_ms(int index) {
        return this.transitionRecord.getTime_ms(index);
    }

    public long getReferenceStartTimeStamp_ms() {
        return (long)this.transitionRecord.getTime_ms(this.referenceStartIndex);
    }

    public long getThresholdStartTimeStamp_ms() {
        return (long)this.transitionRecord.getTime_ms(this.thresholdStartIndex);
    }

    public long getThresholdEndTimeStamp_ms() {
        return (long)this.transitionRecord.getTime_ms(this.thresholdEndIndex);
    }

    public String getFormatedDuration(int index) {
        return StringHelper.getFormatedDuration("HH:mm:ss.SSS", (long)this.transitionRecord.getParent().getTime_ms(index));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.transitionType.getTransitionId()).append(" ").append(" ");
        sb.append("threshold=").append(this.getFormatedDuration(this.thresholdStartIndex)).append(", ");
        sb.append("thresholdStartIndex/size=").append(this.thresholdStartIndex).append("|").append(this.thresholdSize).append(", ");
        sb.append("isPeak=").append(this.isPeak()).append(", ").append("isSlope=").append(this.isSlope()).append(", ");
        sb.append("referenceStartIndex/size=").append(this.referenceStartIndex).append("|").append(this.referenceSize).append(", ");
        sb.append("reference=").append(this.getFormatedDuration(this.referenceStartIndex));
        if (this.recoveryStartIndex > 0) {
            sb.append(", ");
            sb.append("recovery=").append(this.getFormatedDuration(this.recoveryStartIndex)).append(", ");
            sb.append("recoveryStartIndex/size=").append(this.recoveryStartIndex).append("|").append(this.recoverySize).append(", ");
        }
        return sb.toString();
    }

    public boolean isSlope() {
        return this.transitionType.getClassType() == TransitionClassTypes.SLOPE;
    }

    public boolean isPeak() {
        return this.transitionType.getClassType() == TransitionClassTypes.PEAK;
    }

    public boolean isPulse() {
        return this.transitionType.getClassType() == TransitionClassTypes.PULSE;
    }

    public TransitionType getTransitionType() {
        return this.transitionType;
    }

    public int getReferenceStartIndex() {
        return this.referenceStartIndex;
    }

    public int getReferenceEndIndex() {
        return this.referenceEndIndex;
    }

    public int getThresholdStartIndex() {
        return this.thresholdStartIndex;
    }

    public int getThresholdEndIndex() {
        return this.thresholdEndIndex;
    }

    public int getRecoveryStartIndex() {
        return this.recoveryStartIndex;
    }

    public int getRecoveryEndIndex() {
        return this.recoveryEndIndex;
    }

    public int getReferenceSize() {
        return this.referenceSize;
    }

    public int getThresholdSize() {
        return this.thresholdSize;
    }

    public int getRecoverySize() {
        return this.recoverySize;
    }
}

