/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.ICustomDestinationList;
import org.eclipse.swt.internal.ole.win32.IObjectArray;
import org.eclipse.swt.internal.ole.win32.IObjectCollection;
import org.eclipse.swt.internal.ole.win32.IPropertyStore;
import org.eclipse.swt.internal.ole.win32.IShellLink;
import org.eclipse.swt.internal.ole.win32.ITaskbarList3;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PROPERTYKEY;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Widget;

public class TaskBar
extends Widget {
    int itemCount;
    TaskItem[] items = new TaskItem[4];
    ITaskbarList3 mTaskbarList3;
    String iconsDir;
    static final char[] EXE_PATH;
    static final PROPERTYKEY PKEY_Title;
    static final PROPERTYKEY PKEY_AppUserModel_IsDestListSeparator;
    static final String EXE_PATH_KEY = "org.eclipse.swt.win32.taskbar.executable";
    static final String EXE_ARGS_KEY = "org.eclipse.swt.win32.taskbar.arguments";
    static final String ICON_KEY = "org.eclipse.swt.win32.taskbar.icon";
    static final String ICON_INDEX_KEY = "org.eclipse.swt.win32.taskbar.icon.index";

    static {
        PKEY_Title = new PROPERTYKEY();
        PKEY_AppUserModel_IsDestListSeparator = new PROPERTYKEY();
        OS.PSPropertyKeyFromString("{F29F85E0-4FF9-1068-AB91-08002B27B3D9} 2\u0000".toCharArray(), PKEY_Title);
        OS.PSPropertyKeyFromString("{9F4C2855-9F79-4B39-A8D0-E1D42DE1D5F3}, 6\u0000".toCharArray(), PKEY_AppUserModel_IsDestListSeparator);
        char[] buffer = new char[260];
        while (OS.GetModuleFileName(0L, buffer, buffer.length) == buffer.length) {
            buffer = new char[buffer.length + 260];
        }
        EXE_PATH = buffer;
    }

    TaskBar(Display display, int style) {
        this.display = display;
        this.createHandle();
        this.reskinWidget();
    }

    void createHandle() {
        long[] ppv = new long[1];
        int hr = COM.CoCreateInstance(COM.CLSID_TaskbarList, 0L, 1, COM.IID_ITaskbarList3, ppv);
        if (hr != 0) {
            this.error(2);
        }
        this.mTaskbarList3 = new ITaskbarList3(ppv[0]);
    }

    void createItem(TaskItem item2, int index) {
        if (index == -1) {
            index = this.itemCount;
        }
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TaskItem[] newItems = new TaskItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item2;
    }

    void createItems() {
        Shell[] shells = this.display.getShells();
        int i2 = 0;
        while (i2 < shells.length) {
            this.getItem(shells[i2]);
            ++i2;
        }
        this.getItem(null);
    }

    IShellLink createShellLink(MenuItem item2) {
        IPropertyStore pPropStore;
        PROPERTYKEY key2;
        int style = item2.getStyle();
        if ((style & 0x40) != 0) {
            return null;
        }
        long[] ppv = new long[1];
        int hr = COM.CoCreateInstance(COM.CLSID_ShellLink, 0L, 1, COM.IID_IShellLinkW, ppv);
        if (hr != 0) {
            this.error(2);
        }
        IShellLink pLink = new IShellLink(ppv[0]);
        long hHeap = OS.GetProcessHeap();
        long pv = OS.HeapAlloc(hHeap, 8, OS.PROPVARIANT_sizeof());
        long titlePtr = 0L;
        if ((style & 2) != 0) {
            OS.MoveMemory(pv, new short[]{11}, 2);
            OS.MoveMemory(pv + 8L, new short[]{-1}, 2);
            key2 = PKEY_AppUserModel_IsDestListSeparator;
        } else {
            String text2 = item2.getText();
            int length = text2.length();
            char[] buffer = new char[length + 1];
            text2.getChars(0, length, buffer, 0);
            titlePtr = OS.HeapAlloc(hHeap, 8, buffer.length * 2);
            OS.MoveMemory(titlePtr, buffer, buffer.length * 2);
            OS.MoveMemory(pv, new short[]{31}, 2);
            OS.MoveMemory(pv + 8L, new long[]{titlePtr}, C.PTR_SIZEOF);
            key2 = PKEY_Title;
            String exePath = (String)item2.getData(EXE_PATH_KEY);
            if (exePath != null) {
                length = exePath.length();
                buffer = new char[length + 1];
                exePath.getChars(0, length, buffer, 0);
            } else {
                buffer = EXE_PATH;
            }
            hr = pLink.SetPath(buffer);
            if (hr != 0) {
                this.error(5);
            }
            if ((text2 = (String)item2.getData(EXE_ARGS_KEY)) == null) {
                text2 = "--launcher.openFile /SWTINTERNAL_ID" + item2.id;
            }
            length = text2.length();
            buffer = new char[length + 1];
            text2.getChars(0, length, buffer, 0);
            hr = pLink.SetArguments(buffer);
            if (hr != 0) {
                this.error(5);
            }
            String icon = (String)item2.getData(ICON_KEY);
            int index = 0;
            if (icon != null) {
                text2 = (String)item2.getData(ICON_INDEX_KEY);
                if (text2 != null) {
                    index = Integer.parseInt(text2);
                }
            } else {
                String directory = null;
                Image image = item2.getImage();
                if (image != null) {
                    directory = this.getIconsDir();
                }
                if (directory != null) {
                    ImageData data2;
                    icon = String.valueOf(directory) + "\\" + "menu" + item2.id + ".ico";
                    if (item2.hBitmap != 0L) {
                        Image image2 = Image.win32_new(this.display, 0, item2.hBitmap);
                        data2 = image2.getImageData(DPIUtil.getDeviceZoom());
                    } else {
                        data2 = image.getImageData(DPIUtil.getDeviceZoom());
                    }
                    ImageLoader loader2 = new ImageLoader();
                    loader2.data = new ImageData[]{data2};
                    loader2.save(icon, 3);
                }
            }
            if (icon != null) {
                length = icon.length();
                buffer = new char[length + 1];
                icon.getChars(0, length, buffer, 0);
                hr = pLink.SetIconLocation(buffer, index);
                if (hr != 0) {
                    this.error(5);
                }
            }
        }
        hr = pLink.QueryInterface(COM.IID_IPropertyStore, ppv);
        if (hr != 0) {
            this.error(2);
        }
        if ((hr = (pPropStore = new IPropertyStore(ppv[0])).SetValue(key2, pv)) != 0) {
            this.error(5);
        }
        pPropStore.Commit();
        pPropStore.Release();
        OS.HeapFree(hHeap, 0, pv);
        if (titlePtr != 0L) {
            OS.HeapFree(hHeap, 0, titlePtr);
        }
        return pLink;
    }

    IObjectArray createShellLinkArray(MenuItem[] items) {
        if (items == null) {
            return null;
        }
        if (items.length == 0) {
            return null;
        }
        long[] ppv = new long[1];
        int hr = COM.CoCreateInstance(COM.CLSID_EnumerableObjectCollection, 0L, 1, COM.IID_IObjectCollection, ppv);
        if (hr != 0) {
            this.error(2);
        }
        IObjectCollection pObjColl = new IObjectCollection(ppv[0]);
        int i2 = 0;
        while (i2 < items.length) {
            IShellLink pLink = this.createShellLink(items[i2]);
            if (pLink != null) {
                pObjColl.AddObject(pLink);
                if (hr != 0) {
                    this.error(5);
                }
                pLink.Release();
            }
            ++i2;
        }
        hr = pObjColl.QueryInterface(COM.IID_IObjectArray, ppv);
        if (hr != 0) {
            this.error(2);
        }
        IObjectArray poa = new IObjectArray(ppv[0]);
        pObjColl.Release();
        return poa;
    }

    void destroyItem(TaskItem item2) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item2) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    String getIconsDir() {
        if (this.iconsDir != null) {
            return this.iconsDir;
        }
        String appData = System.getenv("LOCALAPPDATA");
        String appName = Display.APP_NAME;
        if (appData == null || appName == null) {
            return null;
        }
        appName = appName.replaceAll("[\\\\/:*?\"<>|]", "_");
        File dir = new File(String.valueOf(appData) + "\\" + appName + "\\ico_dir");
        if (dir.exists()) {
            File[] fileArray = dir.listFiles();
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                File file = fileArray[n3];
                file.delete();
                ++n3;
            }
        } else if (!dir.mkdirs()) {
            return null;
        }
        this.iconsDir = dir.getPath();
        return this.iconsDir;
    }

    public TaskItem getItem(int index) {
        this.checkWidget();
        this.createItems();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public TaskItem getItem(Shell shell) {
        this.checkWidget();
        int i2 = 0;
        while (i2 < this.items.length) {
            if (this.items[i2] != null && this.items[i2].shell == shell) {
                return this.items[i2];
            }
            ++i2;
        }
        TaskItem item2 = new TaskItem(this, 0);
        if (shell != null) {
            item2.setShell(shell);
        }
        return item2;
    }

    public int getItemCount() {
        this.checkWidget();
        this.createItems();
        return this.itemCount;
    }

    public TaskItem[] getItems() {
        this.checkWidget();
        this.createItems();
        TaskItem[] result2 = new TaskItem[this.itemCount];
        System.arraycopy(this.items, 0, result2, 0, result2.length);
        return result2;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                TaskItem item2 = this.items[i2];
                if (item2 != null && !item2.isDisposed()) {
                    item2.release(false);
                }
                ++i2;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.display.taskBar == this) {
            this.display.taskBar = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.mTaskbarList3.Release();
        this.mTaskbarList3 = null;
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                TaskItem item2 = this.items[i2];
                if (item2 != null) {
                    item2.reskin(flags);
                }
                ++i2;
            }
        }
        super.reskinChildren(flags);
    }

    void setMenu(Menu menu2) {
        long[] ppv = new long[1];
        int hr = COM.CoCreateInstance(COM.CLSID_DestinationList, 0L, 1, COM.IID_ICustomDestinationList, ppv);
        if (hr != 0) {
            this.error(2);
        }
        ICustomDestinationList pDestList = new ICustomDestinationList(ppv[0]);
        String appName = Display.APP_NAME;
        char[] cArray = new char[4];
        cArray[0] = 83;
        cArray[1] = 87;
        cArray[2] = 84;
        char[] buffer = cArray;
        if (appName != null && appName.length() > 0) {
            int length = appName.length();
            buffer = new char[length + 1];
            appName.getChars(0, length, buffer, 0);
        }
        MenuItem[] items = null;
        if (menu2 != null && (items = menu2.getItems()).length != 0) {
            IObjectArray poa = this.createShellLinkArray(items);
            if (poa != null) {
                hr = pDestList.SetAppID(buffer);
                if (hr != 0) {
                    this.error(5);
                }
                int[] cMaxSlots = new int[1];
                pDestList.BeginList(cMaxSlots, COM.IID_IObjectArray, ppv);
                if (hr != 0) {
                    this.error(5);
                }
                IObjectArray pRemovedItems = new IObjectArray(ppv[0]);
                int[] count = new int[1];
                poa.GetCount(count);
                if (count[0] != 0 && (hr = pDestList.AddUserTasks(poa)) != 0) {
                    this.error(5);
                }
                int i2 = 0;
                while (i2 < items.length) {
                    MenuItem[] subItems;
                    IObjectArray poa2;
                    Menu subMenu;
                    MenuItem item2 = items[i2];
                    if ((item2.getStyle() & 0x40) != 0 && (subMenu = item2.getMenu()) != null && (poa2 = this.createShellLinkArray(subItems = subMenu.getItems())) != null) {
                        poa2.GetCount(count);
                        if (count[0] != 0) {
                            String text2 = item2.getText();
                            int length = text2.length();
                            char[] buffer2 = new char[length + 1];
                            text2.getChars(0, length, buffer2, 0);
                            hr = pDestList.AppendCategory(buffer2, poa2);
                            if (hr != 0) {
                                this.error(5);
                            }
                        }
                        poa2.Release();
                    }
                    poa.Release();
                    ++i2;
                }
                hr = pDestList.CommitList();
                if (hr != 0) {
                    this.error(5);
                }
                pRemovedItems.Release();
            }
        } else {
            hr = pDestList.DeleteList(buffer);
            if (hr != 0) {
                this.error(5);
            }
        }
        pDestList.Release();
    }
}

