/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.util.LinkedHashSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.win32.FILETIME;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PROCESS_INFORMATION;
import org.eclipse.swt.internal.win32.SHELLEXECUTEINFO;
import org.eclipse.swt.internal.win32.SHFILEINFO;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;

public final class Program {
    String name;
    String command;
    String iconName;
    String extension;
    static final String[] ARGUMENTS = new String[]{"%1", "%l", "%L"};

    Program() {
    }

    static String assocQueryString(int assocStr, TCHAR key2, boolean expand) {
        TCHAR pszOut = new TCHAR(0, 1024);
        int[] pcchOut = new int[]{pszOut.length()};
        int flags = 1056;
        int result2 = OS.AssocQueryString(flags, assocStr, key2, null, pszOut, pcchOut);
        if (result2 == -2147467261) {
            pszOut = new TCHAR(0, pcchOut[0]);
            result2 = OS.AssocQueryString(flags, assocStr, key2, null, pszOut, pcchOut);
        }
        if (result2 == 0) {
            if (expand) {
                int length = OS.ExpandEnvironmentStrings(pszOut, null, 0);
                if (length != 0) {
                    TCHAR lpDst = new TCHAR(0, length);
                    OS.ExpandEnvironmentStrings(pszOut, lpDst, length);
                    return lpDst.toString(0, Math.max(0, length - 1));
                }
                return "";
            }
            return pszOut.toString(0, Math.max(0, pcchOut[0] - 1));
        }
        return null;
    }

    public static Program findProgram(String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        TCHAR key2 = new TCHAR(0, extension, true);
        Program program = null;
        String command2 = Program.assocQueryString(1, key2, true);
        if (command2 != null) {
            String iconName;
            String name = null;
            if (name == null) {
                name = Program.assocQueryString(3, key2, false);
            }
            if (name == null) {
                name = Program.assocQueryString(4, key2, false);
            }
            if (name == null) {
                name = "";
            }
            if ((iconName = Program.assocQueryString(15, key2, true)) == null) {
                iconName = "";
            }
            program = new Program();
            program.name = name;
            program.command = command2;
            program.iconName = iconName;
            program.extension = extension;
        }
        return program;
    }

    public static String[] getExtensions() {
        String[] extensions = new String[1024];
        char[] lpName = new char[1024];
        int[] lpcName = new int[]{lpName.length};
        FILETIME ft = new FILETIME();
        int dwIndex = 0;
        int count = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, dwIndex, lpName, lpcName, null, null, null, ft) != 259) {
            String extension = new String(lpName, 0, lpcName[0]);
            lpcName[0] = lpName.length;
            if (extension.length() > 0 && extension.charAt(0) == '.') {
                if (count == extensions.length) {
                    String[] newExtensions = new String[extensions.length + 1024];
                    System.arraycopy(extensions, 0, newExtensions, 0, extensions.length);
                    extensions = newExtensions;
                }
                extensions[count++] = extension;
            }
            ++dwIndex;
        }
        if (count != extensions.length) {
            String[] newExtension = new String[count];
            System.arraycopy(extensions, 0, newExtension, 0, count);
            extensions = newExtension;
        }
        return extensions;
    }

    static String getKeyValue(String string2, boolean expand) {
        TCHAR key2 = new TCHAR(0, string2, true);
        long[] phkResult = new long[1];
        if (OS.RegOpenKeyEx(Integer.MIN_VALUE, key2, 0, 131097, phkResult) != 0) {
            return null;
        }
        String result2 = null;
        int[] lpcbData = new int[1];
        if (OS.RegQueryValueEx(phkResult[0], null, 0L, null, null, lpcbData) == 0) {
            char[] lpData;
            result2 = "";
            int length = lpcbData[0] / 2;
            if (lpcbData[0] % 2 != 0) {
                ++length;
            }
            if (length != 0 && OS.RegQueryValueEx(phkResult[0], null, 0L, null, lpData = new char[length], lpcbData) == 0) {
                if (expand) {
                    length = OS.ExpandEnvironmentStrings(lpData, null, 0);
                    if (length != 0) {
                        char[] lpDst = new char[length];
                        OS.ExpandEnvironmentStrings(lpData, lpDst, length);
                        result2 = new String(lpDst, 0, length - 1);
                    }
                } else {
                    result2 = new String(lpData, 0, length - 1);
                }
            }
        }
        if (phkResult[0] != 0L) {
            OS.RegCloseKey(phkResult[0]);
        }
        return result2;
    }

    static Program getProgram(String key2, String extension) {
        String name = Program.getKeyValue(key2, false);
        if (name == null || name.length() == 0) {
            name = key2;
        }
        String DEFAULT_COMMAND = "\\shell";
        String defaultCommand = Program.getKeyValue(String.valueOf(key2) + DEFAULT_COMMAND, true);
        if (defaultCommand == null || defaultCommand.length() == 0) {
            defaultCommand = "open";
        }
        String COMMAND = "\\shell\\" + defaultCommand + "\\command";
        String command2 = Program.getKeyValue(String.valueOf(key2) + COMMAND, true);
        if (command2 == null || command2.length() == 0) {
            return null;
        }
        String DEFAULT_ICON = "\\DefaultIcon";
        String iconName = Program.getKeyValue(String.valueOf(key2) + DEFAULT_ICON, true);
        if (iconName == null) {
            iconName = "";
        }
        Program program = new Program();
        program.name = name;
        program.command = command2;
        program.iconName = iconName;
        program.extension = extension;
        return program;
    }

    public static Program[] getPrograms() {
        LinkedHashSet<Program> programs = new LinkedHashSet<Program>(1024);
        char[] lpName = new char[1024];
        int[] lpcName = new int[]{lpName.length};
        FILETIME ft = new FILETIME();
        int dwIndex = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, dwIndex, lpName, lpcName, null, null, null, ft) != 259) {
            String path2 = new String(lpName, 0, lpcName[0]);
            lpcName[0] = lpName.length;
            Program program = Program.getProgram(path2, null);
            if (program != null) {
                programs.add(program);
            }
            ++dwIndex;
        }
        return programs.toArray(new Program[programs.size()]);
    }

    public static boolean launch(String fileName) {
        return Program.launch(fileName, null);
    }

    public static boolean launch(String fileName, String workingDir) {
        if (fileName == null) {
            SWT.error(4);
        }
        long hHeap = OS.GetProcessHeap();
        TCHAR buffer = new TCHAR(0, fileName, true);
        int byteCount = buffer.length() * 2;
        long lpFile = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(lpFile, buffer, byteCount);
        long lpDirectory = 0L;
        if (workingDir != null && OS.PathIsExe(lpFile)) {
            TCHAR buffer1 = new TCHAR(0, workingDir, true);
            byteCount = buffer1.length() * 2;
            lpDirectory = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpDirectory, buffer1, byteCount);
        }
        SHELLEXECUTEINFO info = new SHELLEXECUTEINFO();
        info.cbSize = SHELLEXECUTEINFO.sizeof;
        info.lpFile = lpFile;
        info.lpDirectory = lpDirectory;
        info.nShow = 5;
        boolean result2 = OS.ShellExecuteEx(info);
        if (lpFile != 0L) {
            OS.HeapFree(hHeap, 0, lpFile);
        }
        if (lpDirectory != 0L) {
            OS.HeapFree(hHeap, 0, lpDirectory);
        }
        return result2;
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        int index = 0;
        boolean append2 = true;
        String prefix = this.command;
        String suffix = "";
        while (index < ARGUMENTS.length) {
            int i2 = this.command.indexOf(ARGUMENTS[index]);
            if (i2 != -1) {
                append2 = false;
                prefix = this.command.substring(0, i2);
                suffix = this.command.substring(i2 + ARGUMENTS[index].length(), this.command.length());
                break;
            }
            ++index;
        }
        if (append2) {
            fileName = " \"" + fileName + "\"";
        }
        String commandLine = String.valueOf(prefix) + fileName + suffix;
        long hHeap = OS.GetProcessHeap();
        TCHAR buffer = new TCHAR(0, commandLine, true);
        int byteCount = buffer.length() * 2;
        long lpCommandLine = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(lpCommandLine, buffer, byteCount);
        STARTUPINFO lpStartupInfo = new STARTUPINFO();
        lpStartupInfo.cb = STARTUPINFO.sizeof;
        PROCESS_INFORMATION lpProcessInformation = new PROCESS_INFORMATION();
        boolean success = OS.CreateProcess(0L, lpCommandLine, 0L, 0L, false, 0, 0L, 0L, lpStartupInfo, lpProcessInformation);
        if (lpCommandLine != 0L) {
            OS.HeapFree(hHeap, 0, lpCommandLine);
        }
        if (lpProcessInformation.hProcess != 0L) {
            OS.CloseHandle(lpProcessInformation.hProcess);
        }
        if (lpProcessInformation.hThread != 0L) {
            OS.CloseHandle(lpProcessInformation.hThread);
        }
        return success;
    }

    public ImageData getImageData() {
        int length;
        if (this.extension != null) {
            SHFILEINFO shfi = new SHFILEINFO();
            int flags = 273;
            TCHAR pszPath = new TCHAR(0, this.extension, true);
            OS.SHGetFileInfo(pszPath.chars, 128, shfi, SHFILEINFO.sizeof, flags);
            if (shfi.hIcon != 0L) {
                Image image = Image.win32_new(null, 1, shfi.hIcon);
                ImageData imageData = image.getImageData();
                image.dispose();
                return imageData;
            }
        }
        int nIconIndex = 0;
        String fileName = this.iconName;
        int index = this.iconName.indexOf(44);
        if (index != -1) {
            fileName = this.iconName.substring(0, index);
            String iconIndex = this.iconName.substring(index + 1, this.iconName.length()).trim();
            try {
                nIconIndex = Integer.parseInt(iconIndex);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((length = fileName.length()) > 1 && fileName.charAt(0) == '\"' && fileName.charAt(length - 1) == '\"') {
            fileName = fileName.substring(1, length - 1);
        }
        TCHAR lpszFile = new TCHAR(0, fileName, true);
        long[] phiconSmall = new long[1];
        long[] phiconLarge = null;
        OS.ExtractIconEx(lpszFile, nIconIndex, phiconLarge, phiconSmall, 1);
        if (phiconSmall[0] == 0L) {
            return null;
        }
        Image image = Image.win32_new(null, 1, phiconSmall[0]);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name) && this.command.equals(program.command) && this.iconName.equals(program.iconName);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.iconName.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

