/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextLineSpacingProvider;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.ScrollBar;

class StyledTextRenderer {
    Device device;
    StyledText styledText;
    StyledTextContent content;
    StyledTextLineSpacingProvider lineSpacingProvider;
    boolean lineSpacingComputing;
    Font regularFont;
    Font boldFont;
    Font italicFont;
    Font boldItalicFont;
    int tabWidth;
    int ascent;
    int descent;
    int averageCharWidth;
    int tabLength;
    int topIndex = -1;
    TextLayout[] layouts;
    int lineCount;
    LineSizeInfo[] lineSizes;
    LineInfo[] lines;
    int maxWidth;
    int maxWidthLineIndex;
    boolean idleRunning;
    Bullet[] bullets;
    int[] bulletsIndices;
    int[] redrawLines;
    int[] ranges;
    int styleCount;
    StyleRange[] styles;
    StyleRange[] stylesSet;
    int stylesSetCount = 0;
    boolean hasLinks;
    boolean fixedPitch;
    static final int BULLET_MARGIN = 8;
    static final boolean COMPACT_STYLES = true;
    static final boolean MERGE_STYLES = true;
    static final int GROW = 32;
    static final int IDLE_TIME = 50;
    static final int CACHE_SIZE = 300;
    static final int BACKGROUND = 1;
    static final int ALIGNMENT = 2;
    static final int INDENT = 4;
    static final int JUSTIFY = 8;
    static final int SEGMENTS = 32;
    static final int TABSTOPS = 64;
    static final int WRAP_INDENT = 128;
    static final int SEGMENT_CHARS = 256;
    static final int VERTICAL_INDENT = 512;

    static int cap(TextLayout layout, int offset) {
        if (layout == null) {
            return offset;
        }
        return Math.min(layout.getText().length() - 1, Math.max(0, offset));
    }

    StyledTextRenderer(Device device, StyledText styledText) {
        this.device = device;
        this.styledText = styledText;
    }

    int addMerge(int[] mergeRanges, StyleRange[] mergeStyles, int mergeCount, int modifyStart, int modifyEnd) {
        int grow;
        int rangeCount = this.styleCount << 1;
        StyleRange endStyle = null;
        int endStart = 0;
        int endLength = 0;
        if (modifyEnd < rangeCount) {
            endStyle = this.styles[modifyEnd >> 1];
            endStart = this.ranges[modifyEnd];
            endLength = this.ranges[modifyEnd + 1];
        }
        if (rangeCount + (grow = mergeCount - (modifyEnd - modifyStart)) >= this.ranges.length) {
            int[] tmpRanges = new int[this.ranges.length + grow + 64];
            System.arraycopy(this.ranges, 0, tmpRanges, 0, modifyStart);
            StyleRange[] tmpStyles = new StyleRange[this.styles.length + (grow >> 1) + 32];
            System.arraycopy(this.styles, 0, tmpStyles, 0, modifyStart >> 1);
            if (rangeCount > modifyEnd) {
                System.arraycopy(this.ranges, modifyEnd, tmpRanges, modifyStart + mergeCount, rangeCount - modifyEnd);
                System.arraycopy(this.styles, modifyEnd >> 1, tmpStyles, modifyStart + mergeCount >> 1, this.styleCount - (modifyEnd >> 1));
            }
            this.ranges = tmpRanges;
            this.styles = tmpStyles;
        } else if (rangeCount > modifyEnd) {
            System.arraycopy(this.ranges, modifyEnd, this.ranges, modifyStart + mergeCount, rangeCount - modifyEnd);
            System.arraycopy(this.styles, modifyEnd >> 1, this.styles, modifyStart + mergeCount >> 1, this.styleCount - (modifyEnd >> 1));
        }
        int j2 = modifyStart;
        int i2 = 0;
        while (i2 < mergeCount) {
            if (j2 > 0 && this.ranges[j2 - 2] + this.ranges[j2 - 1] == mergeRanges[i2] && mergeStyles[i2 >> 1].similarTo(this.styles[j2 - 2 >> 1])) {
                int n2 = j2 - 1;
                this.ranges[n2] = this.ranges[n2] + mergeRanges[i2 + 1];
            } else {
                this.styles[j2 >> 1] = mergeStyles[i2 >> 1];
                this.ranges[j2++] = mergeRanges[i2];
                this.ranges[j2++] = mergeRanges[i2 + 1];
            }
            i2 += 2;
        }
        if (endStyle != null && this.ranges[j2 - 2] + this.ranges[j2 - 1] == endStart && endStyle.similarTo(this.styles[j2 - 2 >> 1])) {
            int n3 = j2 - 1;
            this.ranges[n3] = this.ranges[n3] + endLength;
            modifyEnd += 2;
            mergeCount += 2;
        }
        if (rangeCount > modifyEnd) {
            System.arraycopy(this.ranges, modifyStart + mergeCount, this.ranges, j2, rangeCount - modifyEnd);
            System.arraycopy(this.styles, modifyStart + mergeCount >> 1, this.styles, j2 >> 1, this.styleCount - (modifyEnd >> 1));
        }
        grow = j2 - modifyStart - (modifyEnd - modifyStart);
        this.styleCount += grow >> 1;
        return grow;
    }

    /*
     * Unable to fully structure code
     */
    int addMerge(StyleRange[] mergeStyles, int mergeCount, int modifyStart, int modifyEnd) {
        grow = mergeCount - (modifyEnd - modifyStart);
        endStyle = null;
        if (modifyEnd < this.styleCount) {
            endStyle = this.styles[modifyEnd];
        }
        if (this.styleCount + grow >= this.styles.length) {
            tmpStyles = new StyleRange[this.styles.length + grow + 32];
            System.arraycopy(this.styles, 0, tmpStyles, 0, modifyStart);
            if (this.styleCount > modifyEnd) {
                System.arraycopy(this.styles, modifyEnd, tmpStyles, modifyStart + mergeCount, this.styleCount - modifyEnd);
            }
            this.styles = tmpStyles;
        } else if (this.styleCount > modifyEnd) {
            System.arraycopy(this.styles, modifyEnd, this.styles, modifyStart + mergeCount, this.styleCount - modifyEnd);
        }
        j = modifyStart;
        i = 0;
        while (i < mergeCount) {
            newStyle = mergeStyles[i];
            if (j <= 0) ** GOTO lbl-1000
            style = this.styles[j - 1];
            if (style.start + style.length == newStyle.start && newStyle.similarTo(style)) {
                style.length += newStyle.length;
            } else lbl-1000:
            // 2 sources

            {
                this.styles[j++] = newStyle;
            }
            ++i;
        }
        style = this.styles[j - 1];
        if (endStyle != null && style.start + style.length == endStyle.start && endStyle.similarTo(style)) {
            style.length += endStyle.length;
            ++modifyEnd;
            ++mergeCount;
        }
        if (this.styleCount > modifyEnd) {
            System.arraycopy(this.styles, modifyStart + mergeCount, this.styles, j, this.styleCount - modifyEnd);
        }
        grow = j - modifyStart - (modifyEnd - modifyStart);
        this.styleCount += grow;
        return grow;
    }

    void calculate(int startLine, int lineCount) {
        int endLine = startLine + lineCount;
        if (startLine < 0 || endLine > this.lineSizes.length) {
            return;
        }
        int hTrim = this.styledText.leftMargin + this.styledText.rightMargin + this.styledText.getCaretWidth();
        int i2 = startLine;
        while (i2 < endLine) {
            LineSizeInfo line2 = this.getLineSize(i2);
            if (line2.needsRecalculateSize()) {
                TextLayout layout = this.getTextLayout(i2);
                Rectangle rect = layout.getBounds();
                line2.width = rect.width + hTrim;
                line2.height = rect.height;
                this.disposeTextLayout(layout);
            }
            if (line2.width > this.maxWidth) {
                this.maxWidth = line2.width;
                this.maxWidthLineIndex = i2;
            }
            ++i2;
        }
    }

    LineSizeInfo getLineSize(int i2) {
        if (this.lineSizes[i2] == null) {
            this.lineSizes[i2] = new LineSizeInfo();
        }
        return this.lineSizes[i2];
    }

    void calculateClientArea() {
        int index = Math.max(0, this.styledText.getTopIndex());
        int lineCount = this.content.getLineCount();
        int height = this.styledText.getClientArea().height;
        int y2 = 0;
        while (height > y2 && lineCount > index && this.lineSizes.length > index) {
            this.calculate(index, 1);
            y2 += this.lineSizes[index++].height;
        }
    }

    void calculateIdle() {
        if (this.idleRunning) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (StyledTextRenderer.this.styledText == null) {
                    return;
                }
                long start = System.currentTimeMillis();
                int i2 = 0;
                while (i2 < StyledTextRenderer.this.lineCount) {
                    LineSizeInfo line2 = StyledTextRenderer.this.getLineSize(i2);
                    if (line2.needsRecalculateSize()) {
                        StyledTextRenderer.this.calculate(i2, 1);
                        if (System.currentTimeMillis() - start > 50L) break;
                    }
                    ++i2;
                }
                if (i2 < StyledTextRenderer.this.lineCount) {
                    Display display = StyledTextRenderer.this.styledText.getDisplay();
                    display.asyncExec(this);
                } else {
                    StyledTextRenderer.this.idleRunning = false;
                    StyledTextRenderer.this.styledText.setScrollBars(true);
                    ScrollBar bar = StyledTextRenderer.this.styledText.getVerticalBar();
                    if (bar != null) {
                        bar.setSelection(StyledTextRenderer.this.styledText.getVerticalScrollOffset());
                    }
                }
            }
        };
        Display display = this.styledText.getDisplay();
        display.asyncExec(runnable);
        this.idleRunning = true;
    }

    void clearLineBackground(int startLine, int count) {
        if (this.lines == null) {
            return;
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            LineInfo info = this.lines[i2];
            if (info != null) {
                info.flags &= 0xFFFFFFFE;
                info.background = null;
                if (info.flags == 0) {
                    this.lines[i2] = null;
                }
            }
            ++i2;
        }
    }

    void clearLineStyle(int startLine, int count) {
        if (this.lines == null) {
            return;
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            LineInfo info = this.lines[i2];
            if (info != null) {
                info.flags &= 0xFFFFFD31;
                if (info.flags == 0) {
                    this.lines[i2] = null;
                }
            }
            ++i2;
        }
    }

    void copyInto(StyledTextRenderer renderer) {
        int i2;
        if (this.ranges != null) {
            renderer.ranges = new int[this.styleCount << 1];
            int[] newRanges = renderer.ranges;
            System.arraycopy(this.ranges, 0, newRanges, 0, newRanges.length);
        }
        if (this.styles != null) {
            renderer.styles = new StyleRange[this.styleCount];
            StyleRange[] newStyles = renderer.styles;
            i2 = 0;
            while (i2 < newStyles.length) {
                newStyles[i2] = (StyleRange)this.styles[i2].clone();
                ++i2;
            }
            renderer.styleCount = this.styleCount;
        }
        if (this.lines != null) {
            renderer.lines = new LineInfo[this.lineCount];
            LineInfo[] newLines = renderer.lines;
            i2 = 0;
            while (i2 < newLines.length) {
                newLines[i2] = new LineInfo(this.lines[i2]);
                ++i2;
            }
            renderer.lineCount = this.lineCount;
        }
    }

    void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        if (this.boldItalicFont != null) {
            this.boldItalicFont.dispose();
        }
        this.boldItalicFont = null;
        this.italicFont = null;
        this.boldFont = null;
        this.reset();
        this.content = null;
        this.device = null;
        this.styledText = null;
    }

    void disposeTextLayout(TextLayout layout) {
        if (this.layouts != null) {
            int i2 = 0;
            while (i2 < this.layouts.length) {
                if (this.layouts[i2] == layout) {
                    return;
                }
                ++i2;
            }
        }
        layout.dispose();
    }

    void drawBullet(Bullet bullet, GC gc, int paintX, int paintY, int index, int lineAscent, int lineDescent) {
        Font font;
        StyleRange style = bullet.style;
        GlyphMetrics metrics = style.metrics;
        Color color = style.foreground;
        if (color != null) {
            gc.setForeground(color);
        }
        if ((font = style.font) != null) {
            gc.setFont(font);
        }
        String string2 = "";
        int type2 = bullet.type & 0xF;
        switch (type2) {
            case 1: {
                string2 = "\u2022";
                break;
            }
            case 2: {
                string2 = String.valueOf(index + 1);
                break;
            }
            case 4: {
                string2 = String.valueOf((char)(index % 26 + 97));
                break;
            }
            case 8: {
                string2 = String.valueOf((char)(index % 26 + 65));
            }
        }
        if ((bullet.type & 0x10) != 0) {
            string2 = String.valueOf(string2) + bullet.text;
        }
        Display display = this.styledText.getDisplay();
        TextLayout layout = new TextLayout(display);
        layout.setText(string2);
        layout.setAscent(lineAscent);
        layout.setDescent(lineDescent);
        style = (StyleRange)style.clone();
        style.metrics = null;
        if (style.font == null) {
            style.font = this.getFont(style.fontStyle);
        }
        layout.setStyle(style, 0, string2.length());
        int x2 = paintX + Math.max(0, metrics.width - layout.getBounds().width - 8);
        layout.draw(gc, x2, paintY);
        layout.dispose();
    }

    int drawLine(int lineIndex, int paintX, int paintY, GC gc, Color widgetBackground, Color widgetForeground) {
        TextLayout layout = this.getTextLayout(lineIndex);
        String line2 = this.content.getLine(lineIndex);
        int lineOffset = this.content.getOffsetAtLine(lineIndex);
        int lineLength = line2.length();
        Point selection2 = this.styledText.getSelection();
        int selectionStart = selection2.x - lineOffset;
        int selectionEnd = selection2.y - lineOffset;
        if (this.styledText.getBlockSelection()) {
            selectionEnd = 0;
            selectionStart = 0;
        }
        Rectangle client = this.styledText.getClientArea();
        Color lineBackground = this.getLineBackground(lineIndex, null);
        StyledTextEvent event = this.styledText.getLineBackgroundData(lineOffset, line2);
        if (event != null && event.lineBackground != null) {
            lineBackground = event.lineBackground;
        }
        int height = layout.getBounds().height;
        int verticalIndent = layout.getVerticalIndent();
        if (lineBackground != null) {
            if (verticalIndent > 0) {
                gc.setBackground(widgetBackground);
                gc.fillRectangle(client.x, paintY, client.width, verticalIndent);
            }
            gc.setBackground(lineBackground);
            gc.fillRectangle(client.x, paintY + verticalIndent, client.width, height - verticalIndent);
        } else {
            gc.setBackground(widgetBackground);
            this.styledText.drawBackground(gc, client.x, paintY, client.width, height);
        }
        gc.setForeground(widgetForeground);
        if (selectionStart == selectionEnd || selectionEnd <= 0 && selectionStart > lineLength - 1) {
            layout.draw(gc, paintX, paintY);
        } else {
            int start = Math.max(0, selectionStart);
            int end = Math.min(lineLength, selectionEnd);
            Color selectionFg = this.styledText.getSelectionForeground();
            Color selectionBg = this.styledText.getSelectionBackground();
            int flags = (this.styledText.getStyle() & 0x10000) != 0 ? 65536 : 131072;
            if (selectionStart <= lineLength && lineLength < selectionEnd) {
                flags |= 0x100000;
            }
            layout.draw(gc, paintX, paintY, start, end - 1, selectionFg, selectionBg, flags);
        }
        Bullet bullet = null;
        int bulletIndex = -1;
        if (this.bullets != null) {
            if (this.bulletsIndices != null) {
                int index = lineIndex - this.topIndex;
                if (index >= 0 && index < 300) {
                    bullet = this.bullets[index];
                    bulletIndex = this.bulletsIndices[index];
                }
            } else {
                int i2 = 0;
                while (i2 < this.bullets.length) {
                    bullet = this.bullets[i2];
                    bulletIndex = bullet.indexOf(lineIndex);
                    if (bulletIndex != -1) break;
                    ++i2;
                }
            }
        }
        if (bulletIndex != -1 && bullet != null) {
            FontMetrics metrics = layout.getLineMetrics(0);
            int lineAscent = metrics.getAscent() + metrics.getLeading();
            if (bullet.type == 32) {
                bullet.style.start = lineOffset;
                this.styledText.paintObject(gc, paintX, paintY, lineAscent, metrics.getDescent(), bullet.style, bullet, bulletIndex);
            } else {
                this.drawBullet(bullet, gc, paintX, paintY, bulletIndex, lineAscent, metrics.getDescent());
            }
        }
        TextStyle[] styles = layout.getStyles();
        int[] ranges = null;
        int i3 = 0;
        while (i3 < styles.length) {
            if (styles[i3].metrics != null) {
                if (ranges == null) {
                    ranges = layout.getRanges();
                }
                int start = ranges[i3 << 1];
                int length = ranges[(i3 << 1) + 1] - start + 1;
                Point point = layout.getLocation(start, false);
                FontMetrics metrics = layout.getLineMetrics(layout.getLineIndex(start));
                StyleRange style = (StyleRange)((StyleRange)styles[i3]).clone();
                style.start = start + lineOffset;
                style.length = length;
                int lineAscent = metrics.getAscent() + metrics.getLeading();
                this.styledText.paintObject(gc, point.x + paintX, point.y + paintY, lineAscent, metrics.getDescent(), style, null, 0);
            }
            ++i3;
        }
        this.disposeTextLayout(layout);
        return height;
    }

    int getBaseline() {
        return this.ascent;
    }

    Font getFont(int style) {
        switch (style) {
            case 1: {
                if (this.boldFont != null) {
                    return this.boldFont;
                }
                this.boldFont = new Font(this.device, this.getFontData(style));
                return this.boldFont;
            }
            case 2: {
                if (this.italicFont != null) {
                    return this.italicFont;
                }
                this.italicFont = new Font(this.device, this.getFontData(style));
                return this.italicFont;
            }
            case 3: {
                if (this.boldItalicFont != null) {
                    return this.boldItalicFont;
                }
                this.boldItalicFont = new Font(this.device, this.getFontData(style));
                return this.boldItalicFont;
            }
        }
        return this.regularFont;
    }

    FontData[] getFontData(int style) {
        FontData[] fontDatas = this.regularFont.getFontData();
        int i2 = 0;
        while (i2 < fontDatas.length) {
            fontDatas[i2].setStyle(style);
            ++i2;
        }
        return fontDatas;
    }

    int getHeight() {
        int defaultLineHeight = this.getLineHeight();
        if (this.styledText.isFixedLineHeight()) {
            return this.lineCount * defaultLineHeight + this.styledText.topMargin + this.styledText.bottomMargin;
        }
        int totalHeight = 0;
        int width = this.styledText.getWrapWidth();
        int i2 = 0;
        while (i2 < this.lineCount) {
            LineSizeInfo line2 = this.getLineSize(i2);
            int height = line2.height;
            if (line2.needsRecalculateHeight()) {
                if (width > 0) {
                    int length = this.content.getLine(i2).length();
                    height = (length * this.averageCharWidth / width + 1) * defaultLineHeight;
                } else {
                    height = defaultLineHeight;
                }
            }
            totalHeight += height;
            ++i2;
        }
        return totalHeight + this.styledText.topMargin + this.styledText.bottomMargin;
    }

    boolean hasLink(int offset) {
        String line2;
        if (offset == -1) {
            return false;
        }
        int lineIndex = this.content.getLineAtOffset(offset);
        int lineOffset = this.content.getOffsetAtLine(lineIndex);
        StyledTextEvent event = this.styledText.getLineStyleData(lineOffset, line2 = this.content.getLine(lineIndex));
        if (event != null) {
            StyleRange[] styles = event.styles;
            if (styles != null) {
                int[] ranges = event.ranges;
                if (ranges != null) {
                    int i2 = 0;
                    while (i2 < ranges.length) {
                        if (ranges[i2] <= offset && offset < ranges[i2] + ranges[i2 + 1] && styles[i2 >> 1].underline && styles[i2 >> 1].underlineStyle == 4) {
                            return true;
                        }
                        i2 += 2;
                    }
                } else {
                    int i3 = 0;
                    while (i3 < styles.length) {
                        StyleRange style = styles[i3];
                        if (style.start <= offset && offset < style.start + style.length && style.underline && style.underlineStyle == 4) {
                            return true;
                        }
                        ++i3;
                    }
                }
            }
        } else if (this.ranges != null) {
            int rangeCount = this.styleCount << 1;
            int index = this.getRangeIndex(offset, -1, rangeCount);
            if (index >= rangeCount) {
                return false;
            }
            int rangeStart = this.ranges[index];
            int rangeLength = this.ranges[index + 1];
            StyleRange rangeStyle = this.styles[index >> 1];
            if (rangeStart <= offset && offset < rangeStart + rangeLength && rangeStyle.underline && rangeStyle.underlineStyle == 4) {
                return true;
            }
        }
        return false;
    }

    int getLineAlignment(int index, int defaultAlignment) {
        if (this.lines == null) {
            return defaultAlignment;
        }
        LineInfo info = this.lines[index];
        if (info != null && (info.flags & 2) != 0) {
            return info.alignment;
        }
        return defaultAlignment;
    }

    Color getLineBackground(int index, Color defaultBackground) {
        if (this.lines == null) {
            return defaultBackground;
        }
        LineInfo info = this.lines[index];
        if (info != null && (info.flags & 1) != 0) {
            return info.background;
        }
        return defaultBackground;
    }

    Bullet getLineBullet(int index, Bullet defaultBullet) {
        if (this.bullets == null) {
            return defaultBullet;
        }
        if (this.bulletsIndices != null) {
            return defaultBullet;
        }
        int i2 = 0;
        while (i2 < this.bullets.length) {
            Bullet bullet = this.bullets[i2];
            if (bullet.indexOf(index) != -1) {
                return bullet;
            }
            ++i2;
        }
        return defaultBullet;
    }

    int getLineHeight() {
        return this.ascent + this.descent;
    }

    int getLineHeight(int lineIndex) {
        LineSizeInfo line2 = this.getLineSize(lineIndex);
        if (line2.needsRecalculateHeight()) {
            if (this.isVariableHeight(lineIndex)) {
                this.calculate(lineIndex, 1);
            } else {
                line2.height = this.getLineHeight() + this.getLineSpacing(lineIndex);
            }
        }
        return line2.height;
    }

    private boolean isVariableHeight(int lineIndex) {
        if (this.styledText.isWordWrap()) {
            return true;
        }
        StyleRange[] styles = this.getStylesForLine(lineIndex);
        if (styles != null) {
            StyleRange[] styleRangeArray = styles;
            int n2 = styles.length;
            int n3 = 0;
            while (n3 < n2) {
                StyleRange style = styleRangeArray[n3];
                if (style.isVariableHeight()) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    private int getLineSpacing(int lineIndex) {
        Integer lineSpacing;
        if (this.styledText.lineSpacing > 0) {
            return this.styledText.lineSpacing;
        }
        if (this.lineSpacingProvider != null && (lineSpacing = this.lineSpacingProvider.getLineSpacing(lineIndex)) != null) {
            return lineSpacing;
        }
        return 0;
    }

    private StyleRange[] getStylesForLine(int lineIndex) {
        int start = this.styledText.getOffsetAtLine(lineIndex);
        int length = this.styledText.getLine(lineIndex).length();
        return this.getStyleRanges(start, length, false);
    }

    int getLineIndent(int index, int defaultIndent) {
        if (this.lines == null) {
            return defaultIndent;
        }
        LineInfo info = this.lines[index];
        if (info != null && (info.flags & 4) != 0) {
            return info.indent;
        }
        return defaultIndent;
    }

    int getLineVerticalIndent(int index) {
        if (this.lines == null) {
            return 0;
        }
        LineInfo info = this.lines[index];
        if (info != null && (info.flags & 0x200) != 0) {
            return info.verticalIndent;
        }
        return 0;
    }

    int getLineWrapIndent(int index, int defaultWrapIndent) {
        if (this.lines == null) {
            return defaultWrapIndent;
        }
        LineInfo info = this.lines[index];
        if (info != null && (info.flags & 0x80) != 0) {
            return info.wrapIndent;
        }
        return defaultWrapIndent;
    }

    boolean getLineJustify(int index, boolean defaultJustify) {
        if (this.lines == null) {
            return defaultJustify;
        }
        LineInfo info = this.lines[index];
        if (info != null && (info.flags & 8) != 0) {
            return info.justify;
        }
        return defaultJustify;
    }

    int[] getLineTabStops(int index, int[] defaultTabStops) {
        if (this.lines == null) {
            return defaultTabStops;
        }
        LineInfo info = this.lines[index];
        if (info != null && (info.flags & 0x40) != 0) {
            return info.tabStops;
        }
        return defaultTabStops;
    }

    StyledTextLineSpacingProvider getLineSpacingProvider() {
        return this.lineSpacingProvider;
    }

    /*
     * Unable to fully structure code
     */
    int getRangeIndex(int offset, int low, int high) {
        block5: {
            if (this.styleCount == 0) {
                return 0;
            }
            if (this.ranges == null) ** GOTO lbl19
            while (high - low > 2) {
                index = (high + low) / 2 / 2 * 2;
                end = this.ranges[index] + this.ranges[index + 1];
                if (end > offset) {
                    high = index;
                    continue;
                }
                low = index;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                index = (high + low) / 2;
                end = this.styles[index].start + this.styles[index].length;
                if (end > offset) {
                    high = index;
                    continue;
                }
                low = index;
lbl19:
                // 3 sources

                ** while (high - low > 1)
            }
        }
        return high;
    }

    int[] getRanges(int start, int length) {
        int[] newRanges;
        if (length == 0) {
            return null;
        }
        int end = start + length - 1;
        if (this.ranges != null) {
            int rangeCount = this.styleCount << 1;
            int rangeStart = this.getRangeIndex(start, -1, rangeCount);
            if (rangeStart >= rangeCount) {
                return null;
            }
            if (this.ranges[rangeStart] > end) {
                return null;
            }
            int rangeEnd = Math.min(rangeCount - 2, this.getRangeIndex(end, rangeStart - 1, rangeCount));
            if (this.ranges[rangeEnd] > end) {
                rangeEnd = Math.max(rangeStart, rangeEnd - 2);
            }
            newRanges = new int[rangeEnd - rangeStart + 2];
            System.arraycopy(this.ranges, rangeStart, newRanges, 0, newRanges.length);
        } else {
            int rangeStart = this.getRangeIndex(start, -1, this.styleCount);
            if (rangeStart >= this.styleCount) {
                return null;
            }
            if (this.styles[rangeStart].start > end) {
                return null;
            }
            int rangeEnd = Math.min(this.styleCount - 1, this.getRangeIndex(end, rangeStart - 1, this.styleCount));
            if (this.styles[rangeEnd].start > end) {
                rangeEnd = Math.max(rangeStart, rangeEnd - 1);
            }
            newRanges = new int[rangeEnd - rangeStart + 1 << 1];
            int i2 = rangeStart;
            int j2 = 0;
            while (i2 <= rangeEnd) {
                StyleRange style = this.styles[i2];
                newRanges[j2] = style.start;
                newRanges[j2 + 1] = style.length;
                ++i2;
                j2 += 2;
            }
        }
        if (start > newRanges[0]) {
            newRanges[1] = newRanges[0] + newRanges[1] - start;
            newRanges[0] = start;
        }
        if (end < newRanges[newRanges.length - 2] + newRanges[newRanges.length - 1] - 1) {
            newRanges[newRanges.length - 1] = end - newRanges[newRanges.length - 2] + 1;
        }
        return newRanges;
    }

    StyleRange[] getStyleRanges(int start, int length, boolean includeRanges) {
        StyleRange[] newStyles;
        if (length == 0) {
            return null;
        }
        int end = start + length - 1;
        if (this.ranges != null) {
            int rangeCount = this.styleCount << 1;
            int rangeStart = this.getRangeIndex(start, -1, rangeCount);
            if (rangeStart >= rangeCount) {
                return null;
            }
            if (this.ranges[rangeStart] > end) {
                return null;
            }
            int rangeEnd = Math.min(rangeCount - 2, this.getRangeIndex(end, rangeStart - 1, rangeCount));
            if (this.ranges[rangeEnd] > end) {
                rangeEnd = Math.max(rangeStart, rangeEnd - 2);
            }
            newStyles = new StyleRange[(rangeEnd - rangeStart >> 1) + 1];
            if (includeRanges) {
                int i2 = rangeStart;
                int j2 = 0;
                while (i2 <= rangeEnd) {
                    newStyles[j2] = (StyleRange)this.styles[i2 >> 1].clone();
                    newStyles[j2].start = this.ranges[i2];
                    newStyles[j2].length = this.ranges[i2 + 1];
                    i2 += 2;
                    ++j2;
                }
            } else {
                System.arraycopy(this.styles, rangeStart >> 1, newStyles, 0, newStyles.length);
            }
        } else {
            int rangeStart = this.getRangeIndex(start, -1, this.styleCount);
            if (rangeStart >= this.styleCount) {
                return null;
            }
            if (this.styles[rangeStart].start > end) {
                return null;
            }
            int rangeEnd = Math.min(this.styleCount - 1, this.getRangeIndex(end, rangeStart - 1, this.styleCount));
            if (this.styles[rangeEnd].start > end) {
                rangeEnd = Math.max(rangeStart, rangeEnd - 1);
            }
            newStyles = new StyleRange[rangeEnd - rangeStart + 1];
            System.arraycopy(this.styles, rangeStart, newStyles, 0, newStyles.length);
        }
        if (includeRanges || this.ranges == null) {
            StyleRange style = newStyles[0];
            if (start > style.start) {
                newStyles[0] = style = (StyleRange)style.clone();
                style.length = style.start + style.length - start;
                style.start = start;
            }
            style = newStyles[newStyles.length - 1];
            if (end < style.start + style.length - 1) {
                newStyles[newStyles.length - 1] = style = (StyleRange)style.clone();
                style.length = end - style.start + 1;
            }
        }
        return newStyles;
    }

    StyleRange getStyleRange(StyleRange style) {
        if (style.underline && style.underlineStyle == 4) {
            this.hasLinks = true;
        }
        if (style.start == 0 && style.length == 0 && style.fontStyle == 0) {
            return style;
        }
        StyleRange clone = (StyleRange)style.clone();
        clone.length = 0;
        clone.start = 0;
        clone.fontStyle = 0;
        if (clone.font == null) {
            clone.font = this.getFont(style.fontStyle);
        }
        return clone;
    }

    TextLayout getTextLayout(int lineIndex) {
        if (this.lineSpacingProvider == null) {
            return this.getTextLayout(lineIndex, this.styledText.getOrientation(), this.styledText.getWrapWidth(), this.styledText.lineSpacing);
        }
        int newLineSpacing = this.styledText.lineSpacing;
        Integer spacing = this.lineSpacingProvider.getLineSpacing(lineIndex);
        if (spacing != null && spacing >= 0) {
            newLineSpacing = spacing;
        }
        if (this.isSameLineSpacing(lineIndex, newLineSpacing)) {
            return this.getTextLayout(lineIndex, this.styledText.getOrientation(), this.styledText.getWrapWidth(), newLineSpacing);
        }
        TextLayout layout = this.getTextLayout(lineIndex, this.styledText.getOrientation(), this.styledText.getWrapWidth(), this.styledText.lineSpacing);
        if (layout.getSpacing() != newLineSpacing) {
            layout.setSpacing(newLineSpacing);
            if (this.lineSpacingComputing) {
                return layout;
            }
            try {
                this.lineSpacingComputing = true;
                this.styledText.resetCache(lineIndex, 1);
                this.styledText.setVariableLineHeight();
                this.styledText.setCaretLocation();
                this.styledText.redraw();
            }
            finally {
                this.lineSpacingComputing = false;
            }
        }
        return layout;
    }

    boolean isSameLineSpacing(int lineIndex, int newLineSpacing) {
        if (this.layouts == null) {
            return false;
        }
        int layoutIndex = lineIndex - this.topIndex;
        if (layoutIndex >= 0 && layoutIndex < this.layouts.length) {
            TextLayout layout = this.layouts[layoutIndex];
            return layout != null && !layout.isDisposed() && layout.getSpacing() == newLineSpacing;
        }
        return false;
    }

    TextLayout getTextLayout(int lineIndex, int orientation, int width, int lineSpacing) {
        IME ime;
        int compositionOffset;
        TextLayout layout = null;
        if (this.styledText != null) {
            int layoutIndex;
            int topIndex;
            int n2 = topIndex = this.styledText.topIndex > 0 ? this.styledText.topIndex - 1 : 0;
            if (this.layouts == null || topIndex != this.topIndex) {
                TextLayout[] newLayouts = new TextLayout[300];
                if (this.layouts != null) {
                    int i2 = 0;
                    while (i2 < this.layouts.length) {
                        if (this.layouts[i2] != null) {
                            int layoutIndex2 = i2 + this.topIndex - topIndex;
                            if (layoutIndex2 >= 0 && layoutIndex2 < newLayouts.length) {
                                newLayouts[layoutIndex2] = this.layouts[i2];
                            } else {
                                this.layouts[i2].dispose();
                            }
                        }
                        ++i2;
                    }
                }
                if (this.bullets != null && this.bulletsIndices != null && topIndex != this.topIndex) {
                    int i3;
                    int delta = topIndex - this.topIndex;
                    if (delta > 0) {
                        int startIndex;
                        if (delta < this.bullets.length) {
                            System.arraycopy(this.bullets, delta, this.bullets, 0, this.bullets.length - delta);
                            System.arraycopy(this.bulletsIndices, delta, this.bulletsIndices, 0, this.bulletsIndices.length - delta);
                        }
                        i3 = startIndex = Math.max(0, this.bullets.length - delta);
                        while (i3 < this.bullets.length) {
                            this.bullets[i3] = null;
                            ++i3;
                        }
                    } else {
                        if (-delta < this.bullets.length) {
                            System.arraycopy(this.bullets, 0, this.bullets, -delta, this.bullets.length + delta);
                            System.arraycopy(this.bulletsIndices, 0, this.bulletsIndices, -delta, this.bulletsIndices.length + delta);
                        }
                        int endIndex = Math.min(this.bullets.length, -delta);
                        i3 = 0;
                        while (i3 < endIndex) {
                            this.bullets[i3] = null;
                            ++i3;
                        }
                    }
                }
                this.topIndex = topIndex;
                this.layouts = newLayouts;
            }
            if (this.layouts != null && (layoutIndex = lineIndex - topIndex) >= 0 && layoutIndex < this.layouts.length) {
                layout = this.layouts[layoutIndex];
                if (layout != null) {
                    if (lineIndex < this.lineSizes.length && this.getLineSize(lineIndex).canLayout()) {
                        return layout;
                    }
                } else {
                    layout = this.layouts[layoutIndex] = new TextLayout(this.device);
                }
            }
        }
        if (layout == null) {
            layout = new TextLayout(this.device);
        }
        String line2 = this.content.getLine(lineIndex);
        int lineOffset = this.content.getOffsetAtLine(lineIndex);
        int[] segments = null;
        char[] segmentChars = null;
        int indent = 0;
        int wrapIndent = 0;
        int verticalIndent = 0;
        int alignment = 16384;
        int textDirection = orientation;
        boolean justify = false;
        int[] tabs = new int[]{this.tabWidth};
        Bullet bullet = null;
        int[] ranges = null;
        StyleRange[] styles = null;
        int rangeStart = 0;
        int styleCount = 0;
        StyledTextEvent event = null;
        if (this.styledText != null) {
            event = this.styledText.getBidiSegments(lineOffset, line2);
            if (event != null) {
                segments = event.segments;
                segmentChars = event.segmentsChars;
            }
            event = this.styledText.getLineStyleData(lineOffset, line2);
            indent = this.styledText.indent;
            wrapIndent = this.styledText.wrapIndent;
            alignment = this.styledText.alignment;
            if (this.styledText.isAutoDirection()) {
                textDirection = 0x6000000;
            } else if ((this.styledText.getStyle() & Integer.MIN_VALUE) != 0) {
                textDirection = orientation == 0x4000000 ? 0x2000000 : 0x4000000;
            }
            justify = this.styledText.justify;
            if (this.styledText.tabs != null) {
                tabs = this.styledText.tabs;
            }
        }
        if (event != null) {
            int index;
            indent = event.indent;
            verticalIndent = event.verticalIndent;
            wrapIndent = event.wrapIndent;
            alignment = event.alignment;
            justify = event.justify;
            bullet = event.bullet;
            ranges = event.ranges;
            styles = event.styles;
            if (event.tabStops != null) {
                tabs = event.tabStops;
            }
            if (styles != null) {
                styleCount = styles.length;
                if (this.styledText.isFixedLineHeight()) {
                    int i4 = 0;
                    while (i4 < styleCount) {
                        if (styles[i4].isVariableHeight()) {
                            this.styledText.verticalScrollOffset = -1;
                            this.styledText.setVariableLineHeight();
                            this.styledText.redraw();
                            break;
                        }
                        ++i4;
                    }
                }
            }
            if (this.bullets == null || this.bulletsIndices == null) {
                this.bullets = new Bullet[300];
                this.bulletsIndices = new int[300];
            }
            if ((index = lineIndex - this.topIndex) >= 0 && index < 300) {
                this.bullets[index] = bullet;
                this.bulletsIndices[index] = event.bulletIndex;
            }
        } else {
            LineInfo info;
            if (this.lines != null && (info = this.lines[lineIndex]) != null) {
                if ((info.flags & 4) != 0) {
                    indent = info.indent;
                }
                if ((info.flags & 0x200) != 0) {
                    verticalIndent = info.verticalIndent;
                }
                if ((info.flags & 0x80) != 0) {
                    wrapIndent = info.wrapIndent;
                }
                if ((info.flags & 2) != 0) {
                    alignment = info.alignment;
                }
                if ((info.flags & 8) != 0) {
                    justify = info.justify;
                }
                if ((info.flags & 0x20) != 0) {
                    segments = info.segments;
                }
                if ((info.flags & 0x100) != 0) {
                    segmentChars = info.segmentsChars;
                }
                if ((info.flags & 0x40) != 0) {
                    tabs = info.tabStops;
                }
            }
            if (this.bulletsIndices != null) {
                this.bullets = null;
                this.bulletsIndices = null;
            }
            if (this.bullets != null) {
                int i5 = 0;
                while (i5 < this.bullets.length) {
                    if (this.bullets[i5].indexOf(lineIndex) != -1) {
                        bullet = this.bullets[i5];
                        break;
                    }
                    ++i5;
                }
            }
            ranges = this.ranges;
            styles = this.styles;
            styleCount = this.styleCount;
            rangeStart = ranges != null ? this.getRangeIndex(lineOffset, -1, styleCount << 1) : this.getRangeIndex(lineOffset, -1, styleCount);
        }
        if (bullet != null) {
            StyleRange style = bullet.style;
            GlyphMetrics metrics = style.metrics;
            indent += metrics.width;
        }
        ArrayList<StyleEntry> styleEntries = new ArrayList<StyleEntry>();
        int lastOffset = 0;
        int length = line2.length();
        if (styles != null) {
            if (ranges != null) {
                int rangeCount = styleCount << 1;
                int i6 = rangeStart;
                while (i6 < rangeCount) {
                    int end;
                    int start;
                    if (lineOffset > ranges[i6]) {
                        start = 0;
                        end = Math.min(length, ranges[i6 + 1] - lineOffset + ranges[i6]);
                    } else {
                        start = ranges[i6] - lineOffset;
                        end = Math.min(length, start + ranges[i6 + 1]);
                    }
                    if (start < length) {
                        if (lastOffset < start) {
                            styleEntries.add(new StyleEntry(null, lastOffset, start - 1));
                        }
                        StyleRange style = this.getStyleRange(styles[i6 >> 1]);
                        int endIndex = Math.max(start, Math.min(length, end + 1));
                        if (style.metrics != null && line2.substring(start, endIndex).contains("\t")) {
                            line2 = String.valueOf(line2.substring(0, start)) + line2.substring(start, endIndex).replace('\t', ' ') + (end < line2.length() ? line2.substring(end + 1, line2.length()) : "");
                        }
                        styleEntries.add(new StyleEntry(style, start, end));
                        lastOffset = Math.max(lastOffset, end);
                        i6 += 2;
                        continue;
                    }
                    break;
                }
            } else {
                int i7 = rangeStart;
                while (i7 < styleCount) {
                    int end;
                    int start;
                    if (lineOffset > styles[i7].start) {
                        start = 0;
                        end = Math.min(length, styles[i7].length - lineOffset + styles[i7].start);
                    } else {
                        start = styles[i7].start - lineOffset;
                        end = Math.min(length, start + styles[i7].length);
                    }
                    if (start < length) {
                        if (lastOffset < start) {
                            styleEntries.add(new StyleEntry(null, lastOffset, start - 1));
                        }
                        StyleRange style = this.getStyleRange(styles[i7]);
                        int endIndex = Math.max(start, Math.min(length, end + 1));
                        if (style.metrics != null && line2.substring(start, endIndex).contains("\t")) {
                            line2 = String.valueOf(line2.substring(0, start)) + line2.substring(start, endIndex).replace('\t', ' ') + (end < line2.length() ? line2.substring(end + 1, line2.length()) : "");
                        }
                        styleEntries.add(new StyleEntry(style, start, end));
                        lastOffset = Math.max(lastOffset, end);
                        ++i7;
                        continue;
                    }
                    break;
                }
            }
        }
        if (lastOffset < length) {
            styleEntries.add(new StyleEntry(null, lastOffset, length));
        }
        layout.setFont(this.regularFont);
        layout.setAscent(this.ascent);
        layout.setDescent(this.descent);
        layout.setText(line2);
        layout.setOrientation(orientation);
        layout.setSegments(segments);
        layout.setSegmentsChars(segmentChars);
        layout.setWidth(width);
        layout.setSpacing(lineSpacing);
        layout.setTabs(tabs);
        layout.setDefaultTabWidth(this.tabLength);
        layout.setIndent(indent);
        layout.setVerticalIndent(verticalIndent);
        layout.setWrapIndent(wrapIndent);
        layout.setAlignment(alignment);
        layout.setJustify(justify);
        layout.setTextDirection(textDirection);
        for (StyleEntry styleEntry : styleEntries) {
            layout.setStyle(styleEntry.style, styleEntry.start, styleEntry.end);
        }
        if (this.styledText != null && this.styledText.ime != null && (compositionOffset = (ime = this.styledText.ime).getCompositionOffset()) != -1) {
            int compositionLine;
            int commitCount = ime.getCommitCount();
            int compositionLength = ime.getText().length();
            if (compositionLength != commitCount && (compositionLine = this.content.getLineAtOffset(compositionOffset)) == lineIndex) {
                int[] imeRanges = ime.getRanges();
                TextStyle[] imeStyles = ime.getStyles();
                if (imeRanges.length > 0) {
                    int i8 = 0;
                    while (i8 < imeStyles.length) {
                        int start = imeRanges[i8 * 2] - lineOffset;
                        int end = imeRanges[i8 * 2 + 1] - lineOffset;
                        TextStyle imeStyle = imeStyles[i8];
                        int j2 = start;
                        while (j2 <= end) {
                            if (j2 < 0 || j2 >= length) break;
                            TextStyle userStyle = layout.getStyle(StyledTextRenderer.cap(layout, j2));
                            if (userStyle == null && j2 > 0) {
                                userStyle = layout.getStyle(StyledTextRenderer.cap(layout, j2 - 1));
                            }
                            if (userStyle == null && j2 + 1 < length) {
                                userStyle = layout.getStyle(StyledTextRenderer.cap(layout, j2 + 1));
                            }
                            if (userStyle == null) {
                                layout.setStyle(imeStyle, j2, j2);
                            } else {
                                TextStyle newStyle = new TextStyle(imeStyle);
                                if (newStyle.font == null) {
                                    newStyle.font = userStyle.font;
                                }
                                if (newStyle.foreground == null) {
                                    newStyle.foreground = userStyle.foreground;
                                }
                                if (newStyle.background == null) {
                                    newStyle.background = userStyle.background;
                                }
                                layout.setStyle(newStyle, j2, j2);
                            }
                            ++j2;
                        }
                        ++i8;
                    }
                } else {
                    int start = compositionOffset - lineOffset;
                    int end = start + compositionLength - 1;
                    TextStyle userStyle = layout.getStyle(StyledTextRenderer.cap(layout, start));
                    if (userStyle == null) {
                        if (start > 0) {
                            userStyle = layout.getStyle(StyledTextRenderer.cap(layout, start - 1));
                        }
                        if (userStyle == null && end + 1 < length) {
                            userStyle = layout.getStyle(StyledTextRenderer.cap(layout, end + 1));
                        }
                        if (userStyle != null) {
                            TextStyle newStyle = new TextStyle();
                            newStyle.font = userStyle.font;
                            newStyle.foreground = userStyle.foreground;
                            newStyle.background = userStyle.background;
                            layout.setStyle(newStyle, start, end);
                        }
                    }
                }
            }
        }
        if (this.styledText != null && this.styledText.isFixedLineHeight()) {
            int index = -1;
            int lineCount = layout.getLineCount();
            int height = this.getLineHeight();
            int i9 = 0;
            while (i9 < lineCount) {
                int lineHeight = layout.getLineBounds((int)i9).height;
                if (lineHeight > height) {
                    height = lineHeight;
                    index = i9;
                }
                ++i9;
            }
            if (index != -1) {
                FontMetrics metrics = layout.getLineMetrics(index);
                this.ascent = metrics.getAscent() + metrics.getLeading();
                this.descent = metrics.getDescent();
                if (this.layouts != null) {
                    int i10 = 0;
                    while (i10 < this.layouts.length) {
                        if (this.layouts[i10] != null && this.layouts[i10] != layout) {
                            this.layouts[i10].setAscent(this.ascent);
                            this.layouts[i10].setDescent(this.descent);
                        }
                        ++i10;
                    }
                }
                this.styledText.calculateScrollBars();
                if (this.styledText.verticalScrollOffset != 0) {
                    int topIndex = this.styledText.topIndex;
                    int topIndexY = this.styledText.topIndexY;
                    int lineHeight = this.getLineHeight();
                    int newVerticalScrollOffset = topIndexY >= 0 ? (topIndex - 1) * lineHeight + lineHeight - topIndexY : topIndex * lineHeight - topIndexY;
                    this.styledText.scrollVertical(newVerticalScrollOffset - this.styledText.verticalScrollOffset, true);
                }
                if (this.styledText.isBidiCaret()) {
                    this.styledText.createCaretBitmaps();
                }
                this.styledText.caretDirection = 0;
                this.styledText.setCaretLocation();
                this.styledText.redraw();
            }
        }
        return layout;
    }

    int getWidth() {
        return this.maxWidth;
    }

    void reset() {
        if (this.layouts != null) {
            int i2 = 0;
            while (i2 < this.layouts.length) {
                TextLayout layout = this.layouts[i2];
                if (layout != null) {
                    layout.dispose();
                }
                ++i2;
            }
            this.layouts = null;
        }
        this.topIndex = -1;
        this.lineCount = 0;
        this.styleCount = 0;
        this.stylesSetCount = 0;
        this.ranges = null;
        this.styles = null;
        this.stylesSet = null;
        this.lines = null;
        this.lineSizes = null;
        this.bullets = null;
        this.bulletsIndices = null;
        this.redrawLines = null;
        this.hasLinks = false;
    }

    void reset(int startLine, int lineCount) {
        int endLine = startLine + lineCount;
        if (startLine < 0 || endLine > this.lineSizes.length) {
            return;
        }
        TreeSet<Integer> lines = new TreeSet<Integer>();
        int i2 = startLine;
        while (i2 < endLine) {
            lines.add(i2);
            ++i2;
        }
        this.reset(lines);
    }

    void reset(Set<Integer> lines) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        int resetLineCount = 0;
        for (Integer line2 : lines) {
            if (line2 < 0 && line2 >= this.lineCount) continue;
            ++resetLineCount;
            this.getLineSize(line2).resetSize();
        }
        if (lines.contains(this.maxWidthLineIndex)) {
            this.maxWidth = 0;
            this.maxWidthLineIndex = -1;
            if (resetLineCount != this.lineCount) {
                int i2 = 0;
                while (i2 < this.lineCount) {
                    LineSizeInfo lineSize = this.getLineSize(i2);
                    if (lineSize.width > this.maxWidth) {
                        this.maxWidth = lineSize.width;
                        this.maxWidthLineIndex = i2;
                    }
                    ++i2;
                }
            }
        }
    }

    void setContent(StyledTextContent content) {
        this.reset();
        this.content = content;
        this.lineCount = content.getLineCount();
        this.lineSizes = new LineSizeInfo[this.lineCount];
        this.maxWidth = 0;
        this.maxWidthLineIndex = -1;
        this.reset(0, this.lineCount);
    }

    void setFont(Font font, int tabs) {
        TextLayout layout = new TextLayout(this.device);
        layout.setFont(this.regularFont);
        this.tabLength = tabs;
        if (font != null) {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
            if (this.boldItalicFont != null) {
                this.boldItalicFont.dispose();
            }
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
            this.regularFont = font;
            layout.setText("    ");
            layout.setFont(font);
            layout.setStyle(new TextStyle(this.getFont(0), null, null), 0, 0);
            layout.setStyle(new TextStyle(this.getFont(1), null, null), 1, 1);
            layout.setStyle(new TextStyle(this.getFont(2), null, null), 2, 2);
            layout.setStyle(new TextStyle(this.getFont(3), null, null), 3, 3);
            FontMetrics metrics = layout.getLineMetrics(0);
            this.ascent = metrics.getAscent() + metrics.getLeading();
            this.descent = metrics.getDescent();
            this.boldFont.dispose();
            this.italicFont.dispose();
            this.boldItalicFont.dispose();
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
        }
        layout.dispose();
        layout = new TextLayout(this.device);
        layout.setFont(this.regularFont);
        StringBuilder tabBuffer = new StringBuilder(tabs);
        int i2 = 0;
        while (i2 < tabs) {
            tabBuffer.append(' ');
            ++i2;
        }
        layout.setText(tabBuffer.toString());
        this.tabWidth = layout.getBounds().width;
        layout.dispose();
        if (this.styledText != null) {
            GC gc = new GC(this.styledText);
            this.averageCharWidth = (int)gc.getFontMetrics().getAverageCharacterWidth();
            this.fixedPitch = gc.stringExtent((String)"l").x == gc.stringExtent((String)"W").x;
            gc.dispose();
        }
    }

    void setLineAlignment(int startLine, int count, int alignment) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 2;
            this.lines[i2].alignment = alignment;
            ++i2;
        }
    }

    void setLineBackground(int startLine, int count, Color background) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 1;
            this.lines[i2].background = background;
            ++i2;
        }
    }

    void setLineBullet(int startLine, int count, Bullet bullet) {
        if (this.bulletsIndices != null) {
            this.bulletsIndices = null;
            this.bullets = null;
        }
        if (this.bullets == null) {
            if (bullet == null) {
                return;
            }
            this.bullets = new Bullet[1];
            this.bullets[0] = bullet;
        }
        int index = 0;
        while (index < this.bullets.length) {
            if (bullet == this.bullets[index]) break;
            ++index;
        }
        if (bullet != null) {
            if (index == this.bullets.length) {
                Bullet[] newBulletsList = new Bullet[this.bullets.length + 1];
                System.arraycopy(this.bullets, 0, newBulletsList, 0, this.bullets.length);
                newBulletsList[index] = bullet;
                this.bullets = newBulletsList;
            }
            bullet.addIndices(startLine, count);
        } else {
            this.updateBullets(startLine, count, 0, false);
            this.styledText.redrawLinesBullet(this.redrawLines);
            this.redrawLines = null;
        }
    }

    void setLineIndent(int startLine, int count, int indent) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 4;
            this.lines[i2].indent = indent;
            ++i2;
        }
    }

    void setLineVerticalIndent(int lineIndex, int verticalLineIndent) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        if (this.lines[lineIndex] == null) {
            this.lines[lineIndex] = new LineInfo();
        }
        this.lines[lineIndex].flags |= 0x200;
        this.lines[lineIndex].verticalIndent = verticalLineIndent;
    }

    void setLineWrapIndent(int startLine, int count, int wrapIndent) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 0x80;
            this.lines[i2].wrapIndent = wrapIndent;
            ++i2;
        }
    }

    void setLineJustify(int startLine, int count, boolean justify) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 8;
            this.lines[i2].justify = justify;
            ++i2;
        }
    }

    void setLineSegments(int startLine, int count, int[] segments) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 0x20;
            this.lines[i2].segments = segments;
            ++i2;
        }
    }

    void setLineSegmentChars(int startLine, int count, char[] segmentChars) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 0x100;
            this.lines[i2].segmentsChars = segmentChars;
            ++i2;
        }
    }

    void setLineTabStops(int startLine, int count, int[] tabStops) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int i2 = startLine;
        while (i2 < startLine + count) {
            if (this.lines[i2] == null) {
                this.lines[i2] = new LineInfo();
            }
            this.lines[i2].flags |= 0x40;
            this.lines[i2].tabStops = tabStops;
            ++i2;
        }
    }

    void setLineSpacingProvider(StyledTextLineSpacingProvider lineSpacingProvider) {
        this.lineSpacingProvider = lineSpacingProvider;
    }

    void setStyleRanges(int[] newRanges, StyleRange[] newStyles) {
        int j2;
        if (newStyles == null) {
            this.styleCount = 0;
            this.stylesSetCount = 0;
            this.ranges = null;
            this.styles = null;
            this.stylesSet = null;
            this.hasLinks = false;
            return;
        }
        if (newRanges == null) {
            newRanges = new int[newStyles.length << 1];
            StyleRange[] tmpStyles = new StyleRange[newStyles.length];
            if (this.stylesSet == null) {
                this.stylesSet = new StyleRange[4];
            }
            int i2 = 0;
            int j3 = 0;
            while (i2 < newStyles.length) {
                StyleRange newStyle = newStyles[i2];
                newRanges[j3++] = newStyle.start;
                newRanges[j3++] = newStyle.length;
                int index = 0;
                while (index < this.stylesSetCount) {
                    if (this.stylesSet[index].similarTo(newStyle)) break;
                    ++index;
                }
                if (index == this.stylesSetCount) {
                    if (this.stylesSetCount == this.stylesSet.length) {
                        StyleRange[] tmpStylesSet = new StyleRange[this.stylesSetCount + 4];
                        System.arraycopy(this.stylesSet, 0, tmpStylesSet, 0, this.stylesSetCount);
                        this.stylesSet = tmpStylesSet;
                    }
                    this.stylesSet[this.stylesSetCount++] = newStyle;
                }
                tmpStyles[i2] = this.stylesSet[index];
                ++i2;
            }
            newStyles = tmpStyles;
        }
        if (this.styleCount == 0) {
            if (newRanges != null) {
                this.ranges = new int[newRanges.length];
                System.arraycopy(newRanges, 0, this.ranges, 0, this.ranges.length);
            }
            this.styles = new StyleRange[newStyles.length];
            System.arraycopy(newStyles, 0, this.styles, 0, this.styles.length);
            this.styleCount = newStyles.length;
            return;
        }
        if (newRanges != null && this.ranges == null) {
            this.ranges = new int[this.styles.length << 1];
            int i3 = 0;
            j2 = 0;
            while (i3 < this.styleCount) {
                this.ranges[j2++] = this.styles[i3].start;
                this.ranges[j2++] = this.styles[i3].length;
                ++i3;
            }
        }
        if (newRanges == null && this.ranges != null) {
            newRanges = new int[newStyles.length << 1];
            int i4 = 0;
            j2 = 0;
            while (i4 < newStyles.length) {
                newRanges[j2++] = newStyles[i4].start;
                newRanges[j2++] = newStyles[i4].length;
                ++i4;
            }
        }
        if (this.ranges != null) {
            boolean insert;
            int start = newRanges[0];
            int rangeCount = this.styleCount << 1;
            int modifyStart = this.getRangeIndex(start, -1, rangeCount);
            boolean bl = insert = modifyStart == rangeCount;
            if (!insert) {
                int end = newRanges[newRanges.length - 2] + newRanges[newRanges.length - 1];
                int modifyEnd = this.getRangeIndex(end, modifyStart - 1, rangeCount);
                boolean bl2 = insert = modifyStart == modifyEnd && this.ranges[modifyStart] >= end;
            }
            if (insert) {
                this.addMerge(newRanges, newStyles, newRanges.length, modifyStart, modifyStart);
                return;
            }
            int modifyEnd = modifyStart;
            int[] mergeRanges = new int[6];
            StyleRange[] mergeStyles = new StyleRange[3];
            int i5 = 0;
            while (i5 < newRanges.length) {
                int newStart = newRanges[i5];
                int newEnd = newStart + newRanges[i5 + 1];
                if (newStart != newEnd) {
                    int modifyLast = 0;
                    int mergeCount = 0;
                    while (modifyEnd < rangeCount) {
                        if (newStart >= this.ranges[modifyStart] + this.ranges[modifyStart + 1]) {
                            modifyStart += 2;
                        }
                        if (this.ranges[modifyEnd] + this.ranges[modifyEnd + 1] > newEnd) break;
                        modifyEnd += 2;
                    }
                    if (this.ranges[modifyStart] < newStart && newStart < this.ranges[modifyStart] + this.ranges[modifyStart + 1]) {
                        mergeStyles[mergeCount >> 1] = this.styles[modifyStart >> 1];
                        mergeRanges[mergeCount] = this.ranges[modifyStart];
                        mergeRanges[mergeCount + 1] = newStart - this.ranges[modifyStart];
                        mergeCount += 2;
                    }
                    mergeStyles[mergeCount >> 1] = newStyles[i5 >> 1];
                    mergeRanges[mergeCount] = newStart;
                    mergeRanges[mergeCount + 1] = newRanges[i5 + 1];
                    mergeCount += 2;
                    if (modifyEnd < rangeCount && this.ranges[modifyEnd] < newEnd && newEnd < this.ranges[modifyEnd] + this.ranges[modifyEnd + 1]) {
                        mergeStyles[mergeCount >> 1] = this.styles[modifyEnd >> 1];
                        mergeRanges[mergeCount] = newEnd;
                        mergeRanges[mergeCount + 1] = this.ranges[modifyEnd] + this.ranges[modifyEnd + 1] - newEnd;
                        mergeCount += 2;
                        modifyLast = 2;
                    }
                    int grow = this.addMerge(mergeRanges, mergeStyles, mergeCount, modifyStart, modifyEnd + modifyLast);
                    rangeCount += grow;
                    modifyStart = modifyEnd += grow;
                }
                i5 += 2;
            }
        } else {
            int modifyEnd;
            boolean insert;
            int start = newStyles[0].start;
            int modifyStart = this.getRangeIndex(start, -1, this.styleCount);
            boolean bl = insert = modifyStart == this.styleCount;
            if (!insert) {
                int end = newStyles[newStyles.length - 1].start + newStyles[newStyles.length - 1].length;
                modifyEnd = this.getRangeIndex(end, modifyStart - 1, this.styleCount);
                boolean bl3 = insert = modifyStart == modifyEnd && this.styles[modifyStart].start >= end;
            }
            if (insert) {
                this.addMerge(newStyles, newStyles.length, modifyStart, modifyStart);
                return;
            }
            modifyEnd = modifyStart;
            StyleRange[] mergeStyles = new StyleRange[3];
            int i6 = 0;
            while (i6 < newStyles.length) {
                StyleRange newStyle = newStyles[i6];
                int newStart = newStyle.start;
                int newEnd = newStart + newStyle.length;
                if (newStart != newEnd) {
                    int modifyLast = 0;
                    int mergeCount = 0;
                    while (modifyEnd < this.styleCount) {
                        if (newStart >= this.styles[modifyStart].start + this.styles[modifyStart].length) {
                            ++modifyStart;
                        }
                        if (this.styles[modifyEnd].start + this.styles[modifyEnd].length > newEnd) break;
                        ++modifyEnd;
                    }
                    StyleRange style = this.styles[modifyStart];
                    if (style.start < newStart && newStart < style.start + style.length) {
                        int n2 = mergeCount++;
                        StyleRange styleRange = (StyleRange)style.clone();
                        mergeStyles[n2] = styleRange;
                        style = styleRange;
                        style.length = newStart - style.start;
                    }
                    mergeStyles[mergeCount++] = newStyle;
                    if (modifyEnd < this.styleCount) {
                        style = this.styles[modifyEnd];
                        if (style.start < newEnd && newEnd < style.start + style.length) {
                            int n3 = mergeCount++;
                            StyleRange styleRange = (StyleRange)style.clone();
                            mergeStyles[n3] = styleRange;
                            style = styleRange;
                            style.length += style.start - newEnd;
                            style.start = newEnd;
                            modifyLast = 1;
                        }
                    }
                    int grow = this.addMerge(mergeStyles, mergeCount, modifyStart, modifyEnd + modifyLast);
                    modifyStart = modifyEnd += grow;
                }
                ++i6;
            }
        }
    }

    void textChanging(TextChangingEvent event) {
        int start = event.start;
        int newCharCount = event.newCharCount;
        int replaceCharCount = event.replaceCharCount;
        int newLineCount = event.newLineCount;
        int replaceLineCount = event.replaceLineCount;
        this.updateRanges(start, replaceCharCount, newCharCount);
        int startLine = this.content.getLineAtOffset(start);
        if (replaceCharCount == this.content.getCharCount()) {
            this.lines = null;
        }
        if (replaceLineCount == this.lineCount) {
            this.lineCount = newLineCount;
            this.lineSizes = new LineSizeInfo[this.lineCount];
            this.reset(0, this.lineCount);
        } else {
            int delta;
            int startIndex = startLine + replaceLineCount + 1;
            int endIndex = startLine + newLineCount + 1;
            if (this.lineCount < startLine) {
                SWT.error(6, null, "bug 478020: lineCount < startLine: " + this.lineCount + ":" + startLine);
            }
            if (this.lineCount < startIndex) {
                SWT.error(6, null, "bug 478020: lineCount < startIndex: " + this.lineCount + ":" + startIndex);
            }
            if (this.lineCount + (delta = newLineCount - replaceLineCount) > this.lineSizes.length) {
                LineSizeInfo[] newLineSizes = new LineSizeInfo[this.lineCount + delta + 32];
                System.arraycopy(this.lineSizes, 0, newLineSizes, 0, this.lineCount);
                this.lineSizes = newLineSizes;
            }
            if (this.lines != null && this.lineCount + delta > this.lines.length) {
                LineInfo[] newLines = new LineInfo[this.lineCount + delta + 32];
                System.arraycopy(this.lines, 0, newLines, 0, this.lineCount);
                this.lines = newLines;
            }
            System.arraycopy(this.lineSizes, startIndex, this.lineSizes, endIndex, this.lineCount - startIndex);
            int i2 = startLine;
            while (i2 < endIndex) {
                this.lineSizes[i2] = null;
                ++i2;
            }
            i2 = this.lineCount + delta;
            while (i2 < this.lineCount) {
                this.lineSizes[i2] = null;
                ++i2;
            }
            if (this.layouts != null) {
                int layoutStartLine = startLine - this.topIndex;
                int layoutEndLine = layoutStartLine + replaceLineCount + 1;
                int i3 = layoutStartLine;
                while (i3 < layoutEndLine) {
                    if (i3 >= 0 && i3 < this.layouts.length) {
                        if (this.layouts[i3] != null) {
                            this.layouts[i3].dispose();
                        }
                        this.layouts[i3] = null;
                        if (this.bullets != null && this.bulletsIndices != null) {
                            this.bullets[i3] = null;
                        }
                    }
                    ++i3;
                }
                if (delta > 0) {
                    i3 = this.layouts.length - 1;
                    while (i3 >= layoutEndLine) {
                        if (i3 >= 0 && i3 < this.layouts.length) {
                            endIndex = i3 + delta;
                            if (endIndex >= 0 && endIndex < this.layouts.length) {
                                this.layouts[endIndex] = this.layouts[i3];
                                this.layouts[i3] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[endIndex] = this.bullets[i3];
                                    this.bulletsIndices[endIndex] = this.bulletsIndices[i3];
                                    this.bullets[i3] = null;
                                }
                            } else {
                                if (this.layouts[i3] != null) {
                                    this.layouts[i3].dispose();
                                }
                                this.layouts[i3] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[i3] = null;
                                }
                            }
                        }
                        --i3;
                    }
                } else if (delta < 0) {
                    i3 = layoutEndLine;
                    while (i3 < this.layouts.length) {
                        if (i3 >= 0 && i3 < this.layouts.length) {
                            endIndex = i3 + delta;
                            if (endIndex >= 0 && endIndex < this.layouts.length) {
                                this.layouts[endIndex] = this.layouts[i3];
                                this.layouts[i3] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[endIndex] = this.bullets[i3];
                                    this.bulletsIndices[endIndex] = this.bulletsIndices[i3];
                                    this.bullets[i3] = null;
                                }
                            } else {
                                if (this.layouts[i3] != null) {
                                    this.layouts[i3].dispose();
                                }
                                this.layouts[i3] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[i3] = null;
                                }
                            }
                        }
                        ++i3;
                    }
                }
            }
            if (replaceLineCount != 0 || newLineCount != 0) {
                int startLineOffset = this.content.getOffsetAtLine(startLine);
                if (startLineOffset != start) {
                    ++startLine;
                }
                this.updateBullets(startLine, replaceLineCount, newLineCount, true);
                if (this.lines != null) {
                    startIndex = startLine + replaceLineCount;
                    endIndex = startLine + newLineCount;
                    System.arraycopy(this.lines, startIndex, this.lines, endIndex, this.lineCount - startIndex);
                    int i4 = startLine;
                    while (i4 < endIndex) {
                        this.lines[i4] = null;
                        ++i4;
                    }
                    i4 = this.lineCount + delta;
                    while (i4 < this.lineCount) {
                        this.lines[i4] = null;
                        ++i4;
                    }
                }
            }
            this.lineCount += delta;
            if (this.maxWidthLineIndex != -1 && startLine <= this.maxWidthLineIndex && this.maxWidthLineIndex <= startLine + replaceLineCount) {
                this.maxWidth = 0;
                this.maxWidthLineIndex = -1;
                i2 = 0;
                while (i2 < this.lineCount) {
                    LineSizeInfo lineSize = this.getLineSize(i2);
                    if (lineSize.width > this.maxWidth) {
                        this.maxWidth = lineSize.width;
                        this.maxWidthLineIndex = i2;
                    }
                    ++i2;
                }
            }
        }
    }

    void updateBullets(int startLine, int replaceLineCount, int newLineCount, boolean update) {
        if (this.bullets == null) {
            return;
        }
        if (this.bulletsIndices != null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.bullets.length) {
            Bullet bullet = this.bullets[i2];
            int[] lines = bullet.removeIndices(startLine, replaceLineCount, newLineCount, update);
            if (lines != null) {
                if (this.redrawLines == null) {
                    this.redrawLines = lines;
                } else {
                    int[] newRedrawBullets = new int[this.redrawLines.length + lines.length];
                    System.arraycopy(this.redrawLines, 0, newRedrawBullets, 0, this.redrawLines.length);
                    System.arraycopy(lines, 0, newRedrawBullets, this.redrawLines.length, lines.length);
                    this.redrawLines = newRedrawBullets;
                }
            }
            ++i2;
        }
        int removed = 0;
        int i3 = 0;
        while (i3 < this.bullets.length) {
            if (this.bullets[i3].size() == 0) {
                ++removed;
            }
            ++i3;
        }
        if (removed > 0) {
            if (removed == this.bullets.length) {
                this.bullets = null;
            } else {
                Bullet[] newBulletsList = new Bullet[this.bullets.length - removed];
                int i4 = 0;
                int j2 = 0;
                while (i4 < this.bullets.length) {
                    Bullet bullet = this.bullets[i4];
                    if (bullet.size() > 0) {
                        newBulletsList[j2++] = bullet;
                    }
                    ++i4;
                }
                this.bullets = newBulletsList;
            }
        }
    }

    void updateRanges(int start, int replaceCharCount, int newCharCount) {
        if (this.styleCount == 0 || replaceCharCount == 0 && newCharCount == 0) {
            return;
        }
        if (this.ranges != null) {
            int rangeCount = this.styleCount << 1;
            int modifyStart = this.getRangeIndex(start, -1, rangeCount);
            if (modifyStart == rangeCount) {
                return;
            }
            int end = start + replaceCharCount;
            int modifyEnd = this.getRangeIndex(end, modifyStart - 1, rangeCount);
            int offset = newCharCount - replaceCharCount;
            if (modifyStart == modifyEnd && this.ranges[modifyStart] < start && end < this.ranges[modifyEnd] + this.ranges[modifyEnd + 1]) {
                if (newCharCount == 0) {
                    int n2 = modifyStart + 1;
                    this.ranges[n2] = this.ranges[n2] - replaceCharCount;
                    modifyEnd += 2;
                } else {
                    if (rangeCount + 2 > this.ranges.length) {
                        int[] newRanges = new int[this.ranges.length + 64];
                        System.arraycopy(this.ranges, 0, newRanges, 0, rangeCount);
                        this.ranges = newRanges;
                        StyleRange[] newStyles = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, newStyles, 0, this.styleCount);
                        this.styles = newStyles;
                    }
                    System.arraycopy(this.ranges, modifyStart + 2, this.ranges, modifyStart + 4, rangeCount - (modifyStart + 2));
                    System.arraycopy(this.styles, modifyStart + 2 >> 1, this.styles, modifyStart + 4 >> 1, this.styleCount - (modifyStart + 2 >> 1));
                    this.ranges[modifyStart + 3] = this.ranges[modifyStart] + this.ranges[modifyStart + 1] - end;
                    this.ranges[modifyStart + 2] = start + newCharCount;
                    this.ranges[modifyStart + 1] = start - this.ranges[modifyStart];
                    this.styles[(modifyStart >> 1) + 1] = this.styles[modifyStart >> 1];
                    rangeCount += 2;
                    ++this.styleCount;
                    modifyEnd += 4;
                }
                if (offset != 0) {
                    int i2 = modifyEnd;
                    while (i2 < rangeCount) {
                        int n3 = i2;
                        this.ranges[n3] = this.ranges[n3] + offset;
                        i2 += 2;
                    }
                }
            } else {
                if (this.ranges[modifyStart] < start && start < this.ranges[modifyStart] + this.ranges[modifyStart + 1]) {
                    this.ranges[modifyStart + 1] = start - this.ranges[modifyStart];
                    modifyStart += 2;
                }
                if (modifyEnd < rangeCount && this.ranges[modifyEnd] < end && end < this.ranges[modifyEnd] + this.ranges[modifyEnd + 1]) {
                    this.ranges[modifyEnd + 1] = this.ranges[modifyEnd] + this.ranges[modifyEnd + 1] - end;
                    this.ranges[modifyEnd] = end;
                }
                if (offset != 0) {
                    int i3 = modifyEnd;
                    while (i3 < rangeCount) {
                        int n4 = i3;
                        this.ranges[n4] = this.ranges[n4] + offset;
                        i3 += 2;
                    }
                }
                System.arraycopy(this.ranges, modifyEnd, this.ranges, modifyStart, rangeCount - modifyEnd);
                System.arraycopy(this.styles, modifyEnd >> 1, this.styles, modifyStart >> 1, this.styleCount - (modifyEnd >> 1));
                this.styleCount -= modifyEnd - modifyStart >> 1;
            }
        } else {
            int modifyStart = this.getRangeIndex(start, -1, this.styleCount);
            if (modifyStart == this.styleCount) {
                return;
            }
            int end = start + replaceCharCount;
            int modifyEnd = this.getRangeIndex(end, modifyStart - 1, this.styleCount);
            int offset = newCharCount - replaceCharCount;
            if (modifyStart == modifyEnd && this.styles[modifyStart].start < start && end < this.styles[modifyEnd].start + this.styles[modifyEnd].length) {
                if (newCharCount == 0) {
                    this.styles[modifyStart].length -= replaceCharCount;
                    ++modifyEnd;
                } else {
                    if (this.styleCount + 1 > this.styles.length) {
                        StyleRange[] newStyles = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, newStyles, 0, this.styleCount);
                        this.styles = newStyles;
                    }
                    System.arraycopy(this.styles, modifyStart + 1, this.styles, modifyStart + 2, this.styleCount - (modifyStart + 1));
                    this.styles[modifyStart + 1] = (StyleRange)this.styles[modifyStart].clone();
                    this.styles[modifyStart + 1].length = this.styles[modifyStart].start + this.styles[modifyStart].length - end;
                    this.styles[modifyStart + 1].start = start + newCharCount;
                    this.styles[modifyStart].length = start - this.styles[modifyStart].start;
                    ++this.styleCount;
                    modifyEnd += 2;
                }
                if (offset != 0) {
                    int i4 = modifyEnd;
                    while (i4 < this.styleCount) {
                        this.styles[i4].start += offset;
                        ++i4;
                    }
                }
            } else {
                if (this.styles[modifyStart].start < start && start < this.styles[modifyStart].start + this.styles[modifyStart].length) {
                    this.styles[modifyStart].length = start - this.styles[modifyStart].start;
                    ++modifyStart;
                }
                if (modifyEnd < this.styleCount && this.styles[modifyEnd].start < end && end < this.styles[modifyEnd].start + this.styles[modifyEnd].length) {
                    this.styles[modifyEnd].length = this.styles[modifyEnd].start + this.styles[modifyEnd].length - end;
                    this.styles[modifyEnd].start = end;
                }
                if (offset != 0) {
                    int i5 = modifyEnd;
                    while (i5 < this.styleCount) {
                        this.styles[i5].start += offset;
                        ++i5;
                    }
                }
                System.arraycopy(this.styles, modifyEnd, this.styles, modifyStart, this.styleCount - modifyEnd);
                this.styleCount -= modifyEnd - modifyStart;
            }
        }
    }

    static class LineInfo {
        int flags;
        Color background;
        int alignment;
        int indent;
        int wrapIndent;
        boolean justify;
        int[] segments;
        char[] segmentsChars;
        int[] tabStops;
        int verticalIndent;

        public LineInfo() {
        }

        public LineInfo(LineInfo info) {
            if (info != null) {
                this.flags = info.flags;
                this.background = info.background;
                this.alignment = info.alignment;
                this.indent = info.indent;
                this.wrapIndent = info.wrapIndent;
                this.justify = info.justify;
                this.segments = info.segments;
                this.segmentsChars = info.segmentsChars;
                this.tabStops = info.tabStops;
                this.verticalIndent = info.verticalIndent;
            }
        }
    }

    static class LineSizeInfo {
        private static final int RESETED_SIZE = -1;
        int height;
        int width;

        public LineSizeInfo() {
            this.resetSize();
        }

        void resetSize() {
            this.height = -1;
            this.width = -1;
        }

        boolean canLayout() {
            return !this.needsRecalculateWidth();
        }

        boolean needsRecalculateSize() {
            return this.needsRecalculateWidth() || this.needsRecalculateHeight();
        }

        boolean needsRecalculateWidth() {
            return this.width == -1;
        }

        boolean needsRecalculateHeight() {
            return this.height == -1;
        }
    }

    private static final class StyleEntry {
        public final int start;
        public final int end;
        public final TextStyle style;

        public StyleEntry(TextStyle style, int start, int end) {
            this.style = style;
            this.start = start;
            this.end = end;
        }
    }
}

