/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.rank;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.interpolation.NevilleInterpolator;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math3.exception.InsufficientDataException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSquarePercentile
extends AbstractStorelessUnivariateStatistic
implements StorelessUnivariateStatistic,
Serializable {
    private static final int PSQUARE_CONSTANT = 5;
    private static final double DEFAULT_QUANTILE_DESIRED = 50.0;
    private static final long serialVersionUID = 2283912083175715479L;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00.00");
    private final List<Double> initialFive = new FixedCapacityList<Double>(5);
    private final double quantile;
    private transient double lastObservation;
    private PSquareMarkers markers = null;
    private double pValue = Double.NaN;
    private long countOfObservations;

    public PSquarePercentile(double p2) {
        if (p2 > 100.0 || p2 < 0.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE, (Number)p2, 0, 100);
        }
        this.quantile = p2 / 100.0;
    }

    PSquarePercentile() {
        this(50.0);
    }

    @Override
    public int hashCode() {
        double result2 = this.getResult();
        result2 = Double.isNaN(result2) ? 37.0 : result2;
        double markersHash = this.markers == null ? 0.0 : (double)this.markers.hashCode();
        double[] toHash = new double[]{result2, this.quantile, markersHash, this.countOfObservations};
        return Arrays.hashCode(toHash);
    }

    @Override
    public boolean equals(Object o2) {
        boolean result2 = false;
        if (this == o2) {
            result2 = true;
        } else if (o2 != null && o2 instanceof PSquarePercentile) {
            PSquarePercentile that = (PSquarePercentile)o2;
            boolean isNotNull = this.markers != null && that.markers != null;
            boolean isNull = this.markers == null && that.markers == null;
            result2 = isNotNull ? this.markers.equals(that.markers) : isNull;
            result2 = result2 && this.getN() == that.getN();
        }
        return result2;
    }

    @Override
    public void increment(double observation) {
        ++this.countOfObservations;
        this.lastObservation = observation;
        if (this.markers == null) {
            if (this.initialFive.add(observation)) {
                Collections.sort(this.initialFive);
                this.pValue = this.initialFive.get((int)(this.quantile * (double)(this.initialFive.size() - 1)));
                return;
            }
            this.markers = PSquarePercentile.newMarkers(this.initialFive, this.quantile);
        }
        this.pValue = this.markers.processDataPoint(observation);
    }

    public String toString() {
        if (this.markers == null) {
            return String.format("obs=%s pValue=%s", DECIMAL_FORMAT.format(this.lastObservation), DECIMAL_FORMAT.format(this.pValue));
        }
        return String.format("obs=%s markers=%s", DECIMAL_FORMAT.format(this.lastObservation), this.markers.toString());
    }

    @Override
    public long getN() {
        return this.countOfObservations;
    }

    @Override
    public StorelessUnivariateStatistic copy() {
        PSquarePercentile copy2 = new PSquarePercentile(100.0 * this.quantile);
        if (this.markers != null) {
            copy2.markers = (PSquareMarkers)this.markers.clone();
        }
        copy2.countOfObservations = this.countOfObservations;
        copy2.pValue = this.pValue;
        copy2.initialFive.clear();
        copy2.initialFive.addAll(this.initialFive);
        return copy2;
    }

    public double quantile() {
        return this.quantile;
    }

    @Override
    public void clear() {
        this.markers = null;
        this.initialFive.clear();
        this.countOfObservations = 0L;
        this.pValue = Double.NaN;
    }

    @Override
    public double getResult() {
        if (Double.compare(this.quantile, 1.0) == 0) {
            this.pValue = this.maximum();
        } else if (Double.compare(this.quantile, 0.0) == 0) {
            this.pValue = this.minimum();
        }
        return this.pValue;
    }

    private double maximum() {
        double val = Double.NaN;
        if (this.markers != null) {
            val = this.markers.height(5);
        } else if (!this.initialFive.isEmpty()) {
            val = this.initialFive.get(this.initialFive.size() - 1);
        }
        return val;
    }

    private double minimum() {
        double val = Double.NaN;
        if (this.markers != null) {
            val = this.markers.height(1);
        } else if (!this.initialFive.isEmpty()) {
            val = this.initialFive.get(0);
        }
        return val;
    }

    public static PSquareMarkers newMarkers(List<Double> initialFive, double p2) {
        return new Markers(initialFive, p2);
    }

    protected static interface PSquareMarkers
    extends Cloneable {
        public double getPercentileValue();

        public Object clone();

        public double height(int var1);

        public double processDataPoint(double var1);

        public double estimate(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedCapacityList<E>
    extends ArrayList<E>
    implements Serializable {
        private static final long serialVersionUID = 2283952083075725479L;
        private final int capacity;

        FixedCapacityList(int fixedCapacity) {
            super(fixedCapacity);
            this.capacity = fixedCapacity;
        }

        @Override
        public boolean add(E e2) {
            return this.size() < this.capacity ? super.add(e2) : false;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            boolean isCollectionLess = collection != null && collection.size() + this.size() <= this.capacity;
            return isCollectionLess ? super.addAll(collection) : false;
        }
    }

    private static class Marker
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -3575879478288538431L;
        private int index;
        private double intMarkerPosition;
        private double desiredMarkerPosition;
        private double markerHeight;
        private double desiredMarkerIncrement;
        private transient Marker next;
        private transient Marker previous;
        private final UnivariateInterpolator nonLinear = new NevilleInterpolator();
        private transient UnivariateInterpolator linear = new LinearInterpolator();

        private Marker() {
            this.next = this.previous = this;
        }

        private Marker(double heightOfMarker, double makerPositionDesired, double markerPositionIncrement, double markerPositionNumber) {
            this();
            this.markerHeight = heightOfMarker;
            this.desiredMarkerPosition = makerPositionDesired;
            this.desiredMarkerIncrement = markerPositionIncrement;
            this.intMarkerPosition = markerPositionNumber;
        }

        private Marker previous(Marker previousMarker) {
            MathUtils.checkNotNull(previousMarker);
            this.previous = previousMarker;
            return this;
        }

        private Marker next(Marker nextMarker) {
            MathUtils.checkNotNull(nextMarker);
            this.next = nextMarker;
            return this;
        }

        private Marker index(int indexOfMarker) {
            this.index = indexOfMarker;
            return this;
        }

        private void updateDesiredPosition() {
            this.desiredMarkerPosition += this.desiredMarkerIncrement;
        }

        private void incrementPosition(int d2) {
            this.intMarkerPosition += (double)d2;
        }

        private double difference() {
            return this.desiredMarkerPosition - this.intMarkerPosition;
        }

        private double estimate() {
            boolean isPreviousLower;
            double di2 = this.difference();
            boolean isNextHigher = this.next.intMarkerPosition - this.intMarkerPosition > 1.0;
            boolean bl = isPreviousLower = this.previous.intMarkerPosition - this.intMarkerPosition < -1.0;
            if (di2 >= 1.0 && isNextHigher || di2 <= -1.0 && isPreviousLower) {
                int d2 = di2 >= 0.0 ? 1 : -1;
                double[] xval = new double[]{this.previous.intMarkerPosition, this.intMarkerPosition, this.next.intMarkerPosition};
                double[] yval = new double[]{this.previous.markerHeight, this.markerHeight, this.next.markerHeight};
                double xD = this.intMarkerPosition + (double)d2;
                UnivariateFunction univariateFunction = this.nonLinear.interpolate(xval, yval);
                this.markerHeight = univariateFunction.value(xD);
                if (this.isEstimateBad(yval, this.markerHeight)) {
                    int delta = xD - xval[1] > 0.0 ? 1 : -1;
                    double[] xBad = new double[]{xval[1], xval[1 + delta]};
                    double[] yBad = new double[]{yval[1], yval[1 + delta]};
                    MathArrays.sortInPlace(xBad, new double[][]{yBad});
                    univariateFunction = this.linear.interpolate(xBad, yBad);
                    this.markerHeight = univariateFunction.value(xD);
                }
                this.incrementPosition(d2);
            }
            return this.markerHeight;
        }

        private boolean isEstimateBad(double[] y2, double yD) {
            return yD <= y2[0] || yD >= y2[2];
        }

        public boolean equals(Object o2) {
            boolean result2 = false;
            if (this == o2) {
                result2 = true;
            } else if (o2 != null && o2 instanceof Marker) {
                Marker that = (Marker)o2;
                result2 = Double.compare(this.markerHeight, that.markerHeight) == 0;
                result2 = result2 && Double.compare(this.intMarkerPosition, that.intMarkerPosition) == 0;
                result2 = result2 && Double.compare(this.desiredMarkerPosition, that.desiredMarkerPosition) == 0;
                result2 = result2 && Double.compare(this.desiredMarkerIncrement, that.desiredMarkerIncrement) == 0;
                result2 = result2 && this.next.index == that.next.index;
                result2 = result2 && this.previous.index == that.previous.index;
            }
            return result2;
        }

        public int hashCode() {
            return Arrays.hashCode(new double[]{this.markerHeight, this.intMarkerPosition, this.desiredMarkerIncrement, this.desiredMarkerPosition, this.previous.index, this.next.index});
        }

        private void readObject(ObjectInputStream anInstream) throws ClassNotFoundException, IOException {
            anInstream.defaultReadObject();
            this.previous = this.next = this;
            this.linear = new LinearInterpolator();
        }

        public Object clone() {
            return new Marker(this.markerHeight, this.desiredMarkerPosition, this.desiredMarkerIncrement, this.intMarkerPosition);
        }

        public String toString() {
            return String.format("index=%.0f,n=%.0f,np=%.2f,q=%.2f,dn=%.2f,prev=%d,next=%d", this.index, Precision.round(this.intMarkerPosition, 0), Precision.round(this.desiredMarkerPosition, 2), Precision.round(this.markerHeight, 2), Precision.round(this.desiredMarkerIncrement, 2), this.previous.index, this.next.index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Markers
    implements PSquareMarkers,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int LOW = 2;
        private static final int HIGH = 4;
        private final Marker[] markerArray;
        private transient int k = -1;

        private Markers(Marker[] theMarkerArray) {
            MathUtils.checkNotNull(theMarkerArray);
            this.markerArray = theMarkerArray;
            for (int i2 = 1; i2 < 5; ++i2) {
                this.markerArray[i2].previous(this.markerArray[i2 - 1]).next(this.markerArray[i2 + 1]).index(i2);
            }
            this.markerArray[0].previous(this.markerArray[0]).next(this.markerArray[1]).index(0);
            this.markerArray[5].previous(this.markerArray[4]).next(this.markerArray[5]).index(5);
        }

        private Markers(List<Double> initialFive, double p2) {
            this(Markers.createMarkerArray(initialFive, p2));
        }

        private static Marker[] createMarkerArray(List<Double> initialFive, double p2) {
            int countObserved;
            int n2 = countObserved = initialFive == null ? -1 : initialFive.size();
            if (countObserved < 5) {
                throw new InsufficientDataException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, countObserved, 5);
            }
            Collections.sort(initialFive);
            return new Marker[]{new Marker(), new Marker(initialFive.get(0), 1.0, 0.0, 1.0), new Marker(initialFive.get(1), 1.0 + 2.0 * p2, p2 / 2.0, 2.0), new Marker(initialFive.get(2), 1.0 + 4.0 * p2, p2, 3.0), new Marker(initialFive.get(3), 3.0 + 2.0 * p2, (1.0 + p2) / 2.0, 4.0), new Marker(initialFive.get(4), 5.0, 1.0, 5.0)};
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.markerArray);
        }

        public boolean equals(Object o2) {
            boolean result2 = false;
            if (this == o2) {
                result2 = true;
            } else if (o2 != null && o2 instanceof Markers) {
                Markers that = (Markers)o2;
                result2 = Arrays.deepEquals(this.markerArray, that.markerArray);
            }
            return result2;
        }

        @Override
        public double processDataPoint(double inputDataPoint) {
            int kthCell = this.findCellAndUpdateMinMax(inputDataPoint);
            this.incrementPositions(1, kthCell + 1, 5);
            this.updateDesiredPositions();
            this.adjustHeightsOfMarkers();
            return this.getPercentileValue();
        }

        @Override
        public double getPercentileValue() {
            return this.height(3);
        }

        private int findCellAndUpdateMinMax(double observation) {
            this.k = -1;
            if (observation < this.height(1)) {
                this.markerArray[1].markerHeight = observation;
                this.k = 1;
            } else if (observation < this.height(2)) {
                this.k = 1;
            } else if (observation < this.height(3)) {
                this.k = 2;
            } else if (observation < this.height(4)) {
                this.k = 3;
            } else if (observation <= this.height(5)) {
                this.k = 4;
            } else {
                this.markerArray[5].markerHeight = observation;
                this.k = 4;
            }
            return this.k;
        }

        private void adjustHeightsOfMarkers() {
            for (int i2 = 2; i2 <= 4; ++i2) {
                this.estimate(i2);
            }
        }

        @Override
        public double estimate(int index) {
            if (index < 2 || index > 4) {
                throw new OutOfRangeException(index, (Number)2, 4);
            }
            return this.markerArray[index].estimate();
        }

        private void incrementPositions(int d2, int startIndex, int endIndex) {
            for (int i2 = startIndex; i2 <= endIndex; ++i2) {
                this.markerArray[i2].incrementPosition(d2);
            }
        }

        private void updateDesiredPositions() {
            for (int i2 = 1; i2 < this.markerArray.length; ++i2) {
                this.markerArray[i2].updateDesiredPosition();
            }
        }

        private void readObject(ObjectInputStream anInputStream) throws ClassNotFoundException, IOException {
            anInputStream.defaultReadObject();
            for (int i2 = 1; i2 < 5; ++i2) {
                this.markerArray[i2].previous(this.markerArray[i2 - 1]).next(this.markerArray[i2 + 1]).index(i2);
            }
            this.markerArray[0].previous(this.markerArray[0]).next(this.markerArray[1]).index(0);
            this.markerArray[5].previous(this.markerArray[4]).next(this.markerArray[5]).index(5);
        }

        @Override
        public double height(int markerIndex) {
            if (markerIndex >= this.markerArray.length || markerIndex <= 0) {
                throw new OutOfRangeException(markerIndex, (Number)1, this.markerArray.length);
            }
            return this.markerArray[markerIndex].markerHeight;
        }

        @Override
        public Object clone() {
            return new Markers(new Marker[]{new Marker(), (Marker)this.markerArray[1].clone(), (Marker)this.markerArray[2].clone(), (Marker)this.markerArray[3].clone(), (Marker)this.markerArray[4].clone(), (Marker)this.markerArray[5].clone()});
        }

        public String toString() {
            return String.format("m1=[%s],m2=[%s],m3=[%s],m4=[%s],m5=[%s]", this.markerArray[1].toString(), this.markerArray[2].toString(), this.markerArray[3].toString(), this.markerArray[4].toString(), this.markerArray[5].toString());
        }
    }
}

