/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.SaddlePointExpansion;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;

public class PoissonDistribution
extends AbstractIntegerDistribution {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private final NormalDistribution normal;
    private final ExponentialDistribution exponential;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double p2) throws NotStrictlyPositiveException {
        this(p2, 1.0E-12, 10000000);
    }

    public PoissonDistribution(double p2, double epsilon, int maxIterations) throws NotStrictlyPositiveException {
        this(new Well19937c(), p2, epsilon, maxIterations);
    }

    public PoissonDistribution(RandomGenerator rng, double p2, double epsilon, int maxIterations) throws NotStrictlyPositiveException {
        super(rng);
        if (p2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, p2);
        }
        this.mean = p2;
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
        this.normal = new NormalDistribution(rng, p2, FastMath.sqrt(p2), 1.0E-9);
        this.exponential = new ExponentialDistribution(rng, 1.0, 1.0E-9);
    }

    public PoissonDistribution(double p2, double epsilon) throws NotStrictlyPositiveException {
        this(p2, epsilon, 10000000);
    }

    public PoissonDistribution(double p2, int maxIterations) {
        this(p2, 1.0E-12, maxIterations);
    }

    public double getMean() {
        return this.mean;
    }

    public double probability(int x2) {
        double logProbability = this.logProbability(x2);
        return logProbability == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(logProbability);
    }

    public double logProbability(int x2) {
        double ret = x2 < 0 || x2 == Integer.MAX_VALUE ? Double.NEGATIVE_INFINITY : (x2 == 0 ? -this.mean : -SaddlePointExpansion.getStirlingError(x2) - SaddlePointExpansion.getDeviancePart(x2, this.mean) - 0.5 * FastMath.log(Math.PI * 2) - 0.5 * FastMath.log(x2));
        return ret;
    }

    public double cumulativeProbability(int x2) {
        if (x2 < 0) {
            return 0.0;
        }
        if (x2 == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)x2 + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int x2) {
        return this.normal.cumulativeProbability((double)x2 + 0.5);
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        return this.getMean();
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        return (int)FastMath.min(this.nextPoisson(this.mean), Integer.MAX_VALUE);
    }

    private long nextPoisson(double meanPoisson) {
        double y2;
        long y22;
        block9: {
            double pivot = 40.0;
            if (meanPoisson < 40.0) {
                double p2 = FastMath.exp(-meanPoisson);
                long n2 = 0L;
                double r2 = 1.0;
                double rnd = 1.0;
                while ((double)n2 < 1000.0 * meanPoisson) {
                    rnd = this.random.nextDouble();
                    if ((r2 *= rnd) >= p2) {
                        ++n2;
                        continue;
                    }
                    return n2;
                }
                return n2;
            }
            double lambda2 = FastMath.floor(meanPoisson);
            double lambdaFractional = meanPoisson - lambda2;
            double logLambda = FastMath.log(lambda2);
            double logLambdaFactorial = CombinatoricsUtils.factorialLog((int)lambda2);
            y22 = lambdaFractional < Double.MIN_VALUE ? 0L : this.nextPoisson(lambdaFractional);
            double delta = FastMath.sqrt(lambda2 * FastMath.log(32.0 * lambda2 / Math.PI + 1.0));
            double halfDelta = delta / 2.0;
            double twolpd = 2.0 * lambda2 + delta;
            double a1 = FastMath.sqrt(Math.PI * twolpd) * FastMath.exp(1.0 / (8.0 * lambda2));
            double a2 = twolpd / delta * FastMath.exp(-delta * (1.0 + delta) / twolpd);
            double aSum = a1 + a2 + 1.0;
            double p1 = a1 / aSum;
            double p2 = a2 / aSum;
            double c1 = 1.0 / (8.0 * lambda2);
            double x2 = 0.0;
            y2 = 0.0;
            double v2 = 0.0;
            boolean a3 = false;
            double t2 = 0.0;
            double qr = 0.0;
            double qa = 0.0;
            while (true) {
                double u2;
                if ((u2 = this.random.nextDouble()) <= p1) {
                    double n3 = this.random.nextGaussian();
                    x2 = n3 * FastMath.sqrt(lambda2 + halfDelta) - 0.5;
                    if (x2 > delta || x2 < -lambda2) continue;
                    y2 = x2 < 0.0 ? FastMath.floor(x2) : FastMath.ceil(x2);
                    double e2 = this.exponential.sample();
                    v2 = -e2 - n3 * n3 / 2.0 + c1;
                } else {
                    if (u2 > p1 + p2) {
                        y2 = lambda2;
                        break block9;
                    }
                    x2 = delta + twolpd / delta * this.exponential.sample();
                    y2 = FastMath.ceil(x2);
                    v2 = -this.exponential.sample() - delta * (x2 + 1.0) / twolpd;
                }
                a3 = x2 < 0.0;
                t2 = y2 * (y2 + 1.0) / (2.0 * lambda2);
                if (v2 < -t2 && !a3) {
                    y2 = lambda2 + y2;
                    break block9;
                }
                qr = t2 * ((2.0 * y2 + 1.0) / (6.0 * lambda2) - 1.0);
                qa = qr - t2 * t2 / (3.0 * (lambda2 + (double)a3 * (y2 + 1.0)));
                if (v2 < qa) {
                    y2 = lambda2 + y2;
                    break block9;
                }
                if (!(v2 > qr) && v2 < y2 * logLambda - CombinatoricsUtils.factorialLog((int)(y2 + lambda2)) + logLambdaFactorial) break;
            }
            y2 = lambda2 + y2;
        }
        return y22 + (long)y2;
    }
}

