/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi.modbus;

import gde.device.junsi.modbus.ChargerDialog;
import gde.io.DataParser;
import gde.log.Level;
import java.util.Arrays;

public class ChargerMemoryHead {
    short count;
    byte[] index;
    static final int size = 34;

    public ChargerMemoryHead(byte[] memoryHeadBuffer, boolean isDuoOrDX) {
        this.index = new byte[ChargerMemoryHead.getMaxListIndex(isDuoOrDX)];
        this.count = DataParser.parse2Short((byte)memoryHeadBuffer[0], (byte)memoryHeadBuffer[1]);
        for (int i = 0; i < this.count; ++i) {
            this.index[i] = memoryHeadBuffer[2 + i];
        }
        if (ChargerDialog.log.isLoggable(Level.INFO)) {
            ChargerDialog.log.log(Level.INFO, String.format("memoryHead index: %s", this.toString()));
        }
    }

    public static int getMaxListIndex(boolean isDuoOrDX) {
        return isDuoOrDX ? 64 : 32;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" : \n");
        sb.append(String.format("program memory count = %d", this.count)).append("\n");
        for (int i = 0; i < this.count; ++i) {
            sb.append(this.index[i]).append(", ");
        }
        sb.append("\n");
        return sb.toString();
    }

    public byte[] getAsByteArray(boolean isDuoOrDX) {
        byte[] memHeadBuffer = new byte[ChargerMemoryHead.getSize(isDuoOrDX)];
        memHeadBuffer[0] = (byte)(this.count & 0xFF);
        memHeadBuffer[1] = (byte)(this.count >> 8);
        for (int i = 0; i < this.count; ++i) {
            memHeadBuffer[2 + i] = this.index[i];
        }
        return memHeadBuffer;
    }

    public static int getSize(boolean isDuoOrDX) {
        return (isDuoOrDX ? 64 : 32) + 2;
    }

    public short getCount() {
        return this.count;
    }

    public void setCount(short count) {
        this.count = count;
    }

    public byte[] getIndex() {
        return this.index;
    }

    public short getNextFreeIndex() {
        short nextFreeIndex = -1;
        byte[] sortedIndex = new byte[this.count];
        System.arraycopy(this.index, 0, sortedIndex, 0, this.count);
        Arrays.sort(sortedIndex);
        for (int i = 0; i < this.count - 1; ++i) {
            if (sortedIndex[i] + 1 == sortedIndex[i + 1]) continue;
            nextFreeIndex = (short)(sortedIndex[i] + 1);
            break;
        }
        if (nextFreeIndex == -1) {
            short n = this.count;
            int sum = n * (n + 1) / 2;
            int restSum = 0;
            for (int i = 0; i < this.count; ++i) {
                restSum += this.index[i];
            }
            nextFreeIndex = (short)(sum - restSum);
        }
        if (ChargerDialog.log.isLoggable(Level.INFO)) {
            ChargerDialog.log.log(Level.INFO, String.format("memoryHead next free index: %s", nextFreeIndex));
        }
        return nextFreeIndex;
    }

    public byte[] addIndexAfter(byte batTypeOrdinal, int addFreeIndex) {
        byte[] updatedIndex = new byte[this.count + 1];
        int i = 0;
        int j = 0;
        while (i < this.count + 1) {
            updatedIndex[i++] = this.index[j++];
            if (updatedIndex[i - 1] != batTypeOrdinal) continue;
            updatedIndex[i++] = (byte)addFreeIndex;
        }
        return updatedIndex;
    }

    public byte[] removeIndex(byte removeIndex) {
        byte[] updatedIndex = new byte[this.count - 1];
        int i = 0;
        int j = 0;
        while (i < this.count - 1) {
            if (this.index[j++] == removeIndex) continue;
            updatedIndex[i++] = this.index[j - 1];
        }
        return updatedIndex;
    }

    public void setIndex(byte[] index) {
        this.index = index;
    }
}

