/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.junsi.GathererThread;
import gde.device.junsi.iChargerSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public abstract class iCharger
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(iCharger.class.getName());
    public static final String CONFIG_EXT_TEMP_CUT_OFF = "ext_temp_cut_off";
    public static final String CONFIG_WAIT_TIME = "wait_time";
    public static final String CONFIG_IN_VOLTAGE_CUT_OFF = "in_voltage_cut_off";
    public static final String CONFIG_SAFETY_TIME = "safety_time";
    public static final String CONFIG_SET_CAPASITY = "capacity_cut_off";
    public static final String CONFIG_PROCESSING = "processing";
    public static final String CONFIG_BATTERY_TYPE = "battery_type";
    public static final String CONFIG_PROCESSING_TIME = "processing_time";
    protected final DataExplorer application;
    protected iChargerSerialPort serialPort;
    protected final Channels channels;
    protected GathererThread gathererThread;
    protected String[] BATTERIE_TYPES;
    protected static double energySum = 0.0;

    public int getBatTypeIndex(String batTypeName) {
        for (int i = 0; i < this.BATTERIE_TYPES.length; ++i) {
            if (!this.BATTERIE_TYPES[i].toLowerCase().equals(batTypeName.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public iCharger(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.junsi.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new iChargerSerialPort(this, this.application);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT2606"), Messages.getString((String)"GDE_MSGT2605"));
        }
    }

    public iCharger(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.junsi.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        if (deviceConfig.getSerialPortType() != null) {
            this.serialPort = new iChargerSerialPort(this, this.application);
        }
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT2606"), Messages.getString((String)"GDE_MSGT2605"));
        }
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 158;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    protected void setDataLineStartAndLength(byte[] dataBuffer, int[] refStartLength) {
        int crlfPos;
        int startPos;
        byte leader = this.getDataBlockLeader().getBytes()[0];
        byte delimiter = this.getDataBlockSeparator().value().getBytes()[0];
        byte[] lineSep = this.getDataBlockEnding();
        for (startPos = refStartLength[0] + refStartLength[1]; startPos < dataBuffer.length && (dataBuffer[startPos] != leader || dataBuffer[startPos + 2] != delimiter && dataBuffer[startPos + 3] != delimiter); ++startPos) {
        }
        for (crlfPos = refStartLength[0] = startPos; crlfPos < dataBuffer.length && dataBuffer[crlfPos] != lineSep[0] && dataBuffer[crlfPos + 1] != lineSep[1]; ++crlfPos) {
        }
        refStartLength[1] = crlfPos - startPos;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double reduction = record.getReduction();
                double factor = record.getFactor();
                if (record.getOrdinal() >= 9 && record.getUnit().equals("V")) {
                    try {
                        dataTableRow[index + 1] = String.format("%.3f", ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                    }
                    catch (Exception e) {
                        dataTableRow[index + 1] = String.format("%.3f", ((double)record.realGet(record.realSize() - 1).intValue() / 1000.0 - reduction) * factor);
                    }
                } else {
                    try {
                        dataTableRow[index + 1] = record.getDecimalFormat().format(((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                    }
                    catch (Exception e) {
                        dataTableRow[index + 1] = record.getDecimalFormat().format(((double)record.realGet(record.realSize() - 1).intValue() / 1000.0 - reduction) * factor);
                    }
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value * factor + offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value / factor - offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        int displayableCounter = 0;
        recordSet.setAllDisplayable();
        for (i = 7; i < recordSet.size(); ++i) {
            record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, record.getName() + " setDisplayable=" + record.hasReasonableData());
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            try {
                int displayableCounter = 0;
                for (int i = 0; i < recordSet.size(); ++i) {
                    Record record = recordSet.get(i);
                    if (!record.isActive() || !record.hasReasonableData()) continue;
                    ++displayableCounter;
                }
                log.log(Level.FINE, "displayableCounter = " + displayableCounter);
                recordSet.setConfiguredDisplayable(displayableCounter);
                if (recordSet.getName().equals(this.channels.getActiveChannel().getActiveRecordSet().getName())) {
                    this.application.updateGraphicsWindow();
                }
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public iChargerSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR};
    }

    public void open_closeCommPort() {
        block12: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block12;
                        this.gathererThread = new GathererThread(this.application, this, this.serialPort, activChannel.getNumber());
                        try {
                            if (this.serialPort.isConnected()) {
                                this.gathererThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.gathererThread != null) {
                        this.gathererThread.stopDataGatheringThread(false, null);
                    }
                    this.serialPort.close();
                }
            }
        }
    }

    public int[] getCellVoltageOrdinals() {
        return new int[]{1, 3};
    }

    public String getProcessName(byte[] buffer) throws Exception {
        return this.getRecordSetStateNameReplacement(Integer.parseInt(new String(buffer).split(this.getDataBlockSeparator().value())[1]));
    }

    public abstract int getNumberOfLithiumCells();

    public int getCurrentSmoothIndex() {
        return 2;
    }
}

