/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.ChannelPropertyTypes;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapterDialog;
import gde.device.graupner.HoTTAdapterSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

public class HoTTAdapterLiveGatherer
extends Thread {
    static final Logger log = Logger.getLogger(HoTTAdapterLiveGatherer.class.getName());
    final DataExplorer application;
    final HoTTAdapterSerialPort serialPort;
    final HoTTAdapter device;
    final HoTTAdapterDialog dialog;
    final Channels channels;
    Channel channel;
    int timeStep_ms = 1000;
    boolean isPortOpenedByLiveGatherer = false;
    boolean isSwitchedRecordSet = false;
    boolean isGatheredRecordSetVisible = true;
    byte sensorType = (byte)-128;
    byte[] dataBuffer;
    final HashMap<String, Double> calcValues = new HashMap();
    protected static final Map<String, RecordSet> recordSets = new HashMap<String, RecordSet>();
    protected static final boolean[] isSensorType = new boolean[]{false, false, false, false, false, false};

    public HoTTAdapterLiveGatherer(DataExplorer currentApplication, HoTTAdapter useDevice, HoTTAdapterSerialPort useSerialPort, HoTTAdapterDialog useDialog) throws Exception {
        super("liveDataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.dialog = useDialog;
        this.channels = Channels.getInstance();
    }

    @Override
    public void run() {
        boolean isChannelsActivated;
        EnumSet<HoTTAdapter.Sensor> detectedSensors;
        int[] pointsChannels;
        int[] pointsMotorDriver;
        int[] pointsElectric;
        int[] pointsGeneral;
        int[] pointsGPS;
        int[] pointsVario;
        int[] pointsReceiver;
        RecordSet recordSetChannels;
        RecordSet recordSetMotorDriver;
        RecordSet recordSetElectric;
        RecordSet recordSetGeneral;
        RecordSet recordSetGPS;
        RecordSet recordSetVario;
        RecordSet recordSetReceiver;
        int recordSetNumber;
        block111: {
            recordSetNumber = ((Channel)this.channels.get((Object)1)).maxSize() + 1;
            recordSetReceiver = null;
            recordSetVario = null;
            recordSetGPS = null;
            recordSetGeneral = null;
            recordSetElectric = null;
            recordSetMotorDriver = null;
            recordSetChannels = null;
            pointsReceiver = null;
            pointsVario = null;
            pointsGPS = null;
            pointsGeneral = null;
            pointsElectric = null;
            pointsMotorDriver = null;
            pointsChannels = null;
            recordSets.clear();
            StringBuilder sb = new StringBuilder();
            detectedSensors = HoTTAdapter.Sensor.getSetFromSignature("Receiver");
            isChannelsActivated = this.serialPort.getProtocolType().equals("115200") && Boolean.parseBoolean(this.device.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue());
            try {
                int i;
                if (!this.serialPort.isConnected()) {
                    this.serialPort.open();
                    this.isPortOpenedByLiveGatherer = true;
                    this.serialPort.cleanInputStream();
                }
                this.serialPort.isInterruptedByUser = false;
                long startTime = new Date().getTime();
                for (i = 0; i < isSensorType.length; ++i) {
                    HoTTAdapterLiveGatherer.isSensorType[i] = false;
                }
                WaitTimer.delay((long)1000L);
                if (this.serialPort.cleanInputStream() > 2) {
                    HoTTAdapter.IS_SLAVE_MODE = true;
                    log.log(Level.WARNING, "HoTTAdapter.IS_SLAVE_MODE = " + HoTTAdapter.IS_SLAVE_MODE);
                    break block111;
                }
                HoTTAdapter.IS_SLAVE_MODE = false;
                log.log(Level.FINE, "HoTTAdapter.IS_SLAVE_MODE = " + HoTTAdapter.IS_SLAVE_MODE);
                for (i = 0; !(i >= 10 || isSensorType[0] || isSensorType[1] || isSensorType[2] || isSensorType[3] || isSensorType[4] || isSensorType[5]); ++i) {
                    try {
                        this.detectSensorType();
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                try {
                    this.detectSensorType();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
                boolean[] tmpSensorType = (boolean[])isSensorType.clone();
                for (int i2 = 0; i2 < isSensorType.length; ++i2) {
                    if (sb.length() == 0 && tmpSensorType[i2]) {
                        sb.append("Receiver");
                        tmpSensorType[i2] = false;
                        continue;
                    }
                    if (!tmpSensorType[i2]) continue;
                    sb.append(", ").append(tmpSensorType[0] ? "Receiver" : (tmpSensorType[1] ? "VARIO" : (tmpSensorType[2] ? "GPS" : (tmpSensorType[3] ? "GAM" : (tmpSensorType[4] ? "EAM" : (tmpSensorType[5] ? "ESC" : ""))))));
                    tmpSensorType[i2] = false;
                }
                if (isChannelsActivated) {
                    sb.append(", ").append((Object)HoTTAdapter.Sensor.CHANNEL);
                }
                detectedSensors = HoTTAdapter.Sensor.getSetFromSignature(sb.toString().replace(" ", ""));
                if (log.isLoggable(Level.TIME)) {
                    log.log(Level.TIME, sb.toString() + ", detecting sensor type takes " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - startTime)));
                }
                this.application.setStatusMessage("[" + sb.toString() + "]");
                if (!(isSensorType[1] || isSensorType[2] || isSensorType[3] || isSensorType[4] || isSensorType[5])) {
                    this.serialPort.setSensorType(this.serialPort.protocolType.ordinal() < 2 ? (byte)-128 : 52);
                    if (!isSensorType[0]) {
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGW2400"));
                    }
                }
            }
            catch (SerialPortException e) {
                this.serialPort.close();
                this.dialog.resetButtons();
                this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                return;
            }
            catch (ApplicationConfigurationException e) {
                this.serialPort.close();
                this.dialog.resetButtons();
                this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        HoTTAdapterLiveGatherer.this.application.getDeviceSelectionDialog().open();
                    }
                });
                return;
            }
            catch (Throwable t) {
                this.serialPort.close();
                log.log(Level.SEVERE, t.getMessage(), t);
                this.dialog.resetButtons();
                this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{t.getClass().getSimpleName() + " : " + t.getMessage()}));
                return;
            }
        }
        this.channel = this.application.getActiveChannel();
        String recordSetNameExtend = " [live]";
        String recordSetKey = this.channel.getNextRecordSetNumber() + this.device.getRecordSetStemNameReplacement();
        this.channel = (Channel)this.channels.get((Object)1);
        recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.RECEIVER.value() + recordSetNameExtend;
        recordSetReceiver = RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)1, (boolean)true, (boolean)true, (boolean)true);
        this.channel.put((Object)recordSetKey, (Object)recordSetReceiver);
        recordSets.put(HoTTAdapter.Sensor.RECEIVER.value(), recordSetReceiver);
        this.channel.applyTemplate(recordSetKey, true);
        pointsReceiver = new int[recordSetReceiver.size()];
        if (detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) {
            this.channel = (Channel)this.channels.get((Object)2);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.VARIO.value() + recordSetNameExtend;
            recordSetVario = RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)2, (boolean)true, (boolean)true, (boolean)true);
            this.channel.put((Object)recordSetKey, (Object)recordSetVario);
            recordSets.put(HoTTAdapter.Sensor.VARIO.value(), recordSetVario);
            this.channel.applyTemplate(recordSetKey, true);
            pointsVario = new int[recordSetVario.size()];
        }
        if (detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) {
            this.channel = (Channel)this.channels.get((Object)3);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.GPS.value() + recordSetNameExtend;
            recordSetGPS = RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)3, (boolean)true, (boolean)true, (boolean)true);
            this.channel.put((Object)recordSetKey, (Object)recordSetGPS);
            recordSets.put(HoTTAdapter.Sensor.GPS.value(), recordSetGPS);
            this.channel.applyTemplate(recordSetKey, true);
            pointsGPS = new int[recordSetGPS.size()];
        }
        if (detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) {
            this.channel = (Channel)this.channels.get((Object)4);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.GAM.value() + recordSetNameExtend;
            recordSetGeneral = RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)4, (boolean)true, (boolean)true, (boolean)true);
            this.channel.put((Object)recordSetKey, (Object)recordSetGeneral);
            recordSets.put(HoTTAdapter.Sensor.GAM.value(), recordSetGeneral);
            this.channel.applyTemplate(recordSetKey, true);
            pointsGeneral = new int[recordSetGeneral.size()];
        }
        if (detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) {
            this.channel = (Channel)this.channels.get((Object)5);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.EAM.value() + recordSetNameExtend;
            recordSetElectric = RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)5, (boolean)true, (boolean)true, (boolean)true);
            this.channel.put((Object)recordSetKey, (Object)recordSetElectric);
            recordSets.put(HoTTAdapter.Sensor.EAM.value(), recordSetElectric);
            this.channel.applyTemplate(recordSetKey, true);
            pointsElectric = new int[recordSetElectric.size()];
        }
        if (isChannelsActivated) {
            this.channel = (Channel)this.channels.get((Object)6);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.CHANNEL.value() + recordSetNameExtend;
            recordSetChannels = RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)6, (boolean)true, (boolean)true, (boolean)true);
            this.channel.put((Object)recordSetKey, (Object)recordSetChannels);
            recordSets.put(HoTTAdapter.Sensor.CHANNEL.value(), recordSetChannels);
            this.channel.applyTemplate(recordSetKey, true);
            pointsChannels = new int[recordSetChannels.size()];
            detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
        }
        if (detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) {
            this.channel = (Channel)this.channels.get((Object)7);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.ESC.value() + recordSetNameExtend;
            recordSetMotorDriver = RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)7, (boolean)true, (boolean)true, (boolean)true);
            this.channel.put((Object)recordSetKey, (Object)recordSetMotorDriver);
            recordSets.put(HoTTAdapter.Sensor.ESC.value(), recordSetMotorDriver);
            this.channel.applyTemplate(recordSetKey, true);
            pointsMotorDriver = new int[recordSetMotorDriver.size()];
        }
        this.application.getMenuToolBar().updateChannelSelector();
        this.application.getMenuToolBar().updateRecordSetSelectCombo();
        int activeChannelNumber = this.channels.getActiveChannelNumber();
        if (isSensorType[0] && activeChannelNumber == 1) {
            this.dialog.selectTab(1);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.RECEIVER.value() + recordSetNameExtend;
        } else if (isSensorType[HoTTAdapter.Sensor.VARIO.ordinal()] && activeChannelNumber == 2) {
            this.dialog.selectTab(2);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.VARIO.value() + recordSetNameExtend;
        } else if (isSensorType[HoTTAdapter.Sensor.GPS.ordinal()] && activeChannelNumber == 3) {
            this.dialog.selectTab(3);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.GPS.value() + recordSetNameExtend;
        } else if (isSensorType[HoTTAdapter.Sensor.GAM.ordinal()] && activeChannelNumber == 4) {
            this.dialog.selectTab(4);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.GAM.value() + recordSetNameExtend;
        } else if (isSensorType[HoTTAdapter.Sensor.EAM.ordinal()] && activeChannelNumber == 5) {
            this.dialog.selectTab(5);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.EAM.value() + recordSetNameExtend;
        } else if (isChannelsActivated && activeChannelNumber == 6) {
            this.dialog.selectTab(6);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.CHANNEL.value() + recordSetNameExtend;
        } else if (isSensorType[HoTTAdapter.Sensor.ESC.ordinal()] && activeChannelNumber == 7) {
            this.dialog.selectTab(7);
            recordSetKey = recordSetNumber + ") " + HoTTAdapter.Sensor.ESC.value() + recordSetNameExtend;
        }
        this.channel.switchRecordSet(recordSetKey);
        this.channels.switchChannel(this.channel.getName());
        this.application.setStatusMessage(String.format("Sensor: %s", detectedSensors.toString()));
        recordSetReceiver.setRecordSetDescription(recordSetReceiver.getRecordSetDescription() + String.format(" - %s Baud", this.serialPort.getProtocolType()) + String.format(" - Sensor: %s", detectedSensors.toString()));
        boolean isGPSdetected = false;
        Vector<Integer> queryRing = new Vector<Integer>();
        for (int i = 1; i < isSensorType.length; ++i) {
            if (!isSensorType[i]) continue;
            queryRing.add(i);
        }
        long measurementCount = 0L;
        int lastNumberDisplayableRecords = 0;
        long startTime = System.nanoTime() / 1000000L;
        while (!this.serialPort.isInterruptedByUser) {
            block112: {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "====> entry");
                }
                try {
                    RecordSet activeRecordSet;
                    switch (this.serialPort.protocolType) {
                        case TYPE_19200_V3: 
                        case TYPE_19200_V4: {
                            byte[] data;
                            if (HoTTAdapter.IS_SLAVE_MODE) {
                                this.serialPort.setSensorType((byte)-128);
                                this.dataBuffer = this.serialPort.getData(false);
                                while (!this.checkContainsDataBegin(this.dataBuffer)) {
                                    this.dataBuffer = this.serialPort.getData(false);
                                }
                                WaitTimer.delay((long)30L);
                                if (this.checkSignature(this.dataBuffer, (byte)-128)) {
                                    recordSetReceiver.addPoints(this.device.convertDataBytes(pointsReceiver, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    this.switchRecordSetDisplay(HoTTAdapter.Sensor.RECEIVER, recordSetNumber, recordSetNameExtend);
                                    break;
                                }
                                if (this.checkSignature(this.dataBuffer, (byte)-114)) {
                                    this.serialPort.setSensorType((byte)-114);
                                    recordSetElectric.addPoints(this.device.convertDataBytes(pointsElectric, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    this.switchRecordSetDisplay(HoTTAdapter.Sensor.EAM, recordSetNumber, recordSetNameExtend);
                                    break;
                                }
                                if (this.checkSignature(this.dataBuffer, (byte)-115)) {
                                    this.serialPort.setSensorType((byte)-115);
                                    recordSetGeneral.addPoints(this.device.convertDataBytes(pointsGeneral, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    this.switchRecordSetDisplay(HoTTAdapter.Sensor.GAM, recordSetNumber, recordSetNameExtend);
                                    break;
                                }
                                if (this.checkSignature(this.dataBuffer, (byte)-116)) {
                                    this.serialPort.setSensorType((byte)-116);
                                    recordSetMotorDriver.addPoints(this.device.convertDataBytes(pointsMotorDriver, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    this.switchRecordSetDisplay(HoTTAdapter.Sensor.ESC, recordSetNumber, recordSetNameExtend);
                                    break;
                                }
                                if (this.checkSignature(this.dataBuffer, (byte)-118)) {
                                    this.serialPort.setSensorType((byte)-118);
                                    recordSetGPS.addPoints(this.device.convertDataBytes(pointsGPS, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    this.switchRecordSetDisplay(HoTTAdapter.Sensor.GPS, recordSetNumber, recordSetNameExtend);
                                    break;
                                }
                                if (!this.checkSignature(this.dataBuffer, (byte)-119)) break;
                                this.serialPort.setSensorType((byte)-119);
                                recordSetVario.addPoints(this.device.convertDataBytes(pointsVario, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                this.switchRecordSetDisplay(HoTTAdapter.Sensor.VARIO, recordSetNumber, recordSetNameExtend);
                                break;
                            }
                            if (!(!isSensorType[0] || isSensorType[1] || isSensorType[2] || isSensorType[3] || isSensorType[4] || isSensorType[5])) {
                                try {
                                    this.serialPort.setSensorType((byte)-128);
                                    this.serialPort.getData(true);
                                    WaitTimer.delay((long)30L);
                                    recordSetReceiver.addPoints(this.device.convertDataBytes(pointsReceiver, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 4) {
                                try {
                                    this.serialPort.setSensorType((byte)-114);
                                    this.serialPort.getData(true);
                                    WaitTimer.delay((long)30L);
                                    data = this.serialPort.getData(true);
                                    recordSetElectric.addPoints(this.device.convertDataBytes(pointsElectric, data), (double)(System.nanoTime() / 1000000L - startTime));
                                    data[1] = -128;
                                    recordSetReceiver.addPoints(this.device.convertDataBytes(pointsReceiver, data), (double)(System.nanoTime() / 1000000L - startTime));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 3) {
                                try {
                                    this.serialPort.setSensorType((byte)-115);
                                    this.serialPort.getData(true);
                                    WaitTimer.delay((long)30L);
                                    data = this.serialPort.getData(true);
                                    recordSetGeneral.addPoints(this.device.convertDataBytes(pointsGeneral, data), (double)(System.nanoTime() / 1000000L - startTime));
                                    data[1] = -128;
                                    recordSetReceiver.addPoints(this.device.convertDataBytes(pointsReceiver, data), (double)(System.nanoTime() / 1000000L - startTime));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 5) {
                                try {
                                    this.serialPort.setSensorType((byte)-116);
                                    this.serialPort.getData(true);
                                    WaitTimer.delay((long)30L);
                                    data = this.serialPort.getData(true);
                                    recordSetMotorDriver.addPoints(this.device.convertDataBytes(pointsMotorDriver, data), (double)(System.nanoTime() / 1000000L - startTime));
                                    data[1] = -128;
                                    recordSetReceiver.addPoints(this.device.convertDataBytes(pointsReceiver, data), (double)(System.nanoTime() / 1000000L - startTime));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 2) {
                                try {
                                    this.serialPort.setSensorType((byte)-118);
                                    this.serialPort.getData(true);
                                    WaitTimer.delay((long)30L);
                                    data = this.serialPort.getData(true);
                                    recordSetGPS.addPoints(this.device.convertDataBytes(pointsGPS, data), (double)(System.nanoTime() / 1000000L - startTime));
                                    data[1] = -128;
                                    recordSetReceiver.addPoints(this.device.convertDataBytes(pointsReceiver, data), (double)(System.nanoTime() / 1000000L - startTime));
                                    if (!isGPSdetected) {
                                        HoTTAdapter.updateGpsTypeDependent(pointsGPS[23] / 1000, this.device, recordSetGPS, -1L);
                                        isGPSdetected = true;
                                    }
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() <= 0 || (Integer)queryRing.firstElement() != 1) break;
                            try {
                                this.serialPort.setSensorType((byte)-119);
                                this.serialPort.getData(true);
                                WaitTimer.delay((long)30L);
                                data = this.serialPort.getData(true);
                                recordSetVario.addPoints(this.device.convertDataBytes(pointsVario, data), (double)(System.nanoTime() / 1000000L - startTime));
                                data[1] = -128;
                                recordSetReceiver.addPoints(this.device.convertDataBytes(pointsReceiver, data), (double)(System.nanoTime() / 1000000L - startTime));
                            }
                            catch (TimeOutException e) {
                                this.serialPort.addTimeoutError();
                            }
                            break;
                        }
                        case TYPE_115200: {
                            if (!HoTTAdapter.IS_SLAVE_MODE || isSensorType[0]) {
                                try {
                                    this.serialPort.setSensorType((byte)52);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.serialPort.getDataDBM(true, this.dataBuffer);
                                    recordSetReceiver.addPoints(this.device.convertDataBytes(pointsReceiver, this.dataBuffer), (double)(System.nanoTime() / 1000000L - startTime));
                                    Thread.sleep(30L);
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                                if (isChannelsActivated) {
                                    try {
                                        this.serialPort.setSensorType((byte)64);
                                        for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                            Thread.sleep(30L);
                                        }
                                        recordSetChannels.addPoints(this.device.convertDataBytes(pointsChannels, this.dataBuffer), (double)(System.nanoTime() / 1000000L - startTime));
                                        Thread.sleep(30L);
                                    }
                                    catch (TimeOutException e) {
                                        this.serialPort.addTimeoutError();
                                    }
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 4) {
                                try {
                                    this.serialPort.setSensorType((byte)54);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.serialPort.getDataDBM(false, this.dataBuffer);
                                    recordSetElectric.addPoints(this.device.convertDataBytes(pointsElectric, this.dataBuffer), (double)(System.nanoTime() / 1000000L - startTime));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 3) {
                                try {
                                    this.serialPort.setSensorType((byte)53);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.serialPort.getDataDBM(false, this.dataBuffer);
                                    recordSetGeneral.addPoints(this.device.convertDataBytes(pointsGeneral, this.dataBuffer), (double)(System.nanoTime() / 1000000L - startTime));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 5) {
                                try {
                                    this.serialPort.setSensorType((byte)57);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.serialPort.getDataDBM(false, this.dataBuffer);
                                    recordSetMotorDriver.addPoints(this.device.convertDataBytes(pointsMotorDriver, this.dataBuffer), (double)(System.nanoTime() / 1000000L - startTime));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 2) {
                                try {
                                    this.serialPort.setSensorType((byte)56);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.serialPort.getDataDBM(false, this.dataBuffer);
                                    recordSetGPS.addPoints(this.device.convertDataBytes(pointsGPS, this.dataBuffer), (double)(System.nanoTime() / 1000000L - startTime));
                                    if (!isGPSdetected) {
                                        HoTTAdapter.updateGpsTypeDependent(pointsGPS[23] / 1000, this.device, recordSetGPS, -1L);
                                        isGPSdetected = true;
                                    }
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() <= 0 || (Integer)queryRing.firstElement() != 1) break;
                            try {
                                this.serialPort.setSensorType((byte)55);
                                for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                    Thread.sleep(30L);
                                }
                                this.serialPort.getDataDBM(false, this.dataBuffer);
                                recordSetVario.addPoints(this.device.convertDataBytes(pointsVario, this.dataBuffer), (double)(System.nanoTime() / 1000000L - startTime));
                                break;
                            }
                            catch (TimeOutException e) {
                                this.serialPort.addTimeoutError();
                            }
                        }
                    }
                    if (queryRing.size() > 1) {
                        queryRing.add((Integer)queryRing.remove(0));
                    }
                    if (++measurementCount % 5L == 0L) {
                        for (RecordSet recordSet : recordSets.values()) {
                            this.device.updateVisibilityStatus(recordSet, true);
                        }
                    }
                    if ((activeRecordSet = this.application.getActiveRecordSet()) != null && activeRecordSet.size() > 0 && activeRecordSet.isChildOfActiveChannel() && activeRecordSet.equals((Object)activeRecordSet)) {
                        this.application.updateAllTabs(false, lastNumberDisplayableRecords != activeRecordSet.getConfiguredDisplayable());
                        lastNumberDisplayableRecords = activeRecordSet.getConfiguredDisplayable();
                    }
                    if (this.serialPort.getTimeoutErrors() <= 2 || this.serialPort.getTimeoutErrors() % 10 != 0) break block112;
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGW0045", (Object[])new Object[]{"TimeOutException", this.serialPort.getTimeoutErrors() + "; xferErrors = " + this.serialPort.getXferErrors()}), 3);
                }
                catch (DataInconsitsentException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    Iterator<RecordSet> message = Messages.getString((String)"GDE_MSGE0028", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()});
                    for (RecordSet recordSet : recordSets.values()) {
                        this.cleanup(recordSet.getName(), (String)((Object)message));
                    }
                }
                catch (TimeOutException e) {
                    log.log(Level.WARNING, e.getMessage());
                    this.serialPort.addTimeoutError();
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGW0045", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), this.serialPort.getTimeoutErrors() + "; xferErrors = " + this.serialPort.getXferErrors()}), 3);
                    WaitTimer.delay((long)30L);
                }
                catch (SerialPortException | IOException e) {
                    log.log(Level.WARNING, e.getMessage());
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    for (RecordSet recordSet : recordSets.values()) {
                        this.finalizeRecordSet(recordSet);
                    }
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    this.application.openMessageDialogAsync(e.getClass().getSimpleName() + " - " + e.getMessage());
                    for (RecordSet recordSet : recordSets.values()) {
                        this.finalizeRecordSet(recordSet);
                    }
                }
            }
            WaitTimer.delay((long)30L);
        }
        for (RecordSet recordSet : recordSets.values()) {
            this.finalizeRecordSet(recordSet);
        }
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                String toolTipText = HoTTAdapter.getImportToolTip();
                HoTTAdapterLiveGatherer.this.device.configureSerialPortMenu(2, toolTipText, toolTipText);
            }
        });
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "exit");
        }
    }

    public void switchRecordSetDisplay(HoTTAdapter.Sensor sensor, int recordSetNumber, String recordSetNameExtend) {
        if (this.channels.getActiveChannelNumber() != sensor.ordinal() + 1) {
            this.dialog.selectTab(sensor.ordinal() + 1);
            this.channel.switchRecordSet(recordSetNumber + ") " + sensor.value() + recordSetNameExtend);
        }
    }

    public void finalizeRecordSet(RecordSet recordSet) {
        this.serialPort.isInterruptedByUser = true;
        this.serialPort.close();
        this.device.updateVisibilityStatus(recordSet, false);
        this.device.makeInActiveDisplayable(recordSet);
        this.application.updateStatisticsData();
        this.application.updateDataTable(recordSet.getName(), false);
        this.device.getDialog().resetButtons();
    }

    void cleanup(String recordSetKey, String message) {
        this.serialPort.isInterruptedByUser = true;
        this.serialPort.close();
        ((RecordSet)this.channel.get((Object)recordSetKey)).clear();
        this.channel.switchRecordSet(recordSetKey);
        this.channel.remove(recordSetKey);
        this.application.getMenuToolBar().updateRecordSetSelectCombo();
        this.application.updateStatisticsData();
        this.application.updateDataTable(recordSetKey, true);
        this.device.getDialog().resetButtons();
        if (message != null && message.length() > 5) {
            this.application.openMessageDialog(this.dialog.getDialogShell(), message);
        }
    }

    void detectSensorType() throws Exception {
        switch (this.serialPort.protocolType) {
            case TYPE_19200_V3: {
                if (this.serialPort.isInterruptedByUser) break;
                if (!isSensorType[1]) {
                    try {
                        log.log(Level.FINE, "------------ Vario");
                        this.serialPort.setSensorType((byte)-119);
                        this.serialPort.getData(false);
                        Thread.sleep(30L);
                        this.dataBuffer = this.serialPort.getData(true);
                        HoTTAdapterLiveGatherer.isSensorType[1] = DataParser.parse2Short((byte[])this.dataBuffer, (int)16) != 0 || this.dataBuffer[22] != 0;
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!isSensorType[2]) {
                    try {
                        log.log(Level.FINE, "------------ GPS");
                        this.serialPort.setSensorType((byte)-118);
                        this.serialPort.getData(false);
                        Thread.sleep(30L);
                        this.dataBuffer = this.serialPort.getData(true);
                        HoTTAdapterLiveGatherer.isSensorType[2] = this.dataBuffer[37] == 1 || this.dataBuffer[20] != 0 && this.dataBuffer[21] != 0 && this.dataBuffer[25] != 0 && this.dataBuffer[26] != 0;
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!isSensorType[3]) {
                    try {
                        log.log(Level.FINE, "------------ General");
                        this.serialPort.setSensorType((byte)-115);
                        this.serialPort.getData(false);
                        Thread.sleep(30L);
                        this.dataBuffer = this.serialPort.getData(true);
                        HoTTAdapterLiveGatherer.isSensorType[3] = DataParser.parse2Short((byte[])this.dataBuffer, (int)40) != 0;
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!isSensorType[4]) {
                    try {
                        log.log(Level.FINE, "------------ Electric");
                        this.serialPort.setSensorType((byte)-114);
                        this.serialPort.getData(false);
                        Thread.sleep(30L);
                        this.dataBuffer = this.serialPort.getData(true);
                        HoTTAdapterLiveGatherer.isSensorType[4] = DataParser.parse2Short((byte[])this.dataBuffer, (int)40) != 0;
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (isSensorType[1] || isSensorType[2] || isSensorType[3] || isSensorType[4]) {
                    HoTTAdapterLiveGatherer.isSensorType[0] = true;
                }
                if (isSensorType[0]) break;
                try {
                    log.log(Level.FINE, "------------ Receiver");
                    this.serialPort.setSensorType((byte)-128);
                    this.serialPort.getData(false);
                    Thread.sleep(30L);
                    this.dataBuffer = this.serialPort.getData(true);
                    HoTTAdapterLiveGatherer.isSensorType[0] = this.dataBuffer[9] != 0 && this.dataBuffer[6] != 0;
                    Thread.sleep(30L);
                }
                catch (Exception exception) {}
                break;
            }
            case TYPE_19200_V4: {
                if (this.serialPort.isInterruptedByUser) break;
                if (!isSensorType[1]) {
                    try {
                        log.log(Level.FINE, "------------ Vario");
                        this.serialPort.setSensorType((byte)-119);
                        this.serialPort.getData(false);
                        Thread.sleep(90L);
                        this.serialPort.getData(true);
                        Thread.sleep(90L);
                        this.serialPort.getData(true);
                        Thread.sleep(90L);
                        HoTTAdapterLiveGatherer.isSensorType[1] = this.serialPort.getData(true)[15] == -112;
                        Thread.sleep(90L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!isSensorType[2]) {
                    try {
                        log.log(Level.FINE, "------------ GPS");
                        this.serialPort.setSensorType((byte)-118);
                        this.serialPort.getData(false);
                        Thread.sleep(30L);
                        this.serialPort.getData(true);
                        Thread.sleep(30L);
                        this.serialPort.getData(true);
                        Thread.sleep(30L);
                        HoTTAdapterLiveGatherer.isSensorType[2] = this.serialPort.getData(true)[15] == -96;
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!isSensorType[3]) {
                    try {
                        log.log(Level.FINE, "------------ General");
                        this.serialPort.setSensorType((byte)-115);
                        this.serialPort.getData(false);
                        Thread.sleep(30L);
                        this.serialPort.getData(true);
                        Thread.sleep(30L);
                        this.serialPort.getData(true);
                        Thread.sleep(30L);
                        HoTTAdapterLiveGatherer.isSensorType[3] = this.serialPort.getData(true)[15] == -48;
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!isSensorType[4]) {
                    try {
                        log.log(Level.FINE, "------------ Electric");
                        this.serialPort.setSensorType((byte)-114);
                        this.serialPort.getData(false);
                        Thread.sleep(30L);
                        this.serialPort.getData(true);
                        Thread.sleep(30L);
                        this.serialPort.getData(true);
                        Thread.sleep(30L);
                        HoTTAdapterLiveGatherer.isSensorType[4] = this.serialPort.getData(true)[15] == -32;
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!isSensorType[5]) {
                    try {
                        log.log(Level.FINE, "------------ SpeedControler");
                        this.serialPort.setSensorType((byte)-116);
                        this.serialPort.getData(false);
                        Thread.sleep(90L);
                        this.serialPort.getData(true);
                        Thread.sleep(90L);
                        this.serialPort.getData(true);
                        Thread.sleep(90L);
                        HoTTAdapterLiveGatherer.isSensorType[5] = this.serialPort.getData(true)[15] == -64;
                        Thread.sleep(150L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (isSensorType[1] || isSensorType[2] || isSensorType[3] || isSensorType[4] || isSensorType[5]) {
                    HoTTAdapterLiveGatherer.isSensorType[0] = true;
                }
                if (isSensorType[0]) break;
                try {
                    log.log(Level.FINE, "------------ Receiver");
                    this.serialPort.setSensorType((byte)-128);
                    this.serialPort.getData(false);
                    Thread.sleep(150L);
                    this.serialPort.getData(true);
                    Thread.sleep(150L);
                    this.serialPort.getData(true);
                    Thread.sleep(150L);
                    byte[] buffer = this.serialPort.getData(true);
                    HoTTAdapterLiveGatherer.isSensorType[0] = buffer[2] == 124 && buffer[15] == 125;
                    Thread.sleep(150L);
                }
                catch (Exception buffer) {}
                break;
            }
            case TYPE_115200: {
                if (this.serialPort.isInterruptedByUser) break;
                if (!isSensorType[0]) {
                    try {
                        log.log(Level.FINE, "------------ Receiver");
                        this.serialPort.setSensorType((byte)52);
                        for (int i = 0; i < 10; ++i) {
                            try {
                                this.dataBuffer = this.serialPort.getData();
                                if (this.serialPort.isCheckSumOK(4, this.dataBuffer)) break;
                                WaitTimer.delay((long)30L);
                                continue;
                            }
                            catch (Exception e) {
                                WaitTimer.delay((long)60L);
                            }
                        }
                        HoTTAdapterLiveGatherer.isSensorType[0] = this.dataBuffer[17] != 0 && this.dataBuffer[15] != 0;
                        WaitTimer.delay((long)30L);
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
                if (!isSensorType[5]) {
                    try {
                        log.log(Level.FINE, "------------ SpeedControler");
                        this.serialPort.setSensorType((byte)57);
                        for (int i = 0; i < 5 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                            Thread.sleep(30L);
                        }
                        HoTTAdapterLiveGatherer.isSensorType[5] = DataParser.parse2Short((byte[])this.dataBuffer, (int)22) != 0 || DataParser.parse2Short((byte[])this.dataBuffer, (int)10) != 0;
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                }
                if (!isSensorType[4]) {
                    try {
                        log.log(Level.FINE, "------------ Electric");
                        this.serialPort.setSensorType((byte)54);
                        for (int i = 0; i < 5 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                            Thread.sleep(30L);
                        }
                        HoTTAdapterLiveGatherer.isSensorType[4] = DataParser.parse2Short((byte[])this.dataBuffer, (int)50) != 0 || DataParser.parse2Short((byte[])this.dataBuffer, (int)42) != 0 || DataParser.parse2Short((byte[])this.dataBuffer, (int)44) != 0;
                        Thread.sleep(30L);
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
                if (!isSensorType[3]) {
                    try {
                        log.log(Level.FINE, "------------ General");
                        this.serialPort.setSensorType((byte)53);
                        for (int i = 0; i < 5 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                            Thread.sleep(30L);
                        }
                        HoTTAdapterLiveGatherer.isSensorType[3] = DataParser.parse2Short((byte[])this.dataBuffer, (int)36) != 0 || DataParser.parse2Short((byte[])this.dataBuffer, (int)26) != 0 || DataParser.parse2Short((byte[])this.dataBuffer, (int)28) != 0;
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                }
                if (!isSensorType[2]) {
                    try {
                        log.log(Level.FINE, "------------ GPS");
                        this.serialPort.setSensorType((byte)56);
                        for (int i = 0; i < 5 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                            Thread.sleep(30L);
                        }
                        HoTTAdapterLiveGatherer.isSensorType[2] = this.dataBuffer[31] != 0 || this.dataBuffer[16] != 0 && this.dataBuffer[17] != 0 && this.dataBuffer[20] != 0 && this.dataBuffer[21] != 0;
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                }
                if (!isSensorType[1]) {
                    try {
                        log.log(Level.FINE, "------------ Vario");
                        this.serialPort.setSensorType((byte)55);
                        for (int i = 0; i < 5 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                            Thread.sleep(30L);
                        }
                        HoTTAdapterLiveGatherer.isSensorType[1] = DataParser.parse2Short((byte[])this.dataBuffer, (int)10) != 0 || this.dataBuffer[16] != 0;
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                }
                if (isSensorType[1] || isSensorType[2] || isSensorType[3] || isSensorType[4] || isSensorType[5]) {
                    HoTTAdapterLiveGatherer.isSensorType[0] = true;
                }
                if (isSensorType[0]) break;
                try {
                    log.log(Level.FINE, "------------ Receiver");
                    this.serialPort.setSensorType((byte)52);
                    for (int i = 0; i < 5 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                        Thread.sleep(30L);
                    }
                    HoTTAdapterLiveGatherer.isSensorType[0] = this.dataBuffer[17] != 0 && this.dataBuffer[15] != 0;
                    Thread.sleep(30L);
                    break;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage());
                }
            }
        }
    }

    protected boolean checkSignature(byte[] dataBuffer0, byte[] dataBuffer1) {
        boolean isDataSignature = false;
        byte[] tmpBuffer = new byte[dataBuffer0.length * 2];
        System.arraycopy(dataBuffer0, 0, tmpBuffer, 0, dataBuffer0.length);
        System.arraycopy(dataBuffer1, 0, tmpBuffer, dataBuffer0.length, dataBuffer1.length);
        for (int i = 0; i < tmpBuffer.length; ++i) {
            if (tmpBuffer[i] != 124) continue;
            int endIndex = i + dataBuffer0.length - 4;
            isDataSignature = endIndex < tmpBuffer.length && tmpBuffer[endIndex] == 125;
            break;
        }
        return isDataSignature;
    }

    protected boolean checkSignature(byte[] _dataBuffer, byte checkSensorType) {
        boolean isDataSignature = false;
        for (int i = 1; i < _dataBuffer.length; ++i) {
            if (_dataBuffer[i] != 124) continue;
            isDataSignature = _dataBuffer[i - 1] == checkSensorType;
            break;
        }
        return isDataSignature;
    }

    protected boolean checkContainsDataBegin(byte[] _dataBuffer) {
        boolean isDataBegin = false;
        for (int i = 1; i < _dataBuffer.length; ++i) {
            if (_dataBuffer[i] != 124) continue;
            System.arraycopy(_dataBuffer, i - 1, _dataBuffer, 0, 2);
            isDataBegin = true;
            break;
        }
        return isDataBegin;
    }

    protected int setSwitchS() {
        int j = 1;
        for (int i = 0; i < 2; ++i) {
            int k = 1;
            while (j <= (i + 1) * 8) {
                if (HoTTAdapter.isSwitchS[j - 1] != ((this.dataBuffer[i + 161] & k) != 0)) {
                    HoTTAdapter.isSwitchS[j - 1] = (this.dataBuffer[i + 161] & k) != 0;
                    return j;
                }
                ++j;
                k *= 2;
            }
        }
        return 0;
    }

    protected int setSwitchG() {
        int j = 1;
        for (int i = 0; i < 1; ++i) {
            int k = 1;
            while (j <= (i + 1) * 8) {
                if (HoTTAdapter.isSwitchG[j - 1] != ((this.dataBuffer[i + 169] & k) != 0)) {
                    HoTTAdapter.isSwitchG[j - 1] = (this.dataBuffer[i + 169] & k) != 0;
                    return j;
                }
                ++j;
                k *= 2;
            }
        }
        return 0;
    }

    protected int setSwitchL() {
        int j = 1;
        for (int i = 0; i < 1; ++i) {
            int k = 1;
            while (j <= (i + 1) * 8) {
                if (HoTTAdapter.isSwitchL[j - 1] != ((this.dataBuffer[i + 173] & k) != 0)) {
                    HoTTAdapter.isSwitchL[j - 1] = (this.dataBuffer[i + 173] & k) != 0;
                    return j;
                }
                ++j;
                k *= 2;
            }
        }
        return 0;
    }
}

