/*
 * Decompiled with CFR 0.152.
 */
package gde.device.tttronix;

import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.util.logging.Logger;

public class QcCopterSerialPort
extends DeviceCommPort
implements IDeviceCommPort {
    static final String $CLASS_NAME = QcCopterSerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    boolean isInSync = false;
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte FF = 12;
    final int dataSize = this.deviceConfig.getDataBlockSize(InputTypes.SERIAL_IO);
    final int terminalDataSize = 345;
    int retrys = 0;

    public QcCopterSerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public synchronized byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[this.dataSize];
        try {
            data = this.read(data, 1000);
            if (this.containsSTX(data)) {
                while (data[0] != 2) {
                    this.isInSync = false;
                    for (int i = 1; i < data.length; ++i) {
                        if (data[i] != 2) continue;
                        System.arraycopy(data, i, data, 0, this.dataSize - i);
                        byte[] tmpdata = new byte[i];
                        tmpdata = this.read(tmpdata, 1000);
                        System.arraycopy(tmpdata, 0, data, this.dataSize - i, i);
                        this.isInSync = true;
                        log.logp(Level.FINE, $CLASS_NAME, "getData", "----> receive sync finished");
                        break;
                    }
                    if (!this.isInSync) continue;
                }
                if (log.isLoggable(Level.FINER)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
                    log.logp(Level.FINER, $CLASS_NAME, "getData", sb.toString());
                }
                if (data.length != this.dataSize || !this.isChecksumOK(data)) {
                    this.addXferError();
                    ++this.retrys;
                    log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> checksum error occured, number of errors = " + this.getXferErrors());
                    if (this.retrys > 3) {
                        this.retrys = 0;
                        throw new SerialPortException(Messages.getString((String)"GDE_MSGT1904"));
                    }
                    data = this.getData();
                }
            } else {
                throw new TimeOutException("received no flight simulation data!");
            }
            this.retrys = 0;
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        return data;
    }

    boolean containsSTX(byte[] data) {
        boolean isContained = false;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 2) continue;
            isContained = true;
            break;
        }
        return isContained;
    }

    boolean containsFF(byte[] data) {
        boolean isContained = false;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 12) continue;
            isContained = true;
            break;
        }
        return isContained;
    }

    public synchronized String getTerminalData() throws Exception {
        String $METHOD_NAME = "getTerminalData";
        int timeout_ms = 1000;
        byte[] data = null;
        try {
            this.wait4Bytes(timeout_ms);
            data = this.read(new byte[this.getAvailableBytes()], timeout_ms);
            if (log.isLoggable(Level.FINER)) {
                StringBuilder sb = new StringBuilder();
                for (byte b : data) {
                    sb.append(String.format("%c", Character.valueOf((char)b)));
                }
                log.logp(Level.FINER, $CLASS_NAME, "getTerminalData", sb.toString());
            }
        }
        catch (Exception e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "getTerminalData", e.getMessage(), e);
            throw e;
        }
        return data != null && data.length > 0 ? new String(data) : "";
    }

    private boolean isChecksumOK(byte[] buffer) {
        String $METHOD_NAME = "isChecksumOK";
        log.logp(Level.FINER, $CLASS_NAME, "isChecksumOK", Checksum.ADD((byte[])buffer, (int)1, (int)57) + "; " + ((buffer[58] & 0xFF) - 94 << 6 | (buffer[59] & 0xFF) - 94 & 0x3F));
        return Checksum.ADD((byte[])buffer, (int)1, (int)57) == ((buffer[58] & 0xFF) - 94 << 6 | (buffer[59] & 0xFF) - 94 & 0x3F);
    }
}

