/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public class VoltageBlock
extends DataBlock {
    private short voltsInTenthOfVolt;

    public VoltageBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("Voltage V");
        this.measurementUnits.add("V");
        this.measurementFactors.add(0.1);
    }

    private void decode(byte[] rawData) {
        this.voltsInTenthOfVolt = Shorts.fromBytes(rawData[6], rawData[7]);
        this.measurementValues.add(Integer.valueOf(this.getVoltsInTenthOfVolt()));
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof VoltageBlock) {
            VoltageBlock voltage = (VoltageBlock)block;
            return voltage.voltsInTenthOfVolt == this.getVoltsInTenthOfVolt();
        }
        return false;
    }

    public short getVoltsInTenthOfVolt() {
        return this.voltsInTenthOfVolt;
    }
}

