/*
 * Decompiled with CFR 0.152.
 */
package gde.device.weatronic;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.StatisticsType;
import gde.device.weatronic.WeatronicAdapter;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Logger;

public class LogReader {
    static final String $CLASS_NAME = LogReader.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    static final DataExplorer application = DataExplorer.getInstance();
    static final Channels channels = Channels.getInstance();
    static long startTimeStamp_ms;
    static int[] points;
    static Vector<Integer> pointsVector;
    static RecordSet recordSet;
    static WeatronicAdapter device;
    static byte[] buf_length;
    static byte[] buf_log_record_tmp;
    static byte[] buf_log_record;
    static byte[] buf_header;
    static byte[] buf_data;
    static long timeStep_ms;
    static Map<Integer, Measurement> measurements;
    static Vector<Integer> usedMeasurementIds;
    static Map<Integer, DataItem> receivedDataItems;
    static Vector<Integer> unknownIds;

    public LogReader(int activeChannelNumber) {
        channels.setActiveChannelNumber(activeChannelNumber);
    }

    public long getTimeOffset(int interval) {
        switch (interval) {
            case 0: {
                return 1L;
            }
            case 1: {
                return 2L;
            }
            case 2: {
                return 5L;
            }
            case 3: {
                return 10L;
            }
            case 4: {
                return 20L;
            }
            case 5: {
                return 50L;
            }
            case 6: {
                return 100L;
            }
            case 7: {
                return 200L;
            }
            case 8: {
                return 250L;
            }
            case 9: {
                return 500L;
            }
            case 10: {
                return 1000L;
            }
            case 11: {
                return 2000L;
            }
            case 12: {
                return 2500L;
            }
            case 13: {
                return 10000L;
            }
        }
        return 0L;
    }

    private boolean isChannelFilter(int measurementId) {
        return measurementId == 65535 || (measurementId & 0xFF00) == 4096 || (measurementId & 0xFF00) == 4352 || measurementId >= 4608 && measurementId <= 4702 && (measurements.get(measurementId) == null || measurements.get(measurementId).getName().contains("Function")) || measurements.get(measurementId).getName().contains("ControlID");
    }

    private boolean isStatusFilter(int measurementId) {
        return measurementId == 3082 || measurementId == 11273 || measurementId == 11398 || measurementId == 11404 || measurementId == 3098 || measurementId == 3114 || measurementId == 11289 || measurementId == 11305;
    }

    private boolean isUTCFilter(Measurement measurement) {
        return measurement == null || measurement.getName().contains("UTC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized RecordSet read(String filePath, Integer channelConfigNumber) throws Exception {
        block15: {
            String $METHOD_NAME = "read";
            long startTime = System.nanoTime() / 1000000L;
            File file = new File(filePath);
            FileInputStream file_input = new FileInputStream(file);
            DataInputStream data_in = new DataInputStream(file_input);
            long fileSize = file.length();
            long readByteCount = 0L;
            boolean isInitialSwitched = false;
            device = (WeatronicAdapter)DataExplorer.getInstance().getActiveDevice();
            LogReader logReader = new LogReader(channelConfigNumber);
            LogRecord logRecord = null;
            pointsVector.clear();
            usedMeasurementIds.clear();
            receivedDataItems.clear();
            unknownIds.clear();
            long timeStamp = 0L;
            startTimeStamp_ms = 0L;
            MenuToolBar menuToolBar = application.getMenuToolBar();
            GDE.getUiNotification().setProgress(0);
            try {
                Channel activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get((Object)channelConfigNumber);
                if (activeChannel == null) break block15;
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0594") + filePath);
                GDE.getUiNotification().setProgress(0);
                channels.setActiveChannelNumber(activeChannel.getNumber());
                int logRecordCount = 0;
                while (readByteCount < fileSize) {
                    buf_length = new byte[4];
                    int readSize = data_in.read(buf_length);
                    if (readSize == 4) {
                        int logRecordLength = DataParser.parse2Int((byte[])buf_length, (int)0);
                        if (logRecordLength > 4) {
                            if (log.isLoggable(Level.FINER)) {
                                log.log(Level.FINER, "logRecordLength = " + logRecordLength);
                            }
                            buf_log_record = new byte[logRecordLength];
                            System.arraycopy(buf_length, 0, buf_log_record, 0, 4);
                            readByteCount += 4L;
                            readByteCount += (long)data_in.read(buf_log_record, 4, logRecordLength - 4);
                            timeStamp = DataParser.parse2Long((byte[])buf_log_record, (int)4);
                            RecordType recordType = RecordType.values()[buf_log_record[12]];
                            if (startTimeStamp_ms == 0L && recordType == RecordType.DATA) {
                                startTimeStamp_ms = timeStamp;
                            }
                            try {
                                LogReader logReader2 = logReader;
                                Objects.requireNonNull(logReader2);
                                logRecord = logReader2.new LogRecord(buf_log_record, logRecord == null ? null : logRecord.getRecordHeader());
                            }
                            catch (DataInconsitsentException e) {
                                log.log(Level.SEVERE, e.getMessage());
                            }
                            GDE.getUiNotification().setProgress((int)(readByteCount * 100L / fileSize));
                            ++logRecordCount;
                            continue;
                        }
                        log.log(Level.WARNING, "logRecordLength = 0");
                        break;
                    }
                    log.log(Level.WARNING, "datain.read failed!");
                    break;
                }
                recordSet.setStartTimeStamp(startTimeStamp_ms);
                recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms));
                if (log.isLoggable(Level.FINEST)) {
                    System.out.println("logRecordCount = " + logRecordCount);
                }
                StringBuilder sb = new StringBuilder().append("unknown Ids = ");
                for (Integer unknownId : unknownIds) {
                    sb.append(String.format("0x%04x, ", unknownId));
                }
                log.log(Level.WARNING, sb.toString());
                log.logp(Level.TIME, $CLASS_NAME, "read", "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
                if (menuToolBar != null && recordSet != null) {
                    GDE.getUiNotification().setProgress(99);
                    String recordSetName = recordSet.getName();
                    activeChannel = application.getActiveChannel();
                    activeChannel.put((Object)recordSetName, (Object)recordSet);
                    activeChannel.applyTemplate(recordSetName, false);
                    if (!isInitialSwitched) {
                        channels.switchChannel(activeChannel.getName());
                        activeChannel.switchRecordSet(recordSet.getName());
                    } else {
                        device.makeInActiveDisplayable(recordSet);
                    }
                    device.updateVisibilityStatus(recordSet, true);
                    recordSet.descriptionAppendFilename(file.getName());
                    menuToolBar.updateChannelSelector();
                    menuToolBar.updateRecordSetSelectCombo();
                    GDE.getUiNotification().setProgress(100);
                }
            }
            finally {
                data_in.close();
                data_in = null;
            }
        }
        return recordSet;
    }

    static {
        pointsVector = new Vector();
        buf_length = new byte[4];
        measurements = new HashMap<Integer, Measurement>();
        usedMeasurementIds = new Vector();
        receivedDataItems = new HashMap<Integer, DataItem>();
        unknownIds = new Vector();
    }

    public class Measurement {
        public static final double DBL_EPSILON = 2.220446049250313E-16;
        String name;
        int id;
        DataType dataType;
        double factor;
        double offset;
        String unit;

        public Measurement(byte[] buffer) {
            this.name = new String(buffer, 0, 64).trim();
            this.id = DataParser.parse2UnsignedShort((byte[])buffer, (int)64);
            this.dataType = DataType.valueOf(buffer[66]);
            byte[] bytes = new byte[8];
            System.arraycopy(buffer, 67, bytes, 0, 8);
            this.offset = DataParser.byte2Double((byte[])bytes, (boolean)true)[0];
            System.arraycopy(buffer, 75, bytes, 0, 8);
            this.factor = DataParser.byte2Double((byte[])bytes, (boolean)true)[0];
            this.factor = this.factor - 0.0 < 2.220446049250313E-16 ? 1.0 : this.factor;
            this.unit = new String(buffer, 83, 8).trim();
            if (log.isLoggable(Level.FINER)) {
                System.out.println(String.format(Locale.ENGLISH, "%s[%s] factor=%f offset=%f Id=%d type=%d;", this.name, this.unit, this.factor, this.offset, this.id, this.dataType.value));
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            this.name = newName;
        }

        public int getId() {
            return this.id;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public int getDataSize() {
            return this.getSizeByType(this.dataType);
        }

        public int getSizeByType(DataType type) {
            switch (type.ordinal()) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 20;
                }
                case 8: {
                    return 24;
                }
                case 9: {
                    return 24;
                }
                case 11: {
                    return 32;
                }
                case 10: {
                    return 64;
                }
            }
            return 2;
        }

        public double getFactor() {
            return this.factor;
        }

        public double getOffset() {
            return this.offset;
        }

        public String getUnit() {
            return this.unit;
        }
    }

    public static enum RecordType {
        UNKNOWN,
        DATA,
        HEADER,
        EVENT;

    }

    public class LogRecord {
        int length;
        long timeStamp_ms;
        RecordType recordType;
        RecordEvent recordEvent;
        RecordData recordData;
        RecordHeader recordHeader;
        short crc;

        public LogRecord(byte[] buffer, RecordHeader header) throws DataInconsitsentException {
            this.recordHeader = header;
            this.length = DataParser.parse2Int((byte[])buffer, (int)0);
            this.timeStamp_ms = DataParser.parse2Long((byte[])buffer, (int)4);
            this.recordType = RecordType.values()[buffer[12]];
            switch (this.recordType.ordinal()) {
                case 2: {
                    if (log.isLoggable(Level.FINEST)) {
                        System.out.println("RecordType.HEADER");
                    }
                    this.recordHeader = new RecordHeader(buffer);
                    break;
                }
                case 1: {
                    if (log.isLoggable(Level.FINEST)) {
                        System.out.println("RecordType.DATA");
                    }
                    this.recordData = new RecordData(buffer, header, this.timeStamp_ms, startTimeStamp_ms);
                    break;
                }
                case 3: {
                    if (log.isLoggable(Level.FINEST)) {
                        System.out.println("RecordType.EVENT");
                    }
                    this.recordEvent = new RecordEvent(buffer);
                    break;
                }
                default: {
                    log.log(Level.WARNING, "RecordType_UNKNOWN");
                    application.openMessageDialogAsync("RecordType_UNKNOWN");
                }
            }
        }

        public int getLength() {
            return this.length;
        }

        public long getTimeStamp_ms() {
            return this.timeStamp_ms;
        }

        public RecordType getRecordType() {
            return this.recordType;
        }

        public RecordEvent getRecordEvent() {
            return this.recordEvent;
        }

        public RecordData getRecordData() {
            return this.recordData;
        }

        public RecordHeader getRecordHeader() {
            return this.recordHeader;
        }

        public short getCrc() {
            return this.crc;
        }
    }

    public class RecordHeader
    extends Record {
        String modellName;
        int measurementCount;
        int realUsedMeasurementCount;

        public RecordHeader(byte[] buffer) {
            int i;
            this.modellName = new String(buffer, 0 + this.offset, 256);
            this.measurementCount = DataParser.parse2UnsignedShort((byte[])buffer, (int)(256 + this.offset));
            this.realUsedMeasurementCount = 0;
            int activeChannelConfigNumber = application.getActiveChannelNumber();
            int ordinal = 0;
            int existingNumberMeasurements = device.getDeviceConfiguration().getMeasurementNames(activeChannelConfigNumber).length;
            for (i = this.measurementCount; i < existingNumberMeasurements; ++i) {
                device.removeMeasurementFromChannel(activeChannelConfigNumber, device.getMeasurement(activeChannelConfigNumber, this.measurementCount));
            }
            if (this.measurementCount != existingNumberMeasurements) {
                System.out.println();
            }
            block14: for (i = 0; i < this.measurementCount; ++i) {
                byte[] measurementBuffer = new byte[91];
                System.arraycopy(buffer, 258 + this.offset + i * measurementBuffer.length, measurementBuffer, 0, measurementBuffer.length);
                DataType dataSize = DataType.valueOf(measurementBuffer[66]);
                String measurementName = new String(measurementBuffer, 0, 64).trim();
                switch (dataSize.ordinal()) {
                    case 7: {
                        String[] packetGpsNames = new String[]{"_Latitude", "_Longitude", "_Speed", "_Altitude", "_Course", "_isValid", "_UTC"};
                        String[] packetGpsUnits = new String[]{"\u00b0", "\u00b0", "kn", "m", "\u00b0", "-", "-"};
                        double[] packetGpsFactors = new double[]{1.6666666666666668E-7, 1.6666666666666668E-7, 0.1, 0.1, 0.01, 1.0, 1.0};
                        block15: for (int j = 0; j < packetGpsNames.length; ++j) {
                            String packetGpsName = measurementName + packetGpsNames[j];
                            byte[] tempMeasurementBuffer = new byte[64];
                            System.arraycopy(packetGpsName.getBytes(), 0, tempMeasurementBuffer, 0, packetGpsName.getBytes().length);
                            System.arraycopy(tempMeasurementBuffer, 0, measurementBuffer, 0, 64);
                            switch (j) {
                                case 0: {
                                    this.setupMeasurement(Record.DataType.GPS_LATITUDE, activeChannelConfigNumber, ordinal++, packetGpsName, packetGpsUnits[j], true, packetGpsFactors[j], 0.0, true);
                                    continue block15;
                                }
                                case 1: {
                                    this.setupMeasurement(Record.DataType.GPS_LONGITUDE, activeChannelConfigNumber, ordinal++, packetGpsName, packetGpsUnits[j], true, packetGpsFactors[j], 0.0, true);
                                    continue block15;
                                }
                                case 2: {
                                    this.setupMeasurement(Record.DataType.GPS_SPEED, activeChannelConfigNumber, ordinal++, packetGpsName, packetGpsUnits[j], true, packetGpsFactors[j], 0.0, false);
                                    continue block15;
                                }
                                case 3: {
                                    this.setupMeasurement(Record.DataType.GPS_ALTITUDE, activeChannelConfigNumber, ordinal++, packetGpsName, packetGpsUnits[j], true, packetGpsFactors[j], 0.0, false);
                                    continue block15;
                                }
                                case 4: {
                                    this.setupMeasurement(Record.DataType.GPS_AZIMUTH, activeChannelConfigNumber, ordinal++, packetGpsName, packetGpsUnits[j], true, packetGpsFactors[j], 0.0, false);
                                    continue block15;
                                }
                                case 5: {
                                    this.setupMeasurement(Record.DataType.DEFAULT, activeChannelConfigNumber, ordinal++, packetGpsName, packetGpsUnits[j], true, packetGpsFactors[j], 0.0, true);
                                    continue block15;
                                }
                                case 6: {
                                    if (WeatronicAdapter.isUtcFilter) continue block15;
                                    this.setupMeasurement(Record.DataType.DEFAULT, activeChannelConfigNumber, ordinal++, packetGpsName, packetGpsUnits[j], true, packetGpsFactors[j], 0.0, true);
                                    continue block15;
                                }
                            }
                        }
                        Measurement measurement = new Measurement(measurementBuffer);
                        measurements.put(measurement.getId(), measurement);
                        usedMeasurementIds.add(measurement.getId());
                        continue block14;
                    }
                    case 10: {
                        String[] powerSupplyNames = new String[]{"_Status Main", "_Voltage Main", "_Current Main", "_InputVoltage Main", "_InputCurrent Main", "_MainVoltage Main", "_ReserveVoltage Main", "_Main_InputTemperature"};
                        String[] powerSupplyUnits = new String[]{"-", "V", "A", "V", "A", "V", "V", "\u00b0C"};
                        double[] powerSupplyFactors = new double[]{1.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 1.0};
                        for (int j = 0; j < powerSupplyNames.length; ++j) {
                            if (j == 0 && WeatronicAdapter.isStatusFilter) continue;
                            String powerSupplyName = measurementName + powerSupplyNames[j];
                            byte[] tempMeasurementBuffer = new byte[64];
                            System.arraycopy(powerSupplyName.getBytes(), 0, tempMeasurementBuffer, 0, powerSupplyName.getBytes().length);
                            System.arraycopy(tempMeasurementBuffer, 0, measurementBuffer, 0, 64);
                            this.setupMeasurement(Record.DataType.DEFAULT, activeChannelConfigNumber, ordinal++, powerSupplyName, powerSupplyUnits[j], true, powerSupplyFactors[j], 0.0, powerSupplyName.endsWith("Status"));
                        }
                        String[] mainCellMeasurementNames = new String[]{"_Status Cell%d", "_Voltage Cell%d", "_Current Cell%d", "_Capacity Cell%d", "_Temperature Cell%d"};
                        String[] mainCellMeasurementUnits = new String[]{"-", "V", "A", "mAh", "\u00b0C"};
                        double[] mainCellMeasurementFactors = new double[]{1.0, 0.001, 0.001, 0.001, 1.0};
                        for (int cell = 1; cell <= 4; ++cell) {
                            for (int k = 0; k < mainCellMeasurementNames.length; ++k) {
                                if (k == 0 && WeatronicAdapter.isStatusFilter) continue;
                                String cellmeasurementName = measurementName + String.format(mainCellMeasurementNames[k], cell);
                                byte[] tempMeasurementBuffer = new byte[64];
                                System.arraycopy(cellmeasurementName.getBytes(), 0, tempMeasurementBuffer, 0, cellmeasurementName.getBytes().length);
                                System.arraycopy(tempMeasurementBuffer, 0, measurementBuffer, 0, 64);
                                this.setupMeasurement(Record.DataType.DEFAULT, activeChannelConfigNumber, ordinal++, cellmeasurementName, mainCellMeasurementUnits[k], true, mainCellMeasurementFactors[k], 0.0, cellmeasurementName.endsWith("Status"));
                            }
                        }
                        Measurement measurement = new Measurement(measurementBuffer);
                        measurements.put(measurement.getId(), measurement);
                        usedMeasurementIds.add(measurement.getId());
                        continue block14;
                    }
                    default: {
                        Measurement measurement = new Measurement(measurementBuffer);
                        measurements.put(measurement.getId(), measurement);
                        if (WeatronicAdapter.isChannelFilter && LogReader.this.isChannelFilter(measurement.getId()) || WeatronicAdapter.isStatusFilter && LogReader.this.isStatusFilter(measurement.getId()) || WeatronicAdapter.isUtcFilter && LogReader.this.isUTCFilter(measurement)) continue block14;
                        usedMeasurementIds.add(measurement.getId());
                        int index = 1;
                        String tmpMeasurementName = measurement.getName();
                        while (this.isDuplicatedName(this.realUsedMeasurementCount, activeChannelConfigNumber, measurement.getName())) {
                            measurement.setName(tmpMeasurementName + "_" + index++);
                        }
                        if (measurement.getName().contains("_GPS_")) {
                            if (measurement.getName().contains("_GPS_Long")) {
                                this.setupMeasurement(Record.DataType.GPS_LONGITUDE, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), true, measurement.getFactor(), measurement.getOffset(), true);
                                continue block14;
                            }
                            if (measurement.getName().contains("_GPS_Lat")) {
                                this.setupMeasurement(Record.DataType.GPS_LATITUDE, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), true, measurement.getFactor(), measurement.getOffset(), true);
                                continue block14;
                            }
                            if (measurement.getName().contains("_GPS_Alt")) {
                                this.setupMeasurement(Record.DataType.GPS_ALTITUDE, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), false, measurement.getFactor(), measurement.getOffset(), true);
                                continue block14;
                            }
                            if (measurement.getName().contains("_GPS_Course")) {
                                this.setupMeasurement(Record.DataType.GPS_AZIMUTH, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), false, measurement.getFactor(), measurement.getOffset(), true);
                                continue block14;
                            }
                            if (measurement.getName().contains("_GPS_Speed")) {
                                this.setupMeasurement(Record.DataType.GPS_SPEED, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), false, measurement.getFactor(), measurement.getOffset(), true);
                                continue block14;
                            }
                            if (measurement.getName().contains("_GPS_IsValid")) {
                                this.setupMeasurement(Record.DataType.DEFAULT, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), true, measurement.getFactor(), measurement.getOffset(), true);
                                continue block14;
                            }
                            if (measurement.getName().contains("UTC")) {
                                this.setupMeasurement(Record.DataType.DEFAULT, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), true, measurement.getFactor(), measurement.getOffset(), true);
                                continue block14;
                            }
                            if (measurement.getName().contains("Status")) {
                                this.setupMeasurement(Record.DataType.DEFAULT, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), true, measurement.getFactor(), measurement.getOffset(), true);
                                continue block14;
                            }
                            this.setupMeasurement(activeChannelConfigNumber, ordinal++, measurement, false);
                            continue block14;
                        }
                        if (measurement.getName().contains("UTC")) {
                            this.setupMeasurement(Record.DataType.DEFAULT, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), true, measurement.getFactor(), measurement.getOffset(), true);
                            continue block14;
                        }
                        if (measurement.getName().contains("Status")) {
                            this.setupMeasurement(Record.DataType.DEFAULT, activeChannelConfigNumber, ordinal++, measurement.getName(), measurement.getUnit(), true, measurement.getFactor(), measurement.getOffset(), true);
                            continue block14;
                        }
                        this.setupMeasurement(activeChannelConfigNumber, ordinal++, measurement, false);
                    }
                }
            }
            if (this.realUsedMeasurementCount != existingNumberMeasurements) {
                for (i = this.realUsedMeasurementCount; i < existingNumberMeasurements; ++i) {
                    device.removeMeasurementFromChannel(activeChannelConfigNumber, device.getMeasurement(activeChannelConfigNumber, this.realUsedMeasurementCount));
                }
            }
            device.getDeviceConfiguration().storeDeviceProperties();
            String[] recordNames = device.getDeviceConfiguration().getMeasurementNames(activeChannelConfigNumber);
            String[] recordSymbols = new String[recordNames.length];
            String[] recordUnits = new String[recordNames.length];
            for (int i2 = 0; i2 < recordNames.length; ++i2) {
                MeasurementType measurement = device.getMeasurement(activeChannelConfigNumber, i2);
                recordSymbols[i2] = "";
                recordUnits[i2] = measurement.getUnit();
            }
            String recordSetNameExtend = device.getRecordSetStateNameReplacement(1);
            String recordSetName = channels.getActiveChannel().size() + 1 + ") " + recordSetNameExtend;
            recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)activeChannelConfigNumber, (String[])recordNames, (String[])recordSymbols, (String[])recordUnits, (double)device.getTimeStep_ms(), (boolean)true, (boolean)true, (boolean)true);
            recordSet.getName();
            for (int i3 = 0; i3 < recordSet.size(); ++i3) {
                gde.data.Record record = recordSet.get(i3);
                MeasurementType measurementType = device.getMeasurement(activeChannelConfigNumber, record.getOrdinal());
                if (measurementType == null || measurementType.getProperty(Record.DataType.DEFAULT.value()) != null) continue;
                record.setDataType();
            }
        }

        private boolean isDuplicatedName(int ordinal, int channelConfigNumber, String name) {
            String[] measurementNames = device.getMeasurementNamesReplacements(channelConfigNumber);
            for (int i = 0; i < ordinal; ++i) {
                if (!measurementNames[i].equals(name)) continue;
                return true;
            }
            return false;
        }

        private void setupMeasurement(Record.DataType dataType, int channelConfig, int measurementOrdinal, String name, String unit, boolean isActive, double factor, double offset, boolean isClearStatistics) {
            ++this.realUsedMeasurementCount;
            MeasurementType gdeMeasurement = device.getMeasurement(channelConfig, measurementOrdinal);
            if (!name.equals(gdeMeasurement.getName())) {
                gdeMeasurement.setName(name);
                gdeMeasurement.setStatistics(null);
            }
            gdeMeasurement.removeProperties();
            gdeMeasurement.setUnit(unit);
            gdeMeasurement.setActive(Boolean.valueOf(isActive));
            gdeMeasurement.setFactor(factor);
            gdeMeasurement.setOffset(offset);
            switch (dataType) {
                case GPS_LATITUDE: {
                    PropertyType tmpPropertyType = new PropertyType();
                    tmpPropertyType.setName(Record.DataType.GPS_LATITUDE.value());
                    tmpPropertyType.setType(DataTypes.STRING);
                    tmpPropertyType.setValue((Object)Record.DataType.GPS_LATITUDE.value());
                    gdeMeasurement.getProperty().add(tmpPropertyType);
                    break;
                }
                case GPS_LONGITUDE: {
                    PropertyType tmpPropertyType = new PropertyType();
                    tmpPropertyType.setName(Record.DataType.GPS_LONGITUDE.value());
                    tmpPropertyType.setType(DataTypes.STRING);
                    tmpPropertyType.setValue((Object)Record.DataType.GPS_LONGITUDE.value());
                    gdeMeasurement.getProperty().add(tmpPropertyType);
                    break;
                }
                case GPS_ALTITUDE: {
                    PropertyType tmpPropertyType = new PropertyType();
                    tmpPropertyType.setName(Record.DataType.GPS_ALTITUDE.value());
                    tmpPropertyType.setType(DataTypes.STRING);
                    tmpPropertyType.setValue((Object)Record.DataType.GPS_ALTITUDE.value());
                    gdeMeasurement.getProperty().add(tmpPropertyType);
                    break;
                }
                case GPS_AZIMUTH: {
                    PropertyType tmpPropertyType = new PropertyType();
                    tmpPropertyType.setName(Record.DataType.GPS_AZIMUTH.value());
                    tmpPropertyType.setType(DataTypes.STRING);
                    tmpPropertyType.setValue((Object)Record.DataType.GPS_AZIMUTH.value());
                    gdeMeasurement.getProperty().add(tmpPropertyType);
                    break;
                }
                case GPS_SPEED: {
                    PropertyType tmpPropertyType = new PropertyType();
                    tmpPropertyType.setName(Record.DataType.GPS_SPEED.value());
                    tmpPropertyType.setType(DataTypes.STRING);
                    tmpPropertyType.setValue((Object)Record.DataType.GPS_SPEED.value());
                    gdeMeasurement.getProperty().add(tmpPropertyType);
                    break;
                }
            }
            if (WeatronicAdapter.properties.get(name) != null) {
                String[] measurementNames = device.getMeasurementNamesReplacements(channelConfig);
                int syncOrdinal = -1;
                String syncName = (String)WeatronicAdapter.properties.get(name);
                for (int i = 0; i < measurementNames.length; ++i) {
                    if (!measurementNames[i].equals(syncName)) continue;
                    syncOrdinal = i;
                    break;
                }
                if (syncOrdinal >= 0) {
                    PropertyType tmpPropertyType = new PropertyType();
                    tmpPropertyType.setName(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value());
                    tmpPropertyType.setType(DataTypes.INTEGER);
                    tmpPropertyType.setValue((Object)syncOrdinal);
                    gdeMeasurement.getProperty().add(tmpPropertyType);
                }
            }
            if (isClearStatistics) {
                gdeMeasurement.setStatistics(null);
            } else {
                StatisticsType newStatisticsType = gdeMeasurement.getStatistics();
                if (newStatisticsType == null) {
                    newStatisticsType = new StatisticsType();
                }
                newStatisticsType.setMin(true);
                newStatisticsType.setMax(true);
                newStatisticsType.setAvg(true);
                newStatisticsType.setSigma(true);
                gdeMeasurement.setStatistics(newStatisticsType);
            }
        }

        private void setupMeasurement(int channelConfig, int measurementOrdinal, Measurement measurement, boolean isClearStatistics) {
            ++this.realUsedMeasurementCount;
            MeasurementType gdeMeasurement = device.getMeasurement(channelConfig, measurementOrdinal);
            if (!measurement.getName().equals(gdeMeasurement.getName())) {
                gdeMeasurement.setName((String)(measurement.getName().length() == 0 ? "???_" + measurementOrdinal : measurement.getName()));
                gdeMeasurement.setStatistics(null);
            }
            gdeMeasurement.removeProperties();
            gdeMeasurement.setUnit(measurement.getUnit());
            gdeMeasurement.setActive(Boolean.valueOf(true));
            gdeMeasurement.setFactor(measurement.getFactor());
            gdeMeasurement.setOffset(measurement.getOffset());
            if (WeatronicAdapter.properties.get(measurement.getName()) != null) {
                String[] measurementNames = device.getMeasurementNamesReplacements(channelConfig);
                int syncOrdinal = -1;
                String syncName = (String)WeatronicAdapter.properties.get(measurement.getName());
                for (int i = 0; i < measurementNames.length; ++i) {
                    if (!measurementNames[i].equals(syncName)) continue;
                    syncOrdinal = i;
                    break;
                }
                if (syncOrdinal >= 0) {
                    PropertyType tmpPropertyType = new PropertyType();
                    tmpPropertyType.setName(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value());
                    tmpPropertyType.setType(DataTypes.INTEGER);
                    tmpPropertyType.setValue((Object)syncOrdinal);
                    gdeMeasurement.getProperty().add(tmpPropertyType);
                }
            }
            if (isClearStatistics) {
                gdeMeasurement.setStatistics(null);
            } else {
                StatisticsType newStatisticsType = gdeMeasurement.getStatistics();
                if (newStatisticsType == null) {
                    newStatisticsType = new StatisticsType();
                }
                newStatisticsType.setMin(true);
                newStatisticsType.setMax(true);
                newStatisticsType.setAvg(true);
                newStatisticsType.setSigma(true);
                gdeMeasurement.setStatistics(newStatisticsType);
            }
        }

        public String getModellName() {
            return this.modellName;
        }

        public int getMeasurementCount() {
            return this.measurementCount > measurements.size() ? this.measurementCount : measurements.size();
        }

        public Map<Integer, Measurement> getMeasurements() {
            return measurements;
        }
    }

    public class RecordEvent
    extends Record {
        byte[] eventData;

        public RecordEvent(byte[] buffer) {
            this.eventData = buffer;
        }
    }

    public class RecordData
    extends Record {
        Vector<ConfigSection> configSections;
        int configSectionCount;
        int shortestInterval;
        int measurementCount;
        DataSection dataSection;

        public RecordData(byte[] buffer, RecordHeader recordHeader, long inTimeStamp_ms, long startTimeStamp_ms) throws DataInconsitsentException {
            this.configSections = new Vector();
            this.shortestInterval = 13;
            this.measurementCount = 0;
            this.configSectionCount = buffer[0 + this.offset];
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "configSectionCount = " + this.configSectionCount);
            }
            int configSectionBytes = 0;
            for (int section = 0; section < this.configSectionCount; ++section) {
                ConfigSection configSection = new ConfigSection(buffer, 1 + this.offset + configSectionBytes);
                this.shortestInterval = Math.min(this.shortestInterval, configSection.getInterval());
                this.configSections.add(configSection);
                configSectionBytes += configSection.getLength();
                this.measurementCount += configSection.getCount();
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("header measurement count = %d, config section measurement count = %d", recordHeader.getMeasurementCount(), this.measurementCount));
            }
            this.offset = configSectionBytes + 4 + 8 + 1 + 1;
            long timeOffset = LogReader.this.getTimeOffset(this.shortestInterval);
            int count = 0;
            while (this.offset < buffer.length - 2) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, " -> offset = " + this.offset + " buffer.length-2 = " + (buffer.length - 2));
                }
                DataSection tmpDataSection = new DataSection(buffer, this.offset, this.configSections, recordHeader, inTimeStamp_ms);
                if (tmpDataSection.interval == this.shortestInterval) {
                    long timeStamp_ms = inTimeStamp_ms + timeOffset * (long)count++;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, StringHelper.getFormatedTime((String)"yyyy-MM-dd HH:mm:ss.SSS;", (long)timeStamp_ms));
                    }
                    block8: for (int measurementId : usedMeasurementIds) {
                        DataItem dataItem = receivedDataItems.get(measurementId);
                        if (dataItem == null) {
                            Measurement measurement = measurements.get(measurementId);
                            switch (measurement.getDataType().ordinal()) {
                                case 7: {
                                    int i;
                                    for (i = 0; i < (WeatronicAdapter.isUtcFilter ? 6 : 7); ++i) {
                                        pointsVector.add(0);
                                        if (!log.isLoggable(Level.FINER)) continue;
                                        System.out.print("-;");
                                    }
                                    continue block8;
                                }
                                case 10: {
                                    int i;
                                    for (i = 0; i < (WeatronicAdapter.isStatusFilter ? 23 : 28); ++i) {
                                        pointsVector.add(0);
                                        if (!log.isLoggable(Level.FINER)) continue;
                                        System.out.print("-;");
                                    }
                                    continue block8;
                                }
                                default: {
                                    pointsVector.add(0);
                                    if (!log.isLoggable(Level.FINER)) continue block8;
                                    System.out.print("-;");
                                }
                            }
                            continue;
                        }
                        dataItem.addValue(pointsVector, timeStamp_ms);
                        dataItem.printValue(inTimeStamp_ms);
                    }
                    try {
                        if (recordSet.realSize() == pointsVector.size()) {
                            points = new int[recordSet.realSize()];
                            for (int i = 0; i < points.length; ++i) {
                                LogReader.points[i] = pointsVector.get(i);
                            }
                            if (receivedDataItems.get(33968) != null) {
                                recordSet.addPoints(points, (double)(timeStamp_ms - startTimeStamp_ms) * 1.0);
                            }
                        }
                    }
                    catch (DataInconsitsentException e) {
                        application.openMessageDialogAsync(e.getMessage());
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                    if (log.isLoggable(Level.FINER)) {
                        System.out.println();
                    }
                    pointsVector.clear();
                }
                if (log.isLoggable(Level.FINER) && tmpDataSection.getLength() != tmpDataSection.getReadBytes()) {
                    log.log(Level.FINER, "dataSection.getLength() = " + tmpDataSection.getLength() + " != dataSection.getReadBytes() = " + tmpDataSection.getReadBytes());
                }
                this.offset += tmpDataSection.getLength();
            }
        }
    }

    public class DataSection {
        int length;
        int interval;
        int readBytes;

        public DataSection(byte[] buffer, int offset, Vector<ConfigSection> configSections, RecordHeader recordHeader, long sectionTimeStamp) throws DataInconsitsentException {
            this.length = DataParser.parse2Int((byte[])buffer, (int)(0 + offset));
            this.interval = buffer[4 + offset] & 0xFF;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("data sections %3d, interval %3d", this.length, this.interval));
            }
            this.readBytes = 5;
            if (this.length == 0) {
                throw new DataInconsitsentException("DataSection with length 0 detected!");
            }
            for (ConfigSection configSection : configSections) {
                if (configSection.getInterval() != this.interval) continue;
                for (Integer id : configSection.ids) {
                    Measurement measurement = recordHeader.getMeasurements().get(id);
                    if (measurement != null && offset + 5 + measurement.getDataSize() <= buffer.length) {
                        if (usedMeasurementIds.contains(measurement.id)) {
                            receivedDataItems.put(id, new DataItem(buffer, offset + 5, measurement, sectionTimeStamp));
                        }
                        offset += measurement.getDataSize();
                        this.readBytes += measurement.getDataSize();
                        continue;
                    }
                    if (!unknownIds.contains(id)) {
                        unknownIds.add(id);
                    }
                    offset += 2;
                }
            }
        }

        public int getReadBytes() {
            return this.readBytes;
        }

        public int getLength() {
            return this.length;
        }

        public int getInterval() {
            return this.interval;
        }
    }

    public class DataItem {
        final Measurement measurement;
        final DataType dataType;
        int value;
        int longitude;
        int latitude;
        int speed;
        int altitude;
        int course;
        int isValid;
        long timeStamp_ms_utc;
        int status;
        int voltage;
        int current;
        int inVoltage;
        int inCurrent;
        int mainVoltage;
        int reserveVoltage;
        int inTemperature;
        int cell1_Status;
        int cell1_Voltage;
        int cell1_Current;
        int cell1_Capacity;
        int cell1_Temperature;
        int cell2_Status;
        int cell2_Voltage;
        int cell2_Current;
        int cell2_Capacity;
        int cell2_Temperature;
        int cell3_Status;
        int cell3_Voltage;
        int cell3_Current;
        int cell3_Capacity;
        int cell3_Temperature;
        int cell4_Status;
        int cell4_Voltage;
        int cell4_Current;
        int cell4_Capacity;
        int cell4_Temperature;
        long dataSectionTimeStamp_ms;

        public DataItem(byte[] buffer, int offset, Measurement measurement, long dataSectionTimeStemp) {
            this.measurement = measurement;
            this.dataType = measurement.getDataType();
            this.dataSectionTimeStamp_ms = dataSectionTimeStemp;
            switch (this.dataType.ordinal()) {
                case 0: {
                    this.value = buffer[offset];
                    break;
                }
                case 1: {
                    this.value = buffer[offset] & 0xFF;
                    break;
                }
                case 2: {
                    this.value = DataParser.parse2Short((byte[])buffer, (int)offset);
                    break;
                }
                case 3: {
                    this.value = DataParser.parse2UnsignedShort((byte[])buffer, (int)offset);
                    break;
                }
                case 4: {
                    this.value = DataParser.parse2Int((byte[])buffer, (int)offset);
                    break;
                }
                case 5: {
                    this.value = (int)DataParser.getUInt32((byte[])buffer, (int)offset);
                    break;
                }
                case 6: {
                    log.log(Level.WARNING, "Float data item received, can not handle");
                    break;
                }
                case 7: {
                    this.latitude = DataParser.parse2Int((byte[])buffer, (int)offset);
                    this.longitude = DataParser.parse2Int((byte[])buffer, (int)(4 + offset));
                    this.speed = DataParser.parse2Short((byte[])buffer, (int)(8 + offset));
                    this.altitude = DataParser.parse2Short((byte[])buffer, (int)(10 + offset));
                    this.course = DataParser.parse2UnsignedShort((byte[])buffer, (int)(12 + offset));
                    this.isValid = buffer[14 + offset] & 1;
                    this.timeStamp_ms_utc = DataParser.getUInt32((byte[])buffer, (int)(15 + offset)) + (long)(buffer[19] & 0xFF);
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                case 11: {
                    break;
                }
                case 10: {
                    this.status = DataParser.parse2Int((byte[])buffer, (int)offset);
                    this.voltage = DataParser.parse2Short((byte[])buffer, (int)(4 + offset));
                    this.current = DataParser.parse2Short((byte[])buffer, (int)(6 + offset));
                    this.inVoltage = DataParser.parse2Short((byte[])buffer, (int)(8 + offset));
                    this.inCurrent = DataParser.parse2Short((byte[])buffer, (int)(10 + offset));
                    this.mainVoltage = DataParser.parse2Short((byte[])buffer, (int)(12 + offset));
                    this.reserveVoltage = DataParser.parse2Short((byte[])buffer, (int)(14 + offset));
                    this.inTemperature = DataParser.parse2Short((byte[])buffer, (int)(16 + offset));
                    this.cell1_Status = DataParser.parse2Int((byte[])buffer, (int)(20 + offset));
                    this.cell1_Voltage = DataParser.parse2Short((byte[])buffer, (int)(24 + offset));
                    this.cell1_Current = DataParser.parse2Short((byte[])buffer, (int)(26 + offset));
                    this.cell1_Capacity = DataParser.parse2Short((byte[])buffer, (int)(28 + offset));
                    this.cell1_Temperature = buffer[30 + offset];
                    this.cell2_Status = DataParser.parse2Int((byte[])buffer, (int)(31 + offset));
                    this.cell2_Voltage = DataParser.parse2Short((byte[])buffer, (int)(35 + offset));
                    this.cell2_Current = DataParser.parse2Short((byte[])buffer, (int)(37 + offset));
                    this.cell2_Capacity = DataParser.parse2Short((byte[])buffer, (int)(39 + offset));
                    this.cell2_Temperature = buffer[41 + offset];
                    this.cell3_Status = DataParser.parse2Int((byte[])buffer, (int)(42 + offset));
                    this.cell3_Voltage = DataParser.parse2Short((byte[])buffer, (int)(46 + offset));
                    this.cell3_Current = DataParser.parse2Short((byte[])buffer, (int)(48 + offset));
                    this.cell3_Capacity = DataParser.parse2Short((byte[])buffer, (int)(50 + offset));
                    this.cell3_Temperature = buffer[52 + offset];
                    this.cell4_Status = DataParser.parse2Int((byte[])buffer, (int)(53 + offset));
                    this.cell4_Voltage = DataParser.parse2Short((byte[])buffer, (int)(57 + offset));
                    this.cell4_Current = DataParser.parse2Short((byte[])buffer, (int)(59 + offset));
                    this.cell4_Capacity = DataParser.parse2Short((byte[])buffer, (int)(61 + offset));
                    this.cell4_Temperature = buffer[63 + offset];
                    break;
                }
                default: {
                    this.value = DataParser.parse2Short((byte[])buffer, (int)offset);
                }
            }
        }

        private void printValue(long dataSectionTimeStamp) {
            switch (this.dataType.ordinal()) {
                case 7: {
                    if (log.isLoggable(Level.FINER)) {
                        System.out.print(String.format(Locale.ENGLISH, "%.6f\u00b0;%.6f\u00b0;%.1fkn;%.1fm;%.2f\u00b0;%d;%d;", Float.valueOf((float)this.latitude / 6000000.0f), Float.valueOf((float)this.longitude / 6000000.0f), Float.valueOf((float)this.speed / 10.0f), Float.valueOf((float)this.altitude / 10.0f), Float.valueOf((float)this.course / 100.0f), this.isValid, this.timeStamp_ms_utc));
                    }
                    if (this.dataSectionTimeStamp_ms + 2000L >= dataSectionTimeStamp) break;
                    this.isValid = 0;
                    this.course = 0;
                    this.altitude = 0;
                    this.speed = 0;
                    this.longitude = 0;
                    this.latitude = 0;
                    this.timeStamp_ms_utc = 0L;
                    break;
                }
                case 10: {
                    if (log.isLoggable(Level.FINER)) {
                        System.out.print(String.format(Locale.ENGLISH, "%d;%.3fV;%.3fA;%.3fV;%.3fA;%.3fV;%.3fV;%d\u00b0C;", this.status, Float.valueOf((float)this.voltage / 1000.0f), Float.valueOf((float)this.current / 1000.0f), Float.valueOf((float)this.inVoltage / 1000.0f), Float.valueOf((float)this.inCurrent / 1000.0f), Float.valueOf((float)this.mainVoltage / 1000.0f), Float.valueOf((float)this.reserveVoltage / 1000.0f), this.inTemperature));
                    }
                    if (log.isLoggable(Level.FINER)) {
                        System.out.print(String.format(Locale.ENGLISH, "%d;%.3fV;%.3fA;%.3fAh;%d\u00b0C;", this.cell1_Status, Float.valueOf((float)this.cell1_Voltage / 1000.0f), Float.valueOf((float)this.cell1_Current / 1000.0f), Float.valueOf((float)this.cell1_Capacity / 1000.0f), this.cell1_Temperature));
                        System.out.print(String.format(Locale.ENGLISH, "%d;%.3fV;%.3fA;%.3fAh;%d\u00b0C;", this.cell2_Status, Float.valueOf((float)this.cell2_Voltage / 1000.0f), Float.valueOf((float)this.cell2_Current / 1000.0f), Float.valueOf((float)this.cell2_Capacity / 1000.0f), this.cell2_Temperature));
                        System.out.print(String.format(Locale.ENGLISH, "%d;%.3fV;%.3fA;%.3fAh;%d\u00b0C;", this.cell3_Status, Float.valueOf((float)this.cell3_Voltage / 1000.0f), Float.valueOf((float)this.cell3_Current / 1000.0f), Float.valueOf((float)this.cell3_Capacity / 1000.0f), this.cell3_Temperature));
                        System.out.print(String.format(Locale.ENGLISH, "%d;%.3fV;%.3fA;%.3fAh;%d\u00b0C;", this.cell4_Status, Float.valueOf((float)this.cell4_Voltage / 1000.0f), Float.valueOf((float)this.cell4_Current / 1000.0f), Float.valueOf((float)this.cell4_Capacity / 1000.0f), this.cell4_Temperature));
                    }
                    if (this.dataSectionTimeStamp_ms + 2000L >= dataSectionTimeStamp) break;
                    this.inTemperature = 0;
                    this.reserveVoltage = 0;
                    this.mainVoltage = 0;
                    this.inCurrent = 0;
                    this.inVoltage = 0;
                    this.current = 0;
                    this.voltage = 0;
                    this.status = 0;
                    this.cell1_Temperature = 0;
                    this.cell1_Capacity = 0;
                    this.cell1_Current = 0;
                    this.cell1_Voltage = 0;
                    this.cell1_Status = 0;
                    this.cell2_Temperature = 0;
                    this.cell2_Capacity = 0;
                    this.cell2_Current = 0;
                    this.cell2_Voltage = 0;
                    this.cell2_Status = 0;
                    this.cell3_Temperature = 0;
                    this.cell3_Capacity = 0;
                    this.cell3_Current = 0;
                    this.cell3_Voltage = 0;
                    this.cell3_Status = 0;
                    this.cell4_Temperature = 0;
                    this.cell4_Capacity = 0;
                    this.cell4_Current = 0;
                    this.cell4_Voltage = 0;
                    this.cell4_Status = 0;
                    break;
                }
                default: {
                    String format = "%." + this.getDecimalPoints(this.measurement.factor) + "f%s;";
                    if (log.isLoggable(Level.FINER)) {
                        System.out.print(String.format(Locale.ENGLISH, format, (double)this.value * this.measurement.factor + this.measurement.offset, this.measurement.getUnit()));
                    }
                    if (this.dataSectionTimeStamp_ms + 2000L >= dataSectionTimeStamp) break;
                    this.value = 0;
                }
            }
        }

        private void addValue(Vector<Integer> addPointsVector, long dataSectionTimeStamp) {
            switch (this.dataType.ordinal()) {
                case 7: {
                    addPointsVector.add(this.latitude);
                    addPointsVector.add(this.longitude);
                    addPointsVector.add(this.speed * 1000);
                    addPointsVector.add(this.altitude * 1000);
                    addPointsVector.add(this.course * 1000);
                    addPointsVector.add(this.isValid * 1000);
                    if (WeatronicAdapter.isUtcFilter) break;
                    addPointsVector.add((int)(this.timeStamp_ms_utc - dataSectionTimeStamp) * 1000);
                    break;
                }
                case 10: {
                    if (!WeatronicAdapter.isStatusFilter) {
                        addPointsVector.add(this.status * 1000);
                    }
                    addPointsVector.add(this.voltage * 1000);
                    addPointsVector.add(this.current * 1000);
                    addPointsVector.add(this.inVoltage * 1000);
                    addPointsVector.add(this.inCurrent * 1000);
                    addPointsVector.add(this.mainVoltage * 1000);
                    addPointsVector.add(this.reserveVoltage * 1000);
                    addPointsVector.add(this.inTemperature * 1000);
                    if (!WeatronicAdapter.isStatusFilter) {
                        addPointsVector.add(this.cell1_Status * 1000);
                    }
                    addPointsVector.add(this.cell1_Voltage * 1000);
                    addPointsVector.add(this.cell1_Current * 1000);
                    addPointsVector.add(this.cell1_Capacity * 1000);
                    addPointsVector.add(this.cell1_Temperature * 1000);
                    if (!WeatronicAdapter.isStatusFilter) {
                        addPointsVector.add(this.cell2_Status * 1000);
                    }
                    addPointsVector.add(this.cell2_Voltage * 1000);
                    addPointsVector.add(this.cell2_Current * 1000);
                    addPointsVector.add(this.cell2_Capacity * 1000);
                    addPointsVector.add(this.cell2_Temperature * 1000);
                    if (!WeatronicAdapter.isStatusFilter) {
                        addPointsVector.add(this.cell3_Status * 1000);
                    }
                    addPointsVector.add(this.cell3_Voltage * 1000);
                    addPointsVector.add(this.cell3_Current * 1000);
                    addPointsVector.add(this.cell3_Capacity * 1000);
                    addPointsVector.add(this.cell3_Temperature * 1000);
                    if (!WeatronicAdapter.isStatusFilter) {
                        addPointsVector.add(this.cell4_Status * 1000);
                    }
                    addPointsVector.add(this.cell4_Voltage * 1000);
                    addPointsVector.add(this.cell4_Current * 1000);
                    addPointsVector.add(this.cell4_Capacity * 1000);
                    addPointsVector.add(this.cell4_Temperature * 1000);
                    break;
                }
                default: {
                    if (this.measurement.getName().contains("_GPS_L")) {
                        addPointsVector.add(this.value);
                        break;
                    }
                    addPointsVector.add(this.value * 1000);
                }
            }
        }

        public int getDecimalPoints(double factor) {
            if (factor >= 1.0) {
                return 1;
            }
            return (int)Math.ceil(Math.abs(Math.log10(factor)));
        }

        public Measurement getMeasurement() {
            return this.measurement;
        }
    }

    public class ConfigSection {
        int count;
        int interval;
        Vector<Integer> ids = new Vector();
        int lengthBytes = 0;

        public ConfigSection(byte[] buffer, int offset) {
            this.count = DataParser.parse2UnsignedShort((byte[])buffer, (int)(0 + offset));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("config sections %3d, ", this.count));
            }
            this.interval = buffer[2 + offset] & 0xFF;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("interval %3d, IDs ", this.interval));
            }
            this.lengthBytes = 3 + this.count * 2;
            for (int i = 0; i < this.count; ++i) {
                this.ids.add(DataParser.parse2UnsignedShort((byte[])buffer, (int)(3 + offset + i * 2)));
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, this.ids.toString());
            }
        }

        public int getId(int index) {
            return this.ids.get(index);
        }

        public Vector<Integer> getIds() {
            return this.ids;
        }

        public int getCount() {
            return this.count;
        }

        public int getInterval() {
            return this.interval;
        }

        public int getLength() {
            return this.lengthBytes;
        }
    }

    public static enum DataType {
        SignedByte(43),
        UnsignedByte(52),
        SignedShort(44),
        UnsignedShort(53),
        SignedWord(45),
        UnsignedWord(54),
        Float(6),
        PaketGPS(20),
        PaketControlData(5),
        PaketServoData(4),
        PowerSupply(34),
        ControlIDPaket(17),
        SignedShort2(2),
        SignedShort3(3),
        UnknownSize(0);

        private final int value;

        private DataType(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }

        public static DataType valueOf(int i) {
            for (DataType ds : DataType.values()) {
                if (ds.value != i) continue;
                return ds;
            }
            return UnknownSize;
        }
    }

    public class Record {
        protected int offset = 13;
    }
}

