/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.config.Settings;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.graupner.Ultramat;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class UltramatAcDcEQ
extends Ultramat {
    static final Logger logger = Logger.getLogger(UltramatAcDcEQ.class.getName());

    public UltramatAcDcEQ(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGI2204"), Messages.getString((String)"GDE_MSGT2205"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207")};
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
        this.dialog = null;
    }

    public UltramatAcDcEQ(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGI2204"), Messages.getString((String)"GDE_MSGT2205"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207")};
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
        this.dialog = null;
    }

    @Override
    public int getLovDataByteSize() {
        return 60;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int[] points = new int[this.getNumberOfMeasurements(recordSet.getChannelConfigNumber())];
        int offset = 4;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        if (dataBuffer[offset] == 12) {
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
                if (doUpdateProgressBar && i % 50 == 0) {
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            }
            recordSet.setTimeStep_ms(this.getAverageTimeStep_ms() != null ? this.getAverageTimeStep_ms() : 1000.0);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        try {
            points[0] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[15]), Character.valueOf((char)dataBuffer[16]), Character.valueOf((char)dataBuffer[17]), Character.valueOf((char)dataBuffer[18])), 16);
            points[1] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[19]), Character.valueOf((char)dataBuffer[20]), Character.valueOf((char)dataBuffer[21]), Character.valueOf((char)dataBuffer[22])), 16);
            points[2] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[23]), Character.valueOf((char)dataBuffer[24]), Character.valueOf((char)dataBuffer[25]), Character.valueOf((char)dataBuffer[26])), 16);
            points[3] = Double.valueOf((double)(points[0] * points[1]) / 1000.0).intValue();
            points[4] = Double.valueOf((double)(points[0] * points[2]) / 1000.0).intValue();
            points[5] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[7]), Character.valueOf((char)dataBuffer[8]), Character.valueOf((char)dataBuffer[9]), Character.valueOf((char)dataBuffer[10])), 16);
            points[6] = 0;
            int i = 0;
            int j = 0;
            while (i < 6) {
                points[i + 7] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[27 + j]), Character.valueOf((char)dataBuffer[28 + j]), Character.valueOf((char)dataBuffer[29 + j]), Character.valueOf((char)dataBuffer[30 + j])), 16);
                if (points[i + 7] > 0) {
                    maxVotage = points[i + 7] > maxVotage ? points[i + 7] : maxVotage;
                    minVotage = points[i + 7] < minVotage ? points[i + 7] : minVotage;
                }
                ++i;
                j += 4;
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        points[6] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            logger.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
            points[4] = Double.valueOf((double)points[0] / 1000.0 * (double)points[2]).intValue();
            points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[6] = 0;
            int j = 0;
            int k = 0;
            while (j < 6) {
                points[j + 7] = ((convertBuffer[k + 16] & 0xFF) << 24) + ((convertBuffer[k + 17] & 0xFF) << 16) + ((convertBuffer[k + 18] & 0xFF) << 8) + ((convertBuffer[k + 19] & 0xFF) << 0);
                if (points[j + 7] > 0) {
                    maxVotage = points[j + 7] > maxVotage ? points[j + 7] : maxVotage;
                    minVotage = points[j + 7] < minVotage ? points[j + 7] : minVotage;
                }
                ++j;
                k += 4;
            }
            points[6] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        int displayableCounter = 0;
        recordSet.setAllDisplayable();
        int numCells = 6;
        for (i = recordSet.size() - numCells - 1; i < recordSet.size(); ++i) {
            record.setDisplayable((record = recordSet.get(i)).getOrdinal() <= 5 || record.hasReasonableData());
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, record.getName() + " setDisplayable=" + (record.getOrdinal() <= 5 || record.hasReasonableData()));
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    @Override
    public Ultramat.GraupnerDeviceType getDeviceTypeIdentifier() {
        return Ultramat.GraupnerDeviceType.UltraQuick70;
    }

    @Override
    public int getProductCode(byte[] dataBuffer) {
        return this.getDeviceTypeIdentifier().ordinal();
    }

    @Override
    public boolean isProcessing(int outletNum, byte[] dataBuffer) {
        if (outletNum == 1) {
            try {
                int operationMode1 = this.getProcessingMode(dataBuffer);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "operationMode1 = " + operationMode1);
                }
                return operationMode1 > 0 && operationMode1 < 4 || operationMode1 == 5 || operationMode1 == 7 || operationMode1 == 11 || operationMode1 == 12;
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }
        return false;
    }

    @Override
    public int getProcessingMode(byte[] dataBuffer) {
        return Integer.parseInt(String.format("%c%c", Character.valueOf((char)dataBuffer[11]), Character.valueOf((char)dataBuffer[12])), 16);
    }

    @Override
    public int getCycleNumber(int outletNum, byte[] dataBuffer) {
        return Integer.parseInt(String.format("%c%c", Character.valueOf((char)dataBuffer[13]), Character.valueOf((char)dataBuffer[14])), 16);
    }
}

