/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.comm.DeviceCommPort;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.graupner.Polaron;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.util.logging.Logger;

public class PolaronSerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = PolaronSerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    static final byte[] QUERY_DATA = new byte[]{0, -103};
    static final byte[] RESET = new byte[]{12, 67, 48, 48, 48, 48, 48, 68, 51, 13};
    static final int xferErrorLimit = 15;
    byte cntUp = 0;
    byte cntDown = (byte)-1;
    boolean isInSync = false;
    boolean isDataMissmatchWarningWritten = false;
    int dataCheckSumOffset = 0;
    boolean isCmdMissmatchWarningWritten = false;
    int cmdCheckSumOffset = 0;

    public PolaronSerialPort(Polaron currentDevice, DataExplorer currentApplication) {
        super((IDevice)currentDevice, currentApplication);
    }

    public PolaronSerialPort(DeviceConfiguration deviceConfiguration) {
        super(deviceConfiguration);
    }

    private byte[] prepareCmdBytes(byte[] cmd) {
        return this.prepareCmdBytes(cmd, "");
    }

    private byte[] prepareCmdBytes(byte[] cmd, String body) {
        byte[] b = new byte[body.length() == 0 ? body.length() + 9 : body.length() + 10];
        b[0] = 0;
        if (this.cntUp == 254 || this.cntDown == 1) {
            this.cntUp = 0;
            this.cntDown = (byte)-1;
        }
        b[1] = this.cntUp = (byte)(this.cntUp + 1);
        b[2] = this.cntDown = (byte)(this.cntDown - 1);
        b[3] = (byte)(body.length() == 0 ? body.length() & 0xFF : body.length() + 1 & 0xFF);
        b[4] = 0;
        b[5] = cmd[0];
        b[6] = cmd[1];
        for (int i = 7; i < body.length() + 7; ++i) {
            b[i] = (byte)(body.getBytes()[i - 7] & 0xFF);
        }
        if (body.length() > 0) {
            b[i++] = 0;
        }
        short crc16 = Checksum.CRC16CCITT((byte[])b, (int)3, (int)(body.length() == 0 ? body.length() + 4 : body.length() + 5));
        b[i++] = (byte)(crc16 & 0xFF);
        b[i++] = (byte)((crc16 & 0xFF00) >> 8);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])b, (int)b.length));
        }
        return b;
    }

    public synchronized byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))];
        byte[] answer = new byte[]{0};
        try {
            this.write(this.prepareCmdBytes(QUERY_DATA));
            answer = new byte[data.length];
            answer = this.read(data, 2000);
            if (log.isLoggable(Level.FINER)) {
                log.logp(Level.FINER, $CLASS_NAME, "getData", StringHelper.byte2Hex2CharString((byte[])answer, (int)answer.length));
            }
            if (answer.length == 0 || answer[answer.length - 1] == 0 && answer[answer.length - 2] == 0) {
                throw new TimeOutException("no data");
            }
            if (!this.isCheckSumOK(3, data)) {
                this.addXferError();
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> checksum error occured, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 15");
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        return data;
    }

    public synchronized byte[] getData(boolean checkBeginEndSignature) throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))];
        byte[] answer = new byte[]{0};
        try {
            answer = new byte[data.length];
            answer = this.read(data, 3000);
            while (answer[0] != 12) {
                this.isInSync = false;
                for (int i = 1; i < answer.length; ++i) {
                    if (answer[i] != 12) continue;
                    System.arraycopy(answer, i, data, 0, data.length - i);
                    answer = new byte[i];
                    answer = this.read(answer, 1000);
                    System.arraycopy(answer, 0, data, data.length - i, i);
                    this.isInSync = true;
                    if (!log.isLoggable(Level.FINER)) break;
                    log.logp(Level.FINER, $CLASS_NAME, "getData", "----> receive sync finished");
                    break;
                }
                if (this.isInSync) break;
                this.addXferError();
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> unable to synchronize received data, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of transfer error exceed the acceptable limit of 15");
                }
                this.write(RESET);
                answer = new byte[data.length];
                answer = this.read(answer, 3000);
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getData", StringHelper.convert2CharString((byte[])data));
            }
            if (checkBeginEndSignature && (data[0] != 12 || data[data.length - 1] != 13)) {
                this.addXferError();
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> data start or end does not match, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 15");
                }
                this.write(RESET);
                data = this.getData(true);
            }
            if (checkBeginEndSignature && !this.isChecksumOK(data)) {
                this.addXferError();
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> checksum error occured, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 15");
                }
                this.write(RESET);
                data = this.getData(true);
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        return data;
    }

    public boolean isCheckSumOK(int startIndex, byte[] bytes) {
        String $METHOD_NAME = "isCheckSumOK";
        short checksum = Checksum.CRC16CCITT((byte[])bytes, (int)startIndex, (int)(bytes.length - 2 - startIndex));
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "isCheckSumOK", String.format("checksum: %b - %04X", (checksum & 0xFF00) >> 8 == (bytes[bytes.length - 1] & 0xFF) && (checksum & 0xFF) == (bytes[bytes.length - 2] & 0xFF), checksum));
        }
        return (checksum & 0xFF00) >> 8 == (bytes[bytes.length - 1] & 0xFF) && (checksum & 0xFF) == (bytes[bytes.length - 2] & 0xFF);
    }

    private synchronized boolean isChecksumOK(byte[] buffer) {
        int buffer_check_sum;
        String $METHOD_NAME = "isChecksumOK";
        boolean isOK = false;
        int length = buffer.length;
        int check_sum = Checksum.ADD((byte[])buffer, (int)1, (int)(length - 6));
        if (check_sum == (buffer_check_sum = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)buffer[length - 5]), Character.valueOf((char)buffer[length - 4]), Character.valueOf((char)buffer[length - 3]), Character.valueOf((char)buffer[length - 2])), 16)) || check_sum == buffer_check_sum - this.dataCheckSumOffset) {
            isOK = true;
        } else if (!this.isDataMissmatchWarningWritten) {
            log.logp(Level.WARNING, $CLASS_NAME, "isChecksumOK", "check sum missmatch detected, calculates check_sum = " + check_sum + "; delta to data contained delta = " + (buffer_check_sum - check_sum));
            log.logp(Level.WARNING, $CLASS_NAME, "isChecksumOK", StringHelper.convert2CharString((byte[])buffer));
            this.isDataMissmatchWarningWritten = true;
            this.dataCheckSumOffset = buffer_check_sum - check_sum;
            isOK = true;
        }
        return isOK;
    }
}

