/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.util.Uu;

public class TextUtil {
    public static String transformText(String text2, CalculatedStyle style) {
        IdentValue fontVariant;
        IdentValue transform2 = style.getIdent(CSSName.TEXT_TRANSFORM);
        if (transform2 == IdentValue.LOWERCASE) {
            text2 = text2.toLowerCase();
        }
        if (transform2 == IdentValue.UPPERCASE) {
            text2 = text2.toUpperCase();
        }
        if (transform2 == IdentValue.CAPITALIZE) {
            text2 = TextUtil.capitalizeWords(text2);
        }
        if ((fontVariant = style.getIdent(CSSName.FONT_VARIANT)) == IdentValue.SMALL_CAPS) {
            text2 = text2.toUpperCase();
        }
        return text2;
    }

    public static String transformFirstLetterText(String text2, CalculatedStyle style) {
        if (text2.length() > 0) {
            IdentValue transform2 = style.getIdent(CSSName.TEXT_TRANSFORM);
            IdentValue fontVariant = style.getIdent(CSSName.FONT_VARIANT);
            int end = text2.length();
            for (int i2 = 0; i2 < end; ++i2) {
                char currentChar = text2.charAt(i2);
                if (TextUtil.isFirstLetterSeparatorChar(currentChar)) continue;
                if (transform2 == IdentValue.LOWERCASE) {
                    currentChar = Character.toLowerCase(currentChar);
                    text2 = TextUtil.replaceChar(text2, currentChar, i2);
                    break;
                }
                if (transform2 != IdentValue.UPPERCASE && transform2 != IdentValue.CAPITALIZE && fontVariant != IdentValue.SMALL_CAPS) break;
                currentChar = Character.toUpperCase(currentChar);
                text2 = TextUtil.replaceChar(text2, currentChar, i2);
                break;
            }
        }
        return text2;
    }

    public static String replaceChar(String text2, char newChar, int index) {
        int textLength = text2.length();
        StringBuilder b2 = new StringBuilder(textLength);
        for (int i2 = 0; i2 < textLength; ++i2) {
            if (i2 == index) {
                b2.append(newChar);
                continue;
            }
            b2.append(text2.charAt(i2));
        }
        return b2.toString();
    }

    public static boolean isFirstLetterSeparatorChar(char c2) {
        switch (Character.getType(c2)) {
            case 12: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    private static String capitalizeWords(String text2) {
        if (text2.length() == 0) {
            return text2;
        }
        StringBuffer sb = new StringBuffer();
        boolean cap = true;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            String ch = text2.substring(i2, i2 + 1);
            if (cap) {
                sb.append(ch.toUpperCase());
            } else {
                sb.append(ch);
            }
            cap = false;
            if (!ch.equals(" ")) continue;
            cap = true;
        }
        if (sb.toString().length() != text2.length()) {
            Uu.p("error! to strings arent the same length = -" + sb.toString() + "-" + text2 + "-");
        }
        return sb.toString();
    }
}

