/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.core.v2.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.WeakHashMap;

public class EditDistance {
    private static final WeakHashMap<AbstractMap.SimpleEntry<String, String>, Integer> CACHE = new WeakHashMap();
    private int[] cost;
    private int[] back;
    private final String a;
    private final String b;

    public static int editDistance(String a2, String b2) {
        AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(a2, b2);
        Integer result2 = null;
        if (CACHE.containsKey(entry)) {
            result2 = CACHE.get(entry);
        }
        if (result2 == null) {
            result2 = new EditDistance(a2, b2).calc();
            CACHE.put(entry, result2);
        }
        return result2;
    }

    public static String findNearest(String key2, String[] group2) {
        return EditDistance.findNearest(key2, Arrays.asList(group2));
    }

    public static String findNearest(String key2, Collection<String> group2) {
        int c2 = Integer.MAX_VALUE;
        String r2 = null;
        for (String s2 : group2) {
            int ed = EditDistance.editDistance(key2, s2);
            if (c2 <= ed) continue;
            c2 = ed;
            r2 = s2;
        }
        return r2;
    }

    private EditDistance(String a2, String b2) {
        this.a = a2;
        this.b = b2;
        this.cost = new int[a2.length() + 1];
        this.back = new int[a2.length() + 1];
        for (int i2 = 0; i2 <= a2.length(); ++i2) {
            this.cost[i2] = i2;
        }
    }

    private void flip() {
        int[] t2 = this.cost;
        this.cost = this.back;
        this.back = t2;
    }

    private int min(int a2, int b2, int c2) {
        return Math.min(a2, Math.min(b2, c2));
    }

    private int calc() {
        for (int j2 = 0; j2 < this.b.length(); ++j2) {
            this.flip();
            this.cost[0] = j2 + 1;
            for (int i2 = 0; i2 < this.a.length(); ++i2) {
                int match = this.a.charAt(i2) == this.b.charAt(j2) ? 0 : 1;
                this.cost[i2 + 1] = this.min(this.back[i2] + match, this.cost[i2] + 1, this.back[i2 + 1] + 1);
            }
        }
        return this.cost[this.a.length()];
    }
}

