/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.apache.commons.math3.stat.ranking.TiesStrategy;
import org.apache.commons.math3.util.FastMath;

public class WilcoxonSignedRankTest {
    private NaturalRanking naturalRanking;

    public WilcoxonSignedRankTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public WilcoxonSignedRankTest(NaNStrategy nanStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(nanStrategy, tiesStrategy);
    }

    private void ensureDataConformance(double[] x2, double[] y2) throws NullArgumentException, NoDataException, DimensionMismatchException {
        if (x2 == null || y2 == null) {
            throw new NullArgumentException();
        }
        if (x2.length == 0 || y2.length == 0) {
            throw new NoDataException();
        }
        if (y2.length != x2.length) {
            throw new DimensionMismatchException(y2.length, x2.length);
        }
    }

    private double[] calculateDifferences(double[] x2, double[] y2) {
        double[] z2 = new double[x2.length];
        for (int i2 = 0; i2 < x2.length; ++i2) {
            z2[i2] = y2[i2] - x2[i2];
        }
        return z2;
    }

    private double[] calculateAbsoluteDifferences(double[] z2) throws NullArgumentException, NoDataException {
        if (z2 == null) {
            throw new NullArgumentException();
        }
        if (z2.length == 0) {
            throw new NoDataException();
        }
        double[] zAbs = new double[z2.length];
        for (int i2 = 0; i2 < z2.length; ++i2) {
            zAbs[i2] = FastMath.abs(z2[i2]);
        }
        return zAbs;
    }

    public double wilcoxonSignedRank(double[] x2, double[] y2) throws NullArgumentException, NoDataException, DimensionMismatchException {
        this.ensureDataConformance(x2, y2);
        double[] z2 = this.calculateDifferences(x2, y2);
        double[] zAbs = this.calculateAbsoluteDifferences(z2);
        double[] ranks = this.naturalRanking.rank(zAbs);
        double Wplus = 0.0;
        for (int i2 = 0; i2 < z2.length; ++i2) {
            if (!(z2[i2] > 0.0)) continue;
            Wplus += ranks[i2];
        }
        int N = x2.length;
        double Wminus = (double)(N * (N + 1)) / 2.0 - Wplus;
        return FastMath.max(Wplus, Wminus);
    }

    private double calculateExactPValue(double Wmax, int N) {
        int m2 = 1 << N;
        int largerRankSums = 0;
        for (int i2 = 0; i2 < m2; ++i2) {
            int rankSum = 0;
            for (int j2 = 0; j2 < N; ++j2) {
                if ((i2 >> j2 & 1) != 1) continue;
                rankSum += j2 + 1;
            }
            if (!((double)rankSum >= Wmax)) continue;
            ++largerRankSums;
        }
        return 2.0 * (double)largerRankSums / (double)m2;
    }

    private double calculateAsymptoticPValue(double Wmin, int N) {
        double ES = (double)(N * (N + 1)) / 4.0;
        double VarS = ES * ((double)(2 * N + 1) / 6.0);
        double z2 = (Wmin - ES - 0.5) / FastMath.sqrt(VarS);
        NormalDistribution standardNormal = new NormalDistribution(null, 0.0, 1.0);
        return 2.0 * standardNormal.cumulativeProbability(z2);
    }

    public double wilcoxonSignedRankTest(double[] x2, double[] y2, boolean exactPValue) throws NullArgumentException, NoDataException, DimensionMismatchException, NumberIsTooLargeException, ConvergenceException, MaxCountExceededException {
        this.ensureDataConformance(x2, y2);
        int N = x2.length;
        double Wmax = this.wilcoxonSignedRank(x2, y2);
        if (exactPValue && N > 30) {
            throw new NumberIsTooLargeException(N, (Number)30, true);
        }
        if (exactPValue) {
            return this.calculateExactPValue(Wmax, N);
        }
        double Wmin = (double)(N * (N + 1)) / 2.0 - Wmax;
        return this.calculateAsymptoticPValue(Wmin, N);
    }
}

