/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SparseRealVector;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.OpenIntToDoubleHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMapRealVector
extends SparseRealVector
implements Serializable {
    public static final double DEFAULT_ZERO_TOLERANCE = 1.0E-12;
    private static final long serialVersionUID = 8772222695580707260L;
    private final OpenIntToDoubleHashMap entries;
    private final int virtualSize;
    private final double epsilon;

    public OpenMapRealVector() {
        this(0, 1.0E-12);
    }

    public OpenMapRealVector(int dimension) {
        this(dimension, 1.0E-12);
    }

    public OpenMapRealVector(int dimension, double epsilon) {
        this.virtualSize = dimension;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = epsilon;
    }

    protected OpenMapRealVector(OpenMapRealVector v2, int resize) {
        this.virtualSize = v2.getDimension() + resize;
        this.entries = new OpenIntToDoubleHashMap(v2.entries);
        this.epsilon = v2.epsilon;
    }

    public OpenMapRealVector(int dimension, int expectedSize) {
        this(dimension, expectedSize, 1.0E-12);
    }

    public OpenMapRealVector(int dimension, int expectedSize, double epsilon) {
        this.virtualSize = dimension;
        this.entries = new OpenIntToDoubleHashMap(expectedSize, 0.0);
        this.epsilon = epsilon;
    }

    public OpenMapRealVector(double[] values2) {
        this(values2, 1.0E-12);
    }

    public OpenMapRealVector(double[] values2, double epsilon) {
        this.virtualSize = values2.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = epsilon;
        for (int key2 = 0; key2 < values2.length; ++key2) {
            double value = values2[key2];
            if (this.isDefaultValue(value)) continue;
            this.entries.put(key2, value);
        }
    }

    public OpenMapRealVector(Double[] values2) {
        this(values2, 1.0E-12);
    }

    public OpenMapRealVector(Double[] values2, double epsilon) {
        this.virtualSize = values2.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = epsilon;
        for (int key2 = 0; key2 < values2.length; ++key2) {
            double value = values2[key2];
            if (this.isDefaultValue(value)) continue;
            this.entries.put(key2, value);
        }
    }

    public OpenMapRealVector(OpenMapRealVector v2) {
        this.virtualSize = v2.getDimension();
        this.entries = new OpenIntToDoubleHashMap(v2.getEntries());
        this.epsilon = v2.epsilon;
    }

    public OpenMapRealVector(RealVector v2) {
        this.virtualSize = v2.getDimension();
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = 1.0E-12;
        for (int key2 = 0; key2 < this.virtualSize; ++key2) {
            double value = v2.getEntry(key2);
            if (this.isDefaultValue(value)) continue;
            this.entries.put(key2, value);
        }
    }

    private OpenIntToDoubleHashMap getEntries() {
        return this.entries;
    }

    protected boolean isDefaultValue(double value) {
        return FastMath.abs(value) < this.epsilon;
    }

    @Override
    public RealVector add(RealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        if (v2 instanceof OpenMapRealVector) {
            return this.add((OpenMapRealVector)v2);
        }
        return super.add(v2);
    }

    public OpenMapRealVector add(OpenMapRealVector v2) throws DimensionMismatchException {
        OpenIntToDoubleHashMap randomAccess;
        this.checkVectorDimensions(v2.getDimension());
        boolean copyThis = this.entries.size() > v2.entries.size();
        OpenMapRealVector res = copyThis ? this.copy() : v2.copy();
        OpenIntToDoubleHashMap.Iterator iter = copyThis ? v2.entries.iterator() : this.entries.iterator();
        OpenIntToDoubleHashMap openIntToDoubleHashMap = randomAccess = copyThis ? this.entries : v2.entries;
        while (iter.hasNext()) {
            iter.advance();
            int key2 = iter.key();
            if (randomAccess.containsKey(key2)) {
                res.setEntry(key2, randomAccess.get(key2) + iter.value());
                continue;
            }
            res.setEntry(key2, iter.value());
        }
        return res;
    }

    public OpenMapRealVector append(OpenMapRealVector v2) {
        OpenMapRealVector res = new OpenMapRealVector(this, v2.getDimension());
        OpenIntToDoubleHashMap.Iterator iter = v2.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key() + this.virtualSize, iter.value());
        }
        return res;
    }

    @Override
    public OpenMapRealVector append(RealVector v2) {
        if (v2 instanceof OpenMapRealVector) {
            return this.append((OpenMapRealVector)v2);
        }
        OpenMapRealVector res = new OpenMapRealVector(this, v2.getDimension());
        for (int i2 = 0; i2 < v2.getDimension(); ++i2) {
            res.setEntry(i2 + this.virtualSize, v2.getEntry(i2));
        }
        return res;
    }

    @Override
    public OpenMapRealVector append(double d2) {
        OpenMapRealVector res = new OpenMapRealVector(this, 1);
        res.setEntry(this.virtualSize, d2);
        return res;
    }

    @Override
    public OpenMapRealVector copy() {
        return new OpenMapRealVector(this);
    }

    @Deprecated
    public double dotProduct(OpenMapRealVector v2) throws DimensionMismatchException {
        return this.dotProduct((RealVector)v2);
    }

    @Override
    public OpenMapRealVector ebeDivide(RealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        OpenMapRealVector res = new OpenMapRealVector(this);
        int n2 = this.getDimension();
        for (int i2 = 0; i2 < n2; ++i2) {
            res.setEntry(i2, this.getEntry(i2) / v2.getEntry(i2));
        }
        return res;
    }

    @Override
    public OpenMapRealVector ebeMultiply(RealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        OpenMapRealVector res = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key(), iter.value() * v2.getEntry(iter.key()));
        }
        return res;
    }

    @Override
    public OpenMapRealVector getSubVector(int index, int n2) throws NotPositiveException, OutOfRangeException {
        this.checkIndex(index);
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        this.checkIndex(index + n2 - 1);
        OpenMapRealVector res = new OpenMapRealVector(n2);
        int end = index + n2;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key2 = iter.key();
            if (key2 < index || key2 >= end) continue;
            res.setEntry(key2 - index, iter.value());
        }
        return res;
    }

    @Override
    public int getDimension() {
        return this.virtualSize;
    }

    public double getDistance(OpenMapRealVector v2) throws DimensionMismatchException {
        int key2;
        this.checkVectorDimensions(v2.getDimension());
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        double res = 0.0;
        while (iter.hasNext()) {
            iter.advance();
            key2 = iter.key();
            double delta = iter.value() - v2.getEntry(key2);
            res += delta * delta;
        }
        iter = v2.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            key2 = iter.key();
            if (this.entries.containsKey(key2)) continue;
            double value = iter.value();
            res += value * value;
        }
        return FastMath.sqrt(res);
    }

    @Override
    public double getDistance(RealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        if (v2 instanceof OpenMapRealVector) {
            return this.getDistance((OpenMapRealVector)v2);
        }
        return super.getDistance(v2);
    }

    @Override
    public double getEntry(int index) throws OutOfRangeException {
        this.checkIndex(index);
        return this.entries.get(index);
    }

    public double getL1Distance(OpenMapRealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        double max = 0.0;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            double delta = FastMath.abs(iter.value() - v2.getEntry(iter.key()));
            max += delta;
        }
        iter = v2.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key2 = iter.key();
            if (this.entries.containsKey(key2)) continue;
            double delta = FastMath.abs(iter.value());
            max += FastMath.abs(delta);
        }
        return max;
    }

    @Override
    public double getL1Distance(RealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        if (v2 instanceof OpenMapRealVector) {
            return this.getL1Distance((OpenMapRealVector)v2);
        }
        return super.getL1Distance(v2);
    }

    private double getLInfDistance(OpenMapRealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        double max = 0.0;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            double delta = FastMath.abs(iter.value() - v2.getEntry(iter.key()));
            if (!(delta > max)) continue;
            max = delta;
        }
        iter = v2.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key2 = iter.key();
            if (this.entries.containsKey(key2) || !(iter.value() > max)) continue;
            max = iter.value();
        }
        return max;
    }

    @Override
    public double getLInfDistance(RealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        if (v2 instanceof OpenMapRealVector) {
            return this.getLInfDistance((OpenMapRealVector)v2);
        }
        return super.getLInfDistance(v2);
    }

    @Override
    public boolean isInfinite() {
        boolean infiniteFound = false;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            double value = iter.value();
            if (Double.isNaN(value)) {
                return false;
            }
            if (!Double.isInfinite(value)) continue;
            infiniteFound = true;
        }
        return infiniteFound;
    }

    @Override
    public boolean isNaN() {
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (!Double.isNaN(iter.value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public OpenMapRealVector mapAdd(double d2) {
        return this.copy().mapAddToSelf(d2);
    }

    @Override
    public OpenMapRealVector mapAddToSelf(double d2) {
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            this.setEntry(i2, this.getEntry(i2) + d2);
        }
        return this;
    }

    @Override
    public void setEntry(int index, double value) throws OutOfRangeException {
        this.checkIndex(index);
        if (!this.isDefaultValue(value)) {
            this.entries.put(index, value);
        } else if (this.entries.containsKey(index)) {
            this.entries.remove(index);
        }
    }

    @Override
    public void setSubVector(int index, RealVector v2) throws OutOfRangeException {
        this.checkIndex(index);
        this.checkIndex(index + v2.getDimension() - 1);
        for (int i2 = 0; i2 < v2.getDimension(); ++i2) {
            this.setEntry(i2 + index, v2.getEntry(i2));
        }
    }

    @Override
    public void set(double value) {
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            this.setEntry(i2, value);
        }
    }

    public OpenMapRealVector subtract(OpenMapRealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        OpenMapRealVector res = this.copy();
        OpenIntToDoubleHashMap.Iterator iter = v2.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key2 = iter.key();
            if (this.entries.containsKey(key2)) {
                res.setEntry(key2, this.entries.get(key2) - iter.value());
                continue;
            }
            res.setEntry(key2, -iter.value());
        }
        return res;
    }

    @Override
    public RealVector subtract(RealVector v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        if (v2 instanceof OpenMapRealVector) {
            return this.subtract((OpenMapRealVector)v2);
        }
        return super.subtract(v2);
    }

    @Override
    public OpenMapRealVector unitVector() throws MathArithmeticException {
        OpenMapRealVector res = this.copy();
        res.unitize();
        return res;
    }

    @Override
    public void unitize() throws MathArithmeticException {
        double norm = this.getNorm();
        if (this.isDefaultValue(norm)) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), iter.value() / norm);
        }
    }

    @Override
    public double[] toArray() {
        double[] res = new double[this.virtualSize];
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res[iter.key()] = iter.value();
        }
        return res;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        long temp = Double.doubleToLongBits(this.epsilon);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        result2 = 31 * result2 + this.virtualSize;
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            temp = Double.doubleToLongBits(iter.value());
            result2 = 31 * result2 + (int)(temp ^ temp >> 32);
        }
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        double test;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OpenMapRealVector)) {
            return false;
        }
        OpenMapRealVector other = (OpenMapRealVector)obj;
        if (this.virtualSize != other.virtualSize) {
            return false;
        }
        if (Double.doubleToLongBits(this.epsilon) != Double.doubleToLongBits(other.epsilon)) {
            return false;
        }
        OpenIntToDoubleHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            test = other.getEntry(iter.key());
            if (Double.doubleToLongBits(test) == Double.doubleToLongBits(iter.value())) continue;
            return false;
        }
        iter = other.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            test = iter.value();
            if (Double.doubleToLongBits(test) == Double.doubleToLongBits(this.getEntry(iter.key()))) continue;
            return false;
        }
        return true;
    }

    public double getSparsity() {
        return (double)this.entries.size() / (double)this.getDimension();
    }

    @Override
    public Iterator<RealVector.Entry> sparseIterator() {
        return new OpenMapSparseIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OpenMapSparseIterator
    implements Iterator<RealVector.Entry> {
        private final OpenIntToDoubleHashMap.Iterator iter;
        private final RealVector.Entry current;

        protected OpenMapSparseIterator() {
            this.iter = OpenMapRealVector.this.entries.iterator();
            this.current = new OpenMapEntry(this.iter);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RealVector.Entry next() {
            this.iter.advance();
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    protected class OpenMapEntry
    extends RealVector.Entry {
        private final OpenIntToDoubleHashMap.Iterator iter;

        protected OpenMapEntry(OpenIntToDoubleHashMap.Iterator iter) {
            super(OpenMapRealVector.this);
            this.iter = iter;
        }

        public double getValue() {
            return this.iter.value();
        }

        public void setValue(double value) {
            OpenMapRealVector.this.entries.put(this.iter.key(), value);
        }

        public int getIndex() {
            return this.iter.key();
        }
    }
}

