/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.report.HTMLEditorKit;
import genj.report.Report;
import genj.util.GridBagHelper;
import genj.util.Resources;
import genj.util.swing.EditorHyperlinkSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkListener;

class ReportDetail
extends JPanel {
    private JLabel lFile;
    private JLabel lAuthor;
    private JLabel lVersion;
    private JTextPane tpInfo;
    private HTMLEditorKit editorKit = new HTMLEditorKit(ReportDetail.class);

    public ReportDetail() {
        Resources res = Resources.get((Object)this);
        GridBagHelper gh = new GridBagHelper((Container)this);
        gh.setParameter(1);
        gh.setInsets(new Insets(0, 0, 0, 5));
        this.lFile = new JLabel("");
        this.lFile.setForeground(Color.black);
        gh.add((Component)new JLabel(res.getString("report.file")), 2, 0);
        gh.add((Component)this.lFile, 3, 0, 1, 1, 17);
        this.lAuthor = new JLabel("");
        this.lAuthor.setForeground(Color.black);
        gh.add((Component)new JLabel(res.getString("report.author")), 2, 1);
        gh.add((Component)this.lAuthor, 3, 1, 1, 1, 17);
        this.lVersion = new JLabel();
        this.lVersion.setForeground(Color.black);
        gh.add((Component)new JLabel(res.getString("report.version")), 2, 2);
        gh.add((Component)this.lVersion, 3, 2);
        this.tpInfo = new JTextPane();
        this.tpInfo.setEditable(false);
        this.tpInfo.setEditorKit(this.editorKit);
        this.tpInfo.setFont(new JTextField().getFont());
        this.tpInfo.addHyperlinkListener((HyperlinkListener)new EditorHyperlinkSupport((JEditorPane)this.tpInfo));
        this.tpInfo.setPreferredSize(new Dimension(256, 256));
        JScrollPane spInfo = new JScrollPane(this.tpInfo);
        gh.add((Component)spInfo, 2, 4, 2, 1, 68);
        this.tpInfo.setText(res.getString("report.detail.long"));
    }

    public void setReport(Report report) {
        if (report == null) {
            this.lFile.setText("");
            this.lAuthor.setText("");
            this.lVersion.setText("");
            this.tpInfo.setText("");
        } else {
            this.editorKit.setFrom(report.getClass());
            this.lFile.setText(report.getClass().getSimpleName());
            this.lAuthor.setText(report.getAuthor());
            this.lVersion.setText(this.getReportVersion(report));
            this.tpInfo.setText(report.getInfo().replaceAll("\n", ""));
            this.tpInfo.setCaretPosition(0);
        }
    }

    private String getReportVersion(Report report) {
        Object version = report.getVersion();
        String update = report.getLastUpdate();
        if (update != null) {
            version = (String)version + " - " + Resources.get((Object)this).getString("report.updated") + ": " + update;
        }
        return version;
    }
}

