/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.latex.FontFamilyDeclaration;
import java.io.IOException;

public class L2HFontFamilyDeclaration
extends FontFamilyDeclaration {
    public L2HFontFamilyDeclaration(String string, int n) {
        super(string, n);
    }

    public L2HFontFamilyDeclaration(String string, TeXFontFamily teXFontFamily) {
        super(string, teXFontFamily);
    }

    @Override
    public Object clone() {
        return new L2HFontFamilyDeclaration(this.getName(), this.getFamily());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        super.process(teXParser);
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        String string = "";
        String string2 = "span";
        switch (this.getFamily()) {
            case RM: {
                string = "font-family: " + l2HConverter.getSerifCssFontNames() + "; ";
                break;
            }
            case SF: {
                string = "font-family: " + l2HConverter.getSansSerifCssFontNames() + "; ";
                break;
            }
            case TT: {
                string = "font-family: " + l2HConverter.getMonospaceCssFontNames() + "; ";
                break;
            }
            case VERB: {
                string2 = "code";
                return;
            }
        }
        if (string.isEmpty()) {
            l2HConverter.writeliteral(String.format("<%s>", string2));
        } else {
            teXParser.getListener().getWriteable().writeliteral(String.format("<%s style=\"%s\">", string2, string));
        }
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.getFamily() == TeXFontFamily.VERB) {
            teXParser.getListener().getWriteable().writeliteral("</code>");
        } else {
            teXParser.getListener().getWriteable().writeliteral("</span>");
        }
        super.end(teXParser, teXObjectList);
    }
}

