/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.util.Numerics;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;

abstract class Transferer {
    protected final Raster source;
    protected final WritableRaster target;
    protected final Rectangle region;
    protected int band;

    protected Transferer(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        this.source = raster;
        this.target = writableRaster;
        this.region = rectangle;
    }

    int prepareTransferRegion() {
        return Math.addExact(this.region.y, this.region.height);
    }

    public final void compute(MathTransform1D[] mathTransform1DArray) throws TransformException {
        assert (this.source.getBounds().contains(this.region)) : this.region;
        assert (this.target.getBounds().contains(this.region)) : this.region;
        int n = this.prepareTransferRegion();
        int n2 = this.region.y;
        int n3 = this.region.height;
        this.band = 0;
        while (this.band < mathTransform1DArray.length) {
            MathTransform1D mathTransform1D = mathTransform1DArray[this.band];
            this.region.y = n2;
            do {
                this.region.height = Math.min(n3, n - this.region.y);
                this.computeStrip(mathTransform1D);
            } while ((this.region.y += this.region.height) < n);
            ++this.band;
        }
    }

    abstract void computeStrip(MathTransform1D var1) throws TransformException;

    final int length() {
        return Math.multiplyExact(this.region.width, this.region.height);
    }

    static Transferer create(RenderedImage renderedImage, WritableRaster writableRaster) {
        int n = ImageUtilities.pixelToTileX(renderedImage, writableRaster.getMinX());
        int n2 = ImageUtilities.pixelToTileY(renderedImage, writableRaster.getMinY());
        return Transferer.create(renderedImage.getTile(n, n2), writableRaster, writableRaster.getBounds());
    }

    static Transferer create(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        switch (ImageUtilities.getBandType(writableRaster.getSampleModel())) {
            case 5: {
                if (!Transferer.isDirect(writableRaster, rectangle)) break;
                return new DoubleToDirect(raster, writableRaster, rectangle);
            }
            case 4: {
                switch (ImageUtilities.getBandType(raster.getSampleModel())) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: {
                        if (Transferer.isDirect(writableRaster, rectangle)) {
                            return new FloatToDirect(raster, writableRaster, rectangle);
                        }
                        return new FloatToFloat(raster, writableRaster, rectangle);
                    }
                }
                break;
            }
            case 3: {
                return Transferer.singlePrecision(raster) ? new FloatToInteger(raster, writableRaster, rectangle) : new DoubleToInteger(raster, writableRaster, rectangle);
            }
            case 1: {
                return Transferer.singlePrecision(raster) ? new FloatToUShort(raster, writableRaster, rectangle) : new DoubleToUShort(raster, writableRaster, rectangle);
            }
            case 2: {
                return Transferer.singlePrecision(raster) ? new FloatToShort(raster, writableRaster, rectangle) : new DoubleToShort(raster, writableRaster, rectangle);
            }
            case 0: {
                return Transferer.singlePrecision(raster) ? new FloatToByte(raster, writableRaster, rectangle) : new DoubleToByte(raster, writableRaster, rectangle);
            }
        }
        return new DoubleToDouble(raster, writableRaster, rectangle);
    }

    private static boolean singlePrecision(Raster raster) {
        switch (ImageUtilities.getBandType(raster.getSampleModel())) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDirect(Raster raster, Rectangle rectangle) {
        ComponentSampleModel componentSampleModel;
        SampleModel sampleModel;
        if (raster.getMinX() == rectangle.x && raster.getWidth() == rectangle.width && (sampleModel = raster.getSampleModel()) instanceof ComponentSampleModel && (componentSampleModel = (ComponentSampleModel)sampleModel).getPixelStride() == 1 && componentSampleModel.getScanlineStride() == raster.getWidth()) {
            for (int n : raster.getDataBuffer().getOffsets()) {
                if (n == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static final class DoubleToDirect
    extends Transferer {
        private final DataBufferDouble buffer;

        DoubleToDirect(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
            this.buffer = (DataBufferDouble)writableRaster.getDataBuffer();
        }

        @Override
        void computeStrip(MathTransform1D mathTransform1D) throws TransformException {
            double[] dArray = this.buffer.getData(this.band);
            dArray = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, dArray);
            mathTransform1D.transform(dArray, 0, dArray, 0, this.length());
        }
    }

    private static final class FloatToDirect
    extends Transferer {
        private final DataBufferFloat buffer;

        FloatToDirect(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
            this.buffer = (DataBufferFloat)writableRaster.getDataBuffer();
        }

        @Override
        void computeStrip(MathTransform1D mathTransform1D) throws TransformException {
            float[] fArray = this.buffer.getData(this.band);
            fArray = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, fArray);
            mathTransform1D.transform(fArray, 0, fArray, 0, this.length());
        }
    }

    private static final class FloatToFloat
    extends Transferer {
        private float[] buffer;

        FloatToFloat(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        int prepareTransferRegion() {
            return ImageUtilities.prepareTransferRegion(this.region, 4);
        }

        @Override
        void computeStrip(MathTransform1D mathTransform1D) throws TransformException {
            this.buffer = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
            mathTransform1D.transform(this.buffer, 0, this.buffer, 0, this.length());
            this.target.setSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
        }
    }

    private static class FloatToInteger
    extends Transferer {
        protected float[] buffer;
        protected int[] transfer;

        FloatToInteger(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        final int prepareTransferRegion() {
            return ImageUtilities.prepareTransferRegion(this.region, 4);
        }

        @Override
        final void computeStrip(MathTransform1D mathTransform1D) throws TransformException {
            int n = this.length();
            this.buffer = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
            mathTransform1D.transform(this.buffer, 0, this.buffer, 0, n);
            if (this.transfer == null) {
                this.transfer = new int[n];
            }
            this.clamp(n);
            this.target.setSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.transfer);
        }

        void clamp(int n) {
            for (int i = 0; i < n; ++i) {
                this.transfer[i] = Math.round(this.buffer[i]);
            }
        }
    }

    private static class DoubleToInteger
    extends Transferer {
        protected double[] buffer;
        protected int[] transfer;

        DoubleToInteger(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        final int prepareTransferRegion() {
            return ImageUtilities.prepareTransferRegion(this.region, 5);
        }

        @Override
        final void computeStrip(MathTransform1D mathTransform1D) throws TransformException {
            int n = this.length();
            this.buffer = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
            mathTransform1D.transform(this.buffer, 0, this.buffer, 0, n);
            if (this.transfer == null) {
                this.transfer = new int[n];
            }
            this.clamp(n);
            this.target.setSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.transfer);
        }

        void clamp(int n) {
            for (int i = 0; i < n; ++i) {
                this.transfer[i] = Numerics.clamp(Math.round(this.buffer[i]));
            }
        }
    }

    private static final class FloatToUShort
    extends FloatToInteger {
        FloatToUShort(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        void clamp(int n) {
            for (int i = 0; i < n; ++i) {
                this.transfer[i] = Math.max(0, Math.min(65535, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class DoubleToUShort
    extends DoubleToInteger {
        DoubleToUShort(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        void clamp(int n) {
            for (int i = 0; i < n; ++i) {
                this.transfer[i] = (int)Math.max(0L, Math.min(65535L, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class FloatToShort
    extends FloatToInteger {
        FloatToShort(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        void clamp(int n) {
            for (int i = 0; i < n; ++i) {
                this.transfer[i] = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class DoubleToShort
    extends DoubleToInteger {
        DoubleToShort(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        void clamp(int n) {
            for (int i = 0; i < n; ++i) {
                this.transfer[i] = (int)Math.max(-32768L, Math.min(32767L, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class FloatToByte
    extends FloatToInteger {
        FloatToByte(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        void clamp(int n) {
            for (int i = 0; i < n; ++i) {
                this.transfer[i] = Math.max(0, Math.min(255, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class DoubleToByte
    extends DoubleToInteger {
        DoubleToByte(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        void clamp(int n) {
            for (int i = 0; i < n; ++i) {
                this.transfer[i] = (int)Math.max(0L, Math.min(255L, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class DoubleToDouble
    extends Transferer {
        private double[] buffer;

        DoubleToDouble(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
            super(raster, writableRaster, rectangle);
        }

        @Override
        int prepareTransferRegion() {
            return ImageUtilities.prepareTransferRegion(this.region, 5);
        }

        @Override
        void computeStrip(MathTransform1D mathTransform1D) throws TransformException {
            this.buffer = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
            mathTransform1D.transform(this.buffer, 0, this.buffer, 0, this.length());
            this.target.setSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
        }
    }
}

