/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Pattern URL_PREFIX = Pattern.compile("^([a-z]*?://).*");

    public static String removeScheme(String url) {
        Matcher matcher = URL_PREFIX.matcher(url);
        if (matcher.matches()) {
            return url.substring(matcher.group(1).length());
        }
        return url;
    }

    public static boolean hasScheme(String url) {
        Matcher matcher = URL_PREFIX.matcher(url);
        return matcher.matches();
    }

    public static String getScheme(String url) {
        Matcher matcher = URL_PREFIX.matcher(url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractBaseUrl(String coreUrl) {
        int indexOfLastSlash = (coreUrl = URLUtil.removeTrailingSlashIfPresent(coreUrl)).lastIndexOf("/");
        if (indexOfLastSlash == -1) {
            log.warn("Solr core URL [{}] did not contain expected path segments when parsing, ignoring...", (Object)coreUrl);
            return coreUrl;
        }
        return coreUrl.substring(0, coreUrl.lastIndexOf("/"));
    }

    public static String extractCoreFromCoreUrl(String coreUrl) {
        coreUrl = URLUtil.removeTrailingSlashIfPresent(coreUrl);
        return coreUrl.substring(coreUrl.lastIndexOf("/") + 1);
    }

    public static String buildCoreUrl(String baseUrl, String coreName) {
        baseUrl = URLUtil.removeTrailingSlashIfPresent(baseUrl);
        return baseUrl + "/" + coreName;
    }

    private static String removeTrailingSlashIfPresent(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getBaseUrlForNodeName(String nodeName, String urlScheme) {
        return URLUtil.getBaseUrlForNodeName(nodeName, urlScheme, false);
    }

    public static String getBaseUrlForNodeName(String nodeName, String urlScheme, boolean isV2) {
        int colonAt = nodeName.indexOf(58);
        if (colonAt == -1) {
            throw new IllegalArgumentException("nodeName does not contain expected ':' separator: " + nodeName);
        }
        int _offset = nodeName.indexOf(95, colonAt);
        if (_offset < 0) {
            throw new IllegalArgumentException("nodeName does not contain expected '_' separator: " + nodeName);
        }
        String hostAndPort = nodeName.substring(0, _offset);
        String path = URLDecoder.decode(nodeName.substring(1 + _offset), StandardCharsets.UTF_8);
        return urlScheme + "://" + hostAndPort + (String)(path.isEmpty() ? "" : "/" + (isV2 ? "api" : path));
    }

    public static String getNodeNameForBaseUrl(String solrUrl) throws MalformedURLException, URISyntaxException {
        URL url = new URI(solrUrl).toURL();
        return url.getAuthority() + url.getPath().replace('/', '_');
    }
}

