/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.s3express;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.services.s3.internal.s3express.DefaultS3ExpressSessionCredentials;
import software.amazon.awssdk.services.s3.model.SessionCredentials;

@SdkPublicApi
public interface S3ExpressSessionCredentials
extends AwsCredentialsIdentity {
    public String sessionToken();

    public static S3ExpressSessionCredentials create(String accessKeyId, String secretAccessKey, String sessionToken) {
        return new DefaultS3ExpressSessionCredentials(accessKeyId, secretAccessKey, sessionToken);
    }

    public static S3ExpressSessionCredentials fromSessionResponse(SessionCredentials credentials) {
        return S3ExpressSessionCredentials.create(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken());
    }
}

