/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.installer;

import com.google.common.hash.Hashing;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.python.sdk.Binary;
import com.jetbrains.python.sdk.Resource;
import com.jetbrains.python.sdk.impl.PySdkBundle;
import com.jetbrains.python.sdk.installer.BinaryInstaller;
import com.jetbrains.python.sdk.installer.BinaryInstallerException;
import com.jetbrains.python.sdk.installer.BinaryInstallerKt;
import com.jetbrains.python.sdk.installer.CancelledPrepareException;
import com.jetbrains.python.sdk.installer.PrepareException;
import com.jetbrains.python.sdk.installer.ProcessException;
import com.jetbrains.python.sdk.installer.ResourcePreview;
import com.jetbrains.python.sdk.installer.WrongChecksumPrepareException;
import com.jetbrains.python.sdk.installer.WrongSizePrepareException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH&J$\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH&J&\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\rH\u0002J \u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/python/community/impl/installer/DownloadableBinaryInstaller;", "Lcom/jetbrains/python/sdk/installer/BinaryInstaller;", "<init>", "()V", "getResourcesToDownload", "", "Lcom/jetbrains/python/sdk/Resource;", "binary", "Lcom/jetbrains/python/sdk/Binary;", "process", "", "resourcePaths", "", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "install", "onPrepareComplete", "Lkotlin/Function0;", "checkConsistency", "resource", "target", "download", "getPreview", "Lcom/jetbrains/python/sdk/installer/ResourcePreview;", "intellij.python.community.impl.installer"})
@SourceDebugExtension(value={"SMAP\nDownloadableBinaryInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadableBinaryInstaller.kt\ncom/intellij/python/community/impl/installer/DownloadableBinaryInstaller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1285#2,2:107\n1299#2,4:109\n1869#2:115\n1870#2:117\n1869#2,2:118\n216#3,2:113\n1#4:116\n*S KotlinDebug\n*F\n+ 1 DownloadableBinaryInstaller.kt\ncom/intellij/python/community/impl/installer/DownloadableBinaryInstaller\n*L\n45#1:107,2\n45#1:109,4\n59#1:115\n59#1:117\n59#1:118,2\n50#1:113,2\n*E\n"})
public abstract class DownloadableBinaryInstaller
implements BinaryInstaller {
    @NotNull
    public abstract List<Resource> getResourcesToDownload(@NotNull Binary var1);

    public abstract void process(@NotNull Map<Resource, ? extends Path> var1, @NotNull ProgressIndicator var2) throws ProcessException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void install(@NotNull Binary binary, @NotNull ProgressIndicator indicator, @NotNull Function0<Unit> onPrepareComplete) throws BinaryInstallerException {
        Object object;
        Object resource;
        boolean bl;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(onPrepareComplete, (String)"onPrepareComplete");
        String string = PathManager.getTempPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempPath(...)");
        String tempPath = string;
        Iterable $this$associateWith$iv = this.getResourcesToDownload(binary);
        boolean $i$f$associateWith = false;
        Iterator result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Object destination$iv$iv = (Map)((Object)result$iv);
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : iterable) {
            void it;
            object2 = (Resource)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{System.nanoTime() + "-" + it.getFileName()};
            Path path = Paths.get(tempPath, stringArray);
            map.put(t, path);
        }
        Map files = destination$iv$iv;
        try {
            indicator.setText(PySdkBundle.message((String)"python.sdk.preparation.progress.text", (Object[])new Object[0]));
            $this$forEach$iv = files;
            $i$f$forEach = false;
            for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                destination$iv$iv = entry;
                bl = false;
                resource = (Resource)destination$iv$iv.getKey();
                Path path = (Path)destination$iv$iv.getValue();
                Intrinsics.checkNotNull((Object)path);
                this.download((Resource)resource, path, indicator);
            }
            onPrepareComplete.invoke();
            this.process(files, indicator);
        }
        catch (Throwable throwable) {
            Iterable $this$forEach$iv2 = files.values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Path it = (Path)element$iv;
                boolean bl3 = false;
                object = this;
                try {
                    DownloadableBinaryInstaller $this$install_u24lambda_u242_u240 = object;
                    boolean bl2 = false;
                    FileUtil.delete((Path)it);
                    object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
            }
            throw throwable;
        }
        $this$forEach$iv = files.values();
        $i$f$forEach = false;
        result$iv = $this$forEach$iv.iterator();
        while (result$iv.hasNext()) {
            Object t = result$iv.next();
            Path it = (Path)t;
            bl = false;
            resource = this;
            try {
                DownloadableBinaryInstaller $this$install_u24lambda_u242_u240 = (DownloadableBinaryInstaller)resource;
                boolean bl3 = false;
                FileUtil.delete((Path)it);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl3) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
        }
    }

    private final void checkConsistency(Resource resource, Path target) throws PrepareException {
        BinaryInstallerKt.getLOGGER().debug("Checking installer size");
        long sizeDiff = Files.size(target) - resource.getSize();
        if (sizeDiff != 0L) {
            throw new WrongSizePrepareException(target, sizeDiff);
        }
        BinaryInstallerKt.getLOGGER().debug("Checking installer checksum");
        String string = com.google.common.io.Files.asByteSource((File)target.toFile()).hash(Hashing.sha256()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String actualHashCode = string;
        if (!StringsKt.equals((String)resource.getSha256(), (String)actualHashCode, (boolean)true)) {
            throw new WrongChecksumPrepareException(target, resource.getSha256(), actualHashCode);
        }
    }

    private final void download(Resource resource, Path target, ProgressIndicator indicator) throws PrepareException {
        BinaryInstallerKt.getLOGGER().info("Downloading " + resource.getUrl() + " to " + target);
        String string = StringUtil.formatFileSize((long)resource.getSize());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String fileSizeHumanReadable = string;
        Object[] objectArray = new Object[]{fileSizeHumanReadable, resource.getFileName()};
        indicator.setText2(PySdkBundle.message((String)"python.sdk.downloading.progress.details", (Object[])objectArray));
        try {
            indicator.checkCanceled();
            HttpRequests.request((Url)resource.getUrl()).productNameAsUserAgent().saveToFile(target.toFile(), indicator);
            indicator.checkCanceled();
            this.checkConsistency(resource, target);
        }
        catch (ProcessCanceledException e) {
            throw new CancelledPrepareException(e);
        }
        catch (PrepareException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrepareException(e);
        }
    }

    @Override
    @NotNull
    public ResourcePreview getPreview(@NotNull Binary binary) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        return ResourcePreview.Companion.of((Resource)CollectionsKt.firstOrNull(this.getResourcesToDownload(binary)));
    }
}

