/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.Random;
import java.util.function.ToIntFunction;
import org.jetbrains.jetCheck.IntDistribution;

class BoundedIntDistribution
implements IntDistribution {
    static final IntDistribution ALL_INTS = IntDistribution.uniform(Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final int min;
    private final int max;
    private final ToIntFunction<Random> producer;

    BoundedIntDistribution(int min, int max, ToIntFunction<Random> producer2) {
        if (min > max) {
            throw new IllegalArgumentException(min + ">" + max);
        }
        this.min = min;
        this.max = max;
        this.producer = producer2;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public int generateInt(Random random) {
        int i2 = this.producer.applyAsInt(random);
        if (i2 < this.min || i2 > this.max) {
            throw new IllegalStateException("Int out of bounds produced by " + this.producer + ": " + i2 + " not in [" + this.min + ", " + this.max + "]");
        }
        return i2;
    }

    @Override
    public boolean isValidValue(int i2) {
        return i2 >= this.min && i2 <= this.max;
    }

    public static BoundedIntDistribution bound(int min, int max, final IntDistribution distribution) {
        return new BoundedIntDistribution(min, max, random -> Math.min(Math.max(distribution.generateInt((Random)random), min), max)){

            @Override
            public boolean isValidValue(int i2) {
                return super.isValidValue(i2) && distribution.isValidValue(i2);
            }
        };
    }
}

