/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.impl.RegExpCharImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpParser
implements PsiParser,
LightPsiParser {
    private static final TokenSet PROPERTY_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.NUMBER, RegExpTT.COMMA, RegExpTT.NAME, RegExpTT.RBRACE});
    private final EnumSet<RegExpCapability> myCapabilities;

    public RegExpParser(EnumSet<RegExpCapability> capabilities) {
        this.myCapabilities = capabilities;
    }

    public void parseLight(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        do {
            this.parsePattern(builder);
            if (builder.eof()) break;
            RegExpParser.patternExpected(builder);
        } while (!builder.eof());
        rootMarker.done(root);
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            RegExpParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            RegExpParser.$$$reportNull$$$0(1);
        }
        this.parseLight(root, builder);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            RegExpParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    protected void parsePattern(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        this.parseBranch(builder);
        while (builder.getTokenType() == RegExpTT.UNION) {
            builder.advanceLexer();
            this.parseBranch(builder);
        }
        marker.done(RegExpElementTypes.PATTERN);
    }

    private void parseBranch(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        while (!this.parseAtom(builder)) {
            IElementType token = builder.getTokenType();
            if (token == RegExpTT.GROUP_END || token == RegExpTT.UNION || token == null) {
                marker.done(RegExpElementTypes.BRANCH);
                return;
            }
            RegExpParser.patternExpected(builder);
        }
        while (this.parseAtom(builder)) {
        }
        marker.done(RegExpElementTypes.BRANCH);
    }

    private boolean parseAtom(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseGroup(builder);
        if (marker == null) {
            return false;
        }
        PsiBuilder.Marker marker2 = marker.precede();
        if (this.parseQuantifier(builder)) {
            marker2.done(RegExpElementTypes.CLOSURE);
        } else {
            marker2.drop();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseQuantifier(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.getTokenType() == RegExpTT.LBRACE) {
            PsiBuilder.Marker numberMark;
            boolean minOmitted;
            builder.advanceLexer();
            boolean bl = minOmitted = builder.getTokenType() == RegExpTT.COMMA && this.myCapabilities.contains((Object)RegExpCapability.OMIT_NUMBERS_IN_QUANTIFIERS);
            if (minOmitted) {
                builder.advanceLexer();
            } else if (builder.getTokenType() == RegExpTT.NUMBER) {
                numberMark = builder.mark();
                builder.advanceLexer();
                numberMark.done(RegExpElementTypes.NUMBER);
            } else {
                builder.error(RegExpBundle.message("parse.error.number.expected", new Object[0]));
            }
            if (builder.getTokenType() == RegExpTT.RBRACE) {
                builder.advanceLexer();
                RegExpParser.parseQuantifierType(builder);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            if (!minOmitted) {
                RegExpParser.checkMatches(builder, RegExpTT.COMMA, RegExpBundle.message("parse.error.comma.expected", new Object[0]));
            }
            if (builder.getTokenType() == RegExpTT.RBRACE) {
                builder.advanceLexer();
                RegExpParser.parseQuantifierType(builder);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            if (builder.getTokenType() == RegExpTT.NUMBER) {
                numberMark = builder.mark();
                builder.advanceLexer();
                numberMark.done(RegExpElementTypes.NUMBER);
                RegExpParser.checkMatches(builder, RegExpTT.RBRACE, RegExpBundle.message("parse.error.closing.brace.expected", new Object[0]));
                RegExpParser.parseQuantifierType(builder);
                marker.done(RegExpElementTypes.QUANTIFIER);
                return true;
            }
            builder.error(RegExpBundle.message("parse.error.closing.brace.or.number.expected", new Object[0]));
            marker.done(RegExpElementTypes.QUANTIFIER);
            return true;
        }
        if (RegExpTT.QUANTIFIERS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            RegExpParser.parseQuantifierType(builder);
            marker.done(RegExpElementTypes.QUANTIFIER);
            return true;
        }
        marker.drop();
        return false;
    }

    private static void parseQuantifierType(PsiBuilder builder) {
        if (builder.getTokenType() == RegExpTT.PLUS || builder.getTokenType() == RegExpTT.QUEST) {
            builder.advanceLexer();
        } else if (RegExpTT.QUANTIFIERS.contains(builder.getTokenType())) {
            builder.error(RegExpBundle.message("error.dangling.metacharacter", builder.getTokenText()));
        }
    }

    private PsiBuilder.Marker parseClass(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == RegExpTT.CARET) {
            builder.advanceLexer();
        }
        this.parseClassIntersection(builder);
        RegExpParser.checkMatches(builder, RegExpTT.CLASS_END, RegExpBundle.message("parse.error.unclosed.character.class", new Object[0]));
        marker.done(RegExpElementTypes.CLASS);
        return marker;
    }

    private void parseClassIntersection(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        boolean left = this.parseClassdef(builder);
        if (RegExpTT.ANDAND != builder.getTokenType()) {
            marker.drop();
            return;
        }
        while (RegExpTT.ANDAND == builder.getTokenType()) {
            builder.advanceLexer();
            boolean right = this.parseClassdef(builder);
            if (!left && !right) {
                builder.error(RegExpBundle.message("parse.error.character.class.expected", new Object[0]));
            }
            left = right;
        }
        marker.done(RegExpElementTypes.INTERSECTION);
    }

    private boolean parseClassdef(PsiBuilder builder) {
        int count = 0;
        while (true) {
            IElementType token;
            if ((token = builder.getTokenType()) == RegExpTT.CLASS_BEGIN) {
                this.parseClass(builder);
            } else if (token == RegExpTT.BRACKET_EXPRESSION_BEGIN) {
                RegExpParser.parseBracketExpression(builder);
            } else if (token == RegExpTT.MYSQL_CHAR_BEGIN) {
                RegExpParser.parseMysqlCharExpression(builder);
            } else if (token == RegExpTT.MYSQL_CHAR_EQ_BEGIN) {
                RegExpParser.parseMysqlCharEqExpression(builder);
            } else if (RegExpTT.CHARACTERS.contains(token) || token == RegExpTT.NAMED_CHARACTER) {
                this.parseCharacterRange(builder);
            } else if (token == RegExpTT.CHAR_CLASS) {
                PsiBuilder.Marker m = builder.mark();
                builder.advanceLexer();
                m.done(RegExpElementTypes.SIMPLE_CLASS);
            } else if (token == RegExpTT.PROPERTY) {
                this.parseProperty(builder);
            } else {
                return count > 0;
            }
            ++count;
        }
    }

    private static void parseBracketExpression(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == RegExpTT.CARET) {
            builder.advanceLexer();
        }
        RegExpParser.checkMatches(builder, RegExpTT.NAME, RegExpBundle.message("parse.error.posix.character.class.name.expected", new Object[0]));
        RegExpParser.checkMatches(builder, RegExpTT.BRACKET_EXPRESSION_END, RegExpBundle.message("parse.error.unclosed.posix.bracket.expression", new Object[0]));
        marker.done(RegExpElementTypes.POSIX_BRACKET_EXPRESSION);
    }

    private static void parseMysqlCharExpression(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == RegExpTT.NAME) {
            builder.advanceLexer();
        } else {
            RegExpParser.checkMatches(builder, RegExpTT.CHARACTER, RegExpBundle.message("parse.error.character.or.mysql.character.name.expected", new Object[0]));
        }
        RegExpParser.checkMatches(builder, RegExpTT.MYSQL_CHAR_END, RegExpBundle.message("parse.error.unclosed.mysql.character.expression", new Object[0]));
        marker.done(RegExpElementTypes.MYSQL_CHAR_EXPRESSION);
    }

    private static void parseMysqlCharEqExpression(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        RegExpParser.checkMatches(builder, RegExpTT.CHARACTER, RegExpBundle.message("parse.error.character.expected", new Object[0]));
        RegExpParser.checkMatches(builder, RegExpTT.MYSQL_CHAR_EQ_END, RegExpBundle.message("parse.error.unclosed.mysql.character.equivalence.class", new Object[0]));
        marker.done(RegExpElementTypes.MYSQL_CHAR_EQ_EXPRESSION);
    }

    private void parseCharacterRange(PsiBuilder builder) {
        PsiBuilder.Marker rangeMarker = builder.mark();
        RegExpParser.parseCharacter(builder);
        if (builder.getTokenType() == RegExpTT.MINUS) {
            PsiBuilder.Marker minusMarker = builder.mark();
            builder.advanceLexer();
            IElementType t = builder.getTokenType();
            if (RegExpTT.CHARACTERS.contains(t) || t == RegExpTT.NAMED_CHARACTER) {
                minusMarker.drop();
                RegExpParser.parseCharacter(builder);
                rangeMarker.done(RegExpElementTypes.CHAR_RANGE);
            } else if (t == RegExpTT.CLASS_END) {
                rangeMarker.drop();
                minusMarker.done(RegExpElementTypes.CHAR);
            } else if (t == RegExpTT.CLASS_BEGIN) {
                rangeMarker.drop();
                minusMarker.done(RegExpElementTypes.CHAR);
                this.parseClassdef(builder);
            } else {
                minusMarker.drop();
                builder.error(RegExpBundle.message("parse.error.illegal.character.range", new Object[0]));
                rangeMarker.done(RegExpElementTypes.CHAR_RANGE);
            }
        } else {
            rangeMarker.drop();
        }
    }

    @Nullable
    private PsiBuilder.Marker parseGroup(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        PsiBuilder.Marker marker = builder.mark();
        if (RegExpTT.GROUPS.contains(type)) {
            builder.advanceLexer();
            this.parseGroupEnd(builder);
            marker.done(RegExpElementTypes.GROUP);
        } else if (type == RegExpTT.SET_OPTIONS) {
            PsiBuilder.Marker o;
            builder.advanceLexer();
            if (builder.getTokenType() == RegExpTT.OPTIONS_ON) {
                o = builder.mark();
                builder.advanceLexer();
                o.done(RegExpElementTypes.OPTIONS);
            }
            if (builder.getTokenType() == RegExpTT.OPTIONS_OFF) {
                o = builder.mark();
                builder.advanceLexer();
                o.done(RegExpElementTypes.OPTIONS);
            }
            if (builder.getTokenType() == RegExpTT.COLON) {
                builder.advanceLexer();
                this.parseGroupEnd(builder);
                marker.done(RegExpElementTypes.GROUP);
            } else {
                RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, RegExpBundle.message("parse.error.unclosed.options.group", new Object[0]));
                marker.done(RegExpElementTypes.SET_OPTIONS);
            }
        } else if (RegExpTT.CHARACTERS.contains(type) || type == RegExpTT.NAMED_CHARACTER) {
            marker.drop();
            RegExpParser.parseCharacter(builder);
        } else if (type == RegExpTT.NUMBER || type == RegExpTT.COMMA) {
            builder.remapCurrentToken(RegExpTT.CHARACTER);
            builder.advanceLexer();
            marker.done(RegExpElementTypes.CHAR);
        } else if (RegExpTT.BOUNDARIES.contains(type)) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.BOUNDARY);
        } else if (type == RegExpTT.BACKREF) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.BACKREF);
        } else if (type == RegExpTT.PYTHON_NAMED_GROUP || type == RegExpTT.RUBY_NAMED_GROUP || type == RegExpTT.RUBY_QUOTED_NAMED_GROUP) {
            builder.advanceLexer();
            RegExpParser.checkMatches(builder, RegExpTT.NAME, RegExpBundle.message("parse.error.group.name.expected", new Object[0]));
            RegExpParser.checkMatches(builder, type == RegExpTT.RUBY_QUOTED_NAMED_GROUP ? RegExpTT.QUOTE : RegExpTT.GT, RegExpBundle.message("parse.error.unclosed.group.name", new Object[0]));
            this.parseGroupEnd(builder);
            marker.done(RegExpElementTypes.GROUP);
        } else if (type == RegExpTT.PYTHON_NAMED_GROUP_REF || type == RegExpTT.PCRE_RECURSIVE_NAMED_GROUP_REF) {
            RegExpParser.parseNamedGroupRef(builder, marker, RegExpTT.GROUP_END);
        } else if (type == RegExpTT.PCRE_NUMBERED_GROUP_REF) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.BACKREF);
        } else if (type == RegExpTT.RUBY_NAMED_GROUP_REF || type == RegExpTT.RUBY_NAMED_GROUP_CALL) {
            RegExpParser.parseNamedGroupRef(builder, marker, RegExpTT.GT);
        } else if (type == RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF || type == RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL) {
            RegExpParser.parseNamedGroupRef(builder, marker, RegExpTT.QUOTE);
        } else if (type == RegExpTT.CONDITIONAL) {
            builder.advanceLexer();
            this.parseCondition(builder);
            this.parseBranch(builder);
            if (builder.getTokenType() == RegExpTT.UNION) {
                builder.advanceLexer();
                this.parseBranch(builder);
            }
            if (!RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, RegExpBundle.message("parse.error.unclosed.group", new Object[0]))) {
                this.parseGroupEnd(builder);
            }
            marker.done(RegExpElementTypes.CONDITIONAL);
        } else if (type == RegExpTT.PROPERTY) {
            marker.drop();
            this.parseProperty(builder);
        } else if (type == RegExpTT.DOT || type == RegExpTT.CHAR_CLASS) {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.SIMPLE_CLASS);
        } else {
            if (type == RegExpTT.CLASS_BEGIN) {
                marker.drop();
                return this.parseClass(builder);
            }
            marker.drop();
            return null;
        }
        return marker;
    }

    private void parseCondition(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        if (RegExpTT.LOOKAROUND_GROUPS.contains(type)) {
            PsiBuilder.Marker marker = builder.mark();
            builder.advanceLexer();
            this.parseGroupEnd(builder);
            marker.done(RegExpElementTypes.GROUP);
        } else if (RegExpTT.GROUP_BEGIN == type) {
            IElementType lookAhead = builder.lookAhead(1);
            if (RegExpTT.PCRE_CONDITIONS.contains(lookAhead)) {
                RegExpParser.parsePcreConditionalGroup(builder);
            } else {
                this.parseGroupReferenceCondition(builder, RegExpTT.GROUP_END);
            }
        } else if (RegExpTT.QUOTED_CONDITION_BEGIN == type) {
            this.parseGroupReferenceCondition(builder, RegExpTT.QUOTED_CONDITION_END);
        } else if (RegExpTT.ANGLE_BRACKET_CONDITION_BEGIN == type) {
            this.parseGroupReferenceCondition(builder, RegExpTT.ANGLE_BRACKET_CONDITION_END);
        }
    }

    private void parseGroupReferenceCondition(PsiBuilder builder, IElementType endToken) {
        Boolean named;
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        IElementType next = builder.getTokenType();
        if (next == RegExpTT.NAME) {
            builder.advanceLexer();
            named = true;
        } else if (next == RegExpTT.NUMBER) {
            builder.advanceLexer();
            named = false;
        } else {
            named = null;
            builder.error(RegExpBundle.message("parse.error.group.name.or.number.expected", new Object[0]));
            this.parsePattern(builder);
        }
        RegExpParser.checkMatches(builder, endToken, RegExpBundle.message("parse.error.unclosed.group.reference", new Object[0]));
        if (named == Boolean.TRUE) {
            marker.done(RegExpElementTypes.NAMED_GROUP_REF);
        } else if (named == Boolean.FALSE) {
            marker.done(RegExpElementTypes.BACKREF);
        } else {
            marker.drop();
        }
    }

    private void parseGroupEnd(PsiBuilder builder) {
        this.parsePattern(builder);
        RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, RegExpBundle.message("parse.error.unclosed.group", new Object[0]));
    }

    private static void parsePcreConditionalGroup(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        builder.advanceLexer();
        RegExpParser.checkMatches(builder, RegExpTT.GROUP_END, RegExpBundle.message("parse.error.unclosed.group.reference", new Object[0]));
        marker.done(RegExpElementTypes.GROUP);
    }

    private static void parseNamedGroupRef(PsiBuilder builder, PsiBuilder.Marker marker, IElementType type) {
        builder.advanceLexer();
        RegExpParser.checkMatches(builder, RegExpTT.NAME, RegExpBundle.message("parse.error.group.name.expected", new Object[0]));
        RegExpParser.checkMatches(builder, type, RegExpBundle.message("parse.error.unclosed.group.reference", new Object[0]));
        marker.done(RegExpElementTypes.NAMED_GROUP_REF);
    }

    private static boolean isLetter(CharSequence text) {
        if (text == null) {
            return false;
        }
        assert (text.length() == 1);
        char c = text.charAt(0);
        return AsciiUtil.isLetter(c);
    }

    private void parseProperty(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == RegExpTT.CATEGORY_SHORT_HAND) {
            if (!this.myCapabilities.contains((Object)RegExpCapability.UNICODE_CATEGORY_SHORTHAND)) {
                builder.error(RegExpBundle.message("parse.error.category.shorthand.not.allowed.in.this.regular.expression.dialect", new Object[0]));
            }
            builder.advanceLexer();
        } else if (builder.getTokenType() == RegExpTT.CHARACTER && RegExpParser.isLetter(builder.getTokenText())) {
            builder.error(this.myCapabilities.contains((Object)RegExpCapability.UNICODE_CATEGORY_SHORTHAND) ? RegExpBundle.message("parse.error.illegal.category.shorthand", new Object[0]) : RegExpBundle.message("parse.error.opening.brace.expected", new Object[0]));
            builder.advanceLexer();
        } else if (RegExpParser.checkMatches(builder, RegExpTT.LBRACE, this.myCapabilities.contains((Object)RegExpCapability.UNICODE_CATEGORY_SHORTHAND) ? RegExpBundle.message("parse.error.opening.brace.or.category.shorthand.expected", new Object[0]) : RegExpBundle.message("parse.error.opening.brace.expected", new Object[0]))) {
            if (builder.getTokenType() == RegExpTT.CARET) {
                if (!this.myCapabilities.contains((Object)RegExpCapability.CARET_NEGATED_PROPERTIES)) {
                    builder.error(RegExpBundle.message("parse.error.negating.a.property.not.allowed.in.this.regular.expression.dialect", new Object[0]));
                }
                builder.advanceLexer();
            }
            if (builder.getTokenType() == RegExpTT.NAME) {
                builder.advanceLexer();
                if (this.myCapabilities.contains((Object)RegExpCapability.PROPERTY_VALUES) && builder.getTokenType() == RegExpTT.EQ) {
                    builder.advanceLexer();
                    RegExpParser.checkMatches(builder, RegExpTT.NAME, RegExpBundle.message("parse.error.property.value.expected", new Object[0]));
                }
                RegExpParser.checkMatches(builder, RegExpTT.RBRACE, RegExpBundle.message("parse.error.unclosed.property", new Object[0]));
            } else {
                if (builder.getTokenType() == RegExpTT.RBRACE) {
                    builder.error(RegExpBundle.message("parse.error.empty.property", new Object[0]));
                    builder.advanceLexer();
                } else {
                    builder.error(RegExpBundle.message("parse.error.property.name.expected", new Object[0]));
                }
                while (PROPERTY_TOKENS.contains(builder.getTokenType())) {
                    builder.advanceLexer();
                }
            }
        }
        marker.done(RegExpElementTypes.PROPERTY);
    }

    private static void parseCharacter(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.getTokenType() == RegExpTT.NAMED_CHARACTER) {
            builder.advanceLexer();
            RegExpParser.checkMatches(builder, RegExpTT.LBRACE, RegExpBundle.message("parse.error.opening.brace.expected", new Object[0]));
            RegExpParser.checkMatches(builder, RegExpTT.NAME, RegExpBundle.message("parse.error.unicode.character.name.expected", new Object[0]));
            RegExpParser.checkMatches(builder, RegExpTT.RBRACE, RegExpBundle.message("parse.error.closing.brace.expected", new Object[0]));
            marker.done(RegExpElementTypes.NAMED_CHARACTER);
        } else if (builder.getTokenType() == RegExpTT.UNICODE_CHAR) {
            int value2;
            String text2;
            String text1 = builder.getTokenText();
            assert (text1 != null);
            int value1 = RegExpCharImpl.unescapeChar(text1);
            builder.advanceLexer();
            if (!Character.isSupplementaryCodePoint(value1) && Character.isHighSurrogate((char)value1) && (text2 = builder.getTokenText()) != null && !Character.isSupplementaryCodePoint(value2 = RegExpCharImpl.unescapeChar(text2)) && Character.isLowSurrogate((char)value2)) {
                builder.advanceLexer();
            }
            marker.done(RegExpElementTypes.CHAR);
        } else {
            builder.advanceLexer();
            marker.done(RegExpElementTypes.CHAR);
        }
    }

    private static void patternExpected(PsiBuilder builder) {
        IElementType token = builder.getTokenType();
        if (token == RegExpTT.GROUP_END || token == RegExpTT.RBRACE || token == RegExpTT.CLASS_END) {
            builder.error(RegExpBundle.message("parse.error.unmatched.closing.bracket", builder.getTokenText()));
        } else if (token == RegExpTT.LBRACE) {
            builder.error(RegExpBundle.message("error.dangling.opening.bracket", new Object[0]));
            builder.advanceLexer();
            while (builder.getTokenType() == RegExpTT.NUMBER || builder.getTokenType() == RegExpTT.COMMA) {
                builder.advanceLexer();
            }
            if (builder.getTokenType() == RegExpTT.RBRACE) {
                builder.advanceLexer();
            }
        } else if (RegExpTT.QUANTIFIERS.contains(token)) {
            builder.error(RegExpBundle.message("error.dangling.metacharacter", builder.getTokenText()));
        } else {
            builder.error(RegExpBundle.message("parse.error.pattern.expected", new Object[0]));
        }
        builder.advanceLexer();
    }

    protected static boolean checkMatches(PsiBuilder builder, IElementType token, @NlsContexts.ParsingError @NotNull String message) {
        if (message == null) {
            RegExpParser.$$$reportNull$$$0(3);
        }
        if (builder.getTokenType() == token) {
            builder.advanceLexer();
            return true;
        }
        builder.error(message);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/RegExpParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/RegExpParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkMatches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

