/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.pyi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecorator;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyiUtil {
    private PyiUtil() {
    }

    public static boolean isInsideStub(@NotNull PsiElement element) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(0);
        }
        return PyiUtilCore.isInsideStub((PsiElement)element);
    }

    @Nullable
    public static PsiElement getPythonStub(@NotNull PyElement element) {
        PyiFile pythonStubFile;
        PsiFile file;
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(1);
        }
        if (PyiUtil.pyButNotPyiFile(file = element.getContainingFile()) && (pythonStubFile = PyiUtil.getPythonStubFile((PyFile)file)) != null) {
            return PyiUtil.findSimilarElement(element, pythonStubFile);
        }
        return null;
    }

    @Nullable
    public static PsiElement getOriginalElement(@NotNull PyElement element) {
        PyClass containingClass;
        String typingRedirection;
        PyClass elementClass;
        PyClass pyClass;
        PsiFile file;
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(2);
        }
        if (!((file = element.getContainingFile()) instanceof PyiFile)) {
            return null;
        }
        PyClass pyClass2 = pyClass = element instanceof PyClass ? (elementClass = (PyClass)element) : (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        if (pyClass != null && (typingRedirection = PyTypeShed.INSTANCE.getTypingRedirections().get(pyClass.getQualifiedName())) != null) {
            List<PsiElement> result = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)typingRedirection), PyResolveImportUtil.fromFoothold((PsiElement)element).copyWithoutStubs().copyWithMembers());
            if (result.isEmpty()) {
                return null;
            }
            return result.get(0);
        }
        PyFile originalFile = PyiUtil.getOriginalFile((PyiFile)file);
        if (originalFile == null) {
            return null;
        }
        PsiElement result = PyiUtil.findSimilarElement(element, originalFile);
        if (result instanceof PyElement && PyiUtil.isInsideStub(result) && result.getContainingFile() != file) {
            result = PyiUtil.getOriginalElement((PyElement)result);
        }
        if (result != null) {
            return result;
        }
        if (element instanceof PyFunction && (containingClass = PyUtil.turnConstructorIntoClass((PyFunction)element)) != null) {
            result = PyiUtil.findSimilarElement((PyElement)containingClass, originalFile);
        }
        return result;
    }

    @Nullable
    public static PyFunction getImplementation(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        PsiFile file;
        if (function == null) {
            PyiUtil.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(4);
        }
        if ((file = function.getContainingFile()) instanceof PyiFile) {
            return null;
        }
        return (PyFunction)ContainerUtil.getLastItem(PyiUtil.collectImplementationsOrOverloads(function, true, context));
    }

    @NotNull
    public static List<PyFunction> getOverloads(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyiUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(6);
        }
        return PyiUtil.collectImplementationsOrOverloads(function, false, context);
    }

    public static boolean isOverload(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(8);
        }
        PyKnownDecorator overload = PyKnownDecorator.TYPING_OVERLOAD;
        return element instanceof PyFunction && PyKnownDecoratorUtil.getKnownDecorators((PyDecoratable)((PyFunction)element), context).contains(overload);
    }

    @NotNull
    public static <T extends PyElement> T getOriginalElementOrLeaveAsIs(@NotNull T element, @NotNull Class<T> cls) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(9);
        }
        if (cls == null) {
            PyiUtil.$$$reportNull$$$0(10);
        }
        PyElement pyElement = (PyElement)ObjectUtils.notNull((Object)((PyElement)PyUtil.as(PyiUtil.getOriginalElement(element), cls)), element);
        if (pyElement == null) {
            PyiUtil.$$$reportNull$$$0(11);
        }
        return (T)pyElement;
    }

    public static boolean isPyiFileOfPackage(@NotNull PsiElement element) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(12);
        }
        return element instanceof PyiFile || PyUtil.turnDirIntoInitPyi(element) instanceof PyiFile;
    }

    private static boolean pyButNotPyiFile(@Nullable PsiFile file) {
        return file instanceof PyFile && !(file instanceof PyiFile);
    }

    @Nullable
    private static PyiFile getPythonStubFile(@NotNull PyFile file) {
        QualifiedName name;
        if (file == null) {
            PyiUtil.$$$reportNull$$$0(13);
        }
        if ((name = QualifiedNameFinder.findCanonicalImportPath((PsiElement)file, (PsiElement)file)) == null) {
            return null;
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromFoothold((PsiElement)file);
        return PyUtil.as(PyResolveImportUtil.resolveQualifiedName(name, context).stream().findFirst().map(PyUtil::turnDirIntoInitPyi).orElse(null), PyiFile.class);
    }

    @Nullable
    private static PyFile getOriginalFile(@NotNull PyiFile file) {
        QualifiedName name;
        if (file == null) {
            PyiUtil.$$$reportNull$$$0(14);
        }
        if ((name = QualifiedNameFinder.findCanonicalImportPath((PsiElement)file, (PsiElement)file)) == null) {
            return null;
        }
        String moduleRedirect = PyTypeShed.INSTANCE.getTypeshedModuleRedirections().get(name.toString());
        if (moduleRedirect != null) {
            name = QualifiedName.fromDottedString((String)moduleRedirect);
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromFoothold((PsiElement)file).copyWithoutStubs();
        return PyUtil.as(PyResolveImportUtil.resolveQualifiedName(name, context).stream().findFirst().map(PyUtil::turnDirIntoInitPy).orElse(null), PyFile.class);
    }

    @Nullable
    private static PsiElement findSimilarElement(@NotNull PyElement element, @NotNull PyFile file) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(15);
        }
        if (file == null) {
            PyiUtil.$$$reportNull$$$0(16);
        }
        if (element instanceof PyFile) {
            return file;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
        String name = element.getName();
        if (owner != null && name != null) {
            assert (owner != element);
            PsiElement originalOwner = PyiUtil.findSimilarElement((PyElement)owner, file);
            if (originalOwner instanceof PyTypedElement) {
                TypeEvalContext context = TypeEvalContext.codeInsightFallback((Project)file.getProject());
                PyType type = context.getType((PyTypedElement)originalOwner);
                PsiElement result = PyiUtil.resolveSimilarMember(type, name, context);
                return result == element ? null : result;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveSimilarMember(@Nullable PyType similarOwnerType, @NotNull String name, @NotNull TypeEvalContext context) {
        if (name == null) {
            PyiUtil.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(18);
        }
        if (similarOwnerType == null) {
            return null;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
        List results = similarOwnerType instanceof PyClassLikeType ? ((PyClassLikeType)similarOwnerType).resolveMember(name, null, AccessDirection.READ, resolveContext, false) : similarOwnerType.resolveMember(name, null, AccessDirection.READ, resolveContext);
        return PyiUtil.takeTopPriorityElement(results);
    }

    @NotNull
    private static List<PyFunction> collectImplementationsOrOverloads(@NotNull PyFunction function, boolean implementations, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyiUtil.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(20);
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)function);
        String name = function.getName();
        ArrayList<PyFunction> result = new ArrayList<PyFunction>();
        Processor overloadsProcessor = f -> {
            if (name != null && name.equals(f.getName()) && implementations ^ PyiUtil.isOverload((PsiElement)f, context)) {
                result.add((PyFunction)f);
            }
            return true;
        };
        if (owner instanceof PyClass) {
            PyClass cls = (PyClass)owner;
            if (name != null) {
                cls.visitMethods(overloadsProcessor, false, context);
            }
        } else if (owner instanceof PyFile) {
            PyFunction f2;
            PyFile file = (PyFile)owner;
            Iterator iterator = file.getTopLevelFunctions().iterator();
            while (iterator.hasNext() && overloadsProcessor.process((Object)(f2 = (PyFunction)iterator.next()))) {
            }
        }
        ArrayList<PyFunction> arrayList = result;
        if (arrayList == null) {
            PyiUtil.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement takeTopPriorityElement(@Nullable List<? extends RatedResolveResult> resolveResults) {
        if (!ContainerUtil.isEmpty(resolveResults)) {
            return Collections.max(resolveResults, Comparator.comparingInt(RatedResolveResult::getRate)).getElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/pyi/PyiUtil";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/pyi/PyiUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalElementOrLeaveAsIs";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImplementationsOrOverloads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStub";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPythonStub";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImplementation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOverloads";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isOverload";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElementOrLeaveAsIs";
                break;
            }
            case 11: 
            case 21: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPyiFileOfPackage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPythonStubFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findSimilarElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimilarMember";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectImplementationsOrOverloads";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 21 -> new IllegalStateException(string);
        };
    }
}

