/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\b\u0007\u0018\u0000 D2\u00020\u0001:\u0002DEB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001bH\u0002J\b\u0010#\u001a\u00020 H\u0002J\u0018\u0010$\u001a\u00020 2\b\b\u0002\u0010%\u001a\u00020\u001bH\u0087@\u00a2\u0006\u0002\u0010&J\u0014\u0010'\u001a\u0004\u0018\u00010\u00122\b\u0010(\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u0010)\u001a\u0004\u0018\u00010\u00122\b\u0010(\u001a\u0004\u0018\u00010\u0011J\u001a\u0010'\u001a\u0004\u0018\u00010\u00122\b\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010*\u001a\u00020\u001bJ\u001a\u0010'\u001a\u0004\u0018\u00010\u00122\b\u0010(\u001a\u0004\u0018\u00010+2\u0006\u0010*\u001a\u00020\u001bJ\u0012\u0010,\u001a\u0004\u0018\u00010\u00122\b\u0010(\u001a\u0004\u0018\u00010\u0011J\u0012\u0010,\u001a\u0004\u0018\u00010\u00122\b\u0010(\u001a\u0004\u0018\u00010+J\u0012\u0010-\u001a\u0004\u0018\u00010\u00122\b\u0010.\u001a\u0004\u0018\u00010+J\u0014\u0010/\u001a\u0004\u0018\u00010\u00112\b\u0010.\u001a\u0004\u0018\u00010+H\u0002J\b\u00100\u001a\u00020 H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u00122\b\u00101\u001a\u0004\u0018\u00010\u0011J\u0012\u00102\u001a\u0004\u0018\u00010\u00122\b\u00101\u001a\u0004\u0018\u00010\u0011J\u001c\u00102\u001a\u0004\u0018\u00010\u00122\b\u00101\u001a\u0004\u0018\u00010\u00112\u0006\u00103\u001a\u00020\u001bH\u0002J\u0016\u00104\u001a\u00020 2\u0006\u00101\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u0012J\u000e\u00106\u001a\u00020 2\u0006\u00101\u001a\u00020\u0011J\u000e\u00107\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u0012J\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001209J\u0014\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120;H\u0002J\u0012\u0010<\u001a\u00020 2\b\u0010=\u001a\u0004\u0018\u00010\u0011H\u0003J\"\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120;2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00110@H\u0002J\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020\u0011092\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001209H\u0002J\b\u0010B\u001a\u00020\u0017H\u0016J\b\u0010C\u001a\u00020 H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/dvcs/repo/VcsRepositoryManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "kotlin.jvm.PlatformType", "REPO_LOCK", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "MODIFY_LOCK", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", "repositories", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/dvcs/repo/Repository;", "Lkotlin/collections/HashMap;", "externalRepositories", "pathToRootMap", "", "", "updateAlarm", "Lcom/intellij/util/Alarm;", "isDisposed", "", "isStarted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "updateScheduled", "dispose", "", "disposeAllRepositories", "disposeExternal", "scheduleUpdate", "ensureUpToDate", "force", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRepositoryForFile", "file", "getRepositoryForFileQuick", "quick", "Lcom/intellij/openapi/vcs/FilePath;", "getExternalRepositoryForFile", "getRepositoryForRootQuick", "rootPath", "getVirtualFileForRoot", "updatePathToRootMap", "root", "getRepositoryForRoot", "updateIfNeeded", "addExternalRepository", "repository", "removeExternalRepository", "isExternal", "getRepositories", "", "getExternalRepositories", "", "checkAndUpdateRepositoryCollection", "checkedRoot", "findNewRoots", "knownRoots", "", "findInvalidRoots", "toString", "waitForAsyncTaskCompletion", "Companion", "MyStartupActivity", "intellij.platform.vcs.dvcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsRepositoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsRepositoryManager.kt\ncom/intellij/dvcs/repo/VcsRepositoryManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,434:1\n14#2:435\n*S KotlinDebug\n*F\n+ 1 VcsRepositoryManager.kt\ncom/intellij/dvcs/repo/VcsRepositoryManager\n*L\n87#1:435\n*E\n"})
public final class VcsRepositoryManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private final ProjectLevelVcsManager vcsManager;
    @NotNull
    private final ReentrantReadWriteLock REPO_LOCK;
    private final ReentrantReadWriteLock.WriteLock MODIFY_LOCK;
    @NotNull
    private final HashMap<VirtualFile, Repository> repositories;
    @NotNull
    private final HashMap<VirtualFile, Repository> externalRepositories;
    @NotNull
    private final Map<String, VirtualFile> pathToRootMap;
    @NotNull
    private final Alarm updateAlarm;
    private volatile boolean isDisposed;
    @NotNull
    private final AtomicBoolean isStarted;
    @NotNull
    private final AtomicBoolean updateScheduled;
    @JvmField
    @NotNull
    public static final ExtensionPointName<VcsRepositoryCreator> EP_NAME = new ExtensionPointName("com.intellij.vcsRepositoryCreator");
    @NotNull
    private static final Logger LOG;
    @Topic.ProjectLevel
    @JvmField
    @NotNull
    public static final Topic<VcsRepositoryMappingListener> VCS_REPOSITORY_MAPPING_UPDATED;

    @ApiStatus.Internal
    public VcsRepositoryManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.vcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        this.REPO_LOCK = new ReentrantReadWriteLock();
        this.MODIFY_LOCK = new ReentrantReadWriteLock().writeLock();
        this.repositories = new HashMap();
        this.externalRepositories = new HashMap();
        Map map = CollectionFactory.createFilePathMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createFilePathMap(...)");
        this.pathToRootMap = map;
        this.isStarted = new AtomicBoolean(false);
        this.updateScheduled = new AtomicBoolean(false);
        SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().connect(this.coroutineScope);
        Topic topic = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VCS_CONFIGURATION_CHANGED");
        simpleMessageBusConnection.subscribe(topic, () -> VcsRepositoryManager._init_$lambda$0(this));
        EP_NAME.addChangeListener(this.coroutineScope, () -> VcsRepositoryManager._init_$lambda$1(this));
        this.updateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, null, null, this.coroutineScope);
    }

    public void dispose() {
        this.isDisposed = true;
        this.disposeAllRepositories(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void disposeAllRepositories(boolean disposeExternal) {
        this.REPO_LOCK.writeLock().lock();
        try {
            Repository repo;
            Iterator<Repository> iterator = this.repositories.values().iterator();
            while (iterator.hasNext()) {
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                Disposer.dispose((Disposable)repo);
            }
            this.repositories.clear();
            if (disposeExternal) {
                iterator = this.externalRepositories.values().iterator();
                while (iterator.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                    Disposer.dispose((Disposable)repo);
                }
                this.externalRepositories.clear();
            }
            this.updatePathToRootMap();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    private final void scheduleUpdate() {
        if (!this.isStarted.get() || this.isDisposed) {
            return;
        }
        if (this.updateScheduled.compareAndSet(false, true)) {
            this.updateAlarm.addRequest(() -> VcsRepositoryManager.scheduleUpdate$lambda$2(this), 100);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public final Object ensureUpToDate(boolean force, @NotNull Continuation<? super Unit> $completion) {
        boolean wasNotStarted = this.isStarted.compareAndSet(false, true);
        if (wasNotStarted || force) {
            this.updateScheduled.set(true);
            this.updateAlarm.addRequest(() -> VcsRepositoryManager.ensureUpToDate$lambda$3(this), 0);
        }
        CompletableDeferred waiter = CompletableDeferredKt.CompletableDeferred((Job)JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()));
        this.updateAlarm.addRequest(() -> VcsRepositoryManager.ensureUpToDate$lambda$4(waiter), 10);
        Object object = waiter.join($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object ensureUpToDate$default(VcsRepositoryManager vcsRepositoryManager, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return vcsRepositoryManager.ensureUpToDate(bl, (Continuation<? super Unit>)continuation);
    }

    @RequiresBackgroundThread
    @Nullable
    public final Repository getRepositoryForFile(@Nullable VirtualFile file) {
        return this.getRepositoryForFile(file, false);
    }

    @Nullable
    public final Repository getRepositoryForFileQuick(@Nullable VirtualFile file) {
        return this.getRepositoryForFile(file, true);
    }

    @Nullable
    public final Repository getRepositoryForFile(@Nullable VirtualFile file, boolean quick) {
        VcsRoot vcsRoot = this.vcsManager.getVcsRootObjectFor(file);
        if (vcsRoot == null) {
            return this.getExternalRepositoryForFile(file);
        }
        VcsRoot vcsRoot2 = vcsRoot;
        return quick ? this.getRepositoryForRootQuick(vcsRoot2.getPath()) : this.getRepositoryForRoot(vcsRoot2.getPath());
    }

    @Nullable
    public final Repository getRepositoryForFile(@Nullable FilePath file, boolean quick) {
        VcsRoot vcsRoot = this.vcsManager.getVcsRootObjectFor(file);
        if (vcsRoot == null) {
            return this.getExternalRepositoryForFile(file);
        }
        VcsRoot vcsRoot2 = vcsRoot;
        return quick ? this.getRepositoryForRootQuick(vcsRoot2.getPath()) : this.getRepositoryForRoot(vcsRoot2.getPath());
    }

    @Nullable
    public final Repository getExternalRepositoryForFile(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
        for (Map.Entry<VirtualFile, Repository> entry : repositories.entrySet()) {
            VirtualFile key = entry.getKey();
            Repository value = entry.getValue();
            if (!key.isValid() || !VfsUtilCore.isAncestor((VirtualFile)key, (VirtualFile)file, (boolean)false)) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public final Repository getExternalRepositoryForFile(@Nullable FilePath file) {
        if (file == null) {
            return null;
        }
        Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
        for (Map.Entry<VirtualFile, Repository> entry : repositories.entrySet()) {
            VirtualFile key = entry.getKey();
            Repository value = entry.getValue();
            if (!key.isValid() || !FileUtil.isAncestor((String)key.getPath(), (String)file.getPath(), (boolean)false)) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public final Repository getRepositoryForRootQuick(@Nullable FilePath rootPath) {
        VirtualFile virtualFile = this.getVirtualFileForRoot(rootPath);
        if (virtualFile == null) {
            return null;
        }
        return this.getRepositoryForRoot(virtualFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VirtualFile getVirtualFileForRoot(FilePath rootPath) {
        if (rootPath == null) {
            return null;
        }
        this.REPO_LOCK.readLock().lock();
        try {
            VirtualFile virtualFile = this.pathToRootMap.get(rootPath.getPath());
            return virtualFile;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    private final void updatePathToRootMap() {
        VirtualFile root;
        this.pathToRootMap.clear();
        Iterator<VirtualFile> iterator = this.repositories.keySet().iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            String string = root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.pathToRootMap.put(string, root);
        }
        iterator = this.externalRepositories.keySet().iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            String string = root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.pathToRootMap.put(string, root);
        }
    }

    @Nullable
    public final Repository getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, false);
    }

    @Nullable
    public final Repository getRepositoryForRoot(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Repository getRepositoryForRoot(VirtualFile root, boolean updateIfNeeded) {
        Repository repository;
        if (root == null) {
            return null;
        }
        boolean updateIfNeeded2 = updateIfNeeded;
        Application app = ApplicationManager.getApplication();
        if (updateIfNeeded2 && app.isDispatchThread() && !app.isUnitTestMode() && !app.isHeadlessEnvironment()) {
            updateIfNeeded2 = false;
            LOG.error("Do not call synchronous repository update in EDT");
        }
        this.REPO_LOCK.readLock().lock();
        try {
            if (this.isDisposed) {
                throw new ProcessCanceledException();
            }
            Repository repository2 = this.repositories.get(root);
            if (repository2 == null) {
                repository2 = this.externalRepositories.get(root);
            }
            if ((repository = repository2) != null) {
                Repository it = repository;
                boolean bl = false;
                Repository repository3 = it;
                return repository3;
            }
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        if (!updateIfNeeded2) return null;
        VirtualFile[] virtualFileArray = this.vcsManager.getAllVersionedRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getAllVersionedRoots(...)");
        if (!ArraysKt.contains((Object[])virtualFileArray, (Object)root)) return null;
        this.checkAndUpdateRepositoryCollection(root);
        this.REPO_LOCK.readLock().lock();
        try {
            repository = this.repositories.get(root);
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        Repository repository4 = repository;
        return repository4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExternalRepository(@NotNull VirtualFile root, @NotNull Repository repository) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.REPO_LOCK.writeLock().lock();
        try {
            this.externalRepositories.put(root, repository);
            this.updatePathToRootMap();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExternalRepository(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.REPO_LOCK.writeLock().lock();
        try {
            this.externalRepositories.remove(root);
            this.updatePathToRootMap();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isExternal(@NotNull Repository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.REPO_LOCK.readLock().lock();
        try {
            boolean bl = !this.repositories.containsValue(repository) && this.externalRepositories.containsValue(repository);
            return bl;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<Repository> getRepositories() {
        this.REPO_LOCK.readLock().lock();
        try {
            List<Repository> list = List.copyOf(this.repositories.values());
            Intrinsics.checkNotNullExpressionValue(list, (String)"copyOf(...)");
            Collection collection = list;
            return collection;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<VirtualFile, Repository> getExternalRepositories() {
        this.REPO_LOCK.readLock().lock();
        try {
            Map<VirtualFile, Repository> map = Map.copyOf((Map)this.externalRepositories);
            Intrinsics.checkNotNullExpressionValue(map, (String)"copyOf(...)");
            Map<VirtualFile, Repository> map2 = map;
            return map2;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private final void checkAndUpdateRepositoryCollection(VirtualFile checkedRoot) {
        this.updateScheduled.set(false);
        if (this.MODIFY_LOCK.isHeldByCurrentThread()) {
            LOG.error(new Throwable("Recursive Repository initialization"));
            return;
        }
        this.MODIFY_LOCK.lock();
        try {
            HashMap hashMap;
            this.REPO_LOCK.readLock().lock();
            try {
                hashMap = new HashMap(this.repositories);
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
            HashMap repositoryListSnapshot = hashMap;
            if (checkedRoot != null && repositoryListSnapshot.containsKey(checkedRoot)) {
                return;
            }
            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, () -> VcsRepositoryManager.checkAndUpdateRepositoryCollection$lambda$6(this, repositoryListSnapshot));
            this.REPO_LOCK.writeLock().lock();
            try {
                if (!this.isDisposed) {
                    for (Map.Entry entry : ((Map)this.repositories).entrySet()) {
                        Repository newRepo;
                        VirtualFile file = (VirtualFile)entry.getKey();
                        Repository oldRepo = (Repository)entry.getValue();
                        if (oldRepo == (newRepo = (Repository)repositoryListSnapshot.get(file))) continue;
                        Disposer.dispose((Disposable)oldRepo);
                    }
                    this.repositories.clear();
                    this.repositories.putAll(repositoryListSnapshot);
                }
                this.updatePathToRootMap();
            }
            finally {
                this.REPO_LOCK.writeLock().unlock();
            }
        }
        finally {
            this.MODIFY_LOCK.unlock();
        }
        ((VcsRepositoryMappingListener)this.project.getMessageBus().syncPublisher(VCS_REPOSITORY_MAPPING_UPDATED)).mappingChanged();
    }

    private final Map<VirtualFile, Repository> findNewRoots(Set<? extends VirtualFile> knownRoots) {
        HashMap<VirtualFile, AbstractVcs> newRootsMap = new HashMap<VirtualFile, AbstractVcs>();
        for (VcsRoot root : this.vcsManager.getAllVcsRoots()) {
            VirtualFile rootPath;
            Intrinsics.checkNotNullExpressionValue((Object)root.getPath(), (String)"getPath(...)");
            if (knownRoots.contains(rootPath)) continue;
            Object object = root.getVcs();
            if (object == null) continue;
            AbstractVcs it = object;
            boolean bl = false;
            Repository repository = VcsRepositoryManager.Companion.tryCreateRepository(this.project, it, rootPath, this);
            object = repository;
            if (repository == null) {
                continue;
            }
            Object repository2 = object;
            newRootsMap.put(rootPath, (AbstractVcs)repository2);
        }
        return newRootsMap;
    }

    private final Collection<VirtualFile> findInvalidRoots(Collection<? extends Repository> repositories) {
        ArrayList<VirtualFile> invalidRepos = new ArrayList<VirtualFile>();
        for (Repository repository : repositories) {
            VcsRoot vcsRoot = this.vcsManager.getVcsRootObjectFor(repository.getRoot());
            if (vcsRoot != null && Intrinsics.areEqual((Object)repository.getRoot(), (Object)vcsRoot.getPath()) && Intrinsics.areEqual((Object)repository.getVcs(), (Object)vcsRoot.getVcs())) continue;
            invalidRepos.add(repository.getRoot());
        }
        return invalidRepos;
    }

    @NotNull
    public String toString() {
        return "RepositoryManager(repositories=" + this.repositories + ")";
    }

    @TestOnly
    public final void waitForAsyncTaskCompletion() {
        this.updateAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
    }

    private static final void _init_$lambda$0(VcsRepositoryManager this$0) {
        this$0.scheduleUpdate();
    }

    private static final void _init_$lambda$1(VcsRepositoryManager this$0) {
        this$0.disposeAllRepositories(false);
        this$0.scheduleUpdate();
        ((VcsRepositoryMappingListener)this$0.project.getMessageBus().syncPublisher(VCS_REPOSITORY_MAPPING_UPDATED)).mappingChanged();
    }

    private static final void scheduleUpdate$lambda$2(VcsRepositoryManager this$0) {
        this$0.checkAndUpdateRepositoryCollection(null);
    }

    private static final void ensureUpToDate$lambda$3(VcsRepositoryManager this$0) {
        this$0.checkAndUpdateRepositoryCollection(null);
    }

    private static final void ensureUpToDate$lambda$4(CompletableDeferred $waiter) {
        $waiter.complete((Object)Unit.INSTANCE);
    }

    private static final void checkAndUpdateRepositoryCollection$lambda$6(VcsRepositoryManager this$0, HashMap $repositoryListSnapshot) {
        Collection collection = $repositoryListSnapshot.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<VirtualFile> invalidRoots = this$0.findInvalidRoots(collection);
        for (VirtualFile invalidRoot : invalidRoots) {
            $repositoryListSnapshot.keySet().remove(invalidRoot);
        }
        Set set = $repositoryListSnapshot.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        $repositoryListSnapshot.putAll(this$0.findNewRoots(set));
    }

    @JvmStatic
    @NotNull
    public static final VcsRepositoryManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsRepositoryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        VCS_REPOSITORY_MAPPING_UPDATED = new Topic(VcsRepositoryMappingListener.class, Topic.BroadcastDirection.NONE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/dvcs/repo/VcsRepositoryManager$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/dvcs/repo/VcsRepositoryCreator;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "VCS_REPOSITORY_MAPPING_UPDATED", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/dvcs/repo/VcsRepositoryMappingListener;", "getInstance", "Lcom/intellij/dvcs/repo/VcsRepositoryManager;", "project", "Lcom/intellij/openapi/project/Project;", "tryCreateRepository", "Lcom/intellij/dvcs/repo/Repository;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "rootPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.vcs.dvcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsRepositoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsRepositoryManager.kt\ncom/intellij/dvcs/repo/VcsRepositoryManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,434:1\n30#2,2:435\n*S KotlinDebug\n*F\n+ 1 VcsRepositoryManager.kt\ncom/intellij/dvcs/repo/VcsRepositoryManager$Companion\n*L\n98#1:435,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VcsRepositoryManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<VcsRepositoryManager> serviceClass$iv = VcsRepositoryManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (VcsRepositoryManager)object;
        }

        private final Repository tryCreateRepository(Project project, AbstractVcs vcs, VirtualFile rootPath, Disposable disposable) {
            return (Repository)EP_NAME.computeSafeIfAny(arg_0 -> Companion.tryCreateRepository$lambda$0(vcs, project, rootPath, disposable, arg_0));
        }

        private static final Repository tryCreateRepository$lambda$0(AbstractVcs $vcs, Project $project, VirtualFile $rootPath, Disposable $disposable, VcsRepositoryCreator creator) {
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            if (Intrinsics.areEqual((Object)creator.getVcsKey(), (Object)$vcs.getKeyInstanceMethod())) {
                return creator.createRepositoryIfValid($project, $rootPath, $disposable);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/dvcs/repo/VcsRepositoryManager$MyStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "order", "", "getOrder", "()I", "intellij.platform.vcs.dvcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsRepositoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsRepositoryManager.kt\ncom/intellij/dvcs/repo/VcsRepositoryManager$MyStartupActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,434:1\n75#2:435\n*S KotlinDebug\n*F\n+ 1 VcsRepositoryManager.kt\ncom/intellij/dvcs/repo/VcsRepositoryManager$MyStartupActivity\n*L\n119#1:435\n*E\n"})
    public static final class MyStartupActivity
    implements VcsStartupActivity {
        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var6_3 = $completion;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MyStartupActivity this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$serviceAsync$iv = (ComponentManager)project;
                    $i$f$serviceAsync = 0;
                    Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                    $continuation.I$0 = $i$f$serviceAsync;
                    $continuation.label = 1;
                    v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(VcsRepositoryManager.class, (Continuation)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    $i$f$serviceAsync = $continuation.I$0;
                    $this$serviceAsync$iv = (ComponentManager)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = null;
                    $continuation.label = 2;
                    v1 = VcsRepositoryManager.ensureUpToDate$default((VcsRepositoryManager)v0, false, (Continuation)$continuation, 1, null);
                    if (v1 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl41
                }
                case 2: {
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl41:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public int getOrder() {
            return VcsInitObject.OTHER_INITIALIZATION.getOrder();
        }
    }
}

