/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.collection.IntList;
import androidx.collection.IntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.MonoSpline;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010%J-\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J-\u0010*\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u000bH\u0002J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0012\u0010\u0016\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0012\u0010\u001e\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0012\u0010\u001f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u00060"}, d2={"Landroidx/compose/animation/core/VectorizedMonoSplineKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "timestamps", "Landroidx/collection/IntList;", "keyframes", "Landroidx/collection/IntObjectMap;", "Lkotlin/Pair;", "Landroidx/compose/animation/core/Easing;", "durationMillis", "", "delayMillis", "periodicBias", "", "<init>", "(Landroidx/collection/IntList;Landroidx/collection/IntObjectMap;IIF)V", "getDurationMillis", "()I", "getDelayMillis", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "times", "", "monoSpline", "Landroidx/compose/animation/core/MonoSpline;", "values", "", "[[F", "lastInitialValue", "lastTargetValue", "init", "", "initialValue", "targetValue", "initialVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)V", "getValueFromNanos", "playTimeNanos", "", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "getEasing", "index", "getEasedTimeFromIndex", "timeMillis", "findEntryForTimeMillis", "animation-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVectorizedMonoSplineKeyframesSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedMonoSplineKeyframesSpec.kt\nandroidx/compose/animation/core/VectorizedMonoSplineKeyframesSpec\n+ 2 IntList.kt\nandroidx/collection/IntList\n+ 3 IntObjectMap.kt\nandroidx/collection/IntObjectMap\n*L\n1#1,190:1\n65#2:191\n65#2:192\n70#2:195\n425#3:193\n425#3:194\n*S KotlinDebug\n*F\n+ 1 VectorizedMonoSplineKeyframesSpec.kt\nandroidx/compose/animation/core/VectorizedMonoSplineKeyframesSpec\n*L\n50#1:191\n67#1:192\n161#1:195\n82#1:193\n86#1:194\n*E\n"})
public final class VectorizedMonoSplineKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    @NotNull
    private final IntList timestamps;
    @NotNull
    private final IntObjectMap<Pair<V, Easing>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    private final float periodicBias;
    @Nullable
    private V valueVector;
    @Nullable
    private V velocityVector;
    private float[] times;
    @Nullable
    private MonoSpline monoSpline;
    @Nullable
    private float[][] values;
    @Nullable
    private V lastInitialValue;
    @Nullable
    private V lastTargetValue;
    public static final int $stable = 8;

    public VectorizedMonoSplineKeyframesSpec(@NotNull IntList timestamps, @NotNull IntObjectMap<Pair<V, Easing>> keyframes, int durationMillis, int delayMillis, float periodicBias) {
        Intrinsics.checkNotNullParameter((Object)timestamps, (String)"timestamps");
        Intrinsics.checkNotNullParameter(keyframes, (String)"keyframes");
        this.timestamps = timestamps;
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis;
        this.periodicBias = periodicBias;
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    /*
     * WARNING - void declaration
     */
    private final void init(V initialValue, V targetValue2, V initialVelocity) {
        Object object;
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
            this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
            int n = 0;
            Object this_$iv = this.timestamps;
            int $i$f$getSize = 0;
            int n2 = ((IntList)this_$iv)._size;
            this_$iv = new float[n2];
            object = this;
            while (n < n2) {
                $i$f$getSize = n++;
                this_$iv[$i$f$getSize] = (float)this.timestamps.get($i$f$getSize) / (float)1000L;
            }
            ((VectorizedMonoSplineKeyframesSpec)object).times = (float[])this_$iv;
        }
        if (this.monoSpline == null || !Intrinsics.areEqual(this.lastInitialValue, initialValue) || !Intrinsics.areEqual(this.lastTargetValue, targetValue2)) {
            boolean initialChanged = !Intrinsics.areEqual(this.lastInitialValue, initialValue);
            boolean targetChanged = !Intrinsics.areEqual(this.lastTargetValue, targetValue2);
            this.lastInitialValue = initialValue;
            this.lastTargetValue = targetValue2;
            int dimension = ((AnimationVector)initialValue).getSize$animation_core();
            Object values = this.values;
            if (values == null) {
                Object this_$iv = this.timestamps;
                boolean $i$f$getSize = false;
                int n = ((IntList)this_$iv)._size;
                this_$iv = new float[n][];
                for (int i = 0; i < n; ++i) {
                    float[] fArray;
                    int n3;
                    Object object2;
                    int n4;
                    int n5 = i;
                    int timestamp = this.timestamps.get(n5);
                    Pair<V, Easing> keyframe = this.keyframes.get(timestamp);
                    if (timestamp == 0 && keyframe == null) {
                        int n6 = 0;
                        float[] fArray2 = new float[dimension];
                        n4 = n5;
                        object = this_$iv;
                        while (n6 < dimension) {
                            int n7 = n6++;
                            fArray2[n7] = ((AnimationVector)initialValue).get$animation_core(n7);
                        }
                        object2 = object;
                        n3 = n4;
                        fArray = fArray2;
                    } else if (timestamp == this.getDurationMillis() && keyframe == null) {
                        int n8 = 0;
                        float[] fArray3 = new float[dimension];
                        while (n8 < dimension) {
                            int n9 = n8++;
                            fArray3[n9] = ((AnimationVector)targetValue2).get$animation_core(n9);
                        }
                        object2 = object;
                        n3 = n4;
                        fArray = fArray3;
                    } else {
                        Pair<V, Easing> pair = keyframe;
                        Intrinsics.checkNotNull(pair);
                        AnimationVector vectorValue = (AnimationVector)pair.getFirst();
                        int n10 = 0;
                        float[] fArray4 = new float[dimension];
                        while (n10 < dimension) {
                            int n11 = n10++;
                            fArray4[n11] = vectorValue.get$animation_core(n11);
                        }
                        object2 = object;
                        n3 = n4;
                        fArray = fArray4;
                    }
                    object2[n3] = fArray;
                }
                this.values = values = (Object)this_$iv;
            } else {
                int n;
                int n12;
                int key$iv;
                if (initialChanged) {
                    void this_$iv;
                    IntObjectMap<Pair<V, Easing>> intObjectMap = this.keyframes;
                    key$iv = 0;
                    boolean $i$f$contains2 = false;
                    if (!this_$iv.containsKey(key$iv)) {
                        int index2 = IntList.binarySearch$default(this.timestamps, 0, 0, 0, 6, null);
                        key$iv = 0;
                        float[] $i$f$contains2 = new float[dimension];
                        n12 = index2;
                        object = values;
                        while (key$iv < dimension) {
                            n = key$iv++;
                            $i$f$contains2[n] = ((AnimationVector)initialValue).get$animation_core(n);
                        }
                        object[n12] = $i$f$contains2;
                    }
                }
                if (targetChanged) {
                    void this_$iv;
                    IntObjectMap<Pair<V, Easing>> index2 = this.keyframes;
                    key$iv = this.getDurationMillis();
                    boolean $i$f$contains = false;
                    if (!this_$iv.containsKey(key$iv)) {
                        int index3 = IntList.binarySearch$default(this.timestamps, this.getDurationMillis(), 0, 0, 6, null);
                        int n13 = 0;
                        float[] fArray = new float[dimension];
                        n12 = index3;
                        object = values;
                        while (n13 < dimension) {
                            n = n13++;
                            fArray[n] = ((AnimationVector)targetValue2).get$animation_core(n);
                        }
                        object[n12] = fArray;
                    }
                }
            }
            float[] fArray = this.times;
            if (this.times == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"times");
                fArray = null;
            }
            this.monoSpline = new MonoSpline(fArray, (float[][])values, this.periodicBias);
        }
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        Pair<V, Easing> keyframe = this.keyframes.get(clampedPlayTime);
        if (keyframe != null) {
            return (V)((AnimationVector)keyframe.getFirst());
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue2;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        this.init(initialValue, targetValue2, initialVelocity);
        int index2 = this.findEntryForTimeMillis(clampedPlayTime);
        V v = this.valueVector;
        Intrinsics.checkNotNull(v);
        V valueVector = v;
        MonoSpline monoSpline = this.monoSpline;
        Intrinsics.checkNotNull((Object)monoSpline);
        MonoSpline monoSpline2 = monoSpline;
        float f = this.getEasedTimeFromIndex(index2, clampedPlayTime);
        monoSpline2.getPos(f, (AnimationVector)valueVector, index2);
        return valueVector;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        this.init(initialValue, targetValue2, initialVelocity);
        int index2 = this.findEntryForTimeMillis(clampedPlayTime);
        V v = this.velocityVector;
        Intrinsics.checkNotNull(v);
        V velocityVector = v;
        MonoSpline monoSpline = this.monoSpline;
        Intrinsics.checkNotNull((Object)monoSpline);
        MonoSpline monoSpline2 = monoSpline;
        float f = this.getEasedTimeFromIndex(index2, clampedPlayTime);
        monoSpline2.getSlope(f, (AnimationVector)velocityVector, index2);
        return velocityVector;
    }

    private final Easing getEasing(int index2) {
        int timestamp = this.timestamps.get(index2);
        Object object = this.keyframes.get(timestamp);
        if (object == null || (object = (Easing)object.getSecond()) == null) {
            object = EasingKt.getLinearEasing();
        }
        return object;
    }

    private final float getEasedTimeFromIndex(int index2, int timeMillis) {
        IntList this_$iv = this.timestamps;
        boolean $i$f$getLastIndex = false;
        if (index2 >= this_$iv._size - 1) {
            return (float)timeMillis / (float)1000L;
        }
        int timeMin = this.timestamps.get(index2);
        int timeMax = this.timestamps.get(index2 + 1);
        if (timeMillis == timeMin) {
            return (float)timeMin / (float)1000L;
        }
        int timeRange = timeMax - timeMin;
        Easing easing = this.getEasing(index2);
        float rawFraction = (float)(timeMillis - timeMin) / (float)timeRange;
        float easedFraction = easing.transform(rawFraction);
        return ((float)timeRange * easedFraction + (float)timeMin) / (float)1000L;
    }

    private final int findEntryForTimeMillis(int timeMillis) {
        int index2 = IntList.binarySearch$default(this.timestamps, timeMillis, 0, 0, 6, null);
        return index2 < -1 ? -(index2 + 2) : index2;
    }
}

