/**
 * ./src/components/steps.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { Box, Text } from 'ink';
import React from 'react';
export default function Steps({ step = 1 }) {
    let activeWelcome = false;
    let activeLocation = false;
    let activeKeyboard = false;
    let activePartitions = false;
    let activeUsers = false;
    let activeNetwork = false;
    let activeSummary = false;
    let activeInstall = false;
    let activeFinish = false;
    switch (step) {
        case 1: {
            activeWelcome = true;
            break;
        }
        case 2: {
            activeLocation = true;
            break;
        }
        case 3: {
            activeKeyboard = true;
            break;
        }
        case 4: {
            activePartitions = true;
            break;
        }
        case 5: {
            activeUsers = true;
            break;
        }
        case 6: {
            activeNetwork = true;
            break;
        }
        case 7: {
            activeSummary = true;
            break;
        }
        case 8: {
            activeInstall = true;
            break;
        }
        case 9: {
            activeFinish = true;
            break;
        }
        // No default
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(Box, { flexDirection: "column", height: 9, width: 13 },
            React.createElement(WelcomeTab, { active: activeWelcome }),
            React.createElement(LocationTab, { active: activeLocation }),
            React.createElement(KeyboardTab, { active: activeKeyboard }),
            React.createElement(PartitionTab, { active: activePartitions }),
            React.createElement(UsersTab, { active: activeUsers }),
            React.createElement(NetworkTab, { active: activeNetwork }),
            React.createElement(SummaryTab, { active: activeSummary }),
            React.createElement(InstallTab, { active: activeInstall }),
            React.createElement(FinishTab, { active: activeFinish }))));
}
function WelcomeTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { backgroundColor: backgroundColor, color: color }, " Welcome    "));
}
function LocationTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { backgroundColor: backgroundColor, color: color }, " Location   "));
}
function KeyboardTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { backgroundColor: backgroundColor, color: color }, " Keyboard   "));
}
function PartitionTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { backgroundColor: backgroundColor, color: color }, " Partitions "));
}
function UsersTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { backgroundColor: backgroundColor, color: color }, " Users      "));
}
function NetworkTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { backgroundColor: backgroundColor, color: color }, " Network    "));
}
function SummaryTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { backgroundColor: backgroundColor, color: color }, " Summary    "));
}
function InstallTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { backgroundColor: backgroundColor, color: color }, " Install    "));
}
function FinishTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { backgroundColor: backgroundColor, color: color }, " Finish     "));
}
