import { Q as createAllConfigs, Z as warnDeprecation } from "./utils.js";
import { t as array_bracket_newline_default } from "./rules/array-bracket-newline.js";
import { t as array_bracket_spacing_default } from "./rules/array-bracket-spacing.js";
import { t as array_element_newline_default } from "./rules/array-element-newline.js";
import { t as arrow_parens_default } from "./rules/arrow-parens.js";
import { t as arrow_spacing_default } from "./rules/arrow-spacing.js";
import { t as block_spacing_default } from "./rules/block-spacing.js";
import { t as brace_style_default } from "./rules/brace-style.js";
import { t as comma_dangle_default } from "./rules/comma-dangle.js";
import { t as comma_spacing_default } from "./rules/comma-spacing.js";
import { t as comma_style_default } from "./rules/comma-style.js";
import { t as computed_property_spacing_default } from "./rules/computed-property-spacing.js";
import { t as curly_newline_default } from "./rules/curly-newline.js";
import { t as dot_location_default } from "./rules/dot-location.js";
import { t as eol_last_default } from "./rules/eol-last.js";
import { t as function_call_argument_newline_default } from "./rules/function-call-argument-newline.js";
import { t as function_call_spacing_default } from "./rules/function-call-spacing.js";
import { t as function_paren_newline_default } from "./rules/function-paren-newline.js";
import { t as generator_star_spacing_default } from "./rules/generator-star-spacing.js";
import { t as implicit_arrow_linebreak_default } from "./rules/implicit-arrow-linebreak.js";
import { t as indent_binary_ops_default } from "./rules/indent-binary-ops.js";
import { t as indent_default } from "./rules/indent.js";
import { t as jsx_child_element_spacing_default } from "./rules/jsx-child-element-spacing.js";
import { t as jsx_closing_bracket_location_default } from "./rules/jsx-closing-bracket-location.js";
import { t as jsx_closing_tag_location_default } from "./rules/jsx-closing-tag-location.js";
import { t as jsx_curly_brace_presence_default } from "./rules/jsx-curly-brace-presence.js";
import { t as jsx_curly_newline_default } from "./rules/jsx-curly-newline.js";
import { t as jsx_curly_spacing_default } from "./rules/jsx-curly-spacing.js";
import { t as jsx_equals_spacing_default } from "./rules/jsx-equals-spacing.js";
import { t as jsx_first_prop_new_line_default } from "./rules/jsx-first-prop-new-line.js";
import { t as jsx_function_call_newline_default } from "./rules/jsx-function-call-newline.js";
import { t as jsx_indent_props_default } from "./rules/jsx-indent-props.js";
import { t as jsx_indent_default } from "./rules/jsx-indent.js";
import { t as jsx_max_props_per_line_default } from "./rules/jsx-max-props-per-line.js";
import { t as jsx_newline_default } from "./rules/jsx-newline.js";
import { t as jsx_one_expression_per_line_default } from "./rules/jsx-one-expression-per-line.js";
import { t as jsx_pascal_case_default } from "./rules/jsx-pascal-case.js";
import { t as jsx_props_no_multi_spaces_default } from "./rules/jsx-props-no-multi-spaces.js";
import { t as jsx_quotes_default } from "./rules/jsx-quotes.js";
import { t as jsx_self_closing_comp_default } from "./rules/jsx-self-closing-comp.js";
import { t as jsx_sort_props_default } from "./rules/jsx-sort-props.js";
import { t as jsx_tag_spacing_default } from "./rules/jsx-tag-spacing.js";
import { t as jsx_wrap_multilines_default } from "./rules/jsx-wrap-multilines.js";
import { t as key_spacing_default } from "./rules/key-spacing.js";
import { t as keyword_spacing_default } from "./rules/keyword-spacing.js";
import { t as line_comment_position_default } from "./rules/line-comment-position.js";
import { t as linebreak_style_default } from "./rules/linebreak-style.js";
import { t as lines_around_comment_default } from "./rules/lines-around-comment.js";
import { t as lines_between_class_members_default } from "./rules/lines-between-class-members.js";
import { t as list_style_default } from "./rules/list-style.js";
import { t as max_len_default } from "./rules/max-len.js";
import { t as max_statements_per_line_default } from "./rules/max-statements-per-line.js";
import { t as member_delimiter_style_default } from "./rules/member-delimiter-style.js";
import { t as multiline_comment_style_default } from "./rules/multiline-comment-style.js";
import { t as multiline_ternary_default } from "./rules/multiline-ternary.js";
import { t as new_parens_default } from "./rules/new-parens.js";
import { t as newline_per_chained_call_default } from "./rules/newline-per-chained-call.js";
import { t as no_confusing_arrow_default } from "./rules/no-confusing-arrow.js";
import { t as no_extra_parens_default } from "./rules/no-extra-parens.js";
import { t as no_extra_semi_default } from "./rules/no-extra-semi.js";
import { t as no_floating_decimal_default } from "./rules/no-floating-decimal.js";
import { t as no_mixed_operators_default } from "./rules/no-mixed-operators.js";
import { t as no_mixed_spaces_and_tabs_default } from "./rules/no-mixed-spaces-and-tabs.js";
import { t as no_multi_spaces_default } from "./rules/no-multi-spaces.js";
import { t as no_multiple_empty_lines_default } from "./rules/no-multiple-empty-lines.js";
import { t as no_tabs_default } from "./rules/no-tabs.js";
import { t as no_trailing_spaces_default } from "./rules/no-trailing-spaces.js";
import { t as no_whitespace_before_property_default } from "./rules/no-whitespace-before-property.js";
import { t as nonblock_statement_body_position_default } from "./rules/nonblock-statement-body-position.js";
import { t as object_curly_newline_default } from "./rules/object-curly-newline.js";
import { t as object_curly_spacing_default } from "./rules/object-curly-spacing.js";
import { t as object_property_newline_default } from "./rules/object-property-newline.js";
import { t as one_var_declaration_per_line_default } from "./rules/one-var-declaration-per-line.js";
import { t as operator_linebreak_default } from "./rules/operator-linebreak.js";
import { t as padded_blocks_default } from "./rules/padded-blocks.js";
import { t as padding_line_between_statements_default } from "./rules/padding-line-between-statements.js";
import { t as quote_props_default } from "./rules/quote-props.js";
import { t as quotes_default } from "./rules/quotes.js";
import { t as rest_spread_spacing_default } from "./rules/rest-spread-spacing.js";
import { t as semi_spacing_default } from "./rules/semi-spacing.js";
import { t as semi_style_default } from "./rules/semi-style.js";
import { t as semi_default } from "./rules/semi.js";
import { t as space_before_blocks_default } from "./rules/space-before-blocks.js";
import { t as space_before_function_paren_default } from "./rules/space-before-function-paren.js";
import { t as space_in_parens_default } from "./rules/space-in-parens.js";
import { t as space_infix_ops_default } from "./rules/space-infix-ops.js";
import { t as space_unary_ops_default } from "./rules/space-unary-ops.js";
import { t as spaced_comment_default } from "./rules/spaced-comment.js";
import { t as switch_colon_spacing_default } from "./rules/switch-colon-spacing.js";
import { t as template_curly_spacing_default } from "./rules/template-curly-spacing.js";
import { t as template_tag_spacing_default } from "./rules/template-tag-spacing.js";
import { t as type_annotation_spacing_default } from "./rules/type-annotation-spacing.js";
import { t as type_generic_spacing_default } from "./rules/type-generic-spacing.js";
import { t as type_named_tuple_spacing_default } from "./rules/type-named-tuple-spacing.js";
import { t as wrap_iife_default } from "./rules/wrap-iife.js";
import { t as wrap_regex_default } from "./rules/wrap-regex.js";
import { t as yield_star_spacing_default } from "./rules/yield-star-spacing.js";
var plugin_default = {
	meta: {
		name: "@stylistic/eslint-plugin",
		version: "5.7.1",
		namespace: "@stylistic"
	},
	rules: {
		"array-bracket-newline": array_bracket_newline_default,
		"array-bracket-spacing": array_bracket_spacing_default,
		"array-element-newline": array_element_newline_default,
		"arrow-parens": arrow_parens_default,
		"arrow-spacing": arrow_spacing_default,
		"block-spacing": block_spacing_default,
		"brace-style": brace_style_default,
		"comma-dangle": comma_dangle_default,
		"comma-spacing": comma_spacing_default,
		"comma-style": comma_style_default,
		"computed-property-spacing": computed_property_spacing_default,
		"curly-newline": curly_newline_default,
		"dot-location": dot_location_default,
		"eol-last": eol_last_default,
		"function-call-argument-newline": function_call_argument_newline_default,
		"function-call-spacing": function_call_spacing_default,
		"function-paren-newline": function_paren_newline_default,
		"generator-star-spacing": generator_star_spacing_default,
		"implicit-arrow-linebreak": implicit_arrow_linebreak_default,
		"indent": indent_default,
		"indent-binary-ops": indent_binary_ops_default,
		"jsx-child-element-spacing": jsx_child_element_spacing_default,
		"jsx-closing-bracket-location": jsx_closing_bracket_location_default,
		"jsx-closing-tag-location": jsx_closing_tag_location_default,
		"jsx-curly-brace-presence": jsx_curly_brace_presence_default,
		"jsx-curly-newline": jsx_curly_newline_default,
		"jsx-curly-spacing": jsx_curly_spacing_default,
		"jsx-equals-spacing": jsx_equals_spacing_default,
		"jsx-first-prop-new-line": jsx_first_prop_new_line_default,
		"jsx-function-call-newline": jsx_function_call_newline_default,
		"jsx-indent": jsx_indent_default,
		"jsx-indent-props": jsx_indent_props_default,
		"jsx-max-props-per-line": jsx_max_props_per_line_default,
		"jsx-newline": jsx_newline_default,
		"jsx-one-expression-per-line": jsx_one_expression_per_line_default,
		"jsx-pascal-case": jsx_pascal_case_default,
		"jsx-props-no-multi-spaces": jsx_props_no_multi_spaces_default,
		"jsx-quotes": jsx_quotes_default,
		"jsx-self-closing-comp": jsx_self_closing_comp_default,
		"jsx-sort-props": jsx_sort_props_default,
		"jsx-tag-spacing": jsx_tag_spacing_default,
		"jsx-wrap-multilines": jsx_wrap_multilines_default,
		"key-spacing": key_spacing_default,
		"keyword-spacing": keyword_spacing_default,
		"line-comment-position": line_comment_position_default,
		"linebreak-style": linebreak_style_default,
		"lines-around-comment": lines_around_comment_default,
		"lines-between-class-members": lines_between_class_members_default,
		"exp-list-style": list_style_default,
		"max-len": max_len_default,
		"max-statements-per-line": max_statements_per_line_default,
		"member-delimiter-style": member_delimiter_style_default,
		"multiline-comment-style": multiline_comment_style_default,
		"multiline-ternary": multiline_ternary_default,
		"new-parens": new_parens_default,
		"newline-per-chained-call": newline_per_chained_call_default,
		"no-confusing-arrow": no_confusing_arrow_default,
		"no-extra-parens": no_extra_parens_default,
		"no-extra-semi": no_extra_semi_default,
		"no-floating-decimal": no_floating_decimal_default,
		"no-mixed-operators": no_mixed_operators_default,
		"no-mixed-spaces-and-tabs": no_mixed_spaces_and_tabs_default,
		"no-multi-spaces": no_multi_spaces_default,
		"no-multiple-empty-lines": no_multiple_empty_lines_default,
		"no-tabs": no_tabs_default,
		"no-trailing-spaces": no_trailing_spaces_default,
		"no-whitespace-before-property": no_whitespace_before_property_default,
		"nonblock-statement-body-position": nonblock_statement_body_position_default,
		"object-curly-newline": object_curly_newline_default,
		"object-curly-spacing": object_curly_spacing_default,
		"object-property-newline": object_property_newline_default,
		"one-var-declaration-per-line": one_var_declaration_per_line_default,
		"operator-linebreak": operator_linebreak_default,
		"padded-blocks": padded_blocks_default,
		"padding-line-between-statements": padding_line_between_statements_default,
		"quote-props": quote_props_default,
		"quotes": quotes_default,
		"rest-spread-spacing": rest_spread_spacing_default,
		"semi": semi_default,
		"semi-spacing": semi_spacing_default,
		"semi-style": semi_style_default,
		"space-before-blocks": space_before_blocks_default,
		"space-before-function-paren": space_before_function_paren_default,
		"space-in-parens": space_in_parens_default,
		"space-infix-ops": space_infix_ops_default,
		"space-unary-ops": space_unary_ops_default,
		"spaced-comment": spaced_comment_default,
		"switch-colon-spacing": switch_colon_spacing_default,
		"template-curly-spacing": template_curly_spacing_default,
		"template-tag-spacing": template_tag_spacing_default,
		"type-annotation-spacing": type_annotation_spacing_default,
		"type-generic-spacing": type_generic_spacing_default,
		"type-named-tuple-spacing": type_named_tuple_spacing_default,
		"wrap-iife": wrap_iife_default,
		"wrap-regex": wrap_regex_default,
		"yield-star-spacing": yield_star_spacing_default
	}
};
function customize(options = {}) {
	const defaultPluginName = plugin_default.meta.namespace;
	const { arrowParens = false, blockSpacing = true, braceStyle = "stroustrup", commaDangle = "always-multiline", experimental: enableExperimentalRules = false, indent = 2, jsx = true, pluginName = defaultPluginName, quoteProps = "consistent-as-needed", quotes = "single", semi = false, severity = "error" } = options;
	const [indentLevel = 2, indentOptions = {
		ArrayExpression: 1,
		CallExpression: { arguments: 1 },
		flatTernaryExpressions: false,
		FunctionDeclaration: {
			body: 1,
			parameters: 1,
			returnType: 1
		},
		FunctionExpression: {
			body: 1,
			parameters: 1,
			returnType: 1
		},
		ignoreComments: false,
		ignoredNodes: ["TSUnionType", "TSIntersectionType"],
		ImportDeclaration: 1,
		MemberExpression: 1,
		ObjectExpression: 1,
		offsetTernaryExpressions: true,
		outerIIFEBody: 1,
		SwitchCase: 1,
		tabLength: indentLevel === "tab" ? 4 : indentLevel,
		VariableDeclarator: 1
	}] = Array.isArray(indent) ? indent : [indent];
	let rules = {
		"@stylistic/array-bracket-spacing": [severity, "never"],
		"@stylistic/arrow-parens": [
			severity,
			arrowParens ? "always" : "as-needed",
			{ requireForBlockBody: true }
		],
		"@stylistic/arrow-spacing": [severity, {
			after: true,
			before: true
		}],
		"@stylistic/block-spacing": [severity, blockSpacing ? "always" : "never"],
		"@stylistic/brace-style": [
			severity,
			braceStyle,
			{ allowSingleLine: true }
		],
		"@stylistic/comma-dangle": [severity, commaDangle],
		"@stylistic/comma-spacing": [severity, {
			after: true,
			before: false
		}],
		"@stylistic/comma-style": [severity, "last"],
		"@stylistic/computed-property-spacing": [
			severity,
			"never",
			{ enforceForClassMembers: true }
		],
		"@stylistic/dot-location": [severity, "property"],
		"@stylistic/eol-last": severity,
		"@stylistic/generator-star-spacing": [severity, {
			after: true,
			before: false
		}],
		"@stylistic/indent": [
			severity,
			indentLevel,
			indentOptions
		],
		"@stylistic/indent-binary-ops": [severity, indentLevel],
		"@stylistic/key-spacing": [severity, {
			afterColon: true,
			beforeColon: false
		}],
		"@stylistic/keyword-spacing": [severity, {
			after: true,
			before: true
		}],
		"@stylistic/lines-between-class-members": [
			severity,
			"always",
			{ exceptAfterSingleLine: true }
		],
		"@stylistic/max-statements-per-line": [severity, { max: 1 }],
		"@stylistic/member-delimiter-style": [severity, {
			multiline: {
				delimiter: semi ? "semi" : "none",
				requireLast: semi
			},
			multilineDetection: "brackets",
			overrides: { interface: { multiline: {
				delimiter: semi ? "semi" : "none",
				requireLast: semi
			} } },
			singleline: { delimiter: semi ? "semi" : "comma" }
		}],
		"@stylistic/multiline-ternary": [severity, "always-multiline"],
		"@stylistic/new-parens": severity,
		"@stylistic/no-extra-parens": [severity, "functions"],
		"@stylistic/no-floating-decimal": severity,
		"@stylistic/no-mixed-operators": [severity, {
			allowSamePrecedence: true,
			groups: [
				[
					"==",
					"!=",
					"===",
					"!==",
					">",
					">=",
					"<",
					"<="
				],
				["&&", "||"],
				["in", "instanceof"]
			]
		}],
		"@stylistic/no-mixed-spaces-and-tabs": severity,
		"@stylistic/no-multi-spaces": severity,
		"@stylistic/no-multiple-empty-lines": [severity, {
			max: 1,
			maxBOF: 0,
			maxEOF: 0
		}],
		"@stylistic/no-tabs": indentLevel === "tab" ? "off" : severity,
		"@stylistic/no-trailing-spaces": severity,
		"@stylistic/no-whitespace-before-property": severity,
		"@stylistic/object-curly-spacing": [severity, "always"],
		"@stylistic/operator-linebreak": [severity, "before"],
		"@stylistic/padded-blocks": [severity, {
			blocks: "never",
			classes: "never",
			switches: "never"
		}],
		"@stylistic/quote-props": [severity, quoteProps],
		"@stylistic/quotes": [
			severity,
			quotes,
			{
				allowTemplateLiterals: "always",
				avoidEscape: false
			}
		],
		"@stylistic/rest-spread-spacing": [severity, "never"],
		"@stylistic/semi": [severity, semi ? "always" : "never"],
		"@stylistic/semi-spacing": [severity, {
			after: true,
			before: false
		}],
		"@stylistic/space-before-blocks": [severity, "always"],
		"@stylistic/space-before-function-paren": [severity, {
			anonymous: "always",
			asyncArrow: "always",
			named: "never"
		}],
		"@stylistic/space-in-parens": [severity, "never"],
		"@stylistic/space-infix-ops": severity,
		"@stylistic/space-unary-ops": [severity, {
			nonwords: false,
			words: true
		}],
		"@stylistic/spaced-comment": [
			severity,
			"always",
			{
				block: {
					balanced: true,
					exceptions: ["*"],
					markers: ["!"]
				},
				line: {
					exceptions: ["/", "#"],
					markers: ["/"]
				}
			}
		],
		"@stylistic/template-curly-spacing": severity,
		"@stylistic/template-tag-spacing": [severity, "never"],
		"@stylistic/type-annotation-spacing": [severity, {}],
		"@stylistic/type-generic-spacing": severity,
		"@stylistic/type-named-tuple-spacing": severity,
		"@stylistic/wrap-iife": [
			severity,
			"any",
			{ functionPrototypeMethods: true }
		],
		"@stylistic/yield-star-spacing": [severity, {
			after: true,
			before: false
		}],
		...jsx ? {
			"@stylistic/jsx-closing-bracket-location": severity,
			"@stylistic/jsx-closing-tag-location": severity,
			"@stylistic/jsx-curly-brace-presence": [severity, { propElementValues: "always" }],
			"@stylistic/jsx-curly-newline": severity,
			"@stylistic/jsx-curly-spacing": [severity, "never"],
			"@stylistic/jsx-equals-spacing": severity,
			"@stylistic/jsx-first-prop-new-line": severity,
			"@stylistic/jsx-function-call-newline": [severity, "multiline"],
			"@stylistic/jsx-indent-props": [severity, indentLevel],
			"@stylistic/jsx-max-props-per-line": [severity, {
				maximum: 1,
				when: "multiline"
			}],
			"@stylistic/jsx-one-expression-per-line": [severity, { allow: "single-child" }],
			"@stylistic/jsx-quotes": severity,
			"@stylistic/jsx-tag-spacing": [severity, {
				afterOpening: "never",
				beforeClosing: "never",
				beforeSelfClosing: "always",
				closingSlash: "never"
			}],
			"@stylistic/jsx-wrap-multilines": [severity, {
				arrow: "parens-new-line",
				assignment: "parens-new-line",
				condition: "parens-new-line",
				declaration: "parens-new-line",
				logical: "parens-new-line",
				prop: "parens-new-line",
				propertyValue: "parens-new-line",
				return: "parens-new-line"
			}]
		} : {}
	};
	if (enableExperimentalRules) rules = {
		...rules,
		"@stylistic/array-bracket-newline": "off",
		"@stylistic/array-bracket-spacing": "off",
		"@stylistic/array-element-newline": "off",
		"@stylistic/exp-list-style": "error",
		"@stylistic/function-call-argument-newline": "off",
		"@stylistic/function-paren-newline": "off",
		"@stylistic/jsx-function-call-newline": "off",
		"@stylistic/object-curly-newline": "off",
		"@stylistic/object-curly-spacing": "off",
		"@stylistic/object-property-newline": "off"
	};
	if (pluginName !== defaultPluginName) {
		const regex = new RegExp(`^${defaultPluginName}/`);
		rules = Object.fromEntries(Object.entries(rules).map(([ruleName, ruleConfig]) => [ruleName.replace(regex, `${pluginName}/`), ruleConfig]));
	}
	return {
		plugins: { [pluginName]: plugin_default },
		rules
	};
}
var disable_legacy_default = { rules: {
	"array-bracket-newline": 0,
	"array-bracket-spacing": 0,
	"array-element-newline": 0,
	"arrow-parens": 0,
	"arrow-spacing": 0,
	"block-spacing": 0,
	"brace-style": 0,
	"comma-dangle": 0,
	"comma-spacing": 0,
	"comma-style": 0,
	"computed-property-spacing": 0,
	"dot-location": 0,
	"eol-last": 0,
	"func-call-spacing": 0,
	"function-call-argument-newline": 0,
	"function-paren-newline": 0,
	"generator-star-spacing": 0,
	"implicit-arrow-linebreak": 0,
	"indent": 0,
	"jsx-quotes": 0,
	"key-spacing": 0,
	"keyword-spacing": 0,
	"linebreak-style": 0,
	"lines-around-comment": 0,
	"lines-between-class-members": 0,
	"max-len": 0,
	"max-statements-per-line": 0,
	"multiline-ternary": 0,
	"multiline-comment-style": 0,
	"new-parens": 0,
	"newline-per-chained-call": 0,
	"no-confusing-arrow": 0,
	"no-extra-parens": 0,
	"no-extra-semi": 0,
	"no-floating-decimal": 0,
	"no-mixed-operators": 0,
	"no-mixed-spaces-and-tabs": 0,
	"no-multi-spaces": 0,
	"no-multiple-empty-lines": 0,
	"no-tabs": 0,
	"no-trailing-spaces": 0,
	"no-whitespace-before-property": 0,
	"nonblock-statement-body-position": 0,
	"object-curly-newline": 0,
	"object-curly-spacing": 0,
	"object-property-newline": 0,
	"one-var-declaration-per-line": 0,
	"operator-linebreak": 0,
	"padded-blocks": 0,
	"padding-line-between-statements": 0,
	"quote-props": 0,
	"quotes": 0,
	"rest-spread-spacing": 0,
	"semi": 0,
	"semi-spacing": 0,
	"semi-style": 0,
	"space-before-blocks": 0,
	"space-before-function-paren": 0,
	"space-in-parens": 0,
	"space-infix-ops": 0,
	"space-unary-ops": 0,
	"spaced-comment": 0,
	"switch-colon-spacing": 0,
	"template-curly-spacing": 0,
	"template-tag-spacing": 0,
	"wrap-iife": 0,
	"wrap-regex": 0,
	"yield-star-spacing": 0,
	"@typescript-eslint/block-spacing": 0,
	"@typescript-eslint/brace-style": 0,
	"@typescript-eslint/comma-dangle": 0,
	"@typescript-eslint/comma-spacing": 0,
	"@typescript-eslint/func-call-spacing": 0,
	"@typescript-eslint/indent": 0,
	"@typescript-eslint/key-spacing": 0,
	"@typescript-eslint/keyword-spacing": 0,
	"@typescript-eslint/lines-around-comment": 0,
	"@typescript-eslint/lines-between-class-members": 0,
	"@typescript-eslint/member-delimiter-style": 0,
	"@typescript-eslint/no-extra-parens": 0,
	"@typescript-eslint/no-extra-semi": 0,
	"@typescript-eslint/object-curly-spacing": 0,
	"@typescript-eslint/padding-line-between-statements": 0,
	"@typescript-eslint/quotes": 0,
	"@typescript-eslint/semi": 0,
	"@typescript-eslint/space-before-blocks": 0,
	"@typescript-eslint/space-before-function-paren": 0,
	"@typescript-eslint/space-infix-ops": 0,
	"@typescript-eslint/type-annotation-spacing": 0,
	"react/jsx-child-element-spacing": 0,
	"react/jsx-closing-bracket-location": 0,
	"react/jsx-closing-tag-location": 0,
	"react/jsx-curly-brace-presence": 0,
	"react/jsx-curly-newline": 0,
	"react/jsx-curly-spacing": 0,
	"react/jsx-equals-spacing": 0,
	"react/jsx-first-prop-new-line": 0,
	"react/jsx-indent": 0,
	"react/jsx-indent-props": 0,
	"react/jsx-max-props-per-line": 0,
	"react/jsx-newline": 0,
	"react/jsx-one-expression-per-line": 0,
	"react/jsx-pascal-case": 0,
	"react/jsx-props-no-multi-spaces": 0,
	"react/self-closing-comp": 0,
	"react/jsx-sort-props": 0,
	"react/jsx-tag-spacing": 0,
	"react/jsx-wrap-multilines": 0
} };
const allConfigsIgnore = [/^jsx-/, /^curly-newline$/];
const all = /* @__PURE__ */ createAllConfigs(plugin_default, "@stylistic", (name) => !allConfigsIgnore.some((re) => re.test(name)));
const recommended = /* @__PURE__ */ customize();
const configs = new Proxy({
	"disable-legacy": disable_legacy_default,
	"customize": customize,
	"recommended": recommended,
	"recommended-flat": recommended,
	"all": all,
	"all-flat": all
}, { get(target, p, receiver) {
	const prop = p.toString();
	if (prop.endsWith("-flat")) warnDeprecation(`config("${prop}")`, `"${prop.replace("-flat", "")}"`);
	return Reflect.get(target, p, receiver);
} });
export { plugin_default as n, configs as t };
