/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLambdaRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.And;
import org.opensearch.sql.ast.expression.Between;
import org.opensearch.sql.ast.expression.Case;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.ast.expression.Compare;
import org.opensearch.sql.ast.expression.EqualTo;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.HighlightFunction;
import org.opensearch.sql.ast.expression.In;
import org.opensearch.sql.ast.expression.Interval;
import org.opensearch.sql.ast.expression.LambdaFunction;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Not;
import org.opensearch.sql.ast.expression.Or;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.RelevanceFieldList;
import org.opensearch.sql.ast.expression.ScoreFunction;
import org.opensearch.sql.ast.expression.Span;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.When;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.expression.Xor;
import org.opensearch.sql.ast.expression.subquery.ExistsSubquery;
import org.opensearch.sql.ast.expression.subquery.InSubquery;
import org.opensearch.sql.ast.expression.subquery.ScalarSubquery;
import org.opensearch.sql.ast.expression.subquery.SubqueryExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRelNodeVisitor;
import org.opensearch.sql.calcite.ExtendedRexBuilder;
import org.opensearch.sql.calcite.QualifiedNameResolver;
import org.opensearch.sql.calcite.plan.rel.LogicalSystemLimit;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.calcite.utils.SubsearchUtils;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.CalciteUnsupportedException;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public class CalciteRexNodeVisitor
extends AbstractNodeVisitor<RexNode, CalcitePlanContext> {
    private final CalciteRelNodeVisitor planVisitor;

    public RexNode analyze(UnresolvedExpression unresolved, CalcitePlanContext context) {
        return unresolved.accept(this, context);
    }

    public List<RexNode> analyze(List<UnresolvedExpression> list, CalcitePlanContext context) {
        return list.stream().map(u -> u.accept(this, context)).toList();
    }

    public RexNode analyzeJoinCondition(UnresolvedExpression unresolved, CalcitePlanContext context) {
        return context.resolveJoinCondition(unresolved, this::analyze);
    }

    @Override
    public RexNode visitLiteral(Literal node, CalcitePlanContext context) {
        ExtendedRexBuilder rexBuilder = context.rexBuilder;
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        Object value = node.getValue();
        if (value == null) {
            RelDataType type = typeFactory.createSqlType(SqlTypeName.NULL);
            return rexBuilder.makeNullLiteral(type);
        }
        switch (node.getType()) {
            case NULL: {
                return rexBuilder.makeNullLiteral(typeFactory.createSqlType(SqlTypeName.NULL));
            }
            case STRING: {
                if (value.toString().length() == 1) {
                    return rexBuilder.makeLiteral(value.toString(), typeFactory.createSqlType(SqlTypeName.CHAR));
                }
                return rexBuilder.makeLiteral(value.toString(), typeFactory.createSqlType(SqlTypeName.VARCHAR), true);
            }
            case INTEGER: {
                return rexBuilder.makeExactLiteral(new BigDecimal((Integer)value));
            }
            case LONG: {
                return rexBuilder.makeBigintLiteral(new BigDecimal((Long)value));
            }
            case SHORT: {
                return rexBuilder.makeExactLiteral(new BigDecimal(((Short)value).shortValue()), typeFactory.createSqlType(SqlTypeName.SMALLINT));
            }
            case FLOAT: {
                return rexBuilder.makeApproxLiteral(new BigDecimal(Float.toString(((Float)value).floatValue())), typeFactory.createSqlType(SqlTypeName.FLOAT));
            }
            case DOUBLE: {
                return rexBuilder.makeApproxLiteral(new BigDecimal(Double.toString((Double)value)), typeFactory.createSqlType(SqlTypeName.DOUBLE));
            }
            case DECIMAL: {
                return rexBuilder.makeExactLiteral((BigDecimal)value);
            }
            case BOOLEAN: {
                return rexBuilder.makeLiteral((Boolean)value);
            }
            case DATE: {
                return rexBuilder.makeDateLiteral(new DateString(value.toString()));
            }
            case TIME: {
                return rexBuilder.makeTimeLiteral(new TimeString(value.toString()), -1);
            }
            case TIMESTAMP: {
                return rexBuilder.makeTimestampLiteral(new TimestampString(value.toString()), -1);
            }
        }
        throw new UnsupportedOperationException("Unsupported literal type: " + String.valueOf((Object)node.getType()));
    }

    @Override
    public RexNode visitInterval(Interval node, CalcitePlanContext context) {
        RexNode value = this.analyze(node.getValue(), context);
        SqlIntervalQualifier intervalQualifier = context.rexBuilder.createIntervalUntil(PlanUtils.intervalUnitToSpanUnit(node.getUnit()));
        return context.rexBuilder.makeIntervalLiteral(new BigDecimal(value.toString()), intervalQualifier);
    }

    @Override
    public RexNode visitAnd(And node, CalcitePlanContext context) {
        RelDataType booleanType = context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN);
        RexNode left = this.analyze(node.getLeft(), context);
        RexNode right = this.analyze(node.getRight(), context);
        return context.rexBuilder.makeCall(booleanType, (SqlOperator)SqlStdOperatorTable.AND, List.of(left, right));
    }

    @Override
    public RexNode visitOr(Or node, CalcitePlanContext context) {
        RexNode left = this.analyze(node.getLeft(), context);
        RexNode right = this.analyze(node.getRight(), context);
        return context.relBuilder.or(new RexNode[]{left, right});
    }

    @Override
    public RexNode visitXor(Xor node, CalcitePlanContext context) {
        RexNode left = this.analyze(node.getLeft(), context);
        RexNode right = this.analyze(node.getRight(), context);
        return context.relBuilder.notEquals(left, right);
    }

    @Override
    public RexNode visitNot(Not node, CalcitePlanContext context) {
        RexNode expr = this.analyze(node.getExpression(), context);
        return context.relBuilder.not(expr);
    }

    @Override
    public RexNode visitIn(In node, CalcitePlanContext context) {
        RexNode field = this.analyze(node.getField(), context);
        List<RexNode> valueList = node.getValueList().stream().map(value -> this.analyze((UnresolvedExpression)value, context)).toList();
        ArrayList<RelDataType> dataTypes = new ArrayList<RelDataType>(valueList.stream().map(RexNode::getType).toList());
        dataTypes.add(field.getType());
        RelDataType commonType = context.rexBuilder.getTypeFactory().leastRestrictive(dataTypes);
        if (commonType != null) {
            List<RexNode> newValueList = valueList.stream().map(value -> context.rexBuilder.makeCast(commonType, (RexNode)value)).toList();
            return context.rexBuilder.makeIn(field, newValueList);
        }
        List<ExprType> exprTypes = dataTypes.stream().map(OpenSearchTypeFactory::convertRelDataTypeToExprType).toList();
        throw new SemanticCheckException(StringUtils.format((String)"In expression types are incompatible: fields type %s, values type %s", (Object[])new Object[]{exprTypes.getLast(), exprTypes.subList(0, exprTypes.size() - 1)}));
    }

    @Override
    public RexNode visitCompare(Compare node, CalcitePlanContext context) {
        RexNode left = this.analyze(node.getLeft(), context);
        RexNode right = this.analyze(node.getRight(), context);
        return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, node.getOperator(), left, right);
    }

    @Override
    public RexNode visitBetween(Between node, CalcitePlanContext context) {
        RexNode value = this.analyze(node.getValue(), context);
        RexNode lowerBound = this.analyze(node.getLowerBound(), context);
        RexNode upperBound = this.analyze(node.getUpperBound(), context);
        RelDataType commonType = context.rexBuilder.commonType(value, lowerBound, upperBound);
        if (commonType == null) {
            throw new SemanticCheckException(StringUtils.format((String)"BETWEEN expression types are incompatible: [%s, %s, %s]", (Object[])new Object[]{OpenSearchTypeFactory.convertRelDataTypeToExprType(value.getType()), OpenSearchTypeFactory.convertRelDataTypeToExprType(lowerBound.getType()), OpenSearchTypeFactory.convertRelDataTypeToExprType(upperBound.getType())}));
        }
        lowerBound = context.rexBuilder.makeCast(commonType, lowerBound);
        upperBound = context.rexBuilder.makeCast(commonType, upperBound);
        return context.relBuilder.between(value, lowerBound, upperBound);
    }

    @Override
    public RexNode visitEqualTo(EqualTo node, CalcitePlanContext context) {
        RexNode left = this.analyze(node.getLeft(), context);
        RexNode right = this.analyze(node.getRight(), context);
        return context.rexBuilder.equals(left, right);
    }

    @Override
    public RexNode visitQualifiedName(QualifiedName node, CalcitePlanContext context) {
        return QualifiedNameResolver.resolve(node, context);
    }

    @Override
    public RexNode visitAlias(Alias node, CalcitePlanContext context) {
        RexNode expr = this.analyze(node.getDelegated(), context);
        return context.relBuilder.alias(expr, Strings.isEmpty((CharSequence)node.getAlias()) ? node.getName() : node.getAlias());
    }

    @Override
    public RexNode visitSpan(Span node, CalcitePlanContext context) {
        RexNode field = this.analyze(node.getField(), context);
        RexNode value = this.analyze(node.getValue(), context);
        SpanUnit unit = node.getUnit();
        RexBuilder rexBuilder = context.relBuilder.getRexBuilder();
        RexLiteral unitNode = this.isTimeBased(unit) ? rexBuilder.makeLiteral(unit.getName()) : rexBuilder.constantNull();
        return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.SPAN, new RexNode[]{field, value, unitNode});
    }

    private boolean isTimeBased(SpanUnit unit) {
        return unit != SpanUnit.NONE && unit != SpanUnit.UNKNOWN;
    }

    @Override
    public RexNode visitLambdaFunction(LambdaFunction node, CalcitePlanContext context) {
        try {
            List<QualifiedName> names = node.getFuncArgs();
            List args = IntStream.range(0, names.size()).mapToObj(i -> context.rexLambdaRefMap.getOrDefault(((QualifiedName)names.get(i)).toString(), new RexLambdaRef(i, ((QualifiedName)names.get(i)).toString(), OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.ANY)))).collect(Collectors.toList());
            RexNode body = node.getFunction().accept(this, context);
            List<RexNode> capturedVars = context.getCapturedVariables();
            if (capturedVars != null && !capturedVars.isEmpty()) {
                args = new ArrayList(args);
                for (int i2 = 0; i2 < capturedVars.size(); ++i2) {
                    RexLambdaRef capturedRef = context.getRexLambdaRefMap().get("__captured_" + i2);
                    if (capturedRef == null) continue;
                    args.add(capturedRef);
                }
            }
            RexNode lambdaNode = context.rexBuilder.makeLambdaCall(body, args);
            return lambdaNode;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create lambda function", e);
        }
    }

    @Override
    public RexNode visitLet(Let node, CalcitePlanContext context) {
        RexNode expr = this.analyze(node.getExpression(), context);
        return context.relBuilder.alias(expr, node.getVar().getField().toString());
    }

    public CalcitePlanContext prepareLambdaContext(CalcitePlanContext context, LambdaFunction node, List<RexNode> previousArgument, String functionName, @Nullable RelDataType defaultTypeForReduceAcc) {
        try {
            CalcitePlanContext lambdaContext = context.clone();
            List<RelDataType> candidateType = new ArrayList<RelDataType>();
            candidateType.add(((ArraySqlType)previousArgument.get(0).getType()).getComponentType());
            candidateType.addAll(previousArgument.stream().skip(1L).map(RexNode::getType).toList());
            candidateType = this.modifyLambdaTypeByFunction(functionName, candidateType, defaultTypeForReduceAcc);
            List<QualifiedName> argNames = node.getFuncArgs();
            HashMap<String, RexLambdaRef> lambdaTypes = new HashMap<String, RexLambdaRef>();
            int candidateIndex = 0;
            for (int i = 0; i < argNames.size(); ++i) {
                RelDataType type;
                if (candidateIndex < candidateType.size()) {
                    type = candidateType.get(candidateIndex);
                    ++candidateIndex;
                } else {
                    type = OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER);
                }
                lambdaTypes.put(argNames.get(i).toString(), new RexLambdaRef(i, argNames.get(i).toString(), type));
            }
            lambdaContext.putRexLambdaRefMap(lambdaTypes);
            return lambdaContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to prepare lambda context", e);
        }
    }

    private List<RelDataType> modifyLambdaTypeByFunction(String functionName, List<RelDataType> originalType, @Nullable RelDataType defaultTypeForReduceAcc) {
        switch (functionName.toUpperCase(Locale.ROOT)) {
            case "REDUCE": {
                if (originalType.size() == 2) {
                    if (defaultTypeForReduceAcc != null) {
                        return List.of(defaultTypeForReduceAcc, originalType.get(0));
                    }
                    return List.of(originalType.get(1), originalType.get(0));
                }
                return List.of(originalType.get(2));
            }
        }
        return originalType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RexNode visitFunction(Function node, CalcitePlanContext context) {
        RexNode resolvedNode;
        List<UnresolvedExpression> args = node.getFuncArgs();
        ArrayList<RexNode> arguments = new ArrayList<RexNode>();
        boolean isCoalesce = "coalesce".equalsIgnoreCase(node.getFuncName());
        if (isCoalesce) {
            context.setInCoalesceFunction(true);
        }
        List<RexNode> capturedVars = null;
        try {
            for (UnresolvedExpression arg : args) {
                if (arg instanceof LambdaFunction) {
                    CalcitePlanContext lambdaContext = this.prepareLambdaContext(context, (LambdaFunction)arg, arguments, node.getFuncName(), null);
                    RexNode lambdaNode = this.analyze(arg, lambdaContext);
                    if (node.getFuncName().equalsIgnoreCase("reduce")) {
                        lambdaContext = this.prepareLambdaContext(context, (LambdaFunction)arg, arguments, node.getFuncName(), lambdaNode.getType());
                        lambdaNode = this.analyze(arg, lambdaContext);
                    }
                    arguments.add(lambdaNode);
                    capturedVars = lambdaContext.getCapturedVariables();
                    continue;
                }
                arguments.add(this.analyze(arg, context));
            }
        }
        finally {
            if (isCoalesce) {
                context.setInCoalesceFunction(false);
            }
        }
        if (capturedVars != null && !capturedVars.isEmpty() && (node.getFuncName().equalsIgnoreCase("mvmap") || node.getFuncName().equalsIgnoreCase("transform"))) {
            arguments = new ArrayList<RexNode>(arguments);
            arguments.addAll((Collection<RexNode>)capturedVars);
        }
        if ("LIKE".equalsIgnoreCase(node.getFuncName()) && arguments.size() == 2) {
            RexLiteral defaultCaseSensitive = CalcitePlanContext.isLegacyPreferred() ? context.rexBuilder.makeLiteral(false) : context.rexBuilder.makeLiteral(true);
            arguments = new ArrayList<RexNode>(arguments);
            arguments.add((RexNode)defaultCaseSensitive);
        }
        if ((resolvedNode = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, node.getFuncName(), arguments.toArray(new RexNode[0]))) != null) {
            return resolvedNode;
        }
        throw new IllegalArgumentException("Unsupported operator: " + node.getFuncName());
    }

    @Override
    public RexNode visitWindowFunction(WindowFunction node, CalcitePlanContext context) {
        Function windowFunction = (Function)node.getFunction();
        List<RexNode> arguments = windowFunction.getFuncArgs().stream().map(arg -> this.analyze((UnresolvedExpression)arg, context)).toList();
        List<RexNode> partitions = node.getPartitionByList().stream().map(arg -> this.analyze((UnresolvedExpression)arg, context)).map(this::extractRexNodeFromAlias).toList();
        return BuiltinFunctionName.ofWindowFunction(windowFunction.getFuncName()).map(functionName -> {
            List<RexNode> args;
            RexNode field = arguments.isEmpty() ? null : (RexNode)arguments.getFirst();
            List<RexNode> nodes = PPLFuncImpTable.INSTANCE.validateAggFunctionSignature((BuiltinFunctionName)((Object)functionName), field, args = arguments.isEmpty() || arguments.size() == 1 ? Collections.emptyList() : arguments.subList(1, arguments.size()), context.rexBuilder);
            return nodes != null ? PlanUtils.makeOver(context, functionName, nodes.getFirst(), nodes.size() <= 1 ? Collections.emptyList() : nodes.subList(1, nodes.size()), partitions, List.of(), node.getWindowFrame()) : PlanUtils.makeOver(context, functionName, field, args, partitions, List.of(), node.getWindowFrame());
        }).orElseThrow(() -> new UnsupportedOperationException("Unexpected window function: " + windowFunction.getFuncName()));
    }

    private RexNode extractRexNodeFromAlias(RexNode node) {
        Objects.requireNonNull(node);
        if (node.getKind() == SqlKind.AS) {
            return (RexNode)((RexCall)node).getOperands().get(0);
        }
        return node;
    }

    @Override
    public RexNode visitInSubquery(InSubquery node, CalcitePlanContext context) {
        List<RexNode> nodes = node.getChild().stream().map(child -> this.analyze((UnresolvedExpression)child, context)).toList();
        UnresolvedPlan subquery = node.getQuery();
        RelNode subqueryRel = this.resolveSubqueryPlan(subquery, node, context);
        if (subqueryRel.getRowType().getFieldCount() != nodes.size()) {
            throw new SemanticCheckException("The number of columns in the left hand side of an IN subquery does not match the number of columns in the output of subquery");
        }
        return context.relBuilder.in(subqueryRel, nodes);
    }

    @Override
    public RexNode visitScalarSubquery(ScalarSubquery node, CalcitePlanContext context) {
        return context.relBuilder.scalarQuery(b -> {
            UnresolvedPlan subquery = node.getQuery();
            return this.resolveSubqueryPlan(subquery, node, context);
        });
    }

    @Override
    public RexNode visitExistsSubquery(ExistsSubquery node, CalcitePlanContext context) {
        return context.relBuilder.exists(b -> {
            UnresolvedPlan subquery = node.getQuery();
            return this.resolveSubqueryPlan(subquery, node, context);
        });
    }

    private RelNode resolveSubqueryPlan(UnresolvedPlan subquery, SubqueryExpression subqueryExpression, CalcitePlanContext context) {
        boolean isNestedSubquery = context.isResolvingSubquery();
        context.setResolvingSubquery(true);
        boolean isResolvingJoinConditionOuter = context.isResolvingJoinCondition();
        if (isResolvingJoinConditionOuter) {
            context.setResolvingJoinCondition(false);
        }
        subquery.accept(this.planVisitor, context);
        if (context.sysLimit.subsearchLimit() > 0 && !(subqueryExpression instanceof ScalarSubquery)) {
            SubsearchUtils.SystemLimitInsertionShuttle shuttle = new SubsearchUtils.SystemLimitInsertionShuttle(context);
            Object replacement = context.relBuilder.peek().accept((RelShuttle)shuttle);
            if (!shuttle.isCorrelatedConditionFound()) {
                replacement = LogicalSystemLimit.create(LogicalSystemLimit.SystemLimitType.SUBSEARCH_MAXOUT, replacement, (RexNode)context.relBuilder.literal(context.sysLimit.subsearchLimit()));
            }
            PlanUtils.replaceTop(context.relBuilder, replacement);
        }
        RelNode subqueryRel = context.relBuilder.build();
        if (isResolvingJoinConditionOuter) {
            context.setResolvingJoinCondition(true);
        }
        if (!isNestedSubquery) {
            context.setResolvingSubquery(false);
        }
        return subqueryRel;
    }

    @Override
    public RexNode visitCast(Cast node, CalcitePlanContext context) {
        RexNode expr = this.analyze(node.getExpression(), context);
        RelDataType type = OpenSearchTypeFactory.convertExprTypeToRelDataType(node.getDataType().getCoreType());
        RelDataType nullableType = context.rexBuilder.getTypeFactory().createTypeWithNullability(type, true);
        return context.rexBuilder.makeCast(nullableType, expr, true, true);
    }

    @Override
    public RexNode visitCase(Case node, CalcitePlanContext context) {
        ArrayList<RexNode> caseOperands = new ArrayList<RexNode>();
        for (When when : node.getWhenClauses()) {
            RexNode condition = this.analyze(when.getCondition(), context);
            if (!SqlTypeUtil.isBoolean((RelDataType)condition.getType())) {
                throw new ExpressionEvaluationException(StringUtils.format((String)"Condition expected a boolean type, but got %s", (Object[])new Object[]{condition.getType()}));
            }
            caseOperands.add(condition);
            caseOperands.add(this.analyze(when.getResult(), context));
        }
        RexNode elseExpr = node.getElseClause().map(e -> this.analyze((UnresolvedExpression)e, context)).orElse((RexNode)context.relBuilder.literal(null));
        caseOperands.add(elseExpr);
        return context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
    }

    @Override
    public RexNode visitWhen(When node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("CastWhen function is unsupported in Calcite");
    }

    @Override
    public RexNode visitHighlightFunction(HighlightFunction node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Highlight function is unsupported in Calcite");
    }

    @Override
    public RexNode visitScoreFunction(ScoreFunction node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Score function is unsupported in Calcite");
    }

    @Override
    public RexNode visitRelevanceFieldList(RelevanceFieldList node, CalcitePlanContext context) {
        ArrayList varArgRexNodeList = new ArrayList();
        node.getFieldList().forEach((k, v) -> {
            varArgRexNodeList.add(context.rexBuilder.makeLiteral(k, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true));
            varArgRexNodeList.add(context.rexBuilder.makeLiteral(v, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DOUBLE), true));
        });
        return context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, varArgRexNodeList);
    }

    @Override
    public RexNode visitUnresolvedArgument(UnresolvedArgument node, CalcitePlanContext context) {
        RexNode value = this.analyze(node.getValue(), context);
        return context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, new RexNode[]{context.rexBuilder.makeLiteral(node.getArgName()), value});
    }

    @Generated
    public CalciteRexNodeVisitor(CalciteRelNodeVisitor planVisitor) {
        this.planVisitor = planVisitor;
    }
}

