/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.decoder.http.impl;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;

public class SimplePayloadBodyHandler
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SimplePayloadBodyHandler.class);

    @Override
    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        List<XMLObject> bodyChildren;
        Envelope env = messageContext.ensureSubcontext(SOAP11Context.class).getEnvelope();
        if (env == null) {
            throw new MessageHandlerException("SOAP envelope was null");
        }
        Body body = env.getBody();
        List<XMLObject> list = bodyChildren = body != null ? body.getUnknownXMLObjects() : null;
        if (bodyChildren == null || bodyChildren.isEmpty()) {
            throw new MessageHandlerException("SOAP Envelope Body contained no children");
        }
        if (bodyChildren.size() > 1) {
            this.log.warn("SOAP Envelope Body contained more than one child, returning the first as the message");
        }
        assert (body != null);
        messageContext.setMessage(body.getUnknownXMLObjects().get(0));
    }
}

