/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ism.FailedIndex;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RetryIndexResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RetryIndexResponse> {
    @Nonnull
    private final List<FailedIndex> failedIndices;
    @Nullable
    private final Boolean failures;
    @Nullable
    private final Number updatedIndices;
    public static final JsonpDeserializer<RetryIndexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RetryIndexResponse::setupRetryIndexResponseDeserializer);

    private RetryIndexResponse(Builder builder) {
        this.failedIndices = ApiTypeHelper.unmodifiable(builder.failedIndices);
        this.failures = builder.failures;
        this.updatedIndices = builder.updatedIndices;
    }

    public static RetryIndexResponse of(Function<Builder, ObjectBuilder<RetryIndexResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<FailedIndex> failedIndices() {
        return this.failedIndices;
    }

    @Nullable
    public final Boolean failures() {
        return this.failures;
    }

    @Nullable
    public final Number updatedIndices() {
        return this.updatedIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.failedIndices)) {
            generator.writeKey("failed_indices");
            generator.writeStartArray();
            for (FailedIndex item0 : this.failedIndices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.failures != null) {
            generator.writeKey("failures");
            generator.write(this.failures.booleanValue());
        }
        if (this.updatedIndices != null) {
            generator.writeKey("updated_indices");
            generator.write(this.updatedIndices.doubleValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRetryIndexResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failedIndices, JsonpDeserializer.arrayDeserializer(FailedIndex._DESERIALIZER), "failed_indices");
        op.add(Builder::failures, JsonpDeserializer.booleanDeserializer(), "failures");
        op.add(Builder::updatedIndices, JsonpDeserializer.numberDeserializer(), "updated_indices");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.failedIndices);
        result = 31 * result + Objects.hashCode(this.failures);
        result = 31 * result + Objects.hashCode(this.updatedIndices);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryIndexResponse other = (RetryIndexResponse)o;
        return Objects.equals(this.failedIndices, other.failedIndices) && Objects.equals(this.failures, other.failures) && Objects.equals(this.updatedIndices, other.updatedIndices);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RetryIndexResponse> {
        @Nullable
        private List<FailedIndex> failedIndices;
        @Nullable
        private Boolean failures;
        @Nullable
        private Number updatedIndices;

        public Builder() {
        }

        private Builder(RetryIndexResponse o) {
            this.failedIndices = Builder._listCopy(o.failedIndices);
            this.failures = o.failures;
            this.updatedIndices = o.updatedIndices;
        }

        private Builder(Builder o) {
            this.failedIndices = Builder._listCopy(o.failedIndices);
            this.failures = o.failures;
            this.updatedIndices = o.updatedIndices;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder failedIndices(List<FailedIndex> list) {
            this.failedIndices = Builder._listAddAll(this.failedIndices, list);
            return this;
        }

        @Nonnull
        public final Builder failedIndices(FailedIndex value, FailedIndex ... values) {
            this.failedIndices = Builder._listAdd(this.failedIndices, value, values);
            return this;
        }

        @Nonnull
        public final Builder failedIndices(Function<FailedIndex.Builder, ObjectBuilder<FailedIndex>> fn) {
            return this.failedIndices(fn.apply(new FailedIndex.Builder()).build(), new FailedIndex[0]);
        }

        @Nonnull
        public final Builder failures(@Nullable Boolean value) {
            this.failures = value;
            return this;
        }

        @Nonnull
        public final Builder updatedIndices(@Nullable Number value) {
            this.updatedIndices = value;
            return this;
        }

        @Override
        @Nonnull
        public RetryIndexResponse build() {
            this._checkSingleUse();
            return new RetryIndexResponse(this);
        }
    }
}

