/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality;

import ai.djl.modality.Input;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class Output
extends Input {
    private static final long serialVersionUID = 1L;
    private int code;
    private String message;

    public Output() {
        this(200, "OK");
    }

    public Output(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public byte[] encode() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            DataOutputStream os = new DataOutputStream(baos);
            os.writeLong(1L);
            this.encodeInputBase(os);
            os.writeInt(this.code);
            os.writeUTF(this.message);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static Output decode(InputStream is) throws IOException {
        try (DataInputStream dis = new DataInputStream(is);){
            if (1L != dis.readLong()) {
                throw new IllegalArgumentException("Invalid Input version");
            }
            Output output = new Output();
            Output.decodeInputBase(dis, output);
            output.code = dis.readInt();
            output.message = dis.readUTF();
            Output output2 = output;
            return output2;
        }
    }

    @Override
    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.deepEquals(o)) {
            return false;
        }
        Output output = (Output)o;
        return this.code == output.code && Objects.equals(this.message, output.message);
    }
}

