/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.jobs.processors;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.agent.LLMSpec;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.jobs.processors.MLJobProcessor;
import org.opensearch.ml.stats.otel.counters.MLAdoptionMetricsCounter;
import org.opensearch.ml.stats.otel.metrics.AdoptionMetric;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.telemetry.metrics.tags.Tags;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class MLStatsJobProcessor
extends MLJobProcessor {
    private static final Logger log = LogManager.getLogger(MLStatsJobProcessor.class);
    private static final String TAG_AGENT_MODEL = "model";
    private static final String TAG_AGENT_MODEL_SERVICE_PROVIDER = "model_service_provider";
    private static final String TAG_AGENT_MODEL_DEPLOYMENT = "model_deployment";
    private static final String TAG_AGENT_MODEL_TYPE = "model_type";
    private static final String MODEL_TAG_MODEL = "model";
    private static final String MODEL_TAG_SERVICE_PROVIDER = "service_provider";
    private static final String MODEL_TAG_DEPLOYMENT = "deployment";
    private static final String MODEL_TAG_TYPE = "type";
    private static final int BATCH_SIZE = 10000;
    private static MLStatsJobProcessor instance;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final SdkClient sdkClient;
    private final Map<String, Tags> modelTagsCache = new HashMap<String, Tags>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLStatsJobProcessor getInstance(ClusterService clusterService, Client client, ThreadPool threadPool, ConnectorAccessControlHelper connectorAccessControlHelper, SdkClient sdkClient) {
        if (instance != null) {
            return instance;
        }
        Class<MLStatsJobProcessor> clazz = MLStatsJobProcessor.class;
        synchronized (MLStatsJobProcessor.class) {
            if (instance != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return instance;
            }
            instance = new MLStatsJobProcessor(clusterService, client, threadPool, connectorAccessControlHelper, sdkClient);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void reset() {
        instance = null;
    }

    public MLStatsJobProcessor(ClusterService clusterService, Client client, ThreadPool threadPool, ConnectorAccessControlHelper connectorAccessControlHelper, SdkClient sdkClient) {
        super(clusterService, client, threadPool);
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.sdkClient = sdkClient;
    }

    @Override
    public void run() {
        this.modelTagsCache.clear();
        this.collectModelAndAgentMetrics();
    }

    private void collectModelAndAgentMetrics() {
        if (!this.clusterService.state().metadata().indices().containsKey(".plugins-ml-model")) {
            log.info("Skipping ML model metrics collection - ML model index not found");
            return;
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"chunk_number"));
        searchSourceBuilder.query((QueryBuilder)boolQuery);
        searchSourceBuilder.size(10000);
        searchRequest.source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                for (SearchHit hit : searchResponse.getHits()) {
                    try {
                        String modelId;
                        XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        parser.nextToken();
                        String algorithmName = hit.getSourceAsMap().get("algorithm").toString();
                        MLModel model = MLModel.parse((XContentParser)parser, (String)algorithmName);
                        String string = modelId = model.getModelId() == null ? hit.getId() : model.getModelId();
                        if (model.getConnector() == null && model.getConnectorId() != null) {
                            try (ThreadContext.StoredContext context = MLStatsJobProcessor.this.client.threadPool().getThreadContext().stashContext();){
                                GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-connector")).id(model.getConnectorId())).build();
                                MLStatsJobProcessor.this.connectorAccessControlHelper.getConnector(MLStatsJobProcessor.this.sdkClient, MLStatsJobProcessor.this.client, context, getDataObjectRequest, model.getConnectorId(), (ActionListener<Connector>)ActionListener.wrap(connector -> {
                                    Tags modelTags = model.getTags(connector);
                                    MLStatsJobProcessor.this.modelTagsCache.put(modelId, modelTags);
                                    MLAdoptionMetricsCounter.getInstance().incrementCounter(AdoptionMetric.MODEL_COUNT, modelTags);
                                }, e -> log.error("Failed to get connector for model: {}", (Object)modelId, e)));
                            }
                            return;
                        }
                        Tags modelTags = model.getTags();
                        MLStatsJobProcessor.this.modelTagsCache.put(modelId, modelTags);
                        MLAdoptionMetricsCounter.getInstance().incrementCounter(AdoptionMetric.MODEL_COUNT, modelTags);
                    }
                    catch (Exception e2) {
                        log.error("Failed to parse model from hit: {}", (Object)hit.getId(), (Object)e2);
                    }
                }
                MLStatsJobProcessor.this.collectAgentMetrics();
            }

            public void onFailure(Exception e) {
                log.error("Failed to fetch models", (Throwable)e);
            }
        });
    }

    private void collectAgentMetrics() {
        if (!this.clusterService.state().metadata().indices().containsKey(".plugins-ml-agent")) {
            log.info("Skipping ML agent metrics collection - ML agent index not found");
            return;
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-agent"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(10000);
        searchRequest.source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                for (SearchHit hit : searchResponse.getHits()) {
                    try {
                        XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        parser.nextToken();
                        MLAgent agent = MLAgent.parse((XContentParser)parser);
                        Tags agentTags = agent.getTags();
                        Optional.of(agent).map(MLAgent::getLlm).map(LLMSpec::getModelId).map(MLStatsJobProcessor.this.modelTagsCache::get).map(Tags::getTagsMap).ifPresent(tagsMap -> {
                            MLStatsJobProcessor.this.addTagIfExists((Map<String, ?>)tagsMap, "model", "model", agentTags);
                            MLStatsJobProcessor.this.addTagIfExists((Map<String, ?>)tagsMap, MLStatsJobProcessor.MODEL_TAG_SERVICE_PROVIDER, MLStatsJobProcessor.TAG_AGENT_MODEL_SERVICE_PROVIDER, agentTags);
                            MLStatsJobProcessor.this.addTagIfExists((Map<String, ?>)tagsMap, MLStatsJobProcessor.MODEL_TAG_DEPLOYMENT, MLStatsJobProcessor.TAG_AGENT_MODEL_DEPLOYMENT, agentTags);
                            MLStatsJobProcessor.this.addTagIfExists((Map<String, ?>)tagsMap, MLStatsJobProcessor.MODEL_TAG_TYPE, MLStatsJobProcessor.TAG_AGENT_MODEL_TYPE, agentTags);
                        });
                        MLAdoptionMetricsCounter.getInstance().incrementCounter(AdoptionMetric.AGENT_COUNT, agentTags);
                    }
                    catch (Exception e) {
                        log.error("Failed to parse agent from hit: {}", (Object)hit.getId(), (Object)e);
                    }
                }
            }

            public void onFailure(Exception e) {
                log.error("Failed to fetch agents", (Throwable)e);
            }
        });
    }

    @VisibleForTesting
    void addTagIfExists(Map<String, ?> sourceTagsMap, String sourceKey, String targetKey, Tags targetTags) {
        if (sourceTagsMap.containsKey(sourceKey) && sourceTagsMap.get(sourceKey) != null) {
            targetTags.addTag(targetKey, (String)sourceTagsMap.get(sourceKey));
        }
    }
}

