/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.contextmanagement;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.inject.Inject;
import org.opensearch.ml.common.contextmanager.ActivationRuleFactory;
import org.opensearch.ml.common.contextmanager.ContextManager;
import org.opensearch.ml.common.contextmanager.ContextManagerConfig;
import org.opensearch.ml.engine.algorithms.contextmanager.SlidingWindowManager;
import org.opensearch.ml.engine.algorithms.contextmanager.SummarizationManager;
import org.opensearch.ml.engine.algorithms.contextmanager.ToolsOutputTruncateManager;
import org.opensearch.transport.client.Client;

public class ContextManagerFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(ContextManagerFactory.class);
    private final ActivationRuleFactory activationRuleFactory;
    private final Client client;

    @Inject
    public ContextManagerFactory(ActivationRuleFactory activationRuleFactory, Client client) {
        this.activationRuleFactory = activationRuleFactory;
        this.client = client;
    }

    public ContextManager createContextManager(ContextManagerConfig config) {
        if (config == null || config.getType() == null) {
            throw new IllegalArgumentException("Context manager configuration and type cannot be null");
        }
        String type = config.getType();
        Map managerConfig = config.getConfig();
        Map activationConfig = config.getActivation();
        log.debug("Creating context manager of type: {}", (Object)type);
        ContextManager manager = switch (type) {
            case "ToolsOutputTruncateManager" -> this.createToolsOutputTruncateManager(managerConfig);
            case "SlidingWindowManager" -> this.createSlidingWindowManager(managerConfig);
            case "SummarizationManager" -> this.createSummarizationManager(managerConfig);
            default -> throw new IllegalArgumentException("Unsupported context manager type: " + type);
        };
        try {
            HashMap<String, Map> fullConfig = new HashMap<String, Map>();
            if (managerConfig != null) {
                fullConfig.putAll(managerConfig);
            }
            if (activationConfig != null) {
                fullConfig.put("activation", activationConfig);
            }
            manager.initialize(fullConfig);
            log.debug("Successfully created and initialized context manager: {}", (Object)type);
            return manager;
        }
        catch (Exception e) {
            log.error("Failed to initialize context manager of type: {}", (Object)type, (Object)e);
            throw new RuntimeException("Failed to initialize context manager: " + type, e);
        }
    }

    private ContextManager createToolsOutputTruncateManager(Map<String, Object> config) {
        return new ToolsOutputTruncateManager();
    }

    private ContextManager createSlidingWindowManager(Map<String, Object> config) {
        return new SlidingWindowManager();
    }

    private ContextManager createSummarizationManager(Map<String, Object> config) {
        return new SummarizationManager(this.client);
    }
}

