/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.memory;

import com.google.gson.Gson;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLMemoryType;
import org.opensearch.ml.common.connector.AwsConnector;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.HttpConnector;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.memory.Memory;
import org.opensearch.ml.common.memory.Message;
import org.opensearch.ml.common.memorycontainer.MLWorkingMemory;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLAddMemoriesResponse;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLGetMemoryResponse;
import org.opensearch.ml.engine.MLEngineClassLoader;
import org.opensearch.ml.engine.algorithms.remote.RemoteConnectorExecutor;
import org.opensearch.ml.engine.memory.ConversationIndexMessage;
import org.opensearch.ml.memory.action.conversation.CreateInteractionResponse;
import org.opensearch.script.ScriptService;
import org.opensearch.search.SearchHit;
import org.opensearch.transport.client.Client;

public class RemoteAgenticConversationMemory
implements Memory<Message, CreateInteractionResponse, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(RemoteAgenticConversationMemory.class);
    public static final String TYPE = MLMemoryType.REMOTE_AGENTIC_MEMORY.name();
    private static final String SESSION_ID_FIELD = "session_id";
    private static final String CREATED_TIME_FIELD = "created_time";
    private static final Gson GSON = new Gson();
    private final String conversationId;
    private final String memoryContainerId;
    private final String userId;
    private final Connector connector;
    private final RemoteConnectorExecutor executor;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RemoteAgenticConversationMemory(String memoryId, String memoryContainerId, String userId, Connector connector, ScriptService scriptService, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.conversationId = memoryId;
        this.memoryContainerId = memoryContainerId;
        this.userId = userId;
        this.connector = connector;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.executor = (RemoteConnectorExecutor)MLEngineClassLoader.initInstance(connector.getProtocol(), connector, Connector.class);
        this.executor.setScriptService(scriptService);
        this.executor.setClusterService(clusterService);
        this.executor.setClient(client);
        this.executor.setXContentRegistry(xContentRegistry);
        this.executor.setConnectorPrivateIpEnabled(mlFeatureEnabledSetting.isConnectorPrivateIpEnabled());
        log.info("RemoteAgenticConversationMemory created - sessionId: {}, containerId: {}, endpoint: {}, protocol: {}", (Object)memoryId, (Object)memoryContainerId, connector.getParameters() != null ? connector.getParameters().get("endpoint") : "unknown", (Object)connector.getProtocol());
    }

    public String getType() {
        return TYPE;
    }

    public String getId() {
        return this.conversationId;
    }

    public void save(Message message, String parentId, Integer traceNum, String action) {
        this.save(message, parentId, traceNum, action, (ActionListener<CreateInteractionResponse>)ActionListener.wrap(r -> log.info("Saved message to remote agentic memory, session id: {}, working memory id: {}", (Object)this.conversationId, (Object)r.getId()), e -> log.error("Failed to save message to remote agentic memory", (Throwable)e)));
    }

    public void save(Message message, String parentId, Integer traceNum, String action, ActionListener<CreateInteractionResponse> listener) {
        if (Strings.isNullOrEmpty((String)this.memoryContainerId)) {
            listener.onFailure((Exception)new IllegalStateException("Memory container ID is not configured for this RemoteAgenticConversationMemory. Cannot save messages without a valid memory container."));
            return;
        }
        ConversationIndexMessage msg = (ConversationIndexMessage)message;
        HashMap<String, String> namespace = new HashMap<String, String>();
        namespace.put(SESSION_ID_FIELD, this.conversationId);
        if (!Strings.isNullOrEmpty((String)this.userId)) {
            namespace.put("user_id", this.userId);
        }
        boolean isTrace = traceNum != null;
        HashMap<String, String> metadata = new HashMap<String, String>();
        HashMap<String, Object> structuredData = new HashMap<String, Object>();
        structuredData.put("input", msg.getQuestion() != null ? msg.getQuestion() : "");
        structuredData.put("response", msg.getResponse() != null ? msg.getResponse() : "");
        if (isTrace) {
            metadata.put("type", "trace");
            if (parentId != null) {
                metadata.put("parent_message_id", parentId);
                structuredData.put("parent_message_id", parentId);
            }
            metadata.put("trace_number", String.valueOf(traceNum));
            structuredData.put("trace_number", traceNum);
            if (action != null) {
                metadata.put("origin", action);
                structuredData.put("origin", action);
            }
        } else {
            metadata.put("type", "message");
            if (msg.getFinalAnswer() != null) {
                structuredData.put("final_answer", msg.getFinalAnswer());
            }
        }
        Instant now = Instant.now();
        structuredData.put("create_time", now.toString());
        structuredData.put("updated_time", now.toString());
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("memory_container_id", this.memoryContainerId);
        requestBody.put("structured_data_blob", structuredData);
        requestBody.put("message_id", traceNum);
        requestBody.put("namespace", namespace);
        requestBody.put("metadata", metadata);
        requestBody.put("infer", false);
        this.executeConnectorAction("add_memory", requestBody, (ActionListener<String>)ActionListener.wrap(response -> {
            MLAddMemoriesResponse addResponse = this.parseAddMemoryResponse((String)response);
            String workingMemoryId = addResponse.getWorkingMemoryId();
            CreateInteractionResponse interactionResponse = new CreateInteractionResponse(workingMemoryId);
            listener.onResponse((Object)interactionResponse);
        }, e -> {
            log.error("Failed to add memories to remote memory container", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public void update(String messageId, Map<String, Object> updateContent, ActionListener<UpdateResponse> updateListener) {
        if (Strings.isNullOrEmpty((String)this.memoryContainerId)) {
            updateListener.onFailure((Exception)new IllegalStateException("Memory container ID is not configured for this RemoteAgenticConversationMemory"));
            return;
        }
        this.updateWithRetry(messageId, updateContent, updateListener, 0);
    }

    private void updateWithRetry(String messageId, Map<String, Object> updateContent, ActionListener<UpdateResponse> updateListener, int attemptNumber) {
        int maxRetries = 5;
        long baseDelayMs = 500L;
        HashMap<String, Object> getRequest = new HashMap<String, Object>();
        getRequest.put("memory_container_id", this.memoryContainerId);
        getRequest.put("memory_type", "working");
        getRequest.put("memory_id", messageId);
        this.executeConnectorAction("get_memory", getRequest, (ActionListener<String>)ActionListener.wrap(getResponse -> {
            MLGetMemoryResponse memoryResponse = this.parseGetMemoryResponse((String)getResponse);
            MLWorkingMemory workingMemory = memoryResponse.getWorkingMemory();
            HashMap structuredData = workingMemory == null || workingMemory.getStructuredDataBlob() == null ? new HashMap() : new HashMap(workingMemory.getStructuredDataBlob());
            for (Map.Entry entry : updateContent.entrySet()) {
                structuredData.put((String)entry.getKey(), entry.getValue());
            }
            HashMap finalUpdateContent = new HashMap();
            finalUpdateContent.put("structured_data_blob", structuredData);
            HashMap<String, Object> updateRequest = new HashMap<String, Object>();
            updateRequest.put("memory_container_id", this.memoryContainerId);
            updateRequest.put("memory_type", "working");
            updateRequest.put("memory_id", messageId);
            updateRequest.put("update_content", finalUpdateContent);
            this.executeConnectorAction("update_memory", updateRequest, (ActionListener<String>)ActionListener.wrap(response -> {
                log.info("UPDATE memory succeeded! MessageId: {}, Attempt: {}", (Object)messageId, (Object)(attemptNumber + 1));
                try {
                    UpdateResponse updateResponse = this.parseUpdateResponse((String)response);
                    updateListener.onResponse((Object)updateResponse);
                }
                catch (Exception parseException) {
                    log.error("Failed to parse update response from remote memory", (Throwable)parseException);
                    updateListener.onFailure(parseException);
                }
            }, updateException -> {
                log.error("UPDATE memory failed. MessageId: {}, Attempt: {}/{}, Error: {}", (Object)messageId, (Object)(attemptNumber + 1), (Object)6, (Object)updateException.getMessage(), updateException);
                boolean shouldRetry = this.shouldRetryOnError((Exception)updateException, attemptNumber, 5);
                if (shouldRetry) {
                    long delayMs = 500L * (1L << attemptNumber);
                    log.warn("UPDATE operation failed but is retryable. MessageId: {}, Attempt: {}/{}, RetryAfter: {}ms, ErrorType: {}", (Object)messageId, (Object)(attemptNumber + 1), (Object)6, (Object)delayMs, (Object)(updateException.getMessage() != null ? updateException.getMessage().substring(0, Math.min(100, updateException.getMessage().length())) : "null"));
                    try {
                        this.client.threadPool().schedule(() -> this.updateWithRetry(messageId, updateContent, updateListener, attemptNumber + 1), TimeValue.timeValueMillis((long)delayMs), "opensearch_ml_agentic_memory");
                    }
                    catch (Exception scheduleException) {
                        log.error("Failed to schedule retry after UPDATE failure. MessageId: {}", (Object)messageId, (Object)scheduleException);
                        updateListener.onFailure(scheduleException);
                    }
                } else {
                    log.error("UPDATE operation failed and is NOT retryable. MessageId: {}, TotalAttempts: {}", (Object)messageId, (Object)(attemptNumber + 1), updateException);
                    updateListener.onFailure(updateException);
                }
            }));
        }, e -> {
            log.error("GET memory failed. MessageId: {}, Attempt: {}/{}, Error: {}", (Object)messageId, (Object)(attemptNumber + 1), (Object)6, (Object)e.getMessage(), e);
            boolean shouldRetry = this.shouldRetryOnError((Exception)e, attemptNumber, 5);
            if (shouldRetry) {
                long delayMs = 500L * (1L << attemptNumber);
                log.warn("GET operation failed but is retryable. MessageId: {}, Attempt: {}/{}, RetryAfter: {}ms, ErrorType: {}", (Object)messageId, (Object)(attemptNumber + 1), (Object)6, (Object)delayMs, (Object)(e.getMessage() != null ? e.getMessage().substring(0, Math.min(100, e.getMessage().length())) : "null"));
                try {
                    this.client.threadPool().schedule(() -> this.updateWithRetry(messageId, updateContent, updateListener, attemptNumber + 1), TimeValue.timeValueMillis((long)delayMs), "opensearch_ml_agentic_memory");
                }
                catch (Exception scheduleException) {
                    log.error("Failed to schedule retry after GET failure. MessageId: {}", (Object)messageId, (Object)scheduleException);
                    updateListener.onFailure(scheduleException);
                }
            } else {
                log.error("GET operation failed and is NOT retryable. MessageId: {}, TotalAttempts: {}", (Object)messageId, (Object)(attemptNumber + 1), e);
                updateListener.onFailure(e);
            }
        }));
    }

    private boolean shouldRetryOnError(Exception e, int attemptNumber, int maxRetries) {
        if (attemptNumber >= maxRetries) {
            log.info("Retry limit reached. Attempt: {}, MaxRetries: {}", (Object)attemptNumber, (Object)maxRetries);
            return false;
        }
        String errorMessage = e.getMessage();
        if (errorMessage == null) {
            log.info("Error message is null, not retrying. Exception type: {}", (Object)e.getClass().getName());
            return false;
        }
        if (errorMessage.contains("404") || errorMessage.contains("\"found\":false")) {
            log.info("Detected 404/not found error, will retry. Error: {}", (Object)errorMessage);
            return true;
        }
        if (errorMessage.contains("version_conflict") || errorMessage.contains("VersionConflictEngineException")) {
            log.info("Detected version conflict error, will retry. Error: {}", (Object)errorMessage);
            return true;
        }
        if (errorMessage.contains("timeout") || errorMessage.contains("TimeoutException")) {
            log.info("Detected timeout error, will retry. Error: {}", (Object)errorMessage);
            return true;
        }
        if (errorMessage.contains("ServiceUnavailable") || errorMessage.contains("503") || errorMessage.contains("502") || errorMessage.contains("Bad Gateway")) {
            log.info("Detected service unavailable error, will retry. Error: {}", (Object)errorMessage);
            return true;
        }
        log.info("Error is not retryable. Error: {}", (Object)errorMessage);
        return false;
    }

    public void getMessages(int size, ActionListener<List<Message>> listener) {
        if (Strings.isNullOrEmpty((String)this.memoryContainerId)) {
            listener.onFailure((Exception)new IllegalStateException("Memory container ID is not configured for this RemoteAgenticConversationMemory"));
            return;
        }
        HashMap query = new HashMap();
        HashMap bool = new HashMap();
        ArrayList must = new ArrayList();
        ArrayList<Map<String, Map<String, String>>> mustNot = new ArrayList<Map<String, Map<String, String>>>();
        HashMap<String, String> sessionTerm = new HashMap<String, String>();
        sessionTerm.put("namespace.session_id", this.conversationId);
        must.add(Map.of("term", sessionTerm));
        mustNot.add(Map.of("term", Map.of("metadata.type", "trace")));
        bool.put("must", must);
        bool.put("must_not", mustNot);
        query.put("bool", bool);
        HashMap<String, Object> searchRequest = new HashMap<String, Object>();
        searchRequest.put("memory_container_id", this.memoryContainerId);
        searchRequest.put("memory_type", "working");
        searchRequest.put("query", query);
        searchRequest.put("size", size);
        searchRequest.put("sort", List.of(Map.of(CREATED_TIME_FIELD, "asc")));
        this.executeConnectorAction("search_memories", searchRequest, (ActionListener<String>)ActionListener.wrap(response -> {
            List<Message> interactions = this.parseSearchResponseToInteractions((String)response);
            listener.onResponse(interactions);
        }, e -> {
            log.error("Failed to search memories in remote memory container", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public void clear() {
        throw new UnsupportedOperationException("clear method is not supported in RemoteAgenticConversationMemory");
    }

    public void deleteInteractionAndTrace(String interactionId, ActionListener<Boolean> listener) {
        log.warn("deleteInteractionAndTrace is not fully implemented for RemoteAgenticConversationMemory");
        listener.onResponse((Object)false);
    }

    public void getTraces(String parentMessageId, ActionListener<List<Interaction>> listener) {
        if (Strings.isNullOrEmpty((String)this.memoryContainerId)) {
            listener.onFailure((Exception)new IllegalStateException("Memory container ID is not configured for this RemoteAgenticConversationMemory"));
            return;
        }
        HashMap query = new HashMap();
        HashMap bool = new HashMap();
        ArrayList must = new ArrayList();
        HashMap<String, String> sessionTerm = new HashMap<String, String>();
        sessionTerm.put("namespace.session_id", this.conversationId);
        must.add(Map.of("term", sessionTerm));
        HashMap<String, String> typeTerm = new HashMap<String, String>();
        typeTerm.put("metadata.type", "trace");
        must.add(Map.of("term", typeTerm));
        HashMap<String, String> parentTerm = new HashMap<String, String>();
        parentTerm.put("metadata.parent_message_id", parentMessageId);
        must.add(Map.of("term", parentTerm));
        bool.put("must", must);
        query.put("bool", bool);
        HashMap<String, Object> searchRequest = new HashMap<String, Object>();
        searchRequest.put("memory_container_id", this.memoryContainerId);
        searchRequest.put("memory_type", "working");
        searchRequest.put("query", query);
        searchRequest.put("size", 1000);
        searchRequest.put("sort", List.of(Map.of("message_id", "asc")));
        this.executeConnectorAction("search_memories", searchRequest, (ActionListener<String>)ActionListener.wrap(response -> {
            List<Interaction> traces = this.parseSearchResponseToTraces((String)response);
            listener.onResponse(traces);
        }, e -> {
            log.error("Failed to search traces in remote memory container", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void executeConnectorAction(String action, Map<String, Object> parameters, ActionListener<String> listener) {
        String requestBody;
        if (log.isDebugEnabled()) {
            HashMap<String, Object> actionDebug = new HashMap<String, Object>();
            actionDebug.put("action", action);
            if (parameters != null && !parameters.isEmpty()) {
                HashMap<String, Object> paramKeys = new HashMap<String, Object>();
                for (String key : parameters.keySet()) {
                    Object value = parameters.get(key);
                    paramKeys.put(key, value);
                }
                actionDebug.put("parameters", paramKeys);
            }
            log.debug("Executing RemoteAgenticConversationMemory action: {}", (Object)GSON.toJson(actionDebug));
        }
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("memory_container_id", (String)parameters.get("memory_container_id"));
        if (parameters.containsKey("memory_id")) {
            inputParams.put("memory_id", (String)parameters.get("memory_id"));
        }
        if (parameters.containsKey("memory_type")) {
            inputParams.put("memory_type", (String)parameters.get("memory_type"));
        }
        if ((requestBody = this.buildRequestBody(action, parameters)) != null) {
            inputParams.put("body", requestBody);
        }
        RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(inputParams).build();
        MLInput mlInput = MLInput.builder().algorithm(FunctionName.CONNECTOR).inputDataset((MLInputDataset)inputDataSet).build();
        this.executor.executeAction(action, mlInput, (ActionListener<MLTaskResponse>)ActionListener.wrap(response -> {
            MLTaskResponse taskResponse;
            Map<String, ?> dataMap = RemoteAgenticConversationMemory.extractDataFromModelTensorOutput(response);
            String output = dataMap != null ? GSON.toJson(dataMap) : (response instanceof MLTaskResponse ? ((taskResponse = response).getOutput() != null ? taskResponse.getOutput().toString() : "{}") : response.toString());
            if (log.isDebugEnabled()) {
                Object debugOutput = output;
                if (((String)debugOutput).length() > 500) {
                    debugOutput = ((String)debugOutput).substring(0, 500) + "... [truncated]";
                }
                log.debug("RemoteAgenticConversationMemory action '{}' response: {}", (Object)action, debugOutput);
            }
            listener.onResponse((Object)output);
        }, e -> {
            log.error("Failed to execute connector action '{}' for RemoteAgenticConversationMemory: {}", (Object)action, (Object)e.getMessage(), e);
            listener.onFailure(e);
        }));
    }

    private String buildRequestBody(String action, Map<String, Object> parameters) {
        switch (action) {
            case "add_memory": {
                return GSON.toJson(parameters);
            }
            case "search_memories": {
                HashMap<String, Object> searchBody = new HashMap<String, Object>();
                searchBody.put("query", parameters.get("query"));
                if (parameters.containsKey("size")) {
                    searchBody.put("size", parameters.get("size"));
                }
                if (parameters.containsKey("sort")) {
                    searchBody.put("sort", parameters.get("sort"));
                }
                return GSON.toJson(searchBody);
            }
            case "update_memory": {
                return GSON.toJson(parameters.get("update_content"));
            }
            case "create_session": {
                HashMap<String, Object> sessionBody = new HashMap<String, Object>();
                if (parameters.containsKey("summary")) {
                    sessionBody.put("summary", parameters.get("summary"));
                }
                return GSON.toJson(sessionBody);
            }
        }
        return null;
    }

    private SearchResponse parseSearchResponse(String jsonResponse) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, jsonResponse);){
            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)parser);
            return searchResponse;
        }
    }

    private GetResponse parseGetResponse(String jsonResponse) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, jsonResponse);){
            GetResponse getResponse = GetResponse.fromXContent((XContentParser)parser);
            return getResponse;
        }
    }

    private UpdateResponse parseUpdateResponse(String jsonResponse) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, jsonResponse);){
            UpdateResponse updateResponse = UpdateResponse.fromXContent((XContentParser)parser);
            return updateResponse;
        }
    }

    private MLAddMemoriesResponse parseAddMemoryResponse(String jsonResponse) {
        MLAddMemoriesResponse mLAddMemoriesResponse;
        block19: {
            XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, jsonResponse);
            try {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                String workingMemoryId = null;
                String sessionId = null;
                ArrayList results = new ArrayList();
                block17: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    switch (fieldName) {
                        case "working_memory_id": {
                            workingMemoryId = parser.text();
                            continue block17;
                        }
                        case "session_id": {
                            sessionId = parser.text();
                            continue block17;
                        }
                        case "long_term_memories": {
                            parser.skipChildren();
                            continue block17;
                        }
                    }
                    parser.skipChildren();
                }
                mLAddMemoriesResponse = MLAddMemoriesResponse.builder().workingMemoryId(workingMemoryId).sessionId(sessionId).results(results).build();
                if (parser == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to parse add memory response: " + jsonResponse, (Throwable)e);
                    return MLAddMemoriesResponse.builder().build();
                }
            }
            parser.close();
        }
        return mLAddMemoriesResponse;
    }

    private MLGetMemoryResponse parseGetMemoryResponse(String jsonResponse) {
        MLGetMemoryResponse mLGetMemoryResponse;
        block8: {
            XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, jsonResponse);
            try {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                MLWorkingMemory workingMemory = MLWorkingMemory.parse((XContentParser)parser);
                mLGetMemoryResponse = MLGetMemoryResponse.builder().workingMemory(workingMemory).build();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to parse get memory response: " + jsonResponse, (Throwable)e);
                    return MLGetMemoryResponse.builder().build();
                }
            }
            parser.close();
        }
        return mLGetMemoryResponse;
    }

    private List<Message> parseSearchResponseToInteractions(String response) {
        try {
            SearchResponse searchResponse = this.parseSearchResponse(response);
            return this.convertSearchHitsToMessages(searchResponse);
        }
        catch (Exception e) {
            log.error("Failed to parse search response: " + response, (Throwable)e);
            return new ArrayList<Message>();
        }
    }

    private List<Message> convertSearchHitsToMessages(SearchResponse searchResponse) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (searchResponse.getHits() != null && searchResponse.getHits().getHits() != null) {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                try {
                    Interaction interaction = this.convertHitToInteraction(hit, false);
                    if (interaction == null) continue;
                    messages.add((Message)interaction);
                }
                catch (Exception e) {
                    log.warn("Failed to parse hit: " + hit.getId(), (Throwable)e);
                }
            }
        }
        return messages;
    }

    private Interaction convertHitToInteraction(SearchHit hit, boolean isTrace) {
        String id = hit.getId();
        Map source = hit.getSourceAsMap();
        if (source != null && source.containsKey("structured_data_blob")) {
            Map structuredData = (Map)source.get("structured_data_blob");
            String input = structuredData.getOrDefault("input", "");
            String responseText = structuredData.getOrDefault("response", "");
            String origin = isTrace ? structuredData.getOrDefault("origin", "remote_agentic_memory") : "remote_agentic_memory";
            Long createdTimeMs = source.containsKey(CREATED_TIME_FIELD) ? Long.valueOf(((Number)source.get(CREATED_TIME_FIELD)).longValue()) : null;
            Long updatedTimeMs = source.containsKey("last_updated_time") ? Long.valueOf(((Number)source.get("last_updated_time")).longValue()) : null;
            Instant createTime = createdTimeMs != null ? Instant.ofEpochMilli(createdTimeMs) : Instant.now();
            Instant updatedTime = updatedTimeMs != null ? Instant.ofEpochMilli(updatedTimeMs) : null;
            String parentInteractionId = null;
            Integer traceNumber = null;
            if (source.containsKey("metadata")) {
                Object traceNum;
                Map metadata = (Map)source.get("metadata");
                parentInteractionId = (String)metadata.get("parent_message_id");
                if (isTrace && metadata.containsKey("trace_number") && (traceNum = metadata.get("trace_number")) instanceof Number) {
                    traceNumber = ((Number)traceNum).intValue();
                }
            }
            if (isTrace && parentInteractionId == null && structuredData.containsKey("parent_message_id")) {
                parentInteractionId = (String)structuredData.get("parent_message_id");
            }
            if (isTrace && traceNumber == null) {
                Object msgId;
                Object traceNum;
                if (structuredData.containsKey("trace_number") && (traceNum = structuredData.get("trace_number")) instanceof Number) {
                    traceNumber = ((Number)traceNum).intValue();
                }
                if (traceNumber == null && source.containsKey("message_id") && (msgId = source.get("message_id")) instanceof Number) {
                    traceNumber = ((Number)msgId).intValue();
                }
            }
            if (!input.isEmpty() || !responseText.isEmpty()) {
                return Interaction.builder().id(id).conversationId(this.conversationId).createTime(createTime).updatedTime(updatedTime).input(input).response(responseText).origin(origin).promptTemplate(null).additionalInfo(null).parentInteractionId(parentInteractionId).traceNum(traceNumber).build();
            }
        }
        return null;
    }

    private List<Interaction> parseSearchResponseToTraces(String response) {
        try {
            SearchResponse searchResponse = this.parseSearchResponse(response);
            return this.convertSearchHitsToTraces(searchResponse);
        }
        catch (Exception e) {
            log.error("Failed to parse trace response: " + response, (Throwable)e);
            return new ArrayList<Interaction>();
        }
    }

    private List<Interaction> convertSearchHitsToTraces(SearchResponse searchResponse) {
        ArrayList<Interaction> traces = new ArrayList<Interaction>();
        if (searchResponse.getHits() != null && searchResponse.getHits().getHits() != null) {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                try {
                    Interaction trace = this.convertHitToInteraction(hit, true);
                    if (trace == null) continue;
                    traces.add(trace);
                }
                catch (Exception e) {
                    log.warn("Failed to parse trace hit: " + hit.getId(), (Throwable)e);
                }
            }
        }
        return traces;
    }

    protected static Map<String, ?> extractDataFromModelTensorOutput(Object response) {
        List tensors;
        ModelTensorOutput tensorOutput;
        List outputs;
        MLTaskResponse taskResponse;
        MLOutput mlOutput;
        if (response instanceof MLTaskResponse && (mlOutput = (taskResponse = (MLTaskResponse)response).getOutput()) instanceof ModelTensorOutput && (outputs = (tensorOutput = (ModelTensorOutput)mlOutput).getMlModelOutputs()) != null && !outputs.isEmpty() && (tensors = ((ModelTensors)outputs.get(0)).getMlModelTensors()) != null && !tensors.isEmpty()) {
            return ((ModelTensor)tensors.get(0)).getDataAsMap();
        }
        return null;
    }

    @Generated
    public String getConversationId() {
        return this.conversationId;
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public Connector getConnector() {
        return this.connector;
    }

    @Generated
    public RemoteConnectorExecutor getExecutor() {
        return this.executor;
    }

    @Generated
    public ScriptService getScriptService() {
        return this.scriptService;
    }

    @Generated
    public ClusterService getClusterService() {
        return this.clusterService;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Generated
    public MLFeatureEnabledSetting getMlFeatureEnabledSetting() {
        return this.mlFeatureEnabledSetting;
    }

    public static class Factory
    implements Memory.Factory<RemoteAgenticConversationMemory> {
        private ScriptService scriptService;
        private ClusterService clusterService;
        private Client client;
        private NamedXContentRegistry xContentRegistry;
        private MLFeatureEnabledSetting mlFeatureEnabledSetting;

        public void init(ScriptService scriptService, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
            this.scriptService = scriptService;
            this.clusterService = clusterService;
            this.client = client;
            this.xContentRegistry = xContentRegistry;
            this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        }

        public void create(Map<String, Object> map, ActionListener<RemoteAgenticConversationMemory> listener) {
            if (map == null || map.isEmpty()) {
                listener.onFailure((Exception)new IllegalArgumentException("Invalid input parameter for creating RemoteAgenticConversationMemory"));
                return;
            }
            String memoryId = (String)map.get("memory_id");
            String name = (String)map.get("memory_name");
            String appType = (String)map.get("app_type");
            String memoryContainerId = (String)map.get("memory_container_id");
            String endpoint = (String)map.get("endpoint");
            String region = (String)map.get("region");
            Map credential = (Map)map.get("credential");
            String userId = (String)map.get("user_id");
            this.create(name, memoryId, appType, memoryContainerId, endpoint, region, credential, userId, listener);
        }

        public void create(String name, String memoryId, String appType, String memoryContainerId, String endpoint, String region, Map<String, String> credential, String userId, ActionListener<RemoteAgenticConversationMemory> listener) {
            if (Strings.isNullOrEmpty((String)memoryContainerId)) {
                listener.onFailure((Exception)new IllegalArgumentException("Memory container ID is required for RemoteAgenticConversationMemory. Please provide 'memory_container_id' in the agent configuration."));
                return;
            }
            if (Strings.isNullOrEmpty((String)endpoint)) {
                listener.onFailure((Exception)new IllegalArgumentException("Endpoint is required for RemoteAgenticConversationMemory"));
                return;
            }
            Connector connector = this.createInlineConnector(endpoint, region, credential);
            if (Strings.isEmpty((CharSequence)memoryId)) {
                this.createSessionInRemoteContainer(name, memoryContainerId, connector, (ActionListener<String>)ActionListener.wrap(sessionId -> {
                    this.create((String)sessionId, memoryContainerId, connector, userId, listener);
                    log.debug("Created session in remote memory container, session id: {}", sessionId);
                }, e -> {
                    log.error("Failed to create session in remote memory container", (Throwable)e);
                    listener.onFailure(e);
                }));
            } else {
                this.create(memoryId, memoryContainerId, connector, userId, listener);
            }
        }

        private void createSessionInRemoteContainer(String summary, String memoryContainerId, Connector connector, ActionListener<String> listener) {
            if (log.isDebugEnabled()) {
                if (connector.getActions() != null) {
                    log.debug("Connector has {} actions defined", (Object)connector.getActions().size());
                    for (ConnectorAction action : connector.getActions()) {
                        log.debug("Action: name='{}', actionType='{}'", (Object)action.getName(), (Object)action.getActionType());
                    }
                } else {
                    log.debug("Connector has no actions defined!");
                }
            }
            RemoteConnectorExecutor executor = (RemoteConnectorExecutor)MLEngineClassLoader.initInstance(connector.getProtocol(), connector, Connector.class);
            executor.setScriptService(this.scriptService);
            executor.setClusterService(this.clusterService);
            executor.setClient(this.client);
            executor.setXContentRegistry(this.xContentRegistry);
            executor.setConnectorPrivateIpEnabled(this.mlFeatureEnabledSetting.isConnectorPrivateIpEnabled());
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("memory_container_id", memoryContainerId);
            HashMap<String, String> sessionBody = new HashMap<String, String>();
            if (summary != null) {
                sessionBody.put("summary", summary);
            }
            inputParams.put("body", GSON.toJson(sessionBody));
            RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(inputParams).build();
            MLInput mlInput = MLInput.builder().algorithm(FunctionName.CONNECTOR).inputDataset((MLInputDataset)inputDataSet).build();
            executor.executeAction("create_session", mlInput, (ActionListener<MLTaskResponse>)ActionListener.wrap(response -> {
                try {
                    String sessionId = null;
                    Map<String, ?> dataMap = RemoteAgenticConversationMemory.extractDataFromModelTensorOutput(response);
                    log.debug("Create session response - extracted data: {}", (Object)(dataMap != null ? GSON.toJson(dataMap) : "null"));
                    if (dataMap != null && dataMap.containsKey(RemoteAgenticConversationMemory.SESSION_ID_FIELD)) {
                        sessionId = (String)dataMap.get(RemoteAgenticConversationMemory.SESSION_ID_FIELD);
                    }
                    if (sessionId != null) {
                        listener.onResponse(sessionId);
                    } else {
                        listener.onFailure((Exception)new RuntimeException("Failed to parse session_id from response"));
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }, e -> {
                log.error("Failed to create session via remote connector", (Throwable)e);
                listener.onFailure(e);
            }));
        }

        public void create(String memoryId, String memoryContainerId, Connector connector, String userId, ActionListener<RemoteAgenticConversationMemory> listener) {
            listener.onResponse((Object)new RemoteAgenticConversationMemory(memoryId, memoryContainerId, userId, connector, this.scriptService, this.clusterService, this.client, this.xContentRegistry, this.mlFeatureEnabledSetting));
        }

        private Connector createInlineConnector(String endpoint, String region, Map<String, String> credential) {
            if (!this.isValidEndpoint(endpoint)) {
                throw new IllegalArgumentException("Invalid endpoint URL: " + endpoint);
            }
            String protocol = region != null && credential != null && !credential.isEmpty() ? "aws_sigv4" : "http";
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("endpoint", endpoint);
            if (region != null) {
                parameters.put("region", region);
            }
            String serviceName = this.extractServiceName(endpoint);
            parameters.put("service_name", serviceName);
            HashMap<String, String> credentials = new HashMap<String, String>();
            if (credential != null && !credential.isEmpty()) {
                credentials.putAll(credential);
            }
            String tenantId = this.extractTenantIdFromRoleArn(serviceName, credentials);
            List<ConnectorAction> actions = this.createMemoryContainerActions();
            Object connector = "aws_sigv4".equals(protocol) ? AwsConnector.awsConnectorBuilder().name("inline_remote_memory_connector").protocol(protocol).parameters(parameters).credential(credentials).actions(actions).tenantId(tenantId).build() : HttpConnector.builder().name("inline_remote_memory_connector").protocol(protocol).parameters(parameters).credential(credentials.isEmpty() ? null : credentials).actions(actions).tenantId(null).build();
            if (log.isDebugEnabled()) {
                HashMap<String, Object> debugInfo = new HashMap<String, Object>();
                debugInfo.put("name", connector.getName());
                debugInfo.put("protocol", connector.getProtocol());
                debugInfo.put("parameters", connector.getParameters());
                debugInfo.put("actions", actions.stream().map(a -> a.getName() != null ? a.getName() : a.getActionType().toString()).collect(Collectors.toList()));
                log.debug("Created inline connector for RemoteAgenticConversationMemory: {}", (Object)GSON.toJson(debugInfo));
            }
            connector.decrypt(ConnectorAction.ActionType.EXECUTE.name(), (cred, tenant) -> cred, tenantId);
            return connector;
        }

        private List<ConnectorAction> createMemoryContainerActions() {
            ArrayList<ConnectorAction> actions = new ArrayList<ConnectorAction>();
            actions.add(ConnectorAction.builder().actionType(ConnectorAction.ActionType.EXECUTE).name("create_session").method("POST").url("${parameters.endpoint}/_plugins/_ml/memory_containers/${parameters.memory_container_id}/memories/sessions").headers(Map.of("Content-Type", "application/json")).requestBody("${parameters.body}").build());
            actions.add(ConnectorAction.builder().actionType(ConnectorAction.ActionType.EXECUTE).name("add_memory").method("POST").url("${parameters.endpoint}/_plugins/_ml/memory_containers/${parameters.memory_container_id}/memories").headers(Map.of("Content-Type", "application/json")).requestBody("${parameters.body}").build());
            actions.add(ConnectorAction.builder().actionType(ConnectorAction.ActionType.EXECUTE).name("search_memories").method("GET").url("${parameters.endpoint}/_plugins/_ml/memory_containers/${parameters.memory_container_id}/memories/${parameters.memory_type}/_search").headers(Map.of("Content-Type", "application/json")).requestBody("${parameters.body}").build());
            actions.add(ConnectorAction.builder().actionType(ConnectorAction.ActionType.EXECUTE).name("get_memory").method("GET").url("${parameters.endpoint}/_plugins/_ml/memory_containers/${parameters.memory_container_id}/memories/${parameters.memory_type}/${parameters.memory_id}").headers(Map.of("Content-Type", "application/json")).build());
            actions.add(ConnectorAction.builder().actionType(ConnectorAction.ActionType.EXECUTE).name("update_memory").method("PUT").url("${parameters.endpoint}/_plugins/_ml/memory_containers/${parameters.memory_container_id}/memories/${parameters.memory_type}/${parameters.memory_id}").headers(Map.of("Content-Type", "application/json")).requestBody("${parameters.body}").build());
            actions.add(ConnectorAction.builder().actionType(ConnectorAction.ActionType.EXECUTE).name("delete_memory").method("DELETE").url("${parameters.endpoint}/_plugins/_ml/memory_containers/${parameters.memory_container_id}/memories/${parameters.memory_type}/${parameters.memory_id}").headers(Map.of("Content-Type", "application/json")).build());
            return actions;
        }

        private String extractServiceName(String endpoint) {
            if (endpoint.contains(".aoss.amazonaws.com")) {
                return "aoss";
            }
            if (endpoint.contains(".es.amazonaws.com") || endpoint.contains(".es-staging.amazonaws.com") || endpoint.contains(".es-integ.amazonaws.com")) {
                return "es";
            }
            return "aoss";
        }

        private String extractTenantIdFromRoleArn(String serviceName, Map<String, String> credential) {
            if (!"aoss".equals(serviceName)) {
                return null;
            }
            if (credential == null || !credential.containsKey("roleArn")) {
                return null;
            }
            String roleArn = credential.get("roleArn");
            if (Strings.isNullOrEmpty((String)roleArn)) {
                return null;
            }
            try {
                String[] parts = roleArn.split(":");
                if (parts.length >= 6 && parts[5].startsWith("role/")) {
                    String account = parts[4];
                    return account + ":role";
                }
            }
            catch (Exception e) {
                log.error("Failed to parse roleArn: {}", (Object)roleArn, (Object)e);
            }
            return null;
        }

        private boolean isValidEndpoint(String endpoint) {
            try {
                return endpoint != null && (endpoint.startsWith("http://") || endpoint.startsWith("https://"));
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

